// *****************************************************
// STAR FIELD INCLUDE FILE FOR PERSISTENCE OF VISION 3.x
// *****************************************************
//
// Created by Chris Colefax, May 1997
//
// OVERVIEW: Will create a three dimensional star field suitable
// for animations.
//
// USAGE: To create the default star field just include this file
// in your POV scene file.  You can customise the star field with
// the following options:
//
//   #declare star_count = 1000
//   #declare min_distance = 1000
//   #declare max_distance = 5000
//   #declare star_size = 2
//   #declare star_seed = -4323
//   #declare star_object = sphere {<0, 0, 0>, 20
//      pigment {rgb <1, 1, 1>} finish {ambient 1}}
//
// Star_count is the number of stars to use in the star field.
// Min and max_distance are relative to the origin, measured in
// POVRay units.  Star_size can be used to increase/decrease the
// size of the stars without having to declare the star_object
// (eg. if changing the rendering resolution.  Star_seed is the
// random seed used to create the star field.  Star_object is the
// actual object used, and should be centred at the origin and
// scaled large enough to be seen at the min and max_distances
// specified (or you can use star_size to scale the star objects).
//
// You can create multiple star fields with different options by
// including this file after declaring each set of options (note
// that you don't have to redeclare options if they are the same
// as those already used for a previous star field).
//
// You can modify the star field (eg. rotations, translations) by
// including this file inside an object {} statement, eg:
//
//    object {#include " [filename here] " rotate y * clock * 360}
//
// ***************************************************************

// CHECK VARIABLES AND ASSIGN DEFAULTS
// ***********************************
   #ifndef (star_count) #declare star_count = 1000 #end
   #ifndef (min_distance) #declare min_distance = 1000 #end
   #ifndef (max_distance) #declare max_distance = min_distance * 5 #end
   #declare _SF_distdif = max_distance - min_distance
   #ifndef (star_size) #declare star_size = 1 #end
   #ifndef (_SF_rand) #ifndef (star_seed) #declare _SF_rand = seed(0)
      #else #declare _SF_rand = seed(star_seed) #end #end
   #ifndef (star_object)
      #declare star_object = disc {<0, 0, 0>, z, .5
         pigment {onion color_map {[0 rgb 1.5] [1 rgb 0]} scallop_wave}
         finish {ambient 1 diffuse 0} scale 50} #end

// CREATE STAR FIELD
// *****************
   union {#declare _SF_count = 0 #while (_SF_count < star_count)
     object {star_object
       scale star_size
       translate z * (min_distance + rand(_SF_rand) * _SF_distdif)
       rotate (<rand(_SF_rand),rand(_SF_rand),rand(_SF_rand)>-.5)*360}
   #declare _SF_count = _SF_count + 1 #end }

