// magic sword include file

#ifndef (MAGIC_SWORD)
#declare MAGIC_SWORD = 1

#include "METALS.INC"

#declare baseL	=	<-4,  0,  0>
#declare baseR	=	< 4,  0,  0>
#declare baseB	=	< 0,  0, .5>
#declare baseFL	=	<-1.5,  0,-.5>
#declare baseFR	=	< 1.5,  0,-.5>
#declare baseBL	=	<-1.5,  0, .5>
#declare baseBR	=	< 1.5,  0, .5>
#declare tipL	=	<-1.9,-80,  0>
#declare tipR	=	< 1.9,-80,  0>
#declare tipB	=	< 0,-85, .3>
#declare tipF	=	< 0,-85,-.3>
#declare tipL2	=	<-1.0,-90, 0>
#declare tipR2	=	< 1.0,-90, 0>
#declare tip	=	< 0,-95,  0>

#declare blade =
union
{
	// FRONT
	// base edge
	triangle { baseL baseFL tipF }
	triangle { baseR baseFR tipF }
	triangle { baseL tipL tipF }
	triangle { baseR tipR tipF }
	// tip edge
	triangle { tipL tipF tipL2 }
	triangle { tipR tipF tipR2 }
	// tip end
	triangle { tipL2 tipF tip }
	triangle { tipR2 tipF tip }

	// BACK
	// base edge
	triangle { baseL baseBL tipB }
	triangle { baseR baseBR tipB }
	triangle { baseL tipL tipB }
	triangle { baseR tipR tipB }
	// tip edge
	triangle { tipL tipB tipL2 }
	triangle { tipR tipB tipR2 }
	// tip end
	triangle { tipL2 tipB tip }
	triangle { tipR2 tipB tip }

	union
	{
		triangle { baseFL baseFR tipF }
		triangle { baseBL baseBR tipB }

		difference
		{
			box { <baseL.x, baseL.y, baseFL.z> <baseR.x, baseR.y+5, baseBR.z> }
			cylinder { <baseL.x, baseL.y+1.25, baseFL.z-1> <baseL.x, baseL.y+1.25, baseBL.z+1> 1 scale <1,2,1> }
			cylinder { <baseR.x, baseR.y+1.25, baseFR.z-1> <baseR.x, baseR.y+1.25, baseBR.z+1> 1 scale <1,2,1> }
		}

		text
		{
			ttf "dauphinn.ttf"
			"Guthadradil elwad thaak edragamir fagreth"
			.1 0
			scale <2.5,1.25,1>
			rotate <0,.1348,90>
			translate <.5,-37,-.5>

//			pigment { color <.5,1,1> }
			pigment { Red }
//			pigment { crackle scale .5 color_map { [0 Orange] [.8 Red] } }
//			finish { Luminous }
		}

		texture { T_Gold_4A }
	}

	texture { T_Silver_3C }
}

#declare plate =
union
{
	torus
	{
		5 .5
		rotate x*90
		clipped_by{plane{-y,0}}
	}
	sphere { <-5,0,0> .5 scale <1,2,1> }
	sphere { <5,0,0> .5 scale <1,2,1> }

	union
	{
		box { <-1,4.5,-1> <1,5.5,1> rotate y*60*0 }
		box { <-1,4.5,-1> <1,5.5,1> rotate y*60*1 }
		box { <-1,4.5,-1> <1,5.5,1> rotate y*60*2 }
		scale <2,1,1.25>
		texture { T_Gold_3A }
	}

	scale <2,1,1>
	translate y*.5

	texture { T_Silver_3A }
}

#declare handle =
union
{
	#declare c = 0
	#while (c < 20)
//		torus { baseFR.x*sin((180/80)*(c+20)*pi/180) .25 scale <1.25,1,.75> translate y*(6+c*.5)}	// c<40, small rings
		torus { baseFR.x*sin((180/80)*(c*2+20)*pi/180) .5 scale <1.25,1,.75> translate y*(6+c*1)}	// c<20, large rings
		#declare c = c + 1
	#end

	pigment { color <.7,.5,.3> }
	finish { specular .1 }
}

#declare knob =
union
{
	sphere { 0 1.8 scale <1,.5,1> translate y*27 }
	sphere { 0 2.2 scale <1,.5,1> translate y*28 }
	sphere { 0 1.6 scale <1,.5,1> translate y*29 }
	sphere { 0 1.1 scale <1,.5,1> translate y*29.75 }

	texture { T_Gold_3A }
}

#declare sword =
union
{
	object { blade }
	object { plate }
	object { handle }
	object { knob }
}

#end
