// * ************************************** *
// * *                                    * *
// * *   MAGICAL WISHING WELL (& SWORD)   * *
// * *                                    * *
// * *    scene made by Robert Fremin     * *
// * * for the 1997 jul/aug IRTC contest  * *
// * *                                    * *
// * *    compile using PovRay v.3.02     * *
// * *                                    * *
// * ************************************** *

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "STONES.INC"
#include "WOODS.INC"
#include "glass.inc"

#include "sword.inc"	// the magic sword

////////////////////////////////
// don't change these, see below
#declare real_sky		= false
#declare real_stone		= false
#declare real_stone_t	= false
#declare real_ground	= false
#declare use_coin_dents = false
////////////////////////////////


#declare WellPlace = <20,0,50>	// translate center of the well to here

// --------------------------
// *** switches for scene ***
// --------------------------
// (put // in front of the constant you want to be false)
#declare real_sky		= true
#declare real_stone		= true
#declare real_stone_t	= true
#declare real_ground	= true
#declare use_coin_dents = true

// ---------------------------
// *** set up radiosity ***
// ---------------------------
// These constants are defined in "consts.inc"
// #declare Radiosity_Debug = 1
// #declare Radiosity_Fast = 2
// #declare Radiosity_Normal = 3
// #declare Radiosity_2Bounce = 4
// #declare Radiosity_Final = 5
#declare Rad_Quality = Radiosity_Final
#include "rad_def.inc"

// =========
//  CAMERAS
// =========

// main camera
#declare cam1 =
camera
{
	location  <40, 120,-220>
	look_at   <50, 30, 0>
	rotate y*30
	translate <-40,0,60>
}

// closeup of bucket
#declare cam2 =
camera
{
	location  <0, 50,-70>
	look_at   <0, 0, 0>
}

// sword handle and bucket
#declare cam3 =
camera
{
	location  <-40, 50,-50-20 -30>
	look_at   <23+20, 4,-88+50+30>
}

// zoom of upper rope
#declare cam4 =
camera
{
	location  <100, 70, -90>
	look_at   <60, 70, 0>
	rotate y*-60
//	translate <-40,0,60>
}

// bucket-cam
#declare cam5 =
camera
{
	location  <60, 65,-85>
	look_at   <60, 60,-80>
}

// coins on ground
#declare cam6 =
camera
{
	location  <140, 40,-220>
	look_at   <170, -90, 0>
	rotate y*30
	translate <-40,0,60>
}

// closeup of sword
#declare cam7 =
camera
{
	location  <20, 80,-200>
	look_at   <20, -30, -50>
	rotate y*30
	translate <-40,0,60>
}

// ========
//  LIGHTS
// ========

#declare a_light =
light_source
{
	0
	White
	// <widthVector> <heightVector> nLightsWide mLightsHigh
	area_light
	<25, 0, 0> <0,25, 0>
	4, 4						// total number of lights in grid (4x*4z = 16 lights)
	adaptive 0					// 0,1,2,3...
	jitter						// adds random softening of light
//	translate <500, 800, -500>
	translate <500, 1000, -1000>
	fade_distance 1500
	fade_power 2
}

#declare n_light =
light_source
{
//	<500, 600, -500>
//	<500, 800, -500>
	<500, 1000, -1000>
	White
	fade_distance 1500
	fade_power 2
}

#declare fill_light =
light_source { <-500, 0, -500> color Grey shadowless }

// =====================================
//  THE SKY & OTHER ATMOSPHERIC EFFECTS
// =====================================

sky_sphere
{
#if (real_sky)
	pigment { gradient y color_map { [0 color <0,0,.1>][.1 color <.1,.3,.8>][.3 White] } turbulence .04 }
#else
	pigment { Blue }
#end
}

#declare distant_clouds =
sphere
{
	0 1

	pigment { Clear }
	halo
	{
		emitting
		planar_mapping
		linear
		turbulence 2
		color_map {
			[ 0.0  color rgbft < 1, .5, .5,  1,  1> ]
			[ 0.25 color rgbft <.6, .6, .5,  1, -1> ]
			[ 1.0  color rgbft <.2, .1, .6,  1,  1> ]
		}
		frequency 2
		samples 20
		scale .5
	}
	hollow
	scale <4000,100,1000>
	rotate y*40
	translate <0,100,2500>
}

#declare fog4 =
fog{
	color <.6,.4,.4> filter .3 transmit .2
	fog_type 2
	fog_alt 0.5
	fog_offset -70
	distance 100
}

#declare vapor =
disc
{
	0, y, 1
	pigment
	{
		bozo
		color_map {
			[0 color <2,2,2> filter .4]
			[.2 color <.8,.8,1> filter .5]
			[.5 Clear]
		}
		scale .4
		turbulence .9
	}
	hollow
}

#declare vapors =
union
{
	object { vapor scale <200,1, 75> translate <-100,-60,400> rotate y*40 }
	object { vapor scale <300,2,175> translate <-620,-60,700> rotate y*40 }
	object { vapor scale <500,2,375> translate < 150,-60,850> rotate y*40 }
}

// ================
//  NATURE SCENERY
// ================

#declare ground =
box
{
	<-1,-1,-1> <1,1,1>
#if (real_ground)
	texture
	{
		normal { bump_map { tga "tbump12b.tga" map_type 0 interpolate 2 bump_size 5 } }
		pigment { granite color_map { [0 color <15,.4,.2>][.4 color <.4,0,.05>][.6 Black] } translate x*-15 }
		finish { ambient .3 specular .3 phong .6 }
		rotate <90,45,0>
		scale .05
	}
#else
	pigment { color <7,.5,.3> }
#end
	scale <5000,1,5000>
	translate <0,-89,1000>
}

#declare ground2 =
difference
{
	object { ground }
	cylinder { y*1000 y*-1000 95 translate WellPlace }
}

// Has a bug, someone tell me why this doesn't work.
// Even though I have cut a hole through the ground, lights emitts from that hole!
// Therefore I can't have it in the scene because light shows on inner walls of the well.
/*
#declare ground3 =
light_source
{
	0 Red
	looks_like { ground2 }
	fade_distance 25
	fade_power 2
}
*/

#declare mountains =
height_field
{
	tga "tbump03a.tga"
	smooth

#if (real_ground)
	texture
	{
		normal { bump_map { tga "tbump12b.tga" map_type 0 interpolate 2 bump_size 4 } scale 4 }
		pigment { crackle color_map { [0 color <.9,.6,.4>][.5 color <.7,.5,.3>][1 color <.9,.7,.5>] } }
		rotate <90,45,0>
		scale .05
	}
#else
	pigment { color <.9,.7,.5> }
#end

	scale <4000,250,1000>
	translate <-1000,-60,-900>
	rotate x*-20
	rotate y*40
	translate z*2500
}

// ================================
//  THE SOLID OBJECTS IN THE SCENE
// ================================

// one layer of stones
#declare well_row =
union
{
	#declare c = 0
	#while (c < 20)
		#if (real_stone)
			superellipsoid { .5
		#else
			box { <-1,-1,-1> <1,1,1>
		#end
			scale <16,10,18>
			translate x*100
			rotate y*c*(360/20)
		}
		#declare c = c + 1
	#end

#if (real_stone_t)
	texture
	{
		T_Stone14
		scale 2
		normal { bumps scale 4 }
		finish { Phong_Shiny }
	}
#else
	pigment { Grey }
#end
}

#declare poles =
difference
{
	// poles
	union
	{
		box { <-5,-90,-10> <5,100,10> translate x*-120 }
		box { <-5,-90,-10> <5,100,10> translate x*120 }
	}
	cylinder { <-132,90.75,0> <130,90.75,0> 6.5 }

	#if (real_stone_t)
		texture
		{
			T_Stone28
			finish { Phong_Shiny }
			scale 20
		}
	#else
		pigment { Gray50 }
	#end
}

#declare crank =
union
{
	// bar
	cylinder { <-132,0,0> <130,0,0> 4 texture { T_Brass_2A } }
	// roll
	cylinder { <-35,0,0> <35,0,0>  17.5 }
	cylinder { <-35,0,0> <-40,0,0> 22 }
	cylinder { < 35,0,0> < 40,0,0> 22 }
	// crank
	box { <-130,10,-6> <-127,-50,6> texture { T_Brass_2A } }
	cylinder { <-160,-45,0> <-129,-45,0> 3 texture { T_Brass_2A } }

	pigment { image_map { gif "whiteash.gif" map_type 2 } scale 10 }
	normal  { bump_map  { gif "whiteash.gif" map_type 2 bump_size 4 } scale 10 }
	finish { specular .1 }

	rotate x*-50		// crank movement
	translate y*90
}

#declare rope =
union
{
	// the wrapped part
	#declare c = 5
	#while (c < 14)
		torus { 18 1.5 rotate z*90 translate <-45.5+3*c,90,0> }
		#declare c = c + 1
	#end

	#declare handover = 25		 // angle where torus meets blobs (higher deg.=higher up)
	// rope1: at top of rope
	#declare rope1 = vrotate(z*-18.1, x*handover) + <-45.5+3*16, 90.1, 0>
	torus { 18 1.5 rotate z*90 translate <-45.5+3*16,90,0> clipped_by { plane { -y,-rope1.y } } }
	// rope2: at bucket handle
	#declare rope2 = <23,15.2,-85>

	// the knot
	torus { 2 1.5 rotate x*-55 translate rope2 }
	torus { 2 1.5 rotate x*75 translate rope2 }

	// the bend
	#declare num = 500
	#declare w = rope1
	#declare xf = (rope2.x - rope1.x)/num
	#declare yf = (rope2.y - rope1.y)/num
	#declare zf = (rope2.z - rope1.z)/num
	#declare ang = 0
	#declare decr = 0
	blob { threshold .8
		sphere { w+y*yf 2.3 .7 }
		#while (w.z >= rope2.z)
			sphere { w 2.3-decr .6 }
			#declare w = w + <xf, yf-.3*cos(ang), zf>
			#declare ang = ang + pi/num
			#declare decr = decr + .5/num	// compensation for stronger fields when blobs
											// get tighter together at bottom of the bend
		#end
		sturm
	}

	texture
	{
		pigment { color <.7,.5,.3> }
		normal  { bump_map  { gif "rope.gif" map_type 0 bump_size 5 } }
		finish { specular .2 diffuse .6 }
		rotate <5,10,45>
	}
}

#declare well_walls =
union
{
	object { well_row }
	object { well_row rotate y*9 translate y*-16 }
	object { well_row translate y*-32 }
	object { well_row rotate y*9 translate y*-48 }
	object { well_row translate y*-64 }
	object { well_row rotate y*9 translate y*-80 }
	object { well_row translate y*-96 }
	object { well_row rotate y*9 translate y*-112 }
	object { well_row translate y*-128 }
	object { well_row rotate y*9 translate y*-144 }
	object { well_row translate y*-160 }
	object { well_row rotate y*9 translate y*-176 }
	object { well_row translate y*-192 }
	object { well_row rotate y*9 translate y*-208 }
}

#declare well_water =
cylinder
{
	y*-279 y*-63 105
	texture
	{
		Water
		scale 50
		pigment { color <.85,.9,.85> filter 2 }
		finish { reflection .1 caustics .5 }
	}
}

#declare well =
union
{
	// the (wishing) well
	object { well_walls }

	// rope and stuff
	object { poles }
	object { crank }
	object { rope }

	// the water
	object { well_water }

	// the bottom
	disc { y*-208-11 y 120 pigment { Black } }
}

#declare coin =
cylinder
{
	<0,-.2,0> <0,.2,0> 2
	pigment { color <1,.85,.55> }
	finish { ambient .3 phong .8 metallic }
	#if (use_coin_dents)
		normal { dents scale <.5,1,.5> }
	#end
}

#declare coins =
union
{
	#declare Rx = seed(435);
	#declare Ry = seed(658767);
	#declare Rz = seed(87535);

	#declare c = 0
	#while (c<100)
		object
		{
			coin
			rotate <rand(Rx)*10-5,0,rand(Rz)*10-5>
			#declare xfact = rand(Rx)
			translate <xfact*16,2+rand(Ry),0>
			rotate z*xfact*-15
			rotate y*rand(Ry)*360
		}
		#declare c = c + 1
	#end
}

#declare bucket =
union
{
	torus { 15 .6 }
	torus { 19.5 .8 translate y*30 }
	difference
	{
		cone { y*0 15 y*30 20 }
		cone { y*1 15 y*45 20 }
		torus { 19.1 1 translate y*20 }
		torus { 18.3 1 translate y*15 }
	}

	// rings on bucket
	torus { 1.5 .5 rotate z*90 translate <0,27,-21> }
	torus { 1.5 .5 rotate z*90 translate <0,27, 21> }

	union
	{
		// rings on handle
		torus { 1.5 .5 rotate x*90 translate <0,27+1,-21> }
		torus { 1.5 .5 rotate x*90 translate <0,27+1, 21> }

		// handle
		torus { 21 .5 clipped_by { plane { x,-1.5 } } scale <1.5,1,1> rotate z*48 translate y*27+1 }

		texture { T_Chrome_4B }
	}

	texture { T_Chrome_4C }
//	pigment { Grey }
}

#declare bucket_o_money =
union
{
	object { bucket }

	// put a thick layer of coins in bucket so it looks like it is filled
	object { coins rotate y*79 translate y*29   }
	object { coins rotate y*45 translate y*28.5 }
	object { coins rotate y*27 translate y*28   }
	object { coins rotate y*63 translate y*27.5 }
}

#declare coins_on_ground =
union
{
	object { coin translate <100,-77.8,-67> }
	object { coin translate <103,-77.8,-63> }
	object { coin translate <120,-77.8,-70> }

	object { coin translate <157,-77.8,-50> }
}

#declare path =
union
{
	#declare c = 1
	#while (c < 4)
		superellipsoid
		{
			.2
			scale <50,10,50>
			translate <0,-88,c*150+150>
		}
		#declare c = c + 1
	#end
	difference
	{
		cylinder { y*-1 y*1 1 scale <220,10,220> translate y*-88 }
		cylinder { y*1000 y*-1000 125 }
		#declare c = 0
		#while (c < 180)
			box { <-1000,1000,5> <1000,-1000,-5> rotate y*c }
			#declare c = c + 20
		#end
	}

	rotate y*85
	translate WellPlace
	#if (real_stone_t)
		texture { T_Stone28 scale 40 }
		normal { bumps scale 5 }
		finish { specular .3 phong .2 }
	#else
		pigment { Gray70 }
	#end
}

#declare sword2 =
union
{
	object { sword }

	// some magic around the blade
	sphere
	{
		0 1
		pigment { color Clear }
		finish { specular .9 }
		scale <9,52,.75>
		translate y*-45
	}
}

#declare helper_3daxis =
union
{
	cylinder { x*-1000 x*1000 1 pigment { Red } }
	cylinder { y*-1000 y*1000 1 pigment { Green } }
	cylinder { z*-1000 z*1000 1 pigment { Blue } }
}


// ------------------------------------------------------------------------------------------------------
// SCENE DESCRIPTION
// ------------------------------------------------------------------------------------------------------

// LIGHTS & CAMERA
// ---------------

object { a_light }		// area light
//object { n_light }	// normal light (for faster previews, not in final render)
object { fill_light }	// fill light to soften shadows
camera { cam1 }

// ATMOSPHERIC EFFECTS/OBJECTS
// ---------------------------

object { distant_clouds }		// quite slow with AA, but also very nice!
fog { fog4 }
object { vapors }

// OBJECTS IN SCENE
// ----------------

object { path }
object { mountains }
object { ground2 }
//plane { y, -88 pigment { Red } }	// @@@ development @@@
//light_source { ground3 }		// don't use if not bug is solved: shouldn't glow inside of well
object { well translate WellPlace }
object { bucket_o_money rotate y*-50 translate x*100 rotate y*65 translate <20,10,50> }
object { coins_on_ground }
object { sword scale 1.5 rotate y*180 rotate <-89.5,-75,0> translate <5,11,-50> }

//object { helper_3daxis translate WellPlace }

