//piano_keys.pov - Copyright (c) 1997, Christopher Kelly
//NOTE: the declaration 'position' is alternated between the two vrotate(...) statements
//      to produce the two different scenes aboyd1 and aboyd2. Similarly, when the second
//      position is used, the camera viewing angle is set to 80, (ie. the // is removed).

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"

#declare position = vrotate(<-1,10,0>,-y*45) //vrotate(<-1,7,0>,-y*20)
camera
{
 location position
 look_at 0
 //angle 80
}

light_source { <-0.5,0,-1000> White }
light_source { <1,2,-3> White }

#declare black_key =
superellipsoid
{
 <0.25,0.25>
 scale <0.5,0.5,1.5>
 pigment { Black }
 finish
 {
  ambient 0.2
  diffuse 0.8
  phong 0.9
 }
 translate y*1.5
}

#declare white_key=
superellipsoid
{
 <0.1,0.05>
 scale <1,0.5,2.4>
 pigment { White }
 finish
 {
  //reflection 0.7
  ambient 0.2
  diffuse 0.8
  phong 1.0
 }
 translate -z*0.95
}

#declare TwoKeys =
union
{
#declare c=1
#while (c<3)
object{
 white_key
 translate x*2*(c-1)
 #if (c=1)
  rotate -x*7
  translate <0,-0.5,0.1>
 #end
}
object
{
 black_key
 translate x*((c*2)-1)
}
#declare c=c+1
#end
object
{
 white_key
 translate x*2*(c-1)
}
}

#declare ThreeKeys =
union
{
#declare c=1
#while (c<4)
object{
 white_key
 translate x*2*(c-1)
}
object
{
 black_key
 translate x*((c*2)-1)
}
#declare c=c+1
#end
object
{
 white_key
 translate x*2*(c-1)
}
}

#declare keyboard=
union
{
#declare c=1
#while (c<4)
object
{
 TwoKeys
 translate x*(c-1)*14
}
object
{
 ThreeKeys
 translate x*((c-1)*14+6)
}
#declare c=c+1
#end
translate -x*13
scale z*1.5
translate -z*0.3
}

keyboard

background { White }

plane
{
 y,-3
 pigment { Black }
 finish
 {
  ambient 0.2
  phong 1.0
  diffuse 0.8
 }
}

plane
{
 z,2
 pigment { Black }
 finish
 {
  reflection 0.4
  ambient 0.2
  phong 1.0
  diffuse 0.8
 }
}

text
{
 ttf "c:\windows\fonts\vivaldii.ttf"
 "Boyd"
 0.2,0
 texture { T_Brass_4E }
 scale 4
 translate <-5,2,2>
}
