#include "colors.inc"
#include "keynotes.inc"

camera { location <2, 4, -5> look_at <0, 0, 0>  }

background { color White }

light_source { <-100, 100, -100> color White }
light_source { <100, 100, -100> color White }
light_source { <0, -100, 0> color White }

#declare Arch = 
        difference {
        superellipsoid { <1.0, 0.1> pigment { color Blue }
                rotate y*90
                scale <0.12, 1.5, 1>
                }
        box { <-3, 0, -3>, <3, -5, 3> pigment { color Blue } }
        cylinder { <-3, 0, 0>, <3, 0, 0>, 0.75
                scale <1, 1.78, 0.85>
                pigment { color Yellow }
                }
        }

#declare Arch2 =
        difference {
        superellipsoid { <1.0, 0.1> pigment { color Blue }
                rotate y*90
                scale <0.12, 1.38, 1>
                }
        box { <-3, 0, -3>, <3, -5, 3> pigment { color Blue } }
        cylinder { <-3, 0, 0>, <3, 0, 0>, 0.75
                scale <1, 1.225, 0.85>
                pigment { color Yellow }
                }
        }

union {
	object { Arch
		translate x*-1.3
		}

	object { Arch2
		scale <1, 0.35, 1>
		translate x*1.3
		}
	union
		{
		#declare loop = 0
		#declare X_Loop = -1
		#declare flag = 0
		#declare KeyNum = 0
		cylinder { <-1.2, (1.8*0.75/2 + 1.5*1/2)/2 + 0.5 + 0.195, 0>,
			   <-1.09, (1.8*0.75/2 + 1.5*1/2)/2 + 0.5 + 0.195, 0>,
			   (1.5*1.0 - 1.8*0.75)/2.5
			   scale <1, 1, 2>
			   pigment { color Green }
			 }
		cylinder { <1.2, (1.8*0.75/2 + 1.5*1/2)/2 - 0.5 + 0.195, 0>,
			   <1.09, (1.8*0.75/2 + 1.5*1/2)/2 - 0.5 + 0.195, 0>,
			   (1.5*1.0 - 1.8*0.75)/2.5
			   scale <1, 1, 2>
			   pigment { color Green }
			 }
		#while (loop < pi)
			cylinder { 
				<X_Loop - 0.1, (1.8*0.75/2 + 1.5*1/2)/2 + cos(loop-.1)/2 + 0.195, 0>,
				<X_Loop + 0.1, (1.8*0.75/2 + 1.5*1/2)/2 + cos(loop+.1)/2 + 0.195, 0>,
				(1.5*1.0 - 1.8*0.75)/2.5
				scale <1, 1, 2>
				pigment { color Green }
				}
			#if(flag != 0)
			cylinder {   // string
				<X_Loop, (1.8*0.75/2 + 1.5*1/2)/2 + cos(loop)/2 + 0.195, 0>,
				<X_Loop, 0.05, 0>, 0.0025
				pigment { color Silver }
				finish { ambient 1.0 specular 1 roughness 0.001 }
				}

			cylinder {  // Halo
				<0, ((1.8*0.75/2 + 1.5*1/2)/2 + cos(loop)/2 + 0.195 + 0.05)/2, 0>,
				<0, -((1.8*0.75/2 + 1.5*1/2)/2 + cos(loop)/2 + 0.195 + 0.05)/2, 0>,
					1	
				pigment { color Clear }
				hollow
				halo {
					emitting
					cylindrical_mapping
					linear
					turbulence 0.2
					#include "keycolors.inc"
					samples 10
				        scale <0.65, 1, 0.65>
				     }
				scale <0.02225, 1, 0.02225>
				translate <X_Loop, ((1.8*0.75/2 + 1.5*1/2)/2 + cos(loop)/2 + 0.195 + 0.05)/2, 0>
				}
			#declare KeyNum = KeyNum + 1
			#end
		#if (flag = 1) #declare flag = 0
		#else #declare flag = 1
		#end
		#declare loop = loop + pi/176
		#declare X_Loop = X_Loop + 1/88
		#end
		}
scale <10, 18, 10>
translate y*-10
}


