#declare PROTO = 0

#declare KeyFinish = 
finish {
    specular 1
    roughness 0.001
    ambient 0.85
    diffuse 0
    reflection 0.1
    refraction 0.1
    ior 1
    //refraction 1
    //ior 1.5
}

#declare WhiteKey =
union {
	superellipsoid {
		<0.1, 0.01>
		scale 0.25  /* make it fit in a unit box */
		scale <7/8.0, 1/16.0, 6>
		pigment { color White }
		finish { KeyFinish }
		}
	difference {
		superellipsoid {
			<0.1, 0.05>
			scale 0.25
			scale <7/8.0, 0.6, 6 - 1/16.0>
			translate <0, -0.17, 1/32.0>
			pigment { color White }
			finish { KeyFinish }
			}
		plane { <0, -1, 0>, 1/32.0 pigment {color White }}
		translate y*0.015
		}
}

#declare LeftKey =
difference {
	object { WhiteKey }
	object { Cube
		scale 0.5
		scale <1/4, 2, 6>
		translate <2/8, 0, 2.6>
		pigment { color LightWood }
		}
}

#declare RightKey =
difference {
	object { WhiteKey }
	object { Cube
		scale 0.5
		scale <1/4, 2, 6>
		translate <-2/8, 0, 2.6>
		pigment { color LightWood }
		}
}

#declare BothKey =
difference {
	object { WhiteKey }
	object { Cube
		scale 0.5
		scale <1/4, 2, 6>
		translate <2/8, 0, 2.6>
		pigment { color LightWood }
		}
	object { Cube
		scale 0.5
		scale <1/4, 2, 6>
		translate <-2/8, 0, 2.6>
		pigment { color LightWood }
		}
}

#declare BlackKey =
difference {
	superellipsoid { <0.1, 0.1>
		scale 0.25
		scale <3/8, 0.8, 4>
		pigment { color Black }
		finish { KeyFinish }
		}
	plane { <0, 1, 0>, -1 pigment { color Black }
		finish { ambient 1.0}}

	box { <-0.5, -0.5, -5>, <0.5, 0.6, 5>
		translate <0, 0.5, 5.45>
		pigment { color Black }
		}
	 }

#declare Test =
union {
	object { BothKey }
	object { BlackKey translate <-2/8, 0, 0.64> }
	object { BlackKey translate <2/8, 0, 0.64> }
	}

#declare X_Offset = 0.484375

#declare Octave =
union
	{
	object { BothKey }  //D
	object { BlackKey translate <-2/8, 0, 0.64> }
	object { BlackKey translate <2/8, 0, 0.64> }
	object { LeftKey translate <-0.484375, 0, 0> }  //C
	object { RightKey translate <0.484375, 0, 0> } //E

	object { LeftKey translate <2*X_Offset, 0, 0> } //F
	object { BlackKey translate <2*X_Offset + 0.25, 0, 0.64> }
	object { BothKey translate <3*X_Offset, 0, 0> }  //G
	object { BlackKey translate <3*X_Offset + 0.25, 0, 0.64> }
	object { BothKey translate <4*X_Offset,  0, 0> } //A
	object { BlackKey translate <4*X_Offset + 0.25, 0, 0.64> }
	object { RightKey translate <5*X_Offset, 0, 0> } //B
	translate x*-X_Offset*6/2
	}

#declare FullKeyboard = union
{
object { Octave }
object { Octave translate x*-7*X_Offset  }
object { Octave translate x*7*X_Offset  }
object { Octave translate x*14*X_Offset  }
object { Octave translate x*21*X_Offset  }
object { Octave translate x*-14*X_Offset  }
object { Octave translate x*-21*X_Offset  }
object { WhiteKey translate x*(24.5*X_Offset - 0.25) }
object { RightKey translate x*(-25.5*X_Offset - 0.25)}
object { LeftKey translate x*(-26.5*X_Offset - 0.25)}
object { BlackKey translate <0, 0, 0.64> translate x*(-25.5*X_Offset - 0.25-0.25) }
}

#declare ModOctave1 =
union
        {
        object { BothKey }  //D
        object { BlackKey translate <-2/8, 0, 0.64> }  //C#
        object { BlackKey translate <2/8, 0, 0.64> rotate x*-3 }	//D#
        object { LeftKey translate <-0.484375, 0, 0> }  //C
        object { RightKey translate <0.484375, 0, 0> } //E

        object { LeftKey translate <2*X_Offset, 0, 0> } //F
        object { BlackKey translate <2*X_Offset + 0.25, 0, 0.64> } //F#
        object { BothKey translate <3*X_Offset, 0, 0> }  //G
        object { BlackKey translate <3*X_Offset + 0.25, 0, 0.64> } //G#
        object { BothKey translate <4*X_Offset,  0, 0> } //A
        object { BlackKey translate <4*X_Offset + 0.25, 0, 0.64> rotate x*-3 } //A#
        object { RightKey translate <5*X_Offset, 0, 0> } //B
        translate x*-X_Offset*6/2
        }
#declare ModOctave2 =
union
        {
        object { BothKey }  //D
        object { BlackKey translate <-2/8, 0, 0.64> } //C#
        object { BlackKey translate <2/8, 0, 0.64> rotate x*-3 } //D#
        object { LeftKey translate <-0.484375, 0, 0> }  //C
        object { RightKey translate <0.484375, 0, 0> } //E

        object { LeftKey translate <2*X_Offset, 0, 0> } //F
        object { BlackKey translate <2*X_Offset + 0.25, 0, 0.64> } //F#
        object { BothKey translate <3*X_Offset, 0, 0> rotate x*-3 }  //G
        object { BlackKey translate <3*X_Offset + 0.25, 0, 0.64> } //G#
        object { BothKey translate <4*X_Offset,  0, 0> } //A
        object { BlackKey translate <4*X_Offset + 0.25, 0, 0.64> rotate x*-3 } //A#
        object { RightKey translate <5*X_Offset, 0, 0> } //B
        translate x*-X_Offset*6/2
        }

#declare ModOctave3 =
union
        {
        object { BothKey }  //D
        object { BlackKey translate <-2/8, 0, 0.64> } //C#
        object { BlackKey translate <2/8, 0, 0.64> } //D#
        object { LeftKey translate <-0.484375, 0, 0> }  //C
        object { RightKey translate <0.484375, 0, 0> } //E

        object { LeftKey translate <2*X_Offset, 0, 0> } //F
        object { BlackKey translate <2*X_Offset + 0.25, 0, 0.64> } //F#
        object { BothKey translate <3*X_Offset, 0, 0> rotate x*-3 }  //G
        object { BlackKey translate <3*X_Offset + 0.25, 0, 0.64> } //G#
        object { BothKey translate <4*X_Offset,  0, 0> } //A
        object { BlackKey translate <4*X_Offset + 0.25, 0, 0.64> rotate x*-3} //A#
        object { RightKey translate <5*X_Offset, 0, 0> } //B
        translate x*-X_Offset*6/2
        }

#declare ModOctave4 =
union
        {
        object { BothKey rotate x*-2}  //D
        object { BlackKey translate <-2/8, 0, 0.64> } //C#
        object { BlackKey translate <2/8, 0, 0.64> rotate x*-2} //D#
        object { LeftKey translate <-0.484375, 0, 0> }  //C
        object { RightKey translate <0.484375, 0, 0> } //E

        object { LeftKey translate <2*X_Offset, 0, 0> rotate x*-3} //F
        object { BlackKey translate <2*X_Offset + 0.25, 0, 0.64> }
        object { BothKey translate <3*X_Offset, 0, 0> }  //G
        object { BlackKey translate <3*X_Offset + 0.25, 0, 0.64> }
        object { BothKey translate <4*X_Offset,  0, 0> } //A
        object { BlackKey translate <4*X_Offset + 0.25, 0, 0.64> }
        object { RightKey translate <5*X_Offset, 0, 0> } //B
        translate x*-X_Offset*6/2
        }

#declare ModFullKeyboard = union
{
object { ModOctave3 }
object { ModOctave2 translate x*-7*X_Offset  }
object { ModOctave4 translate x*7*X_Offset  }
object { Octave translate x*14*X_Offset  }
object { Octave translate x*21*X_Offset  }
object { ModOctave1 translate x*-14*X_Offset  }
object { Octave translate x*-21*X_Offset  }
object { WhiteKey translate x*(24.5*X_Offset - 0.25) }
object { RightKey translate x*(-25.5*X_Offset - 0.25)}
object { LeftKey translate x*(-26.5*X_Offset - 0.25)}
object { BlackKey translate <0, 0, 0.64> translate x*(-25.5*X_Offset - 0.25-0.25) }
}

