
#ifndef (ABCDE)
#include "defaults.inc"
#end
//============================================================

#include "stones2.inc"

#declare FernTex1 = texture { pigment { color HuntersGreen }}
#declare FernTex1B = texture { pigment { color PaleGreen }}
#declare FernTex2 = texture { pigment { color YellowGreen  } }
#declare FernTex2B = texture { pigment { color LimeGreen } }
#declare FernTex3 = texture { pigment { color SpringGreen  }}
#declare FernTex3B = texture { pigment { color GreenYellow } }
#declare FernTex4 = texture { pigment { color Green}}
#declare FernTex4B = texture { pigment { color SeaGreen }}
#declare FernTex5 = texture { pigment { color Brown}}
#declare FernTex6 = texture { pigment { color NeonPink } }
#declare FernTex7 = texture { pigment { color MandarinOrange } }

/*
SPLEENWORT FERNs variation 1
*/
#declare Loops = 0
#declare MaxLoops = 2000

#declare CaseSeed1 = seed(4000)
#declare Xseed    = seed(100)
#declare Yseed    = seed(20000)
 #declare X = rand(Xseed)
 #declare Y = rand(Yseed)

#declare Fern1 =

mesh {
#while ( Loops <= MaxLoops )

 #switch(rand(CaseSeed1))
   #range ( 0.00,  0.03) // .03
     #declare X = ( (0 * X ) + (0.00 * Y + 0))
     #declare Y = ( (0 * X ) + (0.16 * Y + 0))
   #break
   #range ( 0.03,  0.76)  //.76
     #declare X = ( ( 0.85 * X ) + (0.04 * Y + 0.0 ))
     #declare Y =(  (-0.04 * X ) + (0.85 * Y + 1.6 ))
   #break
   #range ( 0.76,  0.89)  //.89
     #declare X = ( ( 0.20 * X ) +  (-0.26 * Y + 0.0 ))
     #declare Y = ( (-0.23 * X ) +  ( 0.22 * Y + 1.6 ))
   #break
   #range ( 0.89,  1.00)  // 1
     #declare X = ( (-0.15 * X ) + (0.28 * Y + 0.00 ))
     #declare Y = ( ( 0.26 * X ) + (0.24 * Y + 0.44 ))
   #break
  #end
triangle { < X, Y, .1 >, < X + .2, Y, 0 >, < X + .3, Y + .2, -.1 >  }

//sphere { < X, Y, 0 >, .1 }
#declare Loops = Loops + 1 #end
scale .2
//
}



#declare FernLayer1 =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .45, 0, 2 > rotate < 30, AA, 0 >  }
#declare AA = AA + 20 #end
texture { FernTex1 }
}
#declare FernLayer1B =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .4, 0, 2 > rotate < 27.5, AA, 0 >  }
#declare AA = AA + 25 #end
texture { FernTex1B }
translate< 0, .15, 0 >
}

#declare FernLayer2 =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .35, 0, 2 > rotate < 25, AA, 0 >  }
#declare AA = AA + 30 #end
texture { FernTex2 }
translate< 0, .3, 0 >
}
#declare FernLayer2B =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .30, 0, 2 > rotate < 22.5, AA, 0 >  }
#declare AA = AA + 35 #end
texture { FernTex2B }
translate< 0, .45, 0 >
}

#declare FernLayer3 =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .25, 0, 2 > rotate < 20, AA, 0 >  }
#declare AA = AA + 40 #end
texture { FernTex3 }
translate< 0, .6, 0 >
}
#declare FernLayer3B =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .20, 0, 2 > rotate < 17.5, AA, 0 >  }
#declare AA = AA + 45 #end
texture { FernTex3B }
translate< 0, .75, 0 >
}

#declare FernLayer4 =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .15, 0, 2 > rotate < 15, AA, 0 >  }
#declare AA = AA + 45 #end
texture { FernTex4 }
translate< 0, .9, 0 >
}
#declare FernLayer4B =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .10, 0, 2 > rotate < 12.5, AA, 0 >  }
#declare AA = AA + 50 #end
texture { FernTex4B }
translate< 0, 1.05, 0 >
}

#declare FernLayer5 =
union {
#declare AA = 0 #while ( AA <= 360 )
 object { Fern1 translate< .05, 0, 2 > rotate < 15, AA, 0 >  }
#declare AA = AA + 60 #end
texture { FernTex4 }
translate< 0, 1.3, 0 >
}

#declare FernBase =
  julia_fractal {
    <-0.053,0.0,-0.83,-0.025>
    quaternion
    sqr
    max_iteration 18
    precision 25
    texture { pigment {color VeryDarkBrown }}
    scale < 1.5, .5, 2.5 >
    rotate < 0, 10, 0 >
    translate < 1.6, -1, -.3 >
  }

#declare FernLayers =
union {
  object { FernLayer1 }
  object { FernLayer1B }
  object { FernLayer2 }
  object { FernLayer2B }
  object { FernLayer3 }
  object { FernLayer3B }
  object { FernLayer4 }
  object { FernLayer4B }
  object { FernLayer5 }
}

#declare RightFerns =
union {
object { FernLayers translate < 0,  0, 0 > }
object { FernBase   translate < -1,  0, 0 > }
scale < .75, 1.25, .75 >
}

#declare WallFerns =
union {
object { RightFerns translate< 14,   1.2, 1 >}
object { RightFerns scale < .8, 1.5, .8 > translate< 14, 1.3, 4 >}
object { RightFerns translate< 14,   1.2, 7 >}
object { RightFerns scale < .8, 1.3, .8 > translate< 14,   1.2, 10 >}
object { RightFerns scale < .8, 1.8, .8 > translate< 14, 1.3, 12 >}
}



#declare GardenBed =
union{
   difference{
     box {  <-2.1, -.4, -1.1>   < 2.1,  .4,  1.1>  texture {T_Stone30  }}
     box {  <-2, -.5, -1>   < 2,  .5,  1>  texture {T_Stone30  }}
   }
  box {  <-2, -.3, -1>   < 2,  .3,  1>  texture {pigment {color VeryDarkBrown }}}
  scale < 2.5, .2, 1 >
 translate < 6, -.5, 3 >
}

#declare Flower =
julia_fractal {
    <-0.083,0.0,-0.83,-0.025>
    quaternion
    sqr
    max_iteration 15
    precision 15
    scale .15
    rotate < 0, 0, 90 >
    translate < .5, 0, 3.25 >
}
#declare FBseedY = seed(7)
#declare FBseedZ = seed(9)
#declare FractalBed =
union {
object { GardenBed }
object { FernLayers scale <.4, .6, .3> translate < 1.5, -.5 , 3>}
object { FernLayers scale <.4, .7, .3> translate < 2.5, -.5 , 3>}
object { FernLayers scale <.4, .8, .3> translate < 3.5, -.5 , 3>}
object { FernLayers scale <.4, .8, .3> translate < 4.4, -.5 , 3>}
object { FernLayers scale <.4, .7, .3> translate < 5.3, -.5 , 3>}
object { FernLayers scale <.4, .6, .3> translate < 6.2, -.5 , 3>}
object { FernLayers scale <.4, .6, .3> translate < 7.1, -.5 , 3>}
object { FernLayers scale <.4, .7, .3> translate < 8, -.5 , 3>}
object { FernLayers scale <.4, .8, .3> translate < 9, -.5 , 3>}
object { FernLayers scale <.4, .8, .3> translate < 10, -.5 , 3>}

#declare AA = 1 #while ( AA <= 10 )
  object { Flower texture { FernTex6 } translate < AA, rand (FBseedY), rand (FBseedZ) >}
  object { Flower texture { FernTex7 } translate < AA, rand (FBseedY) + .1, rand (FBseedZ) - .75 >}
#declare AA = AA + .8 #end
scale < 1, 2, 1 >
/*
  #declare AA = 1 #while ( AA <= 11 )
     object { Fern1 scale .8 rotate < -40, 0, 0 > translate< AA + .5, -.3, 2.4 >  texture { FernTex1 } }
     object { Fern1 scale .8 rotate <  40, 0, 0 > translate< AA + .5, -.3, 3.5 >  texture { FernTex1 } }
  #declare AA = AA + .8 #end
  #declare AA = 2 #while ( AA <= 10 )
     object { Fern1 scale .8 rotate < -35, 0, 0 > translate< AA, -.3, 2.5 >  texture { FernTex2 } }
     object { Fern1 scale .8 rotate <  35, 0, 0 > translate< AA, -.3, 3.4 >  texture { FernTex2 } }
  #declare AA = AA + .8 #end
  #declare AA = 2 #while ( AA <= 10 )
     object { Fern2 scale .8 rotate < -35, 0, 0 > translate< AA, -.3, 2.5 >  texture { FernTex3 } }
     object { Fern2 scale .8 rotate <  35, 0, 0 > translate< AA, -.3, 3.4 >  texture { FernTex3 } }
  #declare AA = AA + .8 #end
*/
}
//object { Fern1 texture { FernTex4 }}
//object { Fern2 texture { FernTex4 } translate < 1, 0, 0>}


//object { WallFerns }
//object { FractalBed translate < -5, 0, .5 >}
