
#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "woods.inc"
#include "textures.inc"

#declare BaseCam =
camera {
location <10,30,-40>
look_at <0,20,0>}

#declare OCam =
camera {
location <7,24,-42>
look_at <-5,18,7>
}

camera {OCam}

light_source {<0,200,-140> colour rgb <.55,.55,.55>}

object {
light_source {
<0,200,-140> 
colour rgb <1,1,1>
spotlight
point_at <0,0,30>
radius 7
falloff 8
tightness 30
area_light <40,0,0>,<0,32,24>,6,6
adaptive 3
jitter 
}
}

//chair starts here...

#declare ChairWood =
texture {
pigment {
wood
turbulence .12
octaves 4
lambda 3
scale <.2,.15,1>
rotate <3, 5, 0>
translate <-1,0,0>
colour_map {
[.020 colour rgb  <.75,.65,.46>]
[.080 colour rgb  <.90,.82,.72>]
[1.001 colour rgb <.95,.87,.75>]} 
}
finish {specular .15 roughness .02 ambient .25}
scale 5
}
texture {
pigment {
gradient x
turbulence .5
colour_map {
[0    colour rgbf <1,1,1,1>]
[.97 colour rgbf <1,1,1,1>]
[.98 colour rgbf <.7,.45,.35,.4>]
[.99 colour rgbf <1,1,1,1>]
[1    colour rgbf <1,1,1,1>]}
frequency 10
rotate <0,1.5,2>
scale 18
}
finish {specular .15 roughness .02 ambient .25}
scale 5
}



#declare Seat =
difference {
prism {
linear_sweep
cubic_spline
0,-.75
23
<4,.5>//cp
<0,0>
<-.7,-.3>
<-1,-1>
<-1.875,-7>
<-2,-9>
<-1.7,-9.7>
<-1,-10>
<2,-10.95>
<4,-11>
<6,-10.95>
<9,-10>
<9.7,-9.7>
<10,-9>
<9.875,-7>
<9,-1>
<8.7,-.3>
<8,0>
<6,.45>
<4,.5>
<2,.45>
<0,0>
<-.7,-.3>//cp
translate <-4,0,0>  //width 12 height 10+
}
sphere {<0,0,0>,4 scale <1,.1,1> translate <0,0,-5>}
}

#declare Leg =
object {
sor {
10,
<.25,-4.5>//cp
<1,0>
<1.75,4.5>
<1.5,4.6>
<1.7,4.8>
<1.7,5.2>
<1.5,5.4>
<1.75,5.5>
<1,10>
<.25,14.5>//cp
sturm
}
scale <.35,1,.35>
}

#declare NotALeg =
object {
sor {
10,
<.25,-(4.5-2)>//cp
<1,0>
<1.75,4.5-2>
<1.5,4.6-2>
<1.7,4.8-2>
<1.7,5.2-2>
<1.5,5.4-2>
<1.75,5.5-2>
<1,10>
<.25,14.5-2>//cp
sturm
}
scale <.35,1,.35>
}


#declare Support =
difference {
intersection {
cylinder {<0,16,10><0,16,-10>,16}
prism {
linear_sweep
cubic_spline
10,-10
31,
<-8,4>//cp
<-5.5,0>
<-5,0>
<-4,0>
<-3,0>
<-2,0>
<-1,0>
<0,0>
<1,0>
<2,0>
<3,0>
<4,0>
<5,0>
<5.5,0>
 <8,3.2>
 <7.5,5.75>
 <6.15,6>
<4.501,5>
<4.5,5>
<4.499,5>
<3,7>
<0,8.2>
<-3,7>
<-4.499,5>
<-4.5,5>
<-4.501,5>
 <-6.15,6>
 <-7.5,5.75>
 <-8,3.2>
<-5.5,0>
<-4,0>//cp
}
}
cylinder {<0,16,10><0,16,-10>,15.25}
intersection {cone {<0,16,4.5>,0<0,-.1,4.5>,3}box {<-3.1,16.1,4.5><3.1,-.2,7.51>}}
box {<-12,3,.01><12,-1,-.4>}
}


#declare Chair =
union {

object {Support scale .8 scale <1,1,1/.9> rotate <-90,0,0>
translate <0,6.6,.375>}

object {NotALeg scale <.6,.71,.6> translate <0,0,(16+15.25)/2> rotate <0,0,0> 
translate <0,0,-(16+15.25)/2>} 
object {NotALeg scale <.6,.71,.6> translate <0,0,(16+15.25)/2> rotate <0,7,0> 
translate <0,0,-(16+15.25)/2>} 
object {NotALeg scale <.6,.71,.6> translate <0,0,(16+15.25)/2> rotate <0,14,0> 
translate <0,0,-(16+15.25)/2>} 
object {NotALeg scale <.6,.71,.6> translate <0,0,(16+15.25)/2> rotate <0,-7,0> 
translate <0,0,-(16+15.25)/2>} 
object {NotALeg scale <.6,.71,.6> translate <0,0,(16+15.25)/2> rotate <0,-14,0> 
translate <0,0,-(16+15.25)/2>} 


object {Seat}

object {Leg translate <0,-10,0> scale <1,1,1> 
rotate <10,0,-5> translate <-4,-.375,-8>}
object {Leg translate <0,-10,0> scale <1,1,1> 
rotate <10,0,5> translate <4,-.375,-8>}
object {Leg translate <0,-10,0> scale <1,1,1> 
rotate <-10,0,-5> translate <-4,-.375,-2>}
object {Leg translate <0,-10,0> scale <1,1,1> 
rotate <-10,0,5> translate <4,-.375,-2>}

union {
object {box {<-.25,-.25,0><.25,.25,7.764>}
translate <-4-.44,-5-.375,-8-.882>}
object {box {<-.25,-.25,0><.25,.25,7.764>}
translate <4+.44,-5-.375,-8-.882>}
object {box {<-.25,-.25,-4.155><.25,.25,4.155>}rotate <0,90,0> 
translate <0,-5-.375,-5>}
}

texture {ChairWood}
}

//robot starts here...

#declare Zmeid = <0,0,8>

#declare RAHAmount = 0
#declare RALAmount = 90
#declare LAHAmount = 0
#declare LALAmount = 110

#declare RLHAmount = 70
#declare RLLAmount = -70
#declare LLHAmount = 70
#declare LLLAmount = -70


#declare Metalno1 =
texture {
pigment {colour rgb <.5,.52,.9>}
finish {
ambient .25
brilliance 4
diffuse .5
metallic
specular .8
roughness 1/80
reflection .2
}
}

#declare Metalno2 =
texture {
pigment {colour rgb <.6,.3,.15>}
finish {
ambient .35
brilliance 2
diffuse .3
metallic
specular .8
roughness 1/20
reflection .1
}
}

#declare Metalno3 =
texture {
pigment {colour rgb <1,.85,.55>}
finish {
ambient .35
brilliance 2
diffuse .25
metallic
specular .7
roughness 1/50
reflection .2
}
}

#declare MapMetal =
texture {
material_map {gif "robmap.gif" 
texture {Metalno1}
texture {pigment {colour Black}}
texture {Metalno3}
texture {Metalno1}
texture {Metalno1}
}
}

#declare GreenButtonTex =
texture {
pigment {colour rgb <.2,.9,.2>}
finish {specular .76 roughness .03 brilliance 2}
}

#declare RedButtonTex =
texture {
pigment {colour rgb <1,.2,.2>}
finish {specular .76 roughness .03 brilliance 2}
}


#declare ArmPlate =
union {
prism {
linear_sweep
linear_spline
0,.3
7,
<0,0>
<0,3>
<3,3>
<4,2>
<4,1>
<3,0>
<0,0>
rotate <0,0,-90>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-.3,.3>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-.3,2.7>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-2.7,.3>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-2.7,2.7>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-3.7,1>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-3.7,2>}
texture {Metalno2}
scale <1,.9,1>
}

#declare LegPlate =
union {
box {<0,0,0><.3,-3,3>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-.3,.3>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-.3,2.7>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-2.7,.3>}
sphere {<0,0,0>,.25 scale <1.6,1,1> translate <.15,-2.7,2.7>}
texture {Metalno2}
}

#declare Hand =
union {
sphere {<0,0,0>,1.5 scale <1,1,.5> texture {Metalno2}}
union {
cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,30>}
sphere {<0,4.5,0>,.3 rotate <0,0,30>}
cylinder {<0,4.5,0><0,5.5,0>,.2 rotate <0,0,30>}
sphere {<0,5.5,0>,.2 rotate <0,0,30>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,15>}
sphere {<0,4.5,0>,.3 rotate <0,0,15>}
cylinder {<0,4.5,0><0,6.1,0>,.2 rotate <0,0,15>}
sphere {<0,6.1,0>,.2 rotate <0,0,15>}


cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,0>}
sphere {<0,4.5,0>,.3 rotate <0,0,0>}
cylinder {<0,4.5,0><0,6.35,0>,.2 rotate <0,0,0>}
sphere {<0,6.35,0>,.2 rotate <0,0,0>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,-15>}
sphere {<0,4.5,0>,.3 rotate <0,0,-15>}
cylinder {<0,4.5,0><0,6.1,0>,.2 rotate <0,0,-15>}
sphere {<0,6.1,0>,.2 rotate <0,0,-15>}

cylinder {<0,0,0><0,3.6,0>,.2 rotate <0,0,-40>}
sphere {<0,3.6,0>,.3 rotate <0,0,-40>}
cylinder {<0,3.6,0><0,5,0>,.2 rotate <0,0,-40>}
sphere {<0,5,0>,.2 rotate <0,0,-40>}

difference {
torus {4.5,.2 rotate <90,0,0>}
plane {<1,0,0>,0 rotate <0,0,30>}
plane {<-1,0,0>,0 rotate <0,0,-15>}
}
translate <0,-1.5,0>}
texture {Metalno1}
}

#declare TheGlassTex =
texture {
pigment {colour rgbf <1,1,1,1>}
finish {ambient 0 diffuse 0 reflection .4 phong .3 phong_size 60 
refraction 1 ior 1.5}
}

#declare WaterTex =
texture {
pigment {colour rgbf <1,1,1,1>}
finish {reflection .24 refraction 1 ior 1.33}
}

#declare TheGlass =
union {
        difference {
        object {cylinder {<0,0,0><0,1,0>,1} 
        texture {TheGlassTex}}
        object {cylinder {<0,0,0><0,1,0>,1} 
        texture {TheGlassTex}
        scale .9 translate <0,.3,0>}
        }
        difference {
        object {cylinder {<0,0,0><0,1,0>,1} 
        texture {WaterTex} scale .9 translate <0,.2,0>}
        object {box {<-1.1,.7,-1.1><1.1,1.3,1.1>} 
        texture {WaterTex}}
        }
}

#declare RHand =
union {
object {TheGlass rotate <0,0,-90> scale <4.2,1.8,1.8> 
translate <-1.2,4.5-.2-2,-.2-3.35>}
sphere {<0,0,0>,1.5 scale <1,1,.5> texture {Metalno2}}
union {
cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,20>}
sphere {<0,4.5,0>,.3 rotate <0,0,20>}
cylinder {<0,4.5,0><0,4.5,-1>,.2 rotate <0,0,20>} 
sphere {<0,4.5,-1>,.2 rotate <0,0,20>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,10>}
sphere {<0,4.5,0>,.3 rotate <0,0,10>}
cylinder {<0,4.5,0><0,4.5,-1.6>,.2 rotate <0,0,10>}
sphere {<0,4.5,-1.6>,.2 rotate <0,0,10>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,0>}
sphere {<0,4.5,0>,.3 rotate <0,0,0>}
cylinder {<0,4.5,0><0,4.5,-1.85>,.2 rotate <0,0,0>}
sphere {<0,4.5,-1.85>,.2 rotate <0,0,0>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,-10>}
sphere {<0,4.5,0>,.3 rotate <0,0,-10>}     
cylinder {<0,4.5,0><0,4.5,-1.6>,.2 rotate <0,0,-10>}
sphere {<0,4.5,-1.6>,.2 rotate <0,0,-10>}

cylinder {<0,0,0><0,3.6,0>,.2 rotate <0,0,-30>}
sphere {<0,3.6,0>,.3 rotate <0,0,-30>}
cylinder {<0,3.6,0><0,5,0>,.2 rotate <0,0,-30>}
sphere {<0,5,0>,.2 rotate <0,0,-30>}

difference {
torus {4.5,.2 rotate <90,0,0>}
plane {<1,0,0>,0 rotate <0,0,20>}
plane {<-1,0,0>,0 rotate <0,0,-10>}
}
translate <0,-1.5,0>}
texture {Metalno1}
}

#declare LHand =
object {
sphere {<0,0,0>,1.5 scale <1,1,.5> texture {Metalno2}}
translate <0,-1.5,0>
texture {Metalno1}
}

#declare MainFoot =
union {
union {
cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,24>}
sphere {<0,4.5,0>,.3 rotate <0,0,24>}
cylinder {<0,4.5,0><0,5.25,0>,.2 rotate <0,0,24>}
sphere {<0,5.25,0>,.2 rotate <0,0,24>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,16>}
sphere {<0,4.5,0>,.3 rotate <0,0,16>}
cylinder {<0,4.5,0><0,5.35,0>,.2 rotate <0,0,16>}
sphere {<0,5.35,0>,.2 rotate <0,0,16>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,8>}
sphere {<0,4.5,0>,.3 rotate <0,0,8>}
cylinder {<0,4.5,0><0,5.5,0>,.2 rotate <0,0,8>}
sphere {<0,5.5,0>,.2 rotate <0,0,8>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,0>}
sphere {<0,4.5,0>,.3 rotate <0,0,0>}
cylinder {<0,4.5,0><0,5.6,0>,.2 rotate <0,0,0>}
sphere {<0,5.6,0>,.2 rotate <0,0,0>}

cylinder {<0,0,0><0,4.5,0>,.2 rotate <0,0,-8>}
sphere {<0,4.5,0>,.3 rotate <0,0,-8>}
cylinder {<0,4.5,0><0,5.63,0>,.2 rotate <0,0,-8>}
sphere {<0,5.63,0>,.2 rotate <0,0,-8>}

difference {
torus {4.5,.2 rotate <90,0,0>}
plane {<1,0,0>,0 rotate <0,0,24>}
plane {<-1,0,0>,0 rotate <0,0,-8>}
}
translate <.3,-1.45,0>}
texture {Metalno1}
}

#declare LeftFoot =
union {
difference {
sphere {<0,0,0>,1.4}
plane {<0,0,-1>,0}
texture {Metalno2}}
object {MainFoot translate <0,0,-.2>}
}

#declare RightFoot =
union {
difference {
sphere {<0,0,0>,1.4}
plane {<0,0,-1>,0}
texture {Metalno2}}
object {MainFoot rotate <0,180,0> translate <0,0,-.2>}
}

#declare LeftArm =
union {
sphere {<0,0,0>,1.1 texture {Metalno2}
rotate <LAHAmount,0,0>
}
cylinder {<0,0,0><0,-4,0>,.3 texture {Metalno1}
rotate <LAHAmount,0,0>
}
sphere {<0,0,0>,.5 texture {Metalno2}
rotate <LALAmount,0,0> translate <0,-4,0> rotate <LAHAmount,0,0>}
cylinder {<0,0,0><0,-3,0>,.3 texture {Metalno1}
rotate <LALAmount,0,0> translate <0,-4,0> rotate <LAHAmount,0,0>}
object {LHand scale .4 rotate <0,90,180> 
translate <0,-3,0> rotate <LALAmount,0,0>
translate <0,-4,0> rotate <LAHAmount,0,0>}
}

#declare RightArm =
union {
sphere {<0,0,0>,1.1 texture {Metalno2}
rotate <RAHAmount,0,0>
}
cylinder {<0,0,0><0,-4,0>,.3 texture {Metalno1}
rotate <RAHAmount,0,0>
}
sphere {<0,0,0>,.5 texture {Metalno2}
rotate <RALAmount,0,0> translate <0,-4,0> rotate <RAHAmount,0,0>}
cylinder {<0,0,0><0,-3,0>,.3 texture {Metalno1}
rotate <RALAmount,0,0> translate <0,-4,0> rotate <RAHAmount,0,0>}
object {RHand scale .4 rotate <0,90,180> 
translate <0,-3,0> rotate <RALAmount,0,0>
translate <0,-4,0> rotate <RAHAmount,0,0>}
}

#declare LeftLeg =
union {
sphere {<0,0,0>,1.2 texture {Metalno2} 
rotate <LLHAmount,0,0>}
cylinder {<0,0,0><0,-5,0>,.35 texture {Metalno1} 
rotate <LLHAmount,0,0>}
sphere {<0,0,0>,.6 texture {Metalno2} 
rotate <LLLAmount,0,0> translate <0,-5,0> rotate <LLHAmount,0,0>}
cylinder {<0,0,0><0,-4,0>,.35 texture {Metalno1}
rotate <LLLAmount,0,0> translate <0,-5,0> rotate <LLHAmount,0,0>}
object {LeftFoot scale <.45,.7,.45> rotate <-90,0,180> 
translate <0,-4,0> rotate <LLLAmount,0,0> 
translate <0,-5,0> rotate <LLHAmount,0,0>}
}

#declare RightLeg =
union {
sphere {<0,0,0>,1.2 texture {Metalno2} 
rotate <RLHAmount,0,0>}
cylinder {<0,0,0><0,-5,0>,.35 texture {Metalno1} 
rotate <RLHAmount,0,0>}
sphere {<0,0,0>,.6 texture {Metalno2} 
rotate <RLLAmount,0,0> translate <0,-5,0> rotate <RLHAmount,0,0>}
cylinder {<0,0,0><0,-4,0>,.35 texture {Metalno1}
rotate <RLLAmount,0,0> translate <0,-5,0> rotate <RLHAmount,0,0>}
object {RightFoot scale <.45,.7,.45> rotate <-90,0,180> 
translate <0,-4,0> rotate <RLLAmount,0,0> 
translate <0,-5,0> rotate <RLHAmount,0,0>}
}

#declare GreenButton =
union {
difference {
cylinder {<0,0,0><0,0,-1>,1 translate <0,0,.4>}
sphere {<0,0,0>,1 scale <1,1,.6> translate <0,0,-1> translate <0,0,.4>}
texture {GreenButtonTex}}
torus {1,.2 rotate <-90,0,0> texture {Metalno1}}
}

#declare RedButton =
union {
difference {
cylinder {<0,0,0><0,0,-1>,1}
sphere {<0,0,0>,1 scale <1,1,.6> translate <0,0,-1>}
texture {RedButtonTex}}
torus {1,.2 rotate <-90,0,0> texture {Metalno1}}
}

#declare Neck =
union {
sphere {<0,0,0>,1 scale <1,.4,1>}
sphere {<0,0,0>,1 scale <1,.4,1> translate <0,.4,0>} 
sphere {<0,0,0>,1 scale <1,.4,1> translate <0,.8,0>} 
sphere {<0,0,0>,1 scale <1,.4,1> translate <0,1.2,0>} 
texture {Metalno2}
}


#declare Torso =
union {

difference {
box {<0,0,0><6,-10,4>}
box {<1,-2.5,-.1><5,-7.5,.4>}
texture {MapMetal scale <6,10,1> translate <0,-10,0>}}

object {ArmPlate translate <6,-.5,.5>}
object {ArmPlate translate <-.3,-.5,.5>}

object {LegPlate translate <6,-6.5,.5>}
object {LegPlate translate <-.3,-6.5,.5>}

object {GreenButton scale <.5,.5,.5> translate <3,-3.75-.625,.4>}
object {RedButton scale <.5,.5,.5> translate <3,-6.25-.625,.4>}
//neckplate
object {LegPlate rotate <0,0,90> translate <1.5,0,.5>}
//neck
object {Neck translate <3,.3,2>}

}

#declare Eye =
union {
difference {
sphere {<0,0,0>,1} 
cylinder {<0,0,.1><0,0,-1.1>,.04}
texture {pigment {colour rgb <.2,.2,.2>}normal {bumps .6 bump_size .2}
finish {specular .8 roughness .01}}}
}

#declare Nose =
union {
cylinder {<0,0,0><0,0,-.2>,.2}
sphere {<0,0,-.2>,.2}
texture {Metalno3}
}

#declare M = cylinder {<-1,0,-1><-1,0,1>,.025}

#declare Mouth =
union {
torus {1,.25 texture {Metalno3}}
cylinder {<0,0,0><0,.0001,0>,1 pigment {colour Black}}
intersection {
union {
object {M} 
object {M translate <.1,0,0>}
object {M translate <.2,0,0>}
object {M translate <.3,0,0>}
object {M translate <.4,0,0>}
object {M translate <.5,0,0>}
object {M translate <.6,0,0>}
object {M translate <.7,0,0>}
object {M translate <.8,0,0>}
object {M translate <.9,0,0>}
object {M translate <1,0,0>}
object {M translate <1.1,0,0>}
object {M translate <1.2,0,0>}
object {M translate <1.3,0,0>}
object {M translate <1.4,0,0>}
object {M translate <1.5,0,0>}
object {M translate <1.6,0,0>}
object {M translate <1.7,0,0>}
object {M translate <1.8,0,0>}
object {M translate <1.9,0,0>}
object {M translate <2,0,0>}

texture {Metalno1}
}
sphere {<0,0,0>,1}}
}


#declare Head =
union {
box {<-1,0,-1.75><1,2,0> texture {Metalno1}}
box {<-1,0,0><1,2,2> texture {Metalno1}}
object {Eye scale .2 translate <-.4,1.55,-1.75>}
object {Eye scale .2 translate <.4,1.55,-1.75>}
object {Nose translate <0,1.15,-1.75>}
object {Mouth rotate <-90,0,0> scale .28 translate <0,.45,-1.75>}
}

// 60*70
lathe {
cubic_spline
26,
<28,75>//cp
<30.3,50.6>
<32,26.3>
<33.8,2>
<16.8,2>
<0,2.1>
<0,1.2>
<0,.4>
<17.8,.4>
<35.9,.4>
<34.2,25.3>
<32.5,50.3>
<33.4,58.1>
<34.3,66>
<37.25,66.6>
<42.8,67.2>
<51.3,65.8>
<57.7,62.8>
<58.8,63.4>
<60,63.9>
<54.7,66.8>
<44.5,68.9>
<35.7,68.2>
<32.7,67.4>
<31.5,59>
<30,50>//cp
pigment {colour rgb <.1,.1,.1>}
finish {specular .45 roughness .1}
rotate <180,0,0>
translate <0,68.9,0>
scale .1
translate <0,10.4+(14.9*1.4),0>
translate Zmeid
}

#declare BigRobot =
union {
object {Torso}
object {RightArm rotate <0,30,0> translate <-.3,-2,2>}
object {LeftArm rotate <0,-90,30> translate <6.3,-2,2>}
object {RightLeg translate <-.3-.36,-8,2>}
object {LeftLeg translate <6.3+.36,-8,2>}
object {Head scale <1.75,1.75,1.3> translate <3,1.5,2>}
}

//translate <-3,-10,-2> places the origin at centre of the bottom of the torso
object {BigRobot translate <-3,10,-2>
scale 1.4  
translate <0,10.4,0>
translate Zmeid
}

//smaller robot starts here...such a waste of space!

#declare RAHAmount2 = 0
#declare RALAmount2 = 0
#declare LAHAmount2 = 0
#declare LALAmount2 = 0

#declare RLHAmount2 = 0
#declare RLLAmount2 = 0
#declare LLHAmount2 = 0
#declare LLLAmount2 = 0

#declare LeftArm2 =
union {
sphere {<0,0,0>,1.1 texture {Metalno2}
rotate <LAHAmount2,0,0>
}
cylinder {<0,0,0><0,-4,0>,.3 texture {Metalno1}
rotate <LAHAmount2,0,0>
}
sphere {<0,0,0>,.5 texture {Metalno2}
rotate <LALAmount2,0,0> translate <0,-4,0> rotate <LAHAmount2,0,0>}
cylinder {<0,0,0><0,-3,0>,.3 texture {Metalno1}
rotate <LALAmount2,0,0> translate <0,-4,0> rotate <LAHAmount2,0,0>}
object {Hand scale .4 rotate <0,90,180> 
translate <0,-3,0> rotate <LALAmount2,0,0>
translate <0,-4,0> rotate <LAHAmount2,0,0>}
}

#declare RightArm2 =
union {
sphere {<0,0,0>,1.1 texture {Metalno2}
rotate <RAHAmount2,0,0>
}
cylinder {<0,0,0><0,-4,0>,.3 texture {Metalno1}
rotate <RAHAmount2,0,0>
}
sphere {<0,0,0>,.5 texture {Metalno2}
rotate <RALAmount2,0,0> translate <0,-4,0> rotate <RAHAmount2,0,0>}
cylinder {<0,0,0><0,-3,0>,.3 texture {Metalno1}
rotate <RALAmount2,0,0> translate <0,-4,0> rotate <RAHAmount2,0,0>}
object {Hand scale .4 rotate <0,90,180> 
translate <0,-3,0> rotate <RALAmount2,0,0>
translate <0,-4,0> rotate <RAHAmount2,0,0>}
}

#declare LeftLeg2 =
union {
sphere {<0,0,0>,1.2 texture {Metalno2} 
rotate <LLHAmount2,0,0>}
cylinder {<0,0,0><0,-5,0>,.35 texture {Metalno1} 
rotate <LLHAmount2,0,0>}
sphere {<0,0,0>,.6 texture {Metalno2} 
rotate <LLLAmount2,0,0> translate <0,-5,0> rotate <LLHAmount2,0,0>}
cylinder {<0,0,0><0,-4,0>,.35 texture {Metalno1}
rotate <LLLAmount2,0,0> translate <0,-5,0> rotate <LLHAmount2,0,0>}
object {LeftFoot scale <.45,.7,.45> rotate <-90,0,180> 
translate <0,-4,0> rotate <LLLAmount2,0,0> 
translate <0,-5,0> rotate <LLHAmount2,0,0>}
}

#declare RightLeg2 =
union {
sphere {<0,0,0>,1.2 texture {Metalno2} 
rotate <RLHAmount2,0,0>}
cylinder {<0,0,0><0,-5,0>,.35 texture {Metalno1} 
rotate <RLHAmount2,0,0>}
sphere {<0,0,0>,.6 texture {Metalno2} 
rotate <RLLAmount2,0,0> translate <0,-5,0> rotate <RLHAmount2,0,0>}
cylinder {<0,0,0><0,-4,0>,.35 texture {Metalno1}
rotate <RLLAmount2,0,0> translate <0,-5,0> rotate <RLHAmount2,0,0>}
object {RightFoot scale <.45,.7,.45> rotate <-90,0,180> 
translate <0,-4,0> rotate <RLLAmount2,0,0> 
translate <0,-5,0> rotate <RLHAmount2,0,0>}
}


#declare LittleRobot =
union {
object {Torso}
object {RightArm2 rotate <0,0,-20> translate <-.3,-2,2>}
object {LeftArm2 rotate <0,0,20> translate <6.3,-2,2>}
object {RightLeg2 translate <-.3-.36,-8,2>}
object {LeftLeg2 translate <6.3+.36,-8,2>}
object {Head scale <1.75,1.75,1.3> translate <3,1.5,2>}
}

//translate <-3,-10,-2> places the origin at centre of the bottom of the torso
object {LittleRobot translate <-3,10,-2>
scale .5  
translate <3.3*1.4,8*1.4,0>
translate <5.4,-3,-.42>
translate <0,10.4,0>
pigment {colour rgb <0,6,0>}
translate Zmeid
}


//stage begins here...

#declare BoardWood = 
pigment {
wood
turbulence <.08,.08,.12>
octaves 3
scale <.25,.25,1>
color_map {
[0, .1  color rgb <.880, .600, .3> color rgb <.888, .600, .3>]
[.1, .9 color rgb <.888, .600, .3> color rgb <.600, .400, .2>]
[.9, 1  color rgb <.600, .400, .2> color rgb <.600, .400, .2>]
}
rotate <3,2,1>
warp {
black_hole
<-77,.2,20>,1
falloff 2
strength 1.5
inverse
repeat <6,4,6>
turbulence <.2,.4,.6>
}
scale 4/18
}

#declare BoardWood2 =
texture {
pigment {
gradient x
pigment_map {
[0.000 BoardWood]
[.3333 BoardWood] 
[.3333 BoardWood rotate <0,-4,0> translate <0,5,60>] 
[.6667 BoardWood rotate <0,-4,0> translate <0,5,60>]
[.6667 BoardWood translate <0,-5,100>]
[1.001 BoardWood translate <0,-5,100>]
}
}
finish {specular .4 roughness .2 ambient .2}
scale 18 translate <-80,0,0>
}

#declare PaintedWood =
texture {pigment {BoardWood}}
texture {
pigment {colour rgbf <.1,.1,.1,.2>}
normal {dents .5 scale .1}
finish {specular .6 roughness .1}
}

#declare PurpleCurtain =
texture {
pigment {
granite
turbulence .2
colour_map {
[0 colour rgb <.6,0,.32>]
[.4 colour rgb <.5,.05,.27>]
[.7 colour rgb <.55,0,.3>]
[1 colour rgb <.58,.03,.3>]}
}
finish {specular .2 roughness .3 
ambient colour rgb <.55,0,.27> diffuse .6}
}

#declare Count1 = 0
#declare Boards =
intersection {
        union {
        box {<-81,1,0><81,-21,60>}
        box {<-20,1,0><20,-21,-12>}
        }

        union {
        #while (Count1 <= 30)
        object {box {<-79.95,0,60><-74.05,-1,-12>}translate <Count1*6,0,0>}
        #declare Count1 = Count1 + 1
        #end
        }
texture {BoardWood2}
}

#declare Stage =
union {
box {<-80,-1,0><80,-20,60>}
box {<-20,-1,0><20,-20,-12>}

box {<-80,1.5,1.5><-18.5,-1.5,-1.5>}
box {<80,1.5,1.5><18.5,-1.5,-1.5>}
box {<-18.5,1.5,0><-21.5,-1.5,-12>}
box {<18.5,1.5,0><21.5,-1.5,-12>}
box {<-21.5,1.5,-10.5><21.5,-1.5,-13.5>}

union {Boards}
texture {PaintedWood}
}

#declare Curtain =
object {
prism {
linear_sweep
cubic_spline
0,80,
26,
<-88,8>//cp
<-80,0>
<-72,-8>
<-64,-1>
<-49,-7>
<-41,-1>
<-34,-7>
<-28,-1>
<-22,-2>
<-16,-8>
<-13,-6>
<-10,-.5>
<-7,-6>
<-4,-1>
<0,-7>
<5,-1>
<15,-8>
<29,-.5>
<41,-8>
<53,-1>
<59,-8>
<65,-1>
<73,-8>
<80,0>
<-80,0>
<-88,0>//cp
}
texture {PurpleCurtain}
}

//some stars...
#declare Star =
prism {
linear_sweep
linear_spline
-.02,.02
11,
<0,1>
<.3,.2>
<.77,.2>
<.4,-.2>
<.5,-.9>
<0,-.5>
<-.5,-.9>
<-.4,-.2>
<-.8,.22>
<-.33,.22>
<0,1>
scale 2
rotate <-90,0,0>
}

#declare SFin = finish {ambient .2 diffuse .75 specular .3 roughness .1}

#declare Stars =
union {
object {Star rotate <0,180,0> translate <-49,34,-7-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,0,0> translate <-34,28,-7-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,0,72> translate <-34,15,-7-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,180,-144> translate <-16,30,-8-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,0,72> translate <-16,10,-8-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,180,0> translate <-7,25,-6-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,180,-72> translate <0,12,-7-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,0,144> translate <15,28,-8-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
object {Star rotate <0,175,0> translate <15.5,15,-8-.2> 
pigment {colour rgb <1,1,0>}
finish {SFin}}
}

object {Stars scale 1.5 translate <0,0,50>}
object {Curtain scale 1.5 translate <0,0,50>}

object {Stage scale <1.1,1,1>}

object {Chair translate <0,10.4,5> translate Zmeid}

background {colour rgb <.15,.15,.15>}

//sign starts here...

#declare Board =
object {
box {<0,0,0><4,-5,-.25>}
texture {
pigment {
image_map {gif "robsign.gif" interpolate 2 map_type 0}scale <4,5,1>}
finish {specular .4 roughness .2 ambient .2}
}
}

#declare Sign =
union {
object {Board rotate <20,0,0>}
object {Board rotate <20,0,0> rotate <0,180,0> translate <4,0,0>
texture {pigment {colour White}finish {specular .4 roughness .2 ambient .2}}}
}

object {Sign rotate <0,-90,0> translate <0,5*cos(radians(20)),0> 
scale 3.75 translate <-50,0,8>}

//box starts here...

#declare RobotsBox =
difference {

box {<0,0,0><1,1,1>
texture {
pigment {
image_map {gif "robbox.gif" map_type 0 interpolate 2}
scale <sqrt(2),1,1> rotate <0,45,0>}
finish {specular .4 roughness .1}}
}
box {<.05,.05,.05><.95,1.05,.95>
texture {
pigment {colour rgb <1,0,0>}
finish {specular .4 roughness .1}}
}

}

//speaker starts here

#declare Speaker =
union {
lathe {
cubic_spline
10,
<4,-106>//cp
<20,0>
<25.9,105.9>
<41.3,181.5>
<60,200>
<55,205.1>
<33.9,185.5>
<18,108.8>
<14.1,10.2>
<10,-90>//cp
sturm
}
lathe {
linear_spline
7,
<7.3,0>
<7.8,142.5>
<14.1,142.6>
<14.1,150.6>
<0,150.6>
<0,0>
<7.3,0>
sturm
scale <1,1.3,1>
}
}

#declare Cable =
union {
difference {torus {10,.3}box {<-11,-1,0><11,1,-11>}
scale <1,1,.2>}
difference {torus {10,.3}box {<-11,-1,0><11,1,11>}
scale <1,1,.2> translate <20,0,0>}
translate <0,.5,0>
texture {
pigment {colour rgb <.05,.05,.05>}
finish {specular .2 roughness .05}}
}

object {RobotsBox scale <8,6,8> translate <10,0,9>}
object {Speaker pigment {colour rgb <.6,.6,.6>}finish {specular .7 roughness .05} 
rotate <-16,0,26> scale .04 translate <16,0,15>}
object {Cable translate <16+10,0,13>}

