
// Glenn's "Color" POV-Ray Scene File
// created 18-Sep-97 for the Sep/Oct 1997 Internet Ray Tracing Competition
// at http://www.irtc.org
// last update 20-Oct-97
// copyright 1997 Glenn McCarter

// A still frame from a movie.

// NOTE: these files have many embedded tabs.
// For best viewing, use the POV-Ray for Windows editor,
// and set Editor | Tabs | Real Tabs, with tab size 2.

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "GIncludeRH.inc"
//#include "GRuler.inc"


//===============================================
//             Variables
//===============================================

#declare Wet = 1 // 1 makes the scene wet, otherwise dry
#declare Rain = 1 // 1 makes it raining, otherwise not
#declare Color = 0 // 1 makes the scene with color, otherwise greyscale
#declare HeadlampOn = 0 // turns car headlamps on/off
#declare Car = 1 // includes car, or not
#declare AllBuildings = 1 // turns indirectly seen buildings on/off

#include "Rose.inc"
#include "CityBuildings.inc"
#include "Trashcan.inc"
#include "Umbrella.inc"
#include "StreetScene.inc"
#include "StopLight.inc"
#include "RainCoat.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <2.0, 0.0,  0.0> // makes background taller
  angle 60
/*   // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture 0.4    //lower value = wider range in focus
  focal_point <0,0,48>
	confidence .50
	variance 1/64
*/   // end focal blur
  location  <-42, -18, 56>
  look_at   <0, -7, 52>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
//  up        <0.0,     0.0,  1.5>  // makes background shorter
//  right     <1.33333, 0.0,  0.0>
  right     <2.0, 0.0,  0.0> // makes background taller
  angle 60
//  location  <-42, -12, 56> // off to the side rh (test render view)
//  look_at   <0, -4, 52>
//  location  <-42, -18, 56> // more off to the side rh (test render view)
//  look_at   <0, -4, 52>
  location  <-42, -18, 56> // more pointed rh (render view)
  look_at   <0, -7, 52>
//  location  <-42, 14, 56> // off to the side lh
//  look_at   <0, 7, 52>
//  location  <48*Feet, 73*Feet, 56> // far LH buildings closeup
//  look_at   <70*Feet, 76*Feet, 52>
//  location  <55*Feet, 23*Feet, 56> // far LH corner closeup
//  look_at   <70*Feet, 26*Feet, 52>
//	location <-200*Feet,0,200*Feet> // helicopter view
//	look_at <0,0,20*Feet>
//	location <-400*Feet,0,400*Feet> // blimp view
//	look_at <80*Feet,0,20*Feet>
  }

camera {
//    Special_Cam
    Render_Cam
  }

#declare SepiaFilter =
	box {
		<0,-10,-10>,<.01,10,10>
//		texture { pigment { color rgbf<1.0,0.6,0.0,.98> } } // too deep rich
		texture { pigment { color rgbf<1.4,1.3,1.2,1.0> } } // slight tint, ok
//		texture {	pigment { color rgbf<1.4,1.4,1.2,1.0> } } // too bright, more yellowish
	}
object { SepiaFilter translate <-40,-18,56> }

#declare GrainyFilter =
	box {
		<0,-10,-10>,<.01,10,10>
		texture {
			pigment {
				bozo
				color_map {
					[ 0.00  color rgbf<1.0,1.0,1.0,1.0> ]
					[ 0.90  color rgbf<1.0,1.0,1.0,1.0> ]
					[ 0.95  color rgbf<0.64,0.64,0.50,0.7> ]
					[ 1.00  color rgbf<0.64,0.64,0.50,0.7> ]
				}
			}
		scale .003
		}
	}
//object { GrainyFilter translate <-39,-18,56> }

//===============================================
//             Textures
//===============================================

#declare Grey10 =
	texture {
		pigment { color rgb<.1,.1,.1> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey20 =
	texture {
		pigment { color rgb<.2,.2,.2> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey30 =
	texture {
		pigment { color rgb<.3,.3,.3> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey50 =
	texture {
		pigment { color rgb<.5,.5,.5> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey60 =
	texture {
		pigment { color rgb<.6,.6,.66> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#switch ( Color )
#case (1) // make the textures colorful
	#declare SkinTex =
		texture {
			pigment { color rgb<.93,.62,.35> }
			finish { ambient .12 specular .1 roughness .1 }
		}
	#declare ShoeTex =
		texture {
			pigment { color rgb<.93,.04,.08> }
			finish { ambient .02 specular .95 roughness .01 }
		}
#break
#else // make the textures greyscale
	#declare SkinTex =
		texture {
			pigment { color rgb<.33,.35,.30> }
			finish { ambient .12 specular .4 roughness .08 }
		}
	#declare ShoeTex =
		texture {
			pigment { color rgb<.38,.34,.33> }
			finish { ambient .02 specular .95 roughness .01 }
		}
#end

#switch ( Wet )
#case (1) // wet
	#declare BumpyShiny =
		texture {
			pigment { color rgb<.035,.035,.046> }
			normal { bumps 0.4 scale 1/17 } // final size is 14...
			finish { ambient .02 specular .1 roughness .1 reflection .4 }
		}
	#declare SmoothShiny =
		texture {
			pigment { color rgb<.035,.035,.046> }
			normal { bumps 0.05 scale 4/17 }
			finish { ambient .02 specular .1 roughness .1 reflection .6 }
//			finish { ambient .02 specular .1 roughness .1 }
		}
#declare RoadwayTex =
		texture {
			bozo
			texture_map {
				[ 0.00 BumpyShiny ]
				[ 0.60 BumpyShiny ]
				[ 0.70 SmoothShiny ]
				[ 1.00 SmoothShiny ]
			}
			scale 17
		}
#break
#else // dry
	#declare RoadwayTex =
		texture {
			pigment { color rgb<.090,.093,.097> }
//			normal { bumps 0.3 scale 2 }
			finish { ambient .02 specular .2 roughness .08 }
		}
#end

//===============================================
//             Lighting
//===============================================

object { StreetCornerLight translate <50*Feet,10,0> } // near
object { StreetCornerLight rotate z*-30 translate <64*Feet,28*Feet,0> } // LH corner

#declare SBrightness = 2.5 // pretty darn bright
#declare SDistance = 12*Feet
#include "StreetLight.inc"
object {StreetLightArm rotate z*150 translate <90*Feet,54*Feet,18*Feet> } // far scene LH corner of building
object {StreetLightArm rotate z*-120 translate <124*Feet,3*Feet,18*Feet> } // far scene RH

#declare SBrightness = 1.2 // these lights are dimmer
#declare SDistance = 12*Feet
#include "StreetLight.inc"
object {StreetLight rotate z*-90 translate <140*Feet,-70*Feet,-18*Feet> } // around corner RH

// Test Lights
//object {StreetLightA rotate z*-90 translate <-13*Feet,12*Feet,-18*Feet> } // near area_light
//object { StdBulb100Watt translate <-88,48,88> } // illum near scene
//object { StdBulb100Watt translate <-248*Feet,100*Feet,88*Feet> } // big overhead illum
//object { StdBulb100Watt translate <148*Feet,-200*Feet,88*Feet> } // big overhead illum far
//object {StreetLightArm rotate z*150 translate <86*Feet,44*Feet,18*Feet> } // far scene LH center of building



#declare NearSpot =
  light_source {
    <-40, -24, 10*Feet>
    colour rgb <1.0,1.0,1.0>
    spotlight
    point_at <0, 0, -10>
    radius 16    // degrees fully lit (*2)
    falloff 24   // degrees no lighting (*2)
    tightness 1
		fade_distance 8*Feet
		fade_power 1
  }
object { NearSpot } // illuminates the trashcan

#declare WindowSpot =
  light_source {
    <18*Feet, -2.5*Feet, 16*Feet>
    colour rgb <1.0,1.0,0.96>
    spotlight
    point_at <23*Feet, 0, 5*Feet>
    radius 18    // degrees fully lit (*2)
    falloff 43   // degrees no lighting (*2)
    tightness 1
		fade_distance 6*Feet
		fade_power 1
	  }
object { WindowSpot } // highlights the woman


//===============================================
//             Environment
//===============================================

background { color rgb <0.05, 0.1, 0.3> }
sky_sphere {
	pigment {
		gradient z
		color_map {
			[0 color rgb<.12,.12,.16> ]
			[1 color rgb<0,0,0> ]
		}
	}
}

#declare Street =
	difference {
		box { // road
			<-1*Mile,-1*Mile,-4>,<1*Mile,1*Mile,0>
			texture { RoadwayTex }
		}
		cylinder { // manhole
			<0,0,-5>,<0,0,1>,12.1
			translate <13*Feet,14*Feet,0>
			texture { RoadwayTex }
		}
	}

fog {
	distance 150*Feet
//	color rgb<.45,.45,.45> // light
//	color rgb<.09,.09,.10> // dark, ok
//	color rgb<.03,.03,.05> // darker best
	color rgb<.013,.012,.011> // very dark
//	color rgb<.00,.00,.00> // try it black
}


/*
atmosphere {
	type 3
		samples 10
		distance 300
		scattering 0.0005
//		color rgbf<0,0,0,.5>
	}
*/

#switch ( Rain )
#case (1) // if Rain=1 then add this rain
#declare RS = seed(32715)
#declare NumDrops = 2000 // total number of raindrops
#declare WhiteRain = 0 // 0 for clear, 1 for white (for quicker rendering)
#declare RainScale = 3 // elongation of the drops
#declare RainXAngle = -20
#declare RainYAngle = 4
#declare RainX = 30*Feet
#declare RainY = 20*Feet
#declare RainZ = 10*Feet
#include "Rain.inc"
object { RainShower translate <-3*Feet,-10*Feet,0> }
object { TrashCanDrips }
#end

//===============================================
//             Objects
//===============================================


#declare StreetCorner =
	object { RoundedBox
		translate <.5,.5,.5> // origin at corner, box in XY
		scale <8*Feet,8*Feet,4>
		texture { SideWalkTex }
	}

#declare Shoe =
	#include "HalfShoe.pov"
	union {
		object { HalfShoe }
		object { HalfShoe scale <-1,1,1> }
		object { Stiletto translate <0,-5,-2.5> }
		scale .45
		rotate <0,0,-90>
	}
#declare LegWithShoe =
	union {
		object { Shoe }
		#include "LowerLeg.pov"
		object { LowerLeg scale <.8,1,1> rotate <0,0,-90> translate <-1,0,2> }
	}
#declare Head =
	union {
		sphere { // head
			<0,0,0>,4
			scale <0.9,0.92,1.0>
			texture { pigment { rgb<0,0,0> } finish { ambient .01 specular .03 roughness .02 } }
		}
	}
#declare Woman = // origin at center of head
	union {
		object { Head }
		object { RainCoat }
		object { LegWithShoe rotate <-6,0,8> translate <0,1,-60> } // LH
		object { LegWithShoe rotate <6,38,-2> translate <-8,-1,-57> } // RH
	}
#declare WomanWithUmbrella =
	union {
		object { Woman }
		object { Umbrella rotate <0,0,-10> rotate <-10,-12,0> translate <9,7,-16> }
	}

#switch ( Car )
#case ( 1 )
	#declare SteeringAngle = 5
	#declare LFJounce = 0
	#declare LRJounce = 0
	#declare RRJounce = 0
	#declare RimColor = color rgb<.06,.03,.06>
	#include "Chevy37.inc"
//	object { Chevy37 rotate z*0 translate <20*Feet,25*Feet,-4> } // across street
	object { Chevy37 rotate <-2,0,60> translate <43*Feet,42*Feet,-4> } // around corner
	object { Chevy37 rotate <-3,0,240> translate <82*Feet,67*Feet,-4> } // far side under light
#break
#else
#end


//===============================================
//             Object Assemblies
//===============================================

#declare BlockOBuildingsWithGrate =
	union {
		difference {
			object {BlockOBuildings1 }
			box { // grating hole
				<0,0,-22>,<24,9,1>
				texture { BlackTopTex }
				scale <2.2,1.5,1>
				translate <24*Feet,-5,0>
			}
		} // end difference
		object { GratingWithSteam scale <2.2,1.5,1> translate <24*Feet,-5,.15> }
	} // end union


//===============================================
//             Object Placement
//===============================================


object { DentedTrashCanHFull }
object { Rose rotate <0,-10,-120> translate <-8,-4.5,49.6> } // right
object { OuterPetal rotate <-30,0,-140> translate <-9,-4.5,46.5> } // right

object { WomanWithUmbrella rotate <0,0,-10> translate <23*Feet,-1.8*Feet,60> }
object { Street translate <0,0,-4> }
object { StreetSign rotate <0,0,-18> translate <30*Feet,30*Feet,7.4*Feet> }
object { StreetCorner rotate z*-20 translate <22*Feet,28*Feet,0> } // test

object { OldBench rotate <0,0,179> translate <18*Feet,1.5*Feet,0> } // test near
object { BusStopSign rotate <0,0,-30> translate <75*Feet,44.5*Feet,0> } // test far
object { OldBench rotate <0,0,-120> translate <75*Feet,43*Feet,0> } // test far
object { ManHoleCover rotate z*-8 translate <13*Feet,14*Feet,-3.75> }
object { Hanging3StopLight rotate <0,0,-12> translate <55*Feet,20*Feet,15*Feet> }
object { BlockOBuildingsWithGrate rotate z*180 translate <50*Feet,-6*Feet,0> } // scene near RH
object { BlockOBuildingsM1 rotate z*-30 translate <80*Feet,30*Feet,0> } // scene background
object { BlockOBuildingsM1 rotate z*-120 translate <150*Feet,145*Feet,0> } // scene back LH

#switch ( AllBuildings )
#case (1)
//	object { BlockOBuildingsS2 translate <-50*Feet,43*Feet,0> } // across the street
	object { BlockOBuildingsS1 rotate z*-30 translate <170*Feet,-20*Feet,0> } // background far RH
	object { BlockOBuildingsS2 rotate z*150 translate <120*Feet,-70*Feet,0> } // around corner RH
	object { BlockOBuildingsS1 rotate z*150 translate <220*Feet,-130*Feet,0> } // around corner RH
	object { BlockOBuildingsS1 rotate z*180 translate <300*Feet,-150*Feet,0> } // around corner RH
	object { BlockOBuildingsS2 rotate z*20 translate <100*Feet,200*Feet,0> } // around corner LH
	object { BlockOBuildingsS1 rotate z*60 translate <50*Feet,100*Feet,0> } // around corner LH
	object { BlockOBuildingsS1 rotate z*-60 translate <200*Feet,240*Feet,0> } // around corner LH
#break
#else
#end

// TEST OBJECTS - DO NOT RENDER
//object { Rose rotate <0,-10,150> translate <-9,2,49> } // left
//object { Petal rotate <30,-20,0> translate <-10,2,45> } // left
//object { RTrashCan }
//object { TestSphere scale 29 translate <0,10,0> }
//object { LegWithShoe rotate z*-40 translate <0,0,50> }
//object { BlockOBuildingsS2 rotate z*20 translate <-150*Feet,20*Feet,0> } // behind camera
//object { BlockOBuildingsS1 rotate z*-160 translate <-50*Feet,-24*Feet,0> } // behind camera
//object { Umbrella translate <12,-10,30> }
//object { Umbrella rotate <-22,-12,0> translate <22,10,40> }
//object { GratingWithSteam scale 2 translate <21*Feet,-6*Feet,.4> }
//object { BusStopSign rotate <0,0,-90> translate <7*Feet,1*Feet,0> } // test near
//object { WomanWithUmbrella rotate <0,0,-10> translate <27*Feet,0*Feet,60> }
