
#include "trash.pov"

// Glenn's Trash POV-Ray Object File
// This file does not render.  #include "trash.inc" in another .pov file
// first concept 19-Sep-97  last update 7-Oct-97
// copyright 1997 Glenn McCarter

// A pile of trash
// objects:
//		AlumCan
//		TinCan
//		CandyBox
//		CrumpledTrash
//		WavyTrash
//		NewsPaperSheet
//		RolledNewsPaper
//		WoodBlock
//		Bottle
//		TrashGroup1
// Intended scale is English system (inches)
// origins are all over the place.  Sorry.
// Uses RH coord system

//===============================================
//             Textures
//===============================================


#switch ( Color )
#case (1) // color rendering
#declare AlumCanTex =
	texture {
		pigment { color rgb<.68,.68,.73> }
		normal { bumps 0.2 scale .7 }
		finish { ambient .02 diffuse .3 specular .95 roughness .0012
			metallic brilliance 3 reflection .36 }
	}
#declare CandyBoxTex =
	texture {
		pigment { color rgb<.93,.98,.99> }
		normal { bumps 0.01 scale 1.4 }
		finish { ambient .2 specular .95 roughness .006 }
	}
#declare NewsWhite =
	texture {
		pigment { color rgb<.70,.69,.66> }
		normal { bumps 0.2 scale 0.3 }
		finish { ambient .22 specular .34 roughness .08 }
	}
#declare RoughGrey20 =
	texture {
		pigment { color rgb<.23,.24,.20> }
		normal { bumps 0.2 scale 1.3 }
		finish { ambient .02 specular .34 roughness .06 }
	}

#declare GWoodColD1 = //darker
color_map {
	[0.0 color rgb <0.44, 0.30, 0.20>]
	[0.1 color rgb <0.44, 0.30, 0.20>]
	[0.1 color rgb <0.44, 0.30, 0.20>]
	[0.9 color rgb <0.30, 0.15, 0.10>]
	[0.9 color rgb <0.30, 0.15, 0.10>]
	[1.0 color rgb <0.30, 0.15, 0.10>]
}
#declare GWoodColD2 = //darker
color_map {
	[0.0 color rgbf <0.27, 0.16, 0.10, 0.100>]
	[0.1 color rgbf <0.27, 0.16, 0.10, 0.500>]
	[0.1 color rgbf <0.27, 0.17, 0.10, 0.650>]
	[0.2 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[0.2 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[0.3 color rgbf <0.30, 0.15, 0.10, 1.000>]
	[0.3 color rgbf <0.30, 0.15, 0.10, 0.100>]
	[0.4 color rgbf <0.30, 0.15, 0.10, 0.500>]
	[0.4 color rgbf <0.30, 0.15, 0.10, 0.650>]
	[0.9 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[0.9 color rgbf <0.44, 0.30, 0.20, 0.975>]
	[1.0 color rgbf <0.27, 0.16, 0.10, 1.000>]
}
#declare WoodGrainPig1 =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}
#declare WoodGrainPig2 =
pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}
#declare DriftWoodTex = //this is a layered texture
    texture { pigment { WoodGrainPig1  color_map { GWoodColD1 }}}
    texture { pigment { WoodGrainPig2  color_map { GWoodColD2 }}}

#else // greyscale rendering

#declare AlumCanTex =
	texture {
		pigment { color rgb<.68,.68,.72> }
		normal { bumps 0.2 scale .7 }
		finish { ambient .02 diffuse .3 specular .99 roughness .0012
			metallic brilliance 3 reflection .36 }
	}
#declare CandyBoxTex =
	texture {
		pigment { color rgb<.93,.98,.99> }
		normal { bumps 0.01 scale 1.4 }
		finish { ambient .12 specular .95 roughness .006 }
	}
#declare NewsWhite =
	texture {
		pigment { color rgb<.70,.69,.66> }
		normal { bumps 0.2 scale 0.3 }
		finish { ambient .12 specular .34 roughness .08 }
	}
#declare RoughGrey20 =
	texture {
		pigment { color rgb<.23,.24,.20> }
		normal { bumps 0.2 scale 1.3 }
		finish { ambient .02 specular .34 roughness .06 }
	}
#declare GWoodColD1 = //greyscale
color_map {
	[0.0 color rgb <0.32, 0.30, 0.30>]
	[0.1 color rgb <0.62, 0.60, 0.60>]
	[0.1 color rgb <0.42, 0.40, 0.40>]
	[0.5 color rgb <0.35, 0.32, 0.33>] // test
	[0.9 color rgb <0.18, 0.15, 0.16>]
	[0.9 color rgb <0.12, 0.12, 0.10>]
	[1.0 color rgb <0.05, 0.05, 0.05>]
}
#declare GWoodColD2 = //greyscale
color_map {
	[0.0 color rgbf <0.17, 0.16, 0.15, 0.100>]
	[0.1 color rgbf <0.17, 0.16, 0.15, 0.500>]
	[0.1 color rgbf <0.22, 0.21, 0.20, 0.650>]
	[0.2 color rgbf <0.31, 0.30, 0.30, 0.975>]
	[0.3 color rgbf <0.20, 0.21, 0.20, 1.000>]
	[0.3 color rgbf <0.20, 0.21, 0.20, 0.100>]
	[0.4 color rgbf <0.20, 0.21, 0.20, 0.500>]
	[0.4 color rgbf <0.20, 0.21, 0.20, 0.650>]
	[0.9 color rgbf <0.32, 0.31, 0.30, 0.975>]
	[0.9 color rgbf <0.32, 0.31, 0.30, 0.975>]
	[1.0 color rgbf <0.22, 0.22, 0.22, 1.000>]
}
#declare WoodGrainPig1 =
pigment {
    wood
//    turbulence 0.04
    turbulence 0.10
    octaves 3
    scale <0.05, .05, 1>
}
#declare WoodGrainPig2 =
pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}
#declare DriftWoodTex = //this is a layered texture
    texture { pigment { WoodGrainPig1  color_map { GWoodColD1 }}}
//    texture { pigment { WoodGrainPig2  color_map { GWoodColD2 }}}

#end // greyscale

#declare OldNewsPaperTex =
	texture {
		pigment { color rgb<.86,.84,.82> }
		normal { bumps .02 scale 1.3 }
		finish { ambient .02 specular .3 roughness .09 }
	}
#declare TrashTex =
	texture {
		pigment { color rgb<.32,.34,.36> }
		normal { bumps .04 scale .3 }
		finish { ambient .02 specular .3 roughness .09 }
	}
#declare SodaBottleGlass =
	texture {
		pigment { color rgbf<.92,.96,.93,.85> }
//		pigment { color rgb<.92,.96,.73> } // test
		normal { bumps .04 scale 2 }
		finish { ambient .02 specular .9 roughness .002 refraction 1 ior 1.5 }
//		finish { ambient .22 specular .9 roughness .002 } // test
	}



//===============================================
//             Trash
//===============================================

#declare AlumCan =
	union {
		torus { // upper rim
			1.32,.05
			rotate x*90
			scale <1,1,1.5>
			translate <0,0,5.25>
		}
		cone { // upper underrim
			<0,0,5>,1.3,<0,0,5.2>,1.2
		}
		cylinder { // top
			<0,0,5.2>,<0,0,5.25> 1.30
		}
		cylinder { // main
			<0,0,0>,<0,0,5>,1.3
		}
		cylinder { // bottom
			<0,0,-.2>,<0,0,-.25>,1.30
		}
		cone { // lower underrim
			<0,0,0>,1.3,<0,0,-0.2>,1.2
		}
		torus { // lower rim
			1.32,.05
			rotate x*90
			scale <1,1,1.5>
			translate <0,0,-.25>
		}
		texture { AlumCanTex }
	}

#declare CanRad = 1.45
#declare CanHt = 3.8
#declare TinCan =
	union {
		cylinder { // top
			<0,0,0>,<0,0,0.05>,CanRad
			translate <CanRad,0,0> // origin at edge
			rotate <0,-50,0> // open the lid
			translate <-CanRad,0,CanHt> // put it on the can
		}
		torus { // upper rim
			CanRad+0.02,0.05
			rotate x*90
			scale <1,1,1.5>
			translate <0,0,CanHt+0.05>
		}
		difference {
			union {
				cone { // upper underrim
					<0,0,CanHt>,CanRad,<0,0,CanHt+0.2>,CanRad-.1
				}
				cylinder { // main
					<0,0,0>,<0,0,CanHt>,CanRad
				}
				cone { // lower underrim
					<0,0,0>,CanRad,<0,0,-0.2>,CanRad-.1
				}
			} // end union of outer parts
			cylinder { // inside
				<0,0,-.1>,<0,0,CanHt+1>,CanRad-0.05
			}
		} // end difference
		cylinder { // bottom
			<0,0,-.2>,<0,0,-.25>,CanRad
		}
		torus { // lower rim
			CanRad+0.02,.05
			rotate x*90
			scale <1,1,1.5>
			translate <0,0,-.25>
		}
		torus { // center
			CanRad+0.02,.05
			rotate x*90
			scale <1,1,2.0>
			translate <0,0,CanHt/2>
		}
		torus { // 2 lower
			CanRad+0.02,.05
			rotate x*90
			scale <1,1,2.0>
			translate <0,0,CanHt/2-.2>
		}
		torus { // 2 upper
			CanRad+0.02,.05
			rotate x*90
			scale <1,1,2.0>
			translate <0,0,CanHt/2+.2>
		}
		torus { // 3 lower
			CanRad+0.02,.05
			rotate x*90
			scale <1,1,2.0>
			translate <0,0,CanHt/2-.4>
		}
		torus { // 3 upper
			CanRad+0.02,.05
			rotate x*90
			scale <1,1,2.0>
			translate <0,0,CanHt/2+.4>
		}
		torus { // 4 lower
			CanRad+0.012,.05
			rotate x*90
			scale <1,1,2.0>
			translate <0,0,CanHt/2-.6>
		}
		torus { // 4 upper
			CanRad+0.012,.05
			rotate x*90
			scale <1,1,2.0>
			translate <0,0,CanHt/2+.6>
		}
		texture { AlumCanTex }
	}

#declare SodaBottle =
	lathe { // rotated around y-axis
		cubic_spline // n-3 segments
		36,
//		<-2,.4>,<-1,.4>,<0,.4>,<1.8,.4>,<2.4,0>,<3,0>, // bottom
		<0,.4>,<0,.4>,<0,.4>,<1.8,.4>,<2.4,0>,<3,0>, // bottom (test)
		<3.4,1>,<3.5,2>,<3.6,8>,<3.3,14>,<3,15>,<2,16>, // outside
		<1.5,17>,<1.5,19>,<1.2,22>,<1.1,22.7> // neck
		<1.3,22.9>,<1.4,23>,<1.4,23.6>,<1.3,23.8>,<1,23.8>,<.8,23.4>,<.7,23>, // rim
		<.7,22.7>,<.7,22>,<.8,19>,<.8,17>,<1,16>, // inner neck
		<2,15>,<2.5,14>,<2.8,8>,<2.8,2>, // inside
//		<2.5,1>,<0,1>,<-1,1>,<-2,1> // inner bottom
		<2.5,1>,<0,1>,<0,1>,<0,1> // inner bottom (test)
		texture { SodaBottleGlass }
		rotate <90,0,0> // tilt upright
		scale <.43,.43,.40> // make it reasonable size
	}

#declare CandyBox =
	union {
		box { // lower
			<0,0,0>,<7,5.5,.1>
			texture { CandyBoxTex }
		}
		box { // main
			<0.22,0.22,0.1>,<6.78,5.28,1>
			texture { CandyBoxTex }
		}
		box { // upper
			<0,0,1.0>,<7,5.5,1.1>
			texture { CandyBoxTex }
		}
	}
#declare ThinNewsPaperTube =
	difference {
		cylinder {
			<-4.3,0,0>,<4.3,0,0>,1.7
		}
		cylinder {
			<-4.5,0,0>,<4.5,0,0>,1.68
		}
	}
#declare RolledNewsPaper =
	union {
		object { ThinNewsPaperTube scale <1,1,1> }
		object { ThinNewsPaperTube scale <.96,.9,.9> }
		object { ThinNewsPaperTube scale <.92,.84,.84> translate <0,0.1,0> }
		object { ThinNewsPaperTube scale <.90,.72,.72> translate <0,0.08,0> }
		object { ThinNewsPaperTube scale <.90,.56,.56> translate <0,0.12,0> }
		scale <1,1,.32>
		texture { NewsWhite }
	}
#declare WoodBlock =
	difference {
		box {
			<0,0,0>,<48.5,2.7,.86>
			texture { DriftWoodTex scale 4 rotate <0,88,0> }
		}
		height_field { // creates upper splinters
			png "Dent1HFrev.png"
			rotate x*90 // set up for RH coordinate system
			translate <-.5,.5,0> //center on origin
			scale <2,8,4> // scale it up
			rotate y*-90
			translate <50.25,1.3,0>
			texture { DriftWoodTex scale 4  rotate <0,88,0> }
		}
	}

#declare CrumpledTrash =
	object { CrumpledTrashShape
		texture { TrashTex }
		scale 1
	}
#declare WavyTrash =
	object { WavyTrashShape
		texture { TrashTex }
		scale 1
	}
#declare NewsPaperSheet =
	object { NewsPaperSheetShape
		texture { OldNewsPaperTex }
		scale 1
	}


#declare TrashGroup1 =
	union {
		object { SodaBottle rotate <3,70,0> translate <0,-3.6,45.8> } // right
		object { TinCan rotate z*45 rotate <-34,66,20> translate <-1,3.5,47> } // left
		object { CandyBox rotate <5,12,-24> translate <4,-2,47> } // visible
		object { CrumpledTrash rotate <20,-8,0> translate <-3.5,5.3,46.5> } // left top
		object { WavyTrash rotate <-20,-48,0> translate <-5,-4,46.7> } // right front top
		object { WavyTrash rotate <5,-98,0> rotate <40,0,0> translate <6,4,47> } // left rear top
		object { SodaBottle rotate <0,-70,-0> translate <-1,-2,45.95> } // support rose
		object { WoodBlock rotate <8,-72,-2> translate <-10,-2,5.5> }

		object { TinCan rotate <0,0,-80> rotate <0,-12,0> translate <-5,4,39> } // left lower
		object { AlumCan rotate <-84,6,40> translate <0,2,36> } // lower
		object { CandyBox rotate <45,-24,-33> translate <4,-2,39> } // lower
		object { RolledNewsPaper rotate <5,-14,-83> translate <-6,-1,45> } // upper
		object { RolledNewsPaper rotate <-24,4,-38> translate <0,0,41> } // lower
		object { CrumpledTrash rotate <20,-40,0> translate <-2,-6,42> } // lower right
		object { CrumpledTrash rotate <-10,20,160> translate <-3,-4,43> } // shadow right
		object { WavyTrash rotate <0,0,0> translate <-2,-3,40> }
		object { WavyTrash rotate <0,0,0> translate <-4,4,42> }
		object { NewsPaperSheet rotate <0,-80,-20> translate <0,3,45> }
		object { SodaBottle rotate <25,0,0> translate <-7,0,37> } // lower
	}


