
#include "Trash.inc"

// Glenn's Trashcan POV-Ray Object File
// This file does not render.  #include "trashcan.inc" in another .pov file
// first concept 19-Sep-97  last update 17-Oct-97
// copyright 1997 Glenn McCarter

// Some trashcans
// objects:
//		STrashCan (simple)
//		TrashCanH (simple, with holes)
//		TrashCanHFull (full of trash)
//		DentedTrashCanH (dented, with holes)
//		DentedTrashCanHFull
// Intended scale is English system (inches)
// origin at base of trashcan, can extends upwards into +Z
// Uses RH coord system

//===============================================
//             Textures
//===============================================

#switch ( Wet )
#case (1) // wet
	#declare TrashCanTex =
		texture {
			pigment { color rgb<.2,.2,.2> }
			normal { bumps 0.2 scale 1 }
			finish { ambient .02 specular .75 roughness .03 reflection .2 }
		}
	#declare TrashCanRimTex =
		texture {
			pigment { color rgb<.2,.2,.2> }
			normal { bumps 0.4 scale .3 }
			finish { ambient .02 specular .75 roughness .03 reflection .2 }
		}
#break
#else // dry
	#declare TrashCanTex =
		texture {
			pigment { color rgb<.21,.21,.23> }
			normal { bumps 0.3 scale 2 }
			finish { ambient .02 specular .95 roughness .005 }
		}
	#declare TrashCanRimTex =
		texture {
			pigment { color rgb<.21,.21,.23> }
			normal { bumps 0.4 scale .2 }
			finish { ambient .02 specular .95 roughness .005 }
		}
#end

#switch ( Color )
#case (1) // color rendering
#declare TrashCanLinerTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0  color rgb<0.08,0.10,0.09> ]
				[ 0.5  color rgb<0.25,0.24,0.25> ]
				[ 1.0  color rgb<0.38,0.34,0.39> ]
			}
			scale <.09,.09,.52>
		}
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .95 roughness .005 }
	}
#else // greyscale rendering
#declare TrashCanLinerTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0  color rgb<0.08,0.10,0.09> ]
				[ 0.5  color rgb<0.25,0.24,0.25> ]
				[ 1.0  color rgb<0.38,0.34,0.39> ]
			}
			scale <.09,.09,.52>
		}
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .95 roughness .005 }
	}
#end // greyscale

#declare TextTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0  color rgbt<0.02,0.04,0.02,0.9> ]
				[ 0.2  color rgbt<0.02,0.04,0.02,0.9> ]
				[ 0.2  color rgb<0.02,0.04,0.02> ]
				[ 0.7  color rgb<0.02,0.04,0.02> ]
				[ 0.7  color rgbt<0.02,0.04,0.02,0.9> ]
				[ 1.0  color rgbt<0.02,0.04,0.02,0.9> ]
			}
			turbulence .2
			scale .4
		}
//		pigment { color rgb<.062,.062,.062> }
//		pigment { color rgb<.7,.7,.52> } // test
		finish { ambient .02 specular .7 roughness .002 }
	}


//===============================================
//             BlobTrashCans
//===============================================

#declare BT  = 1.01 // Blob Threshold
#declare BRF = 11.0  // Blob Radius Factor
#declare BSF = 1.0  // Blob Strength Factor
#declare BNSF = -0.4 // Negative Strength Factor ( divisor )

#declare BlobCanShape =
	blob {
		threshold BT
			cylinder { // main
				<0,0,-10>,<0,0,50>
				BRF*1.0, BSF*10.00
				scale <1.0,1.0,1.0>
				translate <0,0,0>
			}
			sphere { // gentle dent RH upper
				<0,0,0>,
				BRF*0.3, BNSF*2.50
				scale <1.0,1.0,2.0>
				rotate <12,0,0>
				translate <-9,0,42>
				rotate <0,0,60>
			}
			sphere { // dent RH lower
				<0,0,0>,
				BRF*0.2, BNSF*6.00
				scale <1.0,1.0,1.4>
				rotate <-8,0,0>
				translate <-9,0,41>
				rotate <0,0,50>
			}
			sphere { // dent far RH
				<0,0,0>,
				BRF*0.18, BNSF*3.00
				scale <1.0,1.0,1.7>
				rotate <58,0,0>
				translate <-9,0,42>
				rotate <0,0,75>
			}
			sphere { // gentlest dent LH
				<0,0,0>,
				BRF*0.30, BNSF*2.50
				scale <1.0,1.0,2.0>
				rotate <12,0,0>
				translate <-9,0,40>
				rotate <0,0,-22>
			}
			sphere { // deep dent LH
				<0,0,0>,
				BRF*0.33, BNSF*2.60
				scale <0.8,0.8,1.0>
				translate <-9,0,40>
				rotate <0,0,-43>
			}
			sphere { // dent furthest LH
				<0,0,0>,
				BRF*0.30, BNSF*2.50
				scale <0.8,0.8,1.0>
				translate <-9,0,38>
				rotate <0,0,-57>
			}
//		texture { SkinTex }
//		texture { Water }
		scale 1
		translate <0,0,0>
	}

#declare MunicipalSanitation =
intersection {
	union {
//		#declare TextString = "ITATION     MUNICIP"
  		#declare TextString = "ICIPAL    SANITATIO"
		#declare TSLength = strlen(TextString)
		#declare CurrentChar = 1
		#while ( CurrentChar <= TSLength)
			object {
				text {
					// NOTE: in RH reference system, the FRONT FACE
					// of text is extruded into +Z
					ttf "c:\Windows\Fonts\STENCIL.TTF",
					substr(TextString,CurrentChar,1),
					1.0, // thickness float
					0 // offset vector
					texture { TextTex }
					scale <2,2,2>
					rotate <90,0,0> // upright into +Z
				}
				translate -7.6*y
				rotate z*(((150*CurrentChar)/TSLength)-125)
				translate <0,0,46>
			}
		#declare CurrentChar = CurrentChar + 1
		#end
	} // end union of letters
	difference {
		object {
			BlobCanShape
			translate <0,0,-30> // center on origin
			scale <1.005,1.005,1.01>
			translate <0,0,30> // move it back up
			texture { TextTex }
		}
		object {
			BlobCanShape
			translate <0,0,-30> // center on origin
			scale <0.998,0.998,1.00>
			translate <0,0,30> // move it back up
			texture { TextTex }
		}
	} // end difference of can shape
} // end intersection between letters and can

#declare TRad = 9 // main radius
#declare BlobCan =
	union {
		object { MunicipalSanitation }
		intersection {
			object {
				BlobCanShape
					texture { TrashCanTex }
			}
			object {
				BlobCanShape
					translate <0,0,-30> // center on origin
					scale <.985,.985,1.01>
					translate <0,0,30> // move it back up
					texture { TrashCanLinerTex }
					inverse
			}
			cylinder { // top and bottom cutoff
				<0,0,0>,<0,0,48>,TRad+1
				texture { TrashCanTex }
			}
		} // end intersection
		torus { // top rim
			TRad+.2, 0.2
			rotate <90,0,0>
			translate <0,0,48>
			texture { TrashCanRimTex }
		}
	} // end union

//===============================================
//             TrashCans
//===============================================

#declare TRad = 9 // main radius
#declare STrashCan = // simple
	union {
		difference {
			cylinder { // outer
				<0,0,0>,<0,0,48>,TRad
				texture { TrashCanTex }
			}
			cylinder { // inner
				<0,0,.5>,<0,0,49>,TRad-.2
				texture { TrashCanLinerTex }
			}
		} // end difference
		torus { // top rim
			TRad, 0.2
			rotate <90,0,0>
			translate <0,0,48>
			texture { TrashCanTex }
		}
	} // end union


#declare HoleSize = .6
#declare HoleCube =
	box {
		<-TRad-1,-HoleSize/2,-HoleSize/2>,<TRad+1,HoleSize/2,HoleSize/2>
		rotate x*45
		scale <1,1,2>
		texture { TrashCanTex }
	}
#declare TrashCanH = // simple shape, with holes
	difference {
		object { STrashCan }
		#declare RowCount = 1
		#while ( RowCount < 4 )
			#declare HDeg = 8 // degrees between adjacent holes
			#declare RowOffset = 0
			#declare HoleDeg = 0
			#while ( HoleDeg < 180 )
				object { HoleCube rotate <0,0,HoleDeg+90+RowOffset> translate <0,0,40+RowCount> }
				#declare HoleDeg = HoleDeg + HDeg
			#end
			#declare HoleDeg = 0
			#declare RowOffset = HDeg/2
			#while ( HoleDeg < 180 )
				object { HoleCube rotate <0,0,HoleDeg+90+RowOffset> translate <0,0,40+RowCount+1> }
				#declare HoleDeg = HoleDeg + HDeg
			#end
			#declare RowCount = RowCount + 2
		#end
	}

#declare DentedTrashCanH = // dented shape, with holes
	difference {
		object { BlobCan }
		#declare RowCount = 1
		#while ( RowCount < 4 )
			#declare HDeg = 8 // degrees between adjacent holes
			#declare RowOffset = 0
			#declare HoleDeg = 0
			#while ( HoleDeg < 180 )
				object { HoleCube rotate <0,0,HoleDeg+90+RowOffset> translate <0,0,40+RowCount> }
				#declare HoleDeg = HoleDeg + HDeg
			#end
			#declare HoleDeg = 0
			#declare RowOffset = HDeg/2
			#while ( HoleDeg < 180 )
				object { HoleCube rotate <0,0,HoleDeg+90+RowOffset> translate <0,0,40+RowCount+1> }
				#declare HoleDeg = HoleDeg + HDeg
			#end
			#declare RowCount = RowCount + 2
		#end
		rotate <0,0,-18>
	}

#declare STrashCanFull =
	union {
		object { STrashCan }
		object { TrashGroup1 }
	}

#declare TrashCanHFull =
	union {
		object { TrashCanH }
		object { TrashGroup1 }
	}

#declare DentedTrashCanHFull =
	union {
		object { DentedTrashCanH }
		object { TrashGroup1 }
	}

