        #declare L_Bmin = Large_Branch_Minimum_Angle
        #declare L_Bmax = Large_Branch_Maximum_Angle
                          - Large_Branch_Minimum_Angle

        #declare M_Bmin = Medium_Branch_Minimum_Angle
        #declare M_Bmax = Medium_Branch_Maximum_Angle
                          - Medium_Branch_Minimum_Angle

        #declare S_Bmin = Small_Branch_Minimum_Angle
        #declare S_Bmax = Small_Branch_Maximum_Angle
                          - Small_Branch_Minimum_Angle

        #declare Large_Branch_Size_Range =
        Large_Branch_Size_Max - Large_Branch_Size_Min

        #declare Medium_Branch_Size_Range =
        Medium_Branch_Size_Max - Medium_Branch_Size_Min

        #declare Small_Branch_Size_Range =
        Small_Branch_Size_Max - Small_Branch_Size_Min

        #if ( Leaf_Type = 0 )

        #declare One_Leaf =

        union{

                // Leaf part #1
                sphere{ 0, 3 scale < 0.4, 0.1, 1.0 >
                        translate z * 3
                        rotate x * -30
                        rotate y * 0 }

                // Leaf part #2
                sphere{ 0, 3 scale < 0.4, 0.1, 1.0 >
                        translate z * 3
                        rotate x * -30
                        rotate y * 120 }

                // Leaf part #3
                sphere{ 0, 3 scale < 0.4, 0.1, 1.0 >
                        translate z * 3
                        rotate x * -30
                        rotate y * 240 }

                // Scale the entire union. Make the leaf small for
                // testing branch placement, then make it big!

                        scale 0.2

        } // End of union.

        #end

// Now create the actual FAST leaf.

        #if ( Leaf_Type = 1 )

                #declare One_Leaf = sphere{ 0, 0.3 }

        #end

// Now create the actual STRANGE leaf. Change this to anything!

        #if ( Leaf_Type = 2 )

        #declare One_Leaf = union {

                sphere { 0, 0.3 }

                difference {

                        box { < -1, -1, -1 > < 1, 1, 1 > }

                        sphere { 0, 1.3 }

                } // End of difference.

        } // End of union.

        #end

// Now create the actual TORUS leaf. This one has a texture!!!

        #if ( Leaf_Type = 3 )

        #declare One_Leaf = union {

                torus { 1, 0.25 pigment { checker Red, Yellow scale 10 } }

                cylinder { < -1, 0,  0 > < 1, 0, 0 >, 0.1
                pigment { checker Blue, Cyan scale 0.1 } }

                cylinder { <  0, 0, -1 > < 0, 0, 1 >, 0.1
                pigment { checker Blue, Cyan scale 0.1 } }

        } // End of union.

        #end

// Create the MESH leaf object - with lots of little triangles!!!

        #if ( Leaf_Type = 4 )

        #declare One_Leaf = mesh {

        #declare A = 1 #while ( A <= TREE_MESH_SIZE )

                // Calculate random location for first point.
                #declare X1 = ( rand(TREE_RAND) * 2 ) - 1
                #declare Y1 = ( rand(TREE_RAND) * 2 ) - 1
                #declare Z1 = ( rand(TREE_RAND) * 2 ) - 1

                // Move a little way from *first* point.
                #declare X2 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Y2 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Z2 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3

                // Move a little way from *first* point.
                #declare X3 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Y3 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Z3 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3

                // Make the triangle.
                triangle { <X1, Y1, Z1>, <X2, Y2, Z2>, <X3, Y3, Z3> }

        #declare A = A + 1 #end

        } // End of mesh.

        #end

// Create the ULTRA-MESH leaf object - with lots of little triangles,
// and each "leaf" has a connector "branch" back to <0,0,0>.

        #if ( Leaf_Type = 5 )

        #declare One_Leaf = mesh {

        #declare A = 1 #while ( A <= TREE_MESH_SIZE )

                // Calculate random location for first point.
                #declare X1 = ( rand(TREE_RAND) * 2 ) - 1
                #declare Y1 = ( rand(TREE_RAND) * 2 ) - 1
                #declare Z1 = ( rand(TREE_RAND) * 2 ) - 1

                // Move a little way from *first* point.
                #declare X2 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Y2 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Z2 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3

                // Move a little way from *first* point.
                #declare X3 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Y3 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3
                #declare Z3 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3

                // Make the "leaf" triangle.
                triangle { <X1, Y1, Z1>, <X2, Y2, Z2>, <X3, Y3, Z3> }

                // Make the "branch" triangles.
                triangle { <X1, Y1, Z1>, <0, 0, 0>, <0,   0, 0.1> }
                triangle { <X1, Y1, Z1>, <0, 0, 0>, <0.1, 0, 0  > }

        #declare A = A + 1 #end

        } // End of mesh.

        #end


        #if ( Leaf_Type = 6 )
        #end


//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now create the tree trunk.

        #declare Tree_Trunk = union {

                cone { < 0, 0, 0 >, 1.00 < 0, Tree_Trunk_Size, 0 >, 0.80 }
                sphere { < 0, Tree_Trunk_Size, 0 >, 0.80 }

                texture { Bark_Texture }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now we begin the CONFUSING nested loops. They create a big union
// called "Complete_Tree". We start with one trunk, and add some large
// branches to it. Then, for each large branch, we add a few medium
// branches - each one is at a random angle. Then, in the inner loop,
// we add small branches. Each one of the small branches gets one leaf
// object attached to it. Whew!
//
// The loops MUST be nested like this - it's the only way to give each
// and every branch a random tilt (relative to the parent branch).
//
// The loops are NOT indented properly, because that put the inner loop
// way off the screen, making things even more confusing!

        #declare Complete_Tree =

        union {

        object { Tree_Trunk }

        #declare A = 0 #while ( A < Number_Of_Large_Branches )

        union {

// Make one large branch.

        #declare This_Large_Branch_Size =
                ( rand(TREE_RAND) * Large_Branch_Size_Range ) +
                Large_Branch_Size_Min

        cone {<0,0,0>,0.60 <0,This_Large_Branch_Size,0>,0.40
                texture { Bark_Texture } }

        sphere { <0,This_Large_Branch_Size,0>,0.40
                texture { Bark_Texture } }

// Loop to put medium branches on that large branch.

        #declare B = 0 #while ( B < Number_Of_Medium_Branches )

        union {

        #declare This_Medium_Branch_Size =
                ( rand(TREE_RAND) * Medium_Branch_Size_Range ) +
                Medium_Branch_Size_Min

        cone { <0,0,0>,0.30 <0,This_Medium_Branch_Size,0>,0.20
                texture { Bark_Texture } }

        sphere { <0,This_Medium_Branch_Size,0>,0.20
                texture { Bark_Texture } }

// Loop to put small branches on that medium branch.

        #declare C = 0 #while ( C < Number_Of_Small_Branches )

        #declare This_Small_Branch_Size =
                ( rand(TREE_RAND) * Small_Branch_Size_Range ) +
                Small_Branch_Size_Min

        union {

        cone { <0,0,0>,0.10 <0,This_Small_Branch_Size,0>,0.05
                texture { Bark_Texture } }

        // (No sphere at the end of that cone - it's invisible!)

// The leaf at the end of the small branch.

//        object { One_Leaf translate y * This_Small_Branch_Size }

        // First, spin the vertical branch to a random angle.
        // The branch doesn't really change - this actually
        // just spins the leaf around!

                #declare SpinAngle = (rand(TREE_RAND)*360)
                rotate y * SpinAngle

        // Now, tilt it over a little.
                #declare BranchAngle = (rand(TREE_RAND)*S_Bmax)+S_Bmin
                rotate z * BranchAngle

        // Rotate it into place, with a little random wiggle.
                #declare Wiggle=(rand(TREE_RAND)*20)-10
                #if ( Wiggle_Flag = off ) #declare Wiggle = 0 #end

                #declare C2 = ( 360 / Number_Of_Small_Branches ) * C
                rotate y * (C2 + Wiggle)

        // Move it up to the top of the Medium_Branch.
        // If flag is "off", then move to the next spot on branch.

                #declare TEMP_HEIGHT = This_Medium_Branch_Size
                #if ( Branches_On_End_Flag = off )
                        #declare TEMP_HEIGHT = This_Medium_Branch_Size -
                        ((This_Medium_Branch_Size / Number_Of_Small_Branches)*C)
                #end

                translate y * TEMP_HEIGHT

        } // End of object.

        #declare C = C + 1 #end

        #declare BranchAngle = (rand(TREE_RAND)*M_Bmax)+M_Bmin
        rotate z * BranchAngle

        #declare Wiggle=(rand(TREE_RAND)*20)-10
        #if ( Wiggle_Flag = off ) #declare Wiggle = 0 #end
        #declare B2 = ( 360 / Number_Of_Medium_Branches ) * B
        rotate y * ( B2 + Wiggle )

        // Move the Medium_Branch up to the top of the Large_Branch.
        // If flag is "off", then move to the next spot on branch.

                #declare TEMP_HEIGHT = This_Large_Branch_Size
                #if ( Branches_On_End_Flag = off )
                        #declare TEMP_HEIGHT = This_Large_Branch_Size -
                        ((This_Large_Branch_Size / Number_Of_Medium_Branches)*B)
                #end

                translate y * TEMP_HEIGHT

        } // End of union.

        #declare B = B + 1 #end

        #declare BranchAngle = (rand(TREE_RAND)*L_Bmax)+L_Bmin
        rotate z * BranchAngle

        #declare Wiggle=(rand(TREE_RAND)*20)-10
        #if ( Wiggle_Flag = off ) #declare Wiggle = 0 #end
        #declare A2 = ( 360 / Number_Of_Large_Branches ) * A
        rotate y * ( A2 + Wiggle )

        // Move the Large_Branch up to the top of the Tree_Trunk.
        // If flag is "off", then move to the next spot on trunk.
        // These are spaced differently than the other branches - they
        // start about 3/4 of the way up the trunk.

                #declare TEMP_HEIGHT = Tree_Trunk_Size
                #if ( Branches_On_End_Flag = off )
                        #declare TEMP_HEIGHT = Tree_Trunk_Size -
                        ((Tree_Trunk_Size / Number_Of_Large_Branches)*A/4)
                #end

                translate y * TEMP_HEIGHT

        } // End of union.

        #declare A = A + 1 #end

        // Now, turn all of the leaves green! This doesn't change the
        // branches, because they already have a texture.

                texture { Leaf_Texture }

    } // end of Complete_Tree union

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now return to your main file and show "Complete_Tree".
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file - bye!

