#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "metals.inc"
#include "stones.inc"
#include "glass.inc"

#include "huis.inc"
#include "lamp.inc"
#include "weg.inc"
#include "bomen.inc"
#include "skelet.inc"
#include "Kerolamp.inc"
#include "pilaar.inc"

#declare Grond = texture
{  pigment  {    bozo
                 color_map
                 { [0.00 color rgb<0.235, 0.055, 0.055>]
                   [0.94 color rgb<0.235, 0.055, 0.055>]
                   [1.00 color rgb<0.551, 0.5127, 0.5127>]    }
                 turbulence 1
                   }
        normal { bumps 1 scale 0.1 }
        finish { Shiny}
}

#declare Hemel = texture
{
pigment{ gradient y
          color_map {[0.00 color Gray10]
                      [1.00 color Gray30]
          }
       }
finish {ambient 1}
}

//DECLARATIES
global_settings {
   ambient_light <0.9,0.9,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


light_source{<-5500, 2800, 000> color red 1.0000 green 1.0000 blue 1.0000}

camera{location <9.7800, 3.000, -7.500>look_at <-2, 3.000, -2.25>}

//SKY
sphere{ <0, 0, 0> 7000 texture{Hemel scale 7500 translate <0,3750,0>}}
sphere{ <0, 0, 0> 2000 texture{T_Cloud1 scale 2000 rotate <0,10,0>}}

// MOON
sphere{  <0, 0, 0> 380
  translate <-5500, 2750, 4000>
texture{pigment {Yellow}
finish{ambient 0.1 }}
}

//GROUND
plane
{   -z, 0
    texture { Grond }
    scale <0.1,0.1,0.1>
     rotate <-90.00, 0, 0>
 }


object{Skelet rotate <0,90,0> translate <2,0,-5.5>}
object {Kerolamp rotate<0,-90,0> translate <2,0.413,-2>}
object {Kerolamp rotate<0,-90,0> translate <2,0.413,-7>}
object {Kerolamp rotate<0,-90,0> translate <-9,0.52,-5.5>}
object{Skelet rotate <0,90,0> translate <-24,0,-5.5>}
object {Kerolamp rotate<0,-90,0> translate <-24,0.4842,-6.6>}
object {Kerolamp rotate<0,-90,0> translate <-4,0.413,-2>} //verlicht kolom

#declare column_flute_alt = on
object {Pilaar translate <-5,0,0>}

// paal
#declare Paal=
box{ <0, 0, 0> < 0.15, 2, 0.15> texture{T_Column1}}

object {Paal translate <-5.1,0,0>}
object {Paal rotate<0,0,-10> translate <-7.1,0,0>}
object {Paal rotate<10,0,0> translate <-9.1,0,-0.10>}
object {Paal rotate<0,0,5> translate <-11.1,0,-0.20>}
object {Paal rotate<1,0,-5> translate <-13.1,0,-0.30>}
object {Paal rotate<-2,0,2> translate <-15.1,0,-0.40>}
object {Paal translate <-17.1,0,-0.50>}
object {Paal translate <-19.1,0,-0.60>}
object {Paal translate <-21.1,0,0>}
object {Paal translate <-23.1,0,0>}
object {Paal translate <-25.1,0,0>}
object {Paal translate <-27.1,0,0>}
object {Paal translate <-29.1,0,0>}
