#include "woods.inc"

#declare S1 = seed(10)
#declare S2 = seed(15)
#declare S3 = seed(1)



// Texture house front

#declare house_tex = // based on yellow_pine from TexMagic
texture {
  pigment
  {
    wood
    turbulence 0.02
    color_map
    {
      [0.00 color rgb<0.808, 0.671, 0.251>]
      [0.22 color rgb<0.808, 0.671, 0.251>]
      [0.34 color rgb<0.600, 0.345, 0.039>]
      [0.39 color rgb<0.808, 0.671, 0.251>]
      [0.71 color rgb<0.808, 0.671, 0.251>]
      [0.82 color rgb<0.529, 0.294, 0.024>]
      [1.00 color rgb<0.808, 0.671, 0.251>]
    }
    translate <1.0, 0.0, 0.0>
    rotate <75.0, 0.0, 0.0>
  }
  finish {
    ambient 0.32
    diffuse 0.63
    phong 0.2    phong_size 10
  }
}
texture {
  pigment
  {
    wood
    turbulence 0.01
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.12 color rgbf<0.702, 0.412, 0.118, 0.608>]
      [0.23 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [0.50 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.83 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    translate <1.0, 0.0, 0.0>
    rotate <75.0, 0.0, 0.0>
    scale <5.0, 5.0, 5.0>
  }
}
texture {
  pigment
  {
    granite
    turbulence 1.0
    color_map
    {
      [0.00 color rgbf<0.498, 0.349, 0.000, 1.000>]
      [0.39 color rgbf<0.478, 0.329, 0.000, 1.000>]
      [0.60 color rgbf<0.478, 0.329, 0.000, 0.686>]
      [0.84 color rgbf<0.486, 0.337, 0.000, 0.486>]
      [0.94 color rgb<0.486, 0.337, 0.000>]
      [1.00 color rgb<0.498, 0.349, 0.000>]
    }
    scale <1.0, 15.0, 1.0>
  }
  finish {
    ambient 0.2
    specular 0.2
  }
}



// **WOOD
// *************************************************************************************
// Base Texture Standard Textures.INC  DMFWood4
// Modifiziert Steffen Heinicke Versuch das Holz etwas mehr natrlicher zu gestalten.
// **************************************************************************************/
// thanks to Steffen Heinicke for his excellent wood tutorial in the Webzine D.P.M. II.
//  Cheers as well to the editor of DPM (ftp://ftp.liteline.de/pub/dpm/dpm2_mag.zip)

#declare DMFedit =
texture {
pigment {
      wood
         turbulence 0.04
   octaves 3
    scale <.1, .1,.1>
color_map {
        [0.0, 0.1 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.888, 0.600, 0.3>]
        [0.1, 0.9 color rgb <0.888, 0.600, 0.3>
                  color rgb <0.600, 0.400, 0.2>]
        [0.9, 1.0 color rgb <0.600, 0.400, 0.2>
                  color rgb <0.600, 0.400, 0.2>]
            } // Ende color map

// verschiedene Verwerfungen
// Warp 1
       warp {
    black_hole <0., 1, 0>, 1.25
    falloff 2
    strength 3
    repeat <2.75,2.75, 2.9>
    turbulence <0.25, 0.25, 0.25>
  inverse
  } // Ende Warp
/*
// Warp 2
       warp {
    black_hole <-0.2, 0.8, -1.8>, 0.85
    falloff 4
    strength 3
    repeat <2.2,2.8, 2>
    turbulence <0.1, 0.1, 0.1>
   inverse
  } // Ende Warp
*/
// Warp 3
      warp {
      black_hole <0.5, 1, 0>, .50
      falloff 2
      strength 0.5
     repeat <1.2,1.8, 4>

    } // ende warp 3
/*
// Warp 4
warp   {
      black_hole <0.3, 0.95, -0.1>, 0.5
      falloff 4
      strength 3
      inverse
   }
*/
// Warp 5
    warp   {
      black_hole <0.5, 0.9, 0.9>, 0.75
      falloff 5
      strength 3
     inverse
    }
} // ende pigment


/**************************************************/
/*** hier beginnt die Oberflchen Beschreibung ****/
/**************************************************/

 normal {
  wood
   turbulence 0.04
   octaves 3
    scale <.1, .1, 1>

// Warp 1
       warp {
    black_hole <0., 1, 0>, 1.25
    falloff 2
    strength 3
   repeat <2.75,2.75, 2.9>
    turbulence <0.25, 0.25, 0.25>
  inverse
  } // Ende Warp
/*
  // Warp 2
       warp {
    black_hole <-0.2, 0.8, -1.8>, 0.85
    falloff 4
    strength 3
    repeat <2.2,2.4, 2>
    turbulence <0.1, 0.1, 0.1>
   inverse
  } // Ende Warp
*/
    // Warp 3
      warp {
      black_hole <0.5, 1, 0>, .50
      falloff 2
      strength 0.5
        repeat <1.2,1.8, 4>

    } // ende warp 3

/*
// Warp 4
warp   {
      black_hole <0.3, 0.95, -0.1>, 0.5
      falloff 4
      strength 3
      inverse
   }

*/
// Warp 5
    warp   {
      black_hole <0.5, 0.9, 0.9>, 0.75
      falloff 5
      strength 3
     inverse
    }

/****
 klammert die slope_map Sektion ruhig mal aus
 die Textur wird dann noch etwas grber
*****/
     slope_map {
         [0    <0.5, 1>]
         [0.1 <1.0, 0>]
         [0.5  <0.5,-1>]
         [0.9 <0.0, 0>]
         [1    <0.5, 1>]
       }

  } // Ende normal

finish {
phong 0.25
roughness 0.01
} // Ende Finish

rotate x*2.5
    } // Ende texture




// Clouds
#declare cloudes =
  texture {
     pigment {
       radial
       color_map {
         [ 0.000  color rgbf<1.000, 1.000, 1.000, 1.000> ]
         [ 0.198  color rgbf<0.808, 0.808, 0.808, 0.833> ]
         [ 0.349  color rgb<0.671, 0.671, 0.916> ]
         [ 0.475  color rgb<0.397, 0.397, 0.504> ]
         [ 0.511  color rgb<0.381, 0.381, 0.504> ]
         [ 0.651  color rgb<0.671, 0.671, 1.000> ]
         [ 0.802  color rgbf<0.808, 0.808, 0.808, 0.833> ]
         [ 1.000  color rgbf<1.000, 1.000, 1.000, 1.000> ]
       }
       turbulence 1.600
       frequency 4.000
      // rotate 90*x
     }
     finish {
       diffuse 0.000
       ambient 1.000
     }

   }



// **** Wood trottoir

// Natural oak (light)
#declare T_Wood1 =
    texture { pigment { P_WoodGrain1A rotate rand(S1)*10 translate <rand(S2)*30, rand(S3)*30, 0>  color_map { M_Wood1A }}}
    texture { pigment { P_WoodGrain1B  color_map { M_Wood1B }}}




