// IRTC
// Topic : Arts & Entertainment
// Round : september - october 97
// by : Gerard Schockmel


// Includes
#include "colors.inc"
#include "ae.inc"
#include "barrel.inc"
#include "camera.pov"
#include "metals.inc"
#include "sig.inc"
#include "gun.inc"


global_settings {
  max_trace_level 25
}



// Cameras

camera { // final
  location <0, 0, -5>
  look_at <0, 0, 0> }

//camera { // final zoom
//  location <0, 0, 13>
//  look_at <0, 0, 20> }

//camera { // side sidewalk
//  location <0, 0, 10>
//  look_at <0, 0, 20> }

//camera { // along sidewalk
//  location <-3.5, 1, 0>
//  look_at <-3.5, 1, 5> }

//camera { //top view
//  location <3.5, 5, 4>
//  look_at <3.5, 0, 4> }



// Lights

light_source { <5, 20, 120>, Red*.6 }
light_source { <1, 20, 25>, White }
light_source { <0, 5, 1>, Gray65 shadowless }
light_source { <0, 5, 10>, Gray60 shadowless }



// half-frame left
//union {

difference {

  box {
    <-10, -1.1, -4.501>, <0, 3, -4.5>
    texture {
      pigment { rgb <.28, 0, .34> }
      finish { reflection .4 phong .3}
    }
  }

  superellipsoid {
    <.25, .25>
    scale <.2, .21, .1>
    pigment { rgb <.28, 0, .34> }
    translate <-.065, 0, -4.5>
  }
no_shadow
pigment { rgb <.28, 0, .34> }
bounded_by { box { <-1, -1, -4.7>, <1, 1, -4.4> }}
}


union { // film holes side (?)
  #declare cnt=0
  #declare off_set= .05
  #while (cnt<10)
    box { <-.32, .21, -4.502>, <-.29, .235, -4.501> translate -y*cnt*off_set translate -x*.005 }
    #declare cnt = cnt + 1
  #end
  pigment { White*1.5 }
  finish { diffuse .8 ambient .9}
  no_shadow
} // end union

text {
  ttf "c:\windows\fonts\arial.ttf"
  //"1the text goes here 2the text goes here 3the text goes here"
    "Colorvision     < frame #0028475 >     Colorvision      KODAK"
  .005, x*.015
  //pigment { White*1.3 }
  pigment { rgb <.28, 0, .34>*3 }
  rotate z*90
  scale .02
  translate <-.275, -.29, -4.502>
  no_shadow
}

#declare cross =
union {
  box {
    <-1, -.1, 0>, <1, .1, .1>
  }

  box {
    <-.1, -1, 0>, <.1, 1, .1>
  }

  difference {
    cylinder {
      <0, 0, 0>, <0, 0, .1>, .8
    }

    cylinder {
      <0, 0, -.01>, <0, 0, .11>, .65
    }
  } // end difference

pigment { rgb <.28, 0, .34>*2 }
finish { diffuse .8 ambient .8 }
scale .018
no_shadow
} // end union

object { cross translate <-.24, .23, -4.5015> }

difference {
  object { cross translate <0, .23, -4.5015> }
  box { <0, .2, -4.503>, <.2, .3, -4.499> }
} // end difference

object { cross translate <-.24, -.233, -4.5015> }

difference {
  object { cross translate <0, -.233, -4.5015> }
  box { <0, -.3, -4.503>, <.2, -.2, -4.499> }
} // end difference



//sphere { 0, .1 pigment { Green }
//  translate <-1.2, 0, -6>
//}

object { cam
  scale .1
  translate <-1.2, -.1, -6>
}






//ground

difference {

height_field {
  gif "ground1.gif"
  smooth
  rotate z*1
  scale <100, 1.7, 100>
  translate <-20, -1.1, -4.5>
  texture {
    pigment { gradient y
      color_map {
        [0.0 OldGold ]
        [0.4 OldGold*1.15 ]
        [0.8 OldGold*.85 ]
      }
    scale <1, .05, 1>
    }
    normal {
      bozo
      normal_map {
        [0.0 bump_map { gif "ground.gif" bump_size 15 } ]
        [0.4 bump_map { gif "ground.gif" bump_size 14 } rotate y*120 ]
        [0.8 bump_map { gif "ground.gif" bump_size 16 } rotate -y*95 ]
      }
      scale <1, 2, 1>
      turbulence .5
    }
  }
}

object {
  sig
  scale <.06, .06, 1>
  rotate x*90
  translate <-.005, -1, -3>
  pigment { OldGold*3}
  finish { crand .1 }
}

} // end difference





/*
// old ground
box {
  <-20000, -1, -4.5>, <20000, -.999, 20000>
  pigment { Yellow }
  hollow
}

box {
  <0, -1, .001>, <10, -.999, -4.5>
  pigment { Yellow }
  hollow
}
*/



// ** Sky

plane { z, 400 hollow pigment { rgb <.15, .49, .65> } }


box {
  <-1, -1, -1>, <1, 1, 1>
  hollow
  pigment { Clear }
  halo {
    emitting
    linear
    spherical_mapping
    color_map {
      //[ 0.00 rgbt <.196, .6, .8, 1> ]
      //[ 0.10 rgbt <1, 0, 1, 0> ]
      //[ 0.20 rgbt <1, 1, 0, 0> ]
      //[ 1.0 rgbt <1, 0, 0, -1> ]
      [ 0.00 rgbt <.196, .6, .8, 1> ]
      [ 1.00 rgbt <1, 0, 0, -1> ]
    }
    samples 20
    scale .5
    //turbulence <.2, .1, .05>
  }
  scale 2
  scale <450, 120, 1>
  translate <5, 15, 200>
}




// ** Clouds

// before sun
box {
  -1, 1
  hollow
  pigment { Clear }
  halo {
    emitting
    linear
    spherical_mapping
    color_map {
      [ 0.00 rgbt <1, 1, 1, 1> ]
      [ 0.40 rgbt <.4, .4, .4, 0> ]
      [ 0.50 rgbt <.3, .3, .3, -1.5> ]
      [ 1 rgbt <.2, .2, .2 , -2> ]
    }
    samples 30
    turbulence .6
    rotate y*90
    scale .3
    scale <3, .5, .7>
  }
scale <2, 2, 1>
scale <10, 10, 1>
translate <-3, 10, 120>
}

// before sun, top right
box {
  -1, 1
  hollow
  pigment { Clear }
  halo {
    emitting
    linear
    spherical_mapping
    color_map {
      [ 0.00 rgbt <1, 1, 1, 1> ]
      [ 0.40 rgbt <.5, .5, .5, 0> ]
      [ 0.50 rgbt <.3, .3, .3, -1> ]
      [ 1 rgbt <.2, .2, .2 , -1.5> ]
    }
    samples 30
    turbulence .7
    scale .3
    scale <3, .4, .8>
  }
  scale <20, 20, 1>
  translate <7, 20, 125>
}


// Cloud 3, right, low
box {
  -1, 1
  hollow
  pigment { Clear }
  halo {
    emitting
    linear
    spherical_mapping
    color_map {
      [ 0.00 rgbt <1, 1, 1, 1> ]
      [ 0.30 rgbt <.7, .7, .7, 0> ]
      [ 0.40 rgbt <.5, .5, .5, -1> ]
      [ 1 rgbt <.4, .4, .4 , -1.5> ]
    }
    samples 30
    turbulence .5
    scale .3
    scale <3, .6, .8>
  }
  scale <20, 20, 1>
  translate <60, 20, 115>
}



// Cloud 4, top right
box {
  -1, 1
  hollow
  pigment { Clear }
  halo {
    emitting
    linear
    spherical_mapping
    color_map {
      [ 0.00 rgbt <1, 1, 1, 1> ]
      [ 0.30 rgbt <.6, .6, .6, 0> ]
      [ 0.40 rgbt <.76, .75, .75, -1> ]
      [ 1 rgbt <.95, .95, .95 , -1.5> ]
    }
    samples 50
    turbulence .7
    scale .3
    scale <3, 2, .8>
  }
  rotate y*40
  scale <25, 25, 30>
  translate <45, 40, 100>
}


// Cloud 5, top left
box {
  -1, 1
  hollow
  pigment { Clear }
  halo {
    emitting
    linear
    spherical_mapping
    color_map {
      [ 0.00 rgbt <1, 1, 1, 1> ]
      [ 0.30 rgbt <.95, .95, .96, 0> ]
      [ 0.40 rgbt <.8, .8, .8, -1> ]
      [ 1 rgbt <.7, .7, .7 , -1.5> ]
    }
    samples 60
    turbulence .75
    scale .3
    scale <3, 1, .8>
  }
  rotate -y*20
  scale <35, 35, 45>
  translate <-25, 20, 50>
}




// ** Setting Sun
sphere {
  0, 1
  hollow
  pigment { Clear }
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [ 0 rgbt <1, 1, 1, 1> ]
      [ 0.25 rgbt <1, 1, 0, 0> ]
      [ 0.35 rgbt <.96, .75, .03, 0> ]
      [ 1 rgbt <1, 0, 0, -1> ]
    }
  jitter .4
  aa_level 3
  aa_threshold .3
  samples 30
  turbulence .05
  }
  scale <17, 15, 15>
  translate <4, 13, 150>
  hollow
}


// ** Mountain

height_field {
gif "mountain3.gif"
texture {
  pigment {
    gradient z
    color_map {
      [0.0 Bronze2*.8 ]
      [0.33 Bronze2*.6 ]
      [.66 Bronze2*.4 ]
      [0.99 Bronze2*.3 ]
    }
    turbulence .1
  }
  finish { diffuse .3 ambient .3 }
}
scale <85, 15, 40>
translate <-20, -1, 75>
}



// ** Town

// *Sidewalk

#declare S1 = seed(10)
#declare S2 = seed(15)
#declare S3 = seed(1)


#declare sidewalk = union {

//boards
#declare board =
  box {
    <-1, -.05, -.2>, <1, .05, .2>
    //pigment { Blue }
    scale .5
}

#declare cnt = 0
#declare off_set = .22

#while (cnt<70)
  object { board
    translate <3+(rand(S1)*.05), -.75, .11+(cnt*off_set)>

    texture { T_Wood35
      normal {
        wood
        scale 1.01275
        turbulence 0.0435
        omega 0.65
        lambda 3.15
        slope_map {
          [0    <0.5, 1>]
          [0.1 <1.0, 0>]
          [0.5  <0.5,-1>]
          [0.9 <0.0, 0>]
          [1    <0.5, 1>]
        }
      }
      scale .8
      rotate y*90
      rotate y*rand(S1)*10
      translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
    }

  }
  #declare cnt = cnt + 1
#end

//poles
#declare poles = union {
  cylinder {
    <0, 0, 0>, <0, 0, 1>, .05
    scale <1, 1, 15.5>
    texture { T_Wood13
    normal {
      wood
      turbulence 0.04
      scale 0.15
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    }
    scale .8
    //rotate y*90
    rotate y*rand(S1)*1
    translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }

  }
  cylinder {
    <0, 0, 0>, <0, 0, 1>, .05
    scale <1, 1, 15.5>
    texture { T_Wood13
      normal {
        wood
        turbulence 0.04
        scale 0.15
        slope_map {
          [0    <0.5, 1>]
          [0.1 <1.0, 0>]
          [0.5  <0.5,-1>]
          [0.9 <0.0, 0>]
          [1    <0.5, 1>]
        }
      }
      scale .8
      //rotate y*90
      rotate y*rand(S1)*1
      translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
    }

    translate .1*y
  }
}

object { poles
  translate <2.55, -.95, 0> }

object { poles
  translate <3.45, -.95, 0> }


// Steps

object { poles
  scale <1, 1, .06>
  rotate y*90
  rotate -x*90
  translate <2.5, -.95, -.06>
      texture { T_Wood13
      normal {
        wood
        turbulence 0.04
        scale 0.15
        slope_map {
          [0    <0.5, 1>]
          [0.1 <1.0, 0>]
          [0.5  <0.5,-1>]
          [0.9 <0.0, 0>]
          [1    <0.5, 1>]
        }
      }
      scale .8
      rotate y*90
      rotate y*rand(S1)*1
      translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
    }

}

object { board
  translate <3, -.85, -.11>
  texture { T_Wood35 scale .8 rotate y*90 rotate y*rand(S1)*10 translate <rand(S2)*2, rand(S3)*2, rand(S1)*3> }
}


// plugs

#declare plug =
  cone {
    <0, 0, 0>, .02
    <0, .17, 0>, .03
  }

#declare cnt = 0

#while (cnt<10) // along sidewalk

  object { plug
  rotate <345+(rand(S2)*30), 0, 0>
  translate <2.47, -1, .3+(cnt*1.5)>

      texture { T_Wood34
      normal {
        wood
        turbulence 0.04
        scale 0.15
        slope_map {
          [0    <0.5, 1>]
          [0.1 <1.0, 0>]
          [0.5  <0.5,-1>]
          [0.9 <0.0, 0>]
          [1    <0.5, 1>]
        }
      }
      scale .2
      rotate x*90
      rotate y*rand(S1)*10
      translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
    }
}
#declare cnt = cnt + 1
#end

object { plug // before step
  rotate <0, 0, 340+(rand(S2)*40)>
  translate <2.6, -1.08, -.2>
  texture { T_Wood34
    normal {
      wood
      turbulence 0.04
      scale 0.15
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    }
    scale .4
    rotate x*90
    rotate y*rand(S1)*10
    translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }
}

object { plug // idem
  rotate <0, 0, 340+(rand(S1)*40)>
  translate <3.4, -1.08, -.2>
        texture { T_Wood34
      normal {
        wood
        turbulence 0.04
        scale 0.15
        slope_map {
          [0    <0.5, 1>]
          [0.1 <1.0, 0>]
          [0.5  <0.5,-1>]
          [0.9 <0.0, 0>]
          [1    <0.5, 1>]
        }
      }
      scale .4
      rotate x*90
      rotate y*rand(S1)*10
      translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }
}

} // end object sidewalk

object { sidewalk
  translate <0, 0, 1.5>
}

object { sidewalk
  scale <1, 1, -1>
  translate <0, 0, -.5>
}

object { sidewalk
  scale <-1, 1, 1>
  translate <0, 0, 1.5>
}





// ** Street front


// ** houses

// * Right side

#declare h_board =
  box {
    <0, 0, 0>, <1, 1, .05>
    scale <5, .2, 1>
    rotate -y*90
    //pigment { Blue }
  }



difference {

  #declare cnt = -4
  #declare off_set = .21
  union {
    #while (cnt<10)
      object { h_board
        translate <3.6, cnt*off_set, 1.5>
        //pigment { Green }
        texture { DMFedit scale .2 rotate rand(S1)*10 translate <rand(S2)*30, rand(S3)*30, 0> }
      }
      #declare cnt = cnt + 1
    #end
  } // end union

//door
  box {
    <0, 0, 0>, <1, 1, .1>
    scale <1, 1.5, 5>
    rotate -y*90
    translate <3.8, -.7, 2.5>
    //pigment { Green }
    texture { DMFedit scale .2 rotate rand(S1)*10 translate <rand(S2)*30, rand(S3)*30, 0> }

  }

// Window
  box {
    <-1, -1, -.1>, <1, 1, .1>
    scale <.8, .5, 4>
    rotate -y*90
    translate <3.8, .6, 5>
  }

} // end difference


#declare window_tex2 =
  texture {
    pigment { crackle color_map { [0 Gray75 ] [.03 White*1.2 ] } }
    //normal {
      //crackle
      //turbulence 0.04
      //scale 0.15
      //slope_map {
      //  [0    <0.5, 1>]
      //  [0.1 <1.0, 0>]
      //  [0.5  <0.5,-1>]
      //  [0.9 <0.0, 0>]
      //  [1    <0.5, 1>]
      //}
    //}
    scale .2
    //rotate y*rand(S1)*1
    //translate <rand(S2)*1, rand(S3)*1, rand(S1)*1>
  }



// door frame
difference {

  box {
    <0, 0, 0>, <1, 1, .1>
    scale <1.15, 1.55, .5>
    rotate -y*90
    translate <3.55, -.7, 2.42>
    texture { window_tex2 }
  }

  box {
    <0, 0, 0>, <1, 1, .2>
    scale <1, 1.5, 1>
    rotate -y*90
    translate <3.6, -.7, 2.5>
    texture { window_tex2 }
  }

} // end difference


// Window frame

#declare window_tex2 =
  texture {
    pigment { crackle color_map { [0 Gray75 ] [.03 White*1.2 ] } }
    //normal {
      //crackle
      //turbulence 0.04
      //scale 0.15
      //slope_map {
      //  [0    <0.5, 1>]
      //  [0.1 <1.0, 0>]
      //  [0.5  <0.5,-1>]
      //  [0.9 <0.0, 0>]
      //  [1    <0.5, 1>]
      //}
    //}
    scale .15
    rotate y*rand(S1)*1
    translate <rand(S2)*1, rand(S3)*1, rand(S1)*1>
  }


#declare window = union {

  difference {
    box {
      <-1, -1, -.1>, <1, 1, .1>
      scale <.85, .615, .3>
      rotate -y*90
      translate <3.55, .6, 5>
      //pigment { Yellow }
      texture { window_tex2 rotate y*90 }
    }

    box {
      <-1, -1, -.1>, <1, 1, .1>
      scale <.8, .5, 6>
      rotate -y*90
      translate <3.8, .6, 5>
      //pigment { Yellow }
      texture { window_tex2 rotate y*90 }
    }
  } //end difference


  //vertical bar
  box {
    <-1, -1, -.1>, <1, 1, .1>
    scale <.03, .5, .3>
    rotate -y*90
    translate <3.55, .6, 5>
    //pigment { Yellow }
    texture { window_tex2 rotate x*90 }
  }

  //horizontal bar
  box {
    <-1, -1, -.1>, <1, 1, .1>
    scale <.8, .03, .3>
    rotate -y*90
    translate <3.55, .6, 5>
    //pigment { Yellow }
    texture { window_tex2 scale .2}
  }

} //end union



object { window }

// Saloon door


#declare late =
lathe {
  linear_spline
  9,
  <0,0>, <2,0>, <2,1>, <1,2>, <2,8>, <1,13>, <2,13>, <2,14>, <0,14>
  pigment { rgb <.2, .6, .2> }
  scale <.02, .035, .02>
}

#declare saloon_door = union {
  difference {
    merge {
      prism {
        cubic_spline
        0, 1, 10,
        <0,-3>, <0,2>, <0,4>, <1,4>, <3,5.5>, <5,3.3>, <6,2.5>, <5,2>, <0,2>, <-3,0>
        scale .1
        rotate -90*x
        translate <0, .35, .05>
      }

      box {
        <-.3, -.3, -.05>, <.3, .3, .05>
        translate <.3, .3, 0>
      }

    //translate <-.5, -.5, -3>
    pigment { rgb <.8, .4, .4> }
    } // end merge

    box {
      <-.3, -.3, -.05>, <.3, .3, .05>
      scale <.8, .8, 1.1>
      translate <.3, .3, 0>
//      translate <-.5, -.5, -3>
    }
  pigment { rgb <.8, .4, .4> }
  } // end difference

#declare cnt = 1
#declare off_set = .12
#while (cnt<5)
  object { late
    translate <cnt*off_set, .05, 0>
//    translate <-.5, -.5, -3>
  }
  #declare cnt = cnt + 1
#end

scale <.8, 1, .8>

} // end union


object { saloon_door rotate -y*99 translate <3.6, -.5, 2.5> }
object { saloon_door rotate y*90 translate <3.6, -.5, 3.5> }



// **baldach

// geruest
#declare poto_v =
  cylinder {
    <0, 0, 0>, <0, 2.3, 0>, .05
    pigment { Brown }
  }

#declare poto_h =
  cylinder {
    <0, 0, 0>, <0, 0, 5>, .05
    pigment { Brown }
  }

#declare poto_hl =
  cylinder {
    <0, 0, 0>, <0, 0, 3.9>, .03
    pigment { Brown }
  }

#declare poto_h_sign =
  cylinder {
    <0, 0, 0>, <-1.1, 0, 0>, .04
    pigment { Brown }
  }

#declare poto_d_sign =
  cylinder {
    <0, 0, 0>, <-.55, 0, 0>, .04
    pigment { Brown }
  }

#declare poto_tex =
  texture { T_Wood10
    normal {
      wood
      turbulence 0.04
      scale 0.15
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    }
    scale .3
    rotate y*rand(S1)*5
    translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }


object { poto_v translate <2.4, -1, 2> texture { poto_tex rotate x*90} }
object { poto_v translate <2.4, -1, 6> texture { poto_tex rotate -x*90 } }
object { poto_h translate <2.4, 1.35, 1.5> texture { poto_tex scale .5 } }
object { poto_hl translate <2.4, -.1, 2.05> texture { poto_tex } }
object { poto_h_sign translate <2.5, .9, 2.07> texture { poto_tex rotate -y*90} }
object { poto_d_sign rotate z*47 translate <2.45, 1.3, 2.07> texture { poto_tex rotate -y*90 rotate -z*45 } }


//baldach

#declare baldach_board =
  box {
    <0, 0, 0>, <1, 1, 1>
    scale <1.39, .05, .2>
    rotate z*30
  }

#declare cnt = 1
#declare off_set = .21
#while (cnt<25)
  object { baldach_board
    translate <2.3, 1.35, 1.29+(cnt*off_set)>
    texture { T_Wood9 scale .2 rotate rand(S1)*10 translate <rand(S2)*30, rand(S3)*30, 0> }

  }
  #declare cnt = cnt +1
#end



// ** Sign


// chain (cf. POV manual )
#declare chain_segment =
  cylinder { <0, 4, 0>, <0, -4, 0>, 1
}

#declare hlf_torus = difference {

  torus { 4,1 rotate x*-90 }

  box { <-5, -5, -1>, <5, 0, 1> }

} // end difference


#declare link = union {
  object { hlf_torus translate y*4 }
  object { chain_segment translate x*4 }
  object { chain_segment translate -x*4 }
  object { hlf_torus rotate x*180 translate -y*4 }
}

#declare double_link = union {
  object { link }
  object { link rotate y*90 translate -y*14 }
  pigment { White }
}

#declare cnt=0

#declare chain = union {
  #while (cnt<2)
    object { double_link rotate y*rand(S3)*10 translate -y*cnt*28 }
    #declare cnt = cnt + 1
  #end

}  // end union


// sign

#declare sign = union {

difference {
prism {
  cubic_spline
  0, 1, 17,
  <-1, .23>, <0, .3>, <1, .23>, <1, .62>, <1.05, 1.02>, <.75, 1>, <.5, 1.17>, <.16, 1>, <0, 1.25>,
  <-.16, 1>, <-.5, 1.17>, <-.75, 1>, <-1.05, 1.02>, <-1, .62>, <-1, .23>, <0, .3>, <1, .23>
  texture {
    pigment { Brown }
    normal {
      wood
      turbulence 0.01
      scale 0.25
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    }
  rotate y*90
  rotate z*3
  }
  scale <1, .2, 1>
  rotate -x*90
}

text {
  ttf "playbill.ttf"
  "SALOON"
  .2, x*.05
  pigment { Black }
  scale <.7, .6, .7>
  translate <-.75, .45, -.3>
}

} // end of difference

object { chain // left chain
  scale .01
  rotate y*10
  translate <-.5, 1.68, -.1>
}

object { chain // chain right
  scale .01
  rotate -y*5
  translate <.5, 1.68, -.1>
}


} // end of union

object { sign scale .5 translate <1.75, 0, 2.125> }





// ** balcony
box {
  <0, 0, 0>, <1, 1, .1>
  scale <5, 1, 1>
  rotate -y*90
  rotate -z*90
  translate <3.5, 2, 1.5>
  //pigment { Red }
  texture { DMFedit scale .2 rotate rand(S1)*10 translate <rand(S2)*30, rand(S3)*30, 0> }

}


#declare fig =
prism {
  cubic_spline
  0, 1, 17,
  <.5,-1>, <0,-.9>, <-.5,-1>, <-.73,-.5>, <-.41,0>, <-.6,.72>, <-.18,1>, <-.35,1.32>, <0,1.5>,
  <.35, 1.32>, <.18,1>, <.6,.72>, <.41,0>, <.73,-.5>, <.5,-1>, <0, -.9>, <-.5,-1>
  pigment { crackle color_map { [0 Gray75 ] [.06 rgb <.2, .6, .2> ] } scale .5 }
  scale <.133, .035, .133>
}

// rails
#declare rail =
  box {
    <0, 0, 0>, <1, 1, 1>
  }

#declare rail_tex =
  texture { T_Wood10
    normal {
      wood
      turbulence 0.04
      scale 0.15
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    }
    scale .3
    rotate y*rand(S1)*5
    translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }

object { rail scale <.05, .05, 5>
  translate <3.5, 2.5, 1.5> texture { rail_tex } } // front rail, upper
object { rail scale <.05, .05, 5>
  translate <3.5, 2.1, 1.5> texture { rail_tex } }  // front rail, lower
object { rail scale < 1, .05, .05>
  translate <3.5, 2.5, 1.5> texture { rail_tex rotate y*90 } } // right rail, upper
object { rail scale < 1, .05, .05>
  translate <3.5, 2.1, 1.5> texture { rail_tex rotate y*90 } } // right rail, lower
object { rail scale < 1, .05, .05>
  translate <3.5, 2.5, 6.5> texture { rail_tex rotate y*90 } } // left rail, upper
object { rail scale < 1, .05, .05>
  translate <3.5, 2.1, 6.5> texture { rail_tex rotate y*90 } } // left rail, lower
object { rail scale <.05, .4, .05>
  translate <3.5, 2.1, 1.5> texture { rail_tex rotate x*90 } } // corner, right
object { rail scale <.05, .4, .05>
  translate <3.5, 2.1, 6.5> texture { rail_tex rotate x*90 } } // corner, left
object { rail scale <.05, .4, .05>
  translate <3.5, 2.1, 4> texture { rail_tex rotate x*90 } } // middle, front
object { rail scale <.05, .4, .05>
  translate <4.4, 2.1, 1.5> texture { rail_tex rotate x*90 } } // corner, right, rear
object { rail scale <.05, .4, .05>
  translate <4.4, 2.1, 6.5> texture { rail_tex rotate x*90 } } // corner, left, rear

// figs
#declare cnt = 1
#declare off_set = .35
#declare set_fig_fr = union {
  #while (cnt<8)
    object { fig rotate <0, 90, 90> translate <3.55, 2.285, 1.38+(cnt*off_set)>
  }
    #declare cnt = cnt + 1
  #end
} // end union

object { set_fig_fr }
object { set_fig_fr translate z*2.5 }


#declare cnt = 1
#declare off_set = .26
#declare set_fig_sd = union {
  #while (cnt<4)
    object { fig rotate <-90, 0, 0> translate <3.43+(cnt*off_set), 2.285, 1.5> }
    #declare cnt = cnt + 1
  #end
} // end union

object { set_fig_sd }
object { set_fig_sd translate z*5 }





// ** 2nd floor

#declare twofloor_board =
  box {
    <0, 0, 0>, <1, 1, .1>
    scale <5, .2, .5>
    rotate -y*90
    //pigment { Green }
  }

#declare window_hole =
  box {
    <-1, -1, -.1>, <1, 1, .1>
    scale <.8, .5, 4>
    rotate -y*90
    translate <4.72, 3.1, 2.8>
  }



union {
  difference {
    union {

      #declare cnt = 1
      #declare off_set = .215
      #while (cnt<11)
        object { twofloor_board
          translate <4.5, 1.79+(cnt*off_set), 1.5>
          texture { DMFedit scale .2 rotate rand(S1)*10 translate <rand(S2)*30, rand(S3)*30, 0> }

        }
      #declare cnt = cnt + 1
      #end

    } // end union

 object { window_hole }
 object { window_hole scale <1, 1.75, .5> translate <0, -2.4, 4> }

  } // end difference



object { window translate <.92, 2.5, -2.2> }
object { window scale <1, 1.75, .5> translate <.92, 1.9, 2.9> }

} // end union



// support beams, back

#declare support =
  cylinder {
    <0, 0, 0>, <0, 2.45, 0>, .05
    //pigment { Brown }
  }

#declare support_2ndfl =
  cylinder {
    <0, 0, 0>, <1.5, 0, 0>, .05
    //pigment { Brown }
  }

#declare support_tex =
  texture { T_Wood1
    normal {
      wood
      turbulence 0.04
      scale 0.15
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    }
    scale .3
    //rotate y*rand(S1)*5
    //translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }


object { support rotate z*35 translate <5, -1, 2> texture { support_tex  rotate -z*35 rotate -x*90}} // front
object { support rotate z*35 translate <5, -1, 4> texture { support_tex rotate -x*90 rotate -z*35 }} // middle
object { support rotate z*35 translate <5, -1, 6> texture { support_tex rotate -x*90 rotate -z*35 }} // back

object { support_2ndfl rotate z*50 translate <3.6, 1, 2> texture { support_tex rotate -x*90 rotate z*50 }} // 2nd floor, front
object { support_2ndfl rotate z*50 translate <3.6, 1, 4> texture { support_tex rotate -x*90 rotate z*50 }} // 2nd floor, middle
object { support_2ndfl rotate z*50 translate <3.6, 1, 6> texture { support_tex rotate -x*90 rotate z*50 }} // 2nd floor, back


// Trough

#declare trough_tex =
texture {
   T_Wood19
  normal {
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.065
    omega .45
    lambda 2.3
    rotate x*4
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .2
}




difference {
  box {
    <-1, -1, -1>, <1, 1, 1>
    scale <1, .5, .5>
    texture { trough_tex }
  }

  superellipsoid {
    <.25, .25>
    scale <.9, .4, .4>
    translate .2*y
    texture { trough_tex rotate y*70 translate 3 }
  }

scale <1, .6, .5>
rotate -y*90
translate <2.2, -.8, 5>
}

box {
  <-1, -.005, -1>, <1, .005, 1>
  scale <.99, .49, .49>
  scale <1, .6, .5>
  rotate -y*90
  translate <2.2, -.52, 5>
  pigment { color LightBlue transmit .5 }
  normal { waves .4 scale .1 bump_size 3 frequency 2 }
  finish { reflection .1 refraction 1 ior 2 specular .3 roughness .05 }
}





// ** House 2 + 3, right

#declare house_a_tex =
  texture { T_Wood20
    normal {
      wood
      turbulence 0.065
      omega 0.45
      lambda 2.3
      scale <0.075, 0.075, 1>
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    rotate x*4
    }
  scale .7
  rotate y*rand(S1)*5
  translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }


#declare house = union {
  #declare cnt = -4
  #declare off_set = .21

  difference {
    union {
      #while (cnt<9)
        object { h_board
          translate <3.6, cnt*off_set, 6.7>
          texture { house_a_tex }
        }
        #declare cnt = cnt + 1
      #end
    } // end union

    box {
      <3.4, 0, 9.2>, <3.9, 1.2, 10.8>
      texture { house_a_tex }

    }
  } // end difference


#declare door_frame_house_a_tex =
  texture { T_Wood7
    normal {
      wood
      turbulence 0.065
      omega 0.45
      lambda 2.3
      scale <0.075, 0.075, 1>
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    rotate x*4
    }
  scale .7
  rotate y*rand(S1)*5
  translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }


#declare door_house_a_tex =
  texture { T_Wood8
    normal {
      wood
      turbulence 0.065
      omega 0.45
      lambda 2.3
      scale <0.075, 0.075, 1>
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    rotate x*4
    }
  scale .7
  rotate y*rand(S1)*5
  translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }


  // Door
  union {
    box {
      <-.2, 0, 0>, <.2, 3, .1>
      translate -x*1
      texture { door_frame_house_a_tex rotate x*90 }
    }

    box {
      <-.2, 0, 0>, <.2, 3, .1>
      translate x*1
      texture { door_frame_house_a_tex rotate x*90 }

    }

    box {
      <-.8, 2.8, 0>, <.8, 3, .1>
      texture { door_frame_house_a_tex rotate y*90 }

    }

    box {
      <-.8, 0, .05>, <.8, 2.8, .1>
      texture {door_house_a_tex rotate x*90 }
    }

    cylinder {
      <-.6, 1.2, 0>, <-.6, 1.2, -.03>, .05
      pigment { Silver }
    }

    sphere {
      <-.6, 1.2, -.09>, .07
      pigment { Silver }
    }

  rotate y*90
  scale <.5, .6, .5>
  translate <3.5, -.72, 8>
  } // end union

  // Window
  object { window translate <0, 0, 5> }



#declare roof_house_a_tex =
  texture { T_Wood8
    normal {
      wood
      turbulence 0.065
      omega 0.45
      lambda 2.3
      scale <0.075, 0.075, 1>
      slope_map {
        [0    <0.5, 1>]
        [0.1 <1.0, 0>]
        [0.5  <0.5,-1>]
        [0.9 <0.0, 0>]
        [1    <0.5, 1>]
      }
    rotate x*4
    }
  scale .7
  rotate y*rand(S1)*5
  translate <rand(S2)*2, rand(S3)*2, rand(S1)*3>
  }




  // Roof
  box {
    <-2.5, 0, 0>, <2.5, 2.3, .1>
    texture { roof_house_a_tex rotate x*90 }
    rotate <45, 90, 0>
    translate < 3.4, 1.8, 9.2>
  }


} // end union

object { house }
object { house translate z*5.2 }





// * Left side

// JAIL


#declare brikk_tex =
  texture {
    pigment { gradient z color_map { [0 Gray40 ] [.3 Gray50] [.6 Gray60] [.9 Gray70] } }
    normal { bump_map { gif "brik.gif" bump_size 10 } }
  }

#declare brik =
  superellipsoid {
    <.25, .25>
    scale <.15, .1, .02>
    rotate y*90
  }


// back side jail
#declare h_cnt=1
#declare v_cnt=1
#declare h_off_set=.305
#declare v_off_set=.205
#declare indent=0

#while (v_cnt<16)
  #while (h_cnt<3)
    object { brik scale <5, 1, 1> // *******************
      texture { brikk_tex scale 3 translate <-1.5, -1.5, 0> scale <.15, .1, .1> rotate y*90}
      rotate -y*90
      translate <-(h_cnt*h_off_set)+indent-3.5, (v_cnt*v_off_set)-1.1, 6.305 >
    }
    #declare h_cnt = h_cnt + 1
  #end
  #declare h_cnt = 1
  #declare v_cnt = v_cnt + 1
  #if (mod(v_cnt, 2)=0)
    #declare indent=0
  #else
    #declare indent=.15
  #end
#end


difference {
  union {
    // front side jail
    #declare h_cnt=1
    #declare v_cnt=1
    #declare h_off_set=.305
    #declare v_off_set=.205
    #declare indent=0

    #while (v_cnt<16)
      #while (h_cnt<17)
        object { brik
          texture {
            brikk_tex
            scale 3
            translate <-1.5, -1.5, 0>
            scale <.15, .1, .1>
            rotate y*90
            rotate x*(rand(seed(h_cnt))*90)-45
            translate <0, (rand(S1)*.1)-.05, (rand(S2)*.1)-.05>
          }
          translate <-3.5, (v_cnt*v_off_set)-1.1, (h_cnt*h_off_set)+indent+1.2>
        }
        #declare h_cnt = h_cnt + 1
      #end
      #declare h_cnt = 1
      #declare v_cnt = v_cnt + 1
      #if (mod(v_cnt, 2)=0)
        #declare indent=.15
      #else
        #declare indent=0
      #end
    #end


  // mortar
    box {
      <-3.51, -1, 1>, <-3.52, 2, 6.4>
      pigment { Gray80 }
    }
  } // end union

  // window r
  box {
    <-.6, 0, -.5>, <.6, 1, .5>
    rotate y*90
    translate <-3.5, .1, 5.3>
    pigment { Gray50 }
  }

  // window l
  box {
    <-.6, 0, -.5>, <.6, 1, .5>
    rotate y*90
    translate <-3.5, .1, 1.9>
    pigment { Gray50 }
  }

  // door
  box {
    <-.45, 0, -.5>, <.45, 1.9, .5>
    rotate y*90
    translate <-3.5, -1, 3.7>
  }

} // end difference



// roof support poles
#declare sup_pole =
  cylinder {
    <-3.5, 1.8725, 1.6625>, <-3.35, 1.8725, 1.6625>, .06

  }
#declare cell_pole_tex =
  texture { T_Wood14
  normal {
    wood
    turbulence 0.04
    scale 0.15
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .2
  rotate y*90
  rotate y*rand(S1)*3
}

#declare cnt=0
#while (cnt<6)
  object { sup_pole texture {cell_pole_tex translate <rand(S2)*2, rand(S3)*2, rand(S1)*3> } translate z*cnt*.915 }
  #declare cnt = cnt + 1
#end



// window frame r, cell
union {
  difference {
    box {
      <-.65, -.05, 0>, <.65, 1.05, .05>
      rotate y*90
      translate <-3.5, .1, 5.3>
    }

    box {
      <-.55, .05, -.1>, <.55, .95, .1>
      rotate y*90
      translate <-3.5, .1, 5.3>
    }
  texture { T_Chrome_3A }
  } // end difference

  #declare barr =
    cylinder {
      <0, 0, 0>, <0, 1.05, 0>, .02
    }

  union {
    object { barr }
    object { barr translate -x*.21 }
    object { barr translate -x*.42 }

    object { barr translate x*.21 }
    object { barr translate x*.42 }

  rotate y*90
  translate <-3.5, .1, 5.3>
  texture { T_Chrome_3A }
  } // end union

} // end union



// window frame l

#declare sheriff_win_tex =
  texture { T_Wood11
  normal {
    wood
    turbulence 0.04
    scale 0.15
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .2
  rotate y*rand(S1)*3
}



union {
  difference {
    box {
      <-.6, 0, -.05>, <.6, 1, .02>
      rotate y*90
      translate <-3.5, .1, 1.9>
    }

    box {
      <-.55, .05, -.5>, <.55, .95, .5>
      rotate y*90
      translate <-3.5, .1, 1.9>
    }
  texture { sheriff_win_tex rotate y*90 rotate z*90 rotate -x*4}
  } // end difference

  box {
    <-.55, .45, -.05>, <.55, .55, .02>
    rotate y*90
    translate <-3.5, .1, 1.9>
  texture { sheriff_win_tex rotate -x*4}
  }

} // end union

box { // black background behind window
  <-1, -1, -.05>, <1, 1.5, .01>
  rotate y*90
  translate <-3.7, .1, 1.9>
  pigment { Black*5 }
}



// glass in window l

// upper

difference {
  union {
    box {
      <-.55, .55, -.001>, <.55, .95, .001>
      rotate y*90
      translate <-3.5, .1, 1.9>
      pigment { Clear }
      finish { reflection .15 refraction 1 ior 1 specular .2 roughness .05 }
    }

    box {
      <-3.499, .6, 1.8>, <-3.5, .85, 2.2>
      pigment { crackle color_map { [0 Gray80 transmit .5] [0.1 rgbt <1,1,1,1>] [1 rgbt<1,1,1,1>] } scale .08 }
      //finish { reflection .15 refraction 1 ior 1 specular .2 roughness .05 }
    }

    box {
      <-3.499, .8, 2>, <-3.5, 1, 2.4>
      pigment { crackle color_map { [0 Gray80 transmit .5] [0.1 Clear] [1 Clear] } scale .08 }
      //finish { reflection .15 refraction 1 ior 1 specular .2 roughness .05 }
    }
  } // end union

  cylinder { // bullethole 1
    <-3.4, .75, 2>, <-3.6, .75, 2>, .035
  }

  cylinder { // bullethole 2
    <-3.4, .9, 2.2>, <-3.6, .9, 2.2>, .035
  }
} // end difference


// lower

difference {
  box {
    <-.55, .05, -.001>, <.55, .45, .001>
    rotate y*90
    translate <-3.5, .1, 1.9>
  }

  union {
    box {
      <-.55, .05, -.005>, <.55, .45, .005>
      scale .7
      rotate y*90
      rotate x*40
      translate <-3.5, .1, 1.9>
    }

    box {
      <-.55, .05, -.005>, <.55, .45, .005>
      scale .6
      rotate y*90
      rotate -x*35
      translate <-3.5, .1, 1.7>
    }

    box {
      <-.55, .05, -.005>, <.55, .45, .005>
      scale .6
      rotate y*90
      rotate -x*35
      translate <-3.5, .4, 1.8>
    }

    box {
      <-.55, .05, -.005>, <.55, .45, .005>
      scale .5
      rotate y*90
      rotate -x*50
      translate <-3.5, .3, 2.2>
    }

  }// end union
pigment { color Gray50 transmit .9 }
finish { reflection .15 refraction 1 ior 1 specular .2 roughness .05 }
}// end difference



// door frame
union {
  difference {
    box {
      <-.52, 0, -.05>, <.52, 1.97, .05>
      rotate y*90
      translate <-3.5, -1, 3.7>
    }

    box {
      <-.45, 0, -.5>, <.45, 1.9, .5>
      rotate y*90
      translate <-3.5, -1, 3.7>
    }
  texture { sheriff_win_tex rotate y*90 rotate z*90 rotate x*3}
  } // end difference

  box {
    <-.45, 0, -.03>, <.45, 1.9, .05>
    rotate y*90
    translate <-3.51, -1, 3.7>
    pigment { Brown }
    normal { wood turbulence .05 scale .1}
  }

#declare sheriff_door_tex =
  texture { T_Wood24
  normal {
    wood
    turbulence 0.04
    scale 0.15
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .2
  rotate y*rand(S1)*3
}



  prism {
    conic_sweep
    linear_spline
    0.85, 1, 5
    <4,4>,<-4,4>,<-4,-4>,<4,-4>,<4,4>
    rotate <-90, 90, 0>
    scale <.1, .09, .1>
    translate y*1.49
    translate <-3.35, -1, 3.7>
    texture { sheriff_door_tex rotate x*90 }
  }

  prism {
    conic_sweep
    linear_spline
    0.85, 1, 5
    <4,4>,<-4,4>,<-4,-4>,<4,-4>,<4,4>
    rotate <-90, 90, 0>
    scale <.1, .09, .1>
    translate y*.65
    translate <-3.35, -1, 3.7>
    texture { sheriff_door_tex rotate x*90 }
  }

  cylinder {
    <0, 0, 0>, <0, .05, 0>, .02
    rotate <90, 90, 0>
    translate <-3.45, .06, 3.35>
    pigment { White }
  }

  sphere {
    <0, 0, 0>, .04
    scale <.7, 1, 1>
    translate <-3.41, .06, 3.35>
    pigment { White }
  }

} // end union


// Sheriff star on door
#declare star =
union {
  difference {
    union {
      sphere {
        <0, 0, 0>, 1.3
      }

      #declare star_point =
        prism {
          linear_spline
          0,1,4
          <-1, 0>, <1, 0>, <0, 2>, <-1, 0>
          scale .8
          rotate -x*90
        }

      #declare cnt=0
      #while (cnt<=360)
        object { star_point
          translate y*1
          rotate z*cnt
        }
        #declare cnt=cnt+(360/5)
      #end
    } // end union

    box {
      <-3, -3, 0>, <3, 3, 2>
    }

    box {
      <-3, -3, -.01>, <3, 3, -2>
    }

  } // end difference


  #declare s =
    text {
      ttf "playbill.ttf"
      "S"
      .1, 0
      scale <2, 1.5, 1>
    }

  #declare h =
    text {
      ttf "playbill.ttf"
      "H"
      .1, 0
      scale <2, 1.5, 1>
    }

  #declare e =
    text {
      ttf "playbill.ttf"
      "E"
      .1, 0
      scale <2, 1.5, 1>
    }

  #declare r =
    text {
      ttf "playbill.ttf"
      "R"
      .1, 0
      scale <2, 1.5, 1>
    }

  #declare i =
    text {
      ttf "playbill.ttf"
      "I"
      .1, 0
      scale <2, 1.5, 1>
    }

  #declare f =
    text {
      ttf "playbill.ttf"
      "F"
      .1, 0
      scale <2, 1.5, 1>
    }

union {
  object { s translate -y*4 rotate -z*65 }
  object { h translate -y*4 rotate -z*45 }
  object { e translate -y*4 rotate -z*25 }
  object { r translate -y*4 translate -x*.3 }
  object { i translate -y*4 rotate z*15 }
  object { f translate -y*4 rotate z*35 }
  object { f translate -y*4 rotate z*55 }
}
pigment { White*1.5 }
no_shadow
} // end union

object {
  star
  scale .065
  rotate y*90
  translate <-3.43, .54, 3.7>
}


// ** Sheriff behind Window

union {
  object { gunhand }

  cone {
    <0, 0, 0>, .4
    <3, 0, 0>, .5
    clipped_by {
      box {
        <.01, -.6, -.6>, <3, .6, .6>
      }
    }
    scale <1, 1, .7>
    translate <2, -.9, .2>
  }

  sphere {
    0, .5
    scale <1, 1, .7>
    rotate -y*45
    translate <4.95, -.9, .15>
  }

  cone {
    <0, 0, 0>, .5
    <0, 0, -2>, .6
    rotate y*20
    scale <.7, 1, 1>
    translate <5, -.9, .2>
  }

  scale .1
  pigment { SkyBlue }
  normal { gradient y sine_wave scale .5 frequency 2 turbulence <.05, .15, 0> bump_size 2}
  rotate z*90
  rotate y*130
  translate <-3.4, -.3, 2.3>
} // end union







// Church/School

#declare church_board_tex =
  texture { T_Wood23
  normal {
    wood
    turbulence 0.04
    scale 0.15
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .3
  rotate y*rand(S1)*3
}


// front church wall
#declare cnt=-4
#declare off_set=.179
#while (cnt<12)
  object { h_board rotate z*15 translate <-3.6, cnt*off_set, 6.5>
    texture { church_board_tex translate <0, rand(seed(cnt))*.1, rand(seed(cnt))*.2> }
  }
  #declare cnt = cnt + 1
#end


// left church wall
#declare cnt=-4
#declare off_set=.179
#while (cnt<12)
  object { h_board rotate -z*15 rotate -y*90 translate <-3.6, cnt*off_set, 6.5>
    texture { church_board_tex
      rotate -z*15
      rotate -y*90
      #declare ZZ=rand(seed(cnt))*5
      rotate z*ZZ
      translate <rand(seed(cnt))*20, rand(seed(cnt))*15, 0>
    }
    #debug str(ZZ, 5 ,3)
  }
  #declare cnt = cnt + 1
#end


// side vertical bands
#declare side_board =
  box {
    <0, 0, 0>, <-.2, 3.07, .1>
    pigment { White }
    //texture { church_board_tex rotate x*90 rotate z*3 }
  }

object {
  side_board
  translate <-3.61, -1, 6.4>
}

object {
  side_board
  rotate y*90
  translate <-3.65, -1, 6.4>
}

object {
  side_board
  translate <-3.61, -1, 11.4>
}

object {
  side_board
  rotate y*90
  translate <-3.65, -1, 11.4>
}

// front upper church wall
difference {
  union {
    #declare cnt=0
    #declare off_set=.21
    #while (cnt<5)
      object { h_board rotate z*15 translate <-3.6, (cnt*off_set)+2.11, 6.5>
        texture { church_board_tex translate <0, rand(seed(cnt))*.7, rand(seed(cnt))*.9> }
      }
      #declare cnt = cnt + 1
    #end
  } // end union

  box {
    <0, 0, 0>, <-5, 2, 3.5>
    rotate -x*20
    translate <-3.5, 2.1, 6.5>
    texture { church_board_tex translate <0, rand(seed(cnt))*.7, rand(seed(cnt))*.9> }
  }

  box {
    <0, 0, 0>, <-5, 2, -3.5>
    rotate x*20
    translate <-3.5, 2.1, 11.5>
    texture { church_board_tex translate <0, rand(seed(cnt))*.7, rand(seed(cnt))*.9> }
  }
} // end difference

#declare church_roof_tex =
  texture { T_Wood6
  normal {
    wood
    turbulence 0.04
    scale 0.15
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .3
  rotate y*rand(S1)*3
}



// church roof
#declare h_r_board =
  box {
    <0, 0, 0>, <1, 1, .05>
    scale <3.1, .2, 1>
    rotate x*90
    rotate z*20
    //rotate -y*90
  }

#declare cnt=0
#declare off_set=.2
#while (cnt<25)
  object { h_r_board rotate -y*90 translate <-(cnt*off_set)-3.6, 2.05, 6.1>
    texture { church_roof_tex rotate y*rand(seed(cnt))*4 rotate z*20 }
  }
  #declare cnt = cnt + 1
#end

#declare cnt=0
#declare off_set=.2
#while (cnt<25)
  object { h_r_board rotate y*90 translate <-(cnt*off_set)-3.8, 2.05, 11.9>
    texture { church_roof_tex rotate y*rand(seed(cnt))*4 rotate z*20 }
  }
  #declare cnt = cnt + 1
#end



// church tower wall
#declare h_t_board =
  box {
    <0, 0, 0>, <1, 1, .05>
    scale <1.3, .2, 1>
    rotate -y*90
  }

// front
#declare cnt=0
#declare off_set=.21
#while (cnt<8)
  object { h_t_board translate <-3.6, (cnt*off_set)+2.73, 8.35>
    texture { church_board_tex rotate x*rand(seed(cnt))*4 translate <0, rand(seed(cnt))*2, rand(seed(cnt))*2> }
  }
  #declare cnt = cnt + 1
#end

// rear
#declare cnt=0
#declare off_set=.21
#while (cnt<8)
  object { h_t_board translate <-4.9, (cnt*off_set)+2.73, 8.35>
    texture { church_board_tex
      rotate y*90
      rotate z*rand(seed(cnt))*4
      translate <rand(seed(cnt))*2, rand(seed(cnt))*1.1, 0>
    }
  }
  #declare cnt = cnt + 1
#end

// left
#declare cnt=0
#declare off_set=.21
#while (cnt<8)
  object { h_t_board rotate -y*90 translate <-3.6, (cnt*off_set)+2.73, 8.4>
    texture { church_board_tex
      rotate -y*90
      rotate z*rand(seed(cnt))*4
      translate <rand(seed(cnt))*2, rand(seed(cnt))*1.5, 0>
    }
  }
  #declare cnt = cnt + 1
#end

//right
#declare cnt=0
#declare off_set=.21
#while (cnt<8)
  object { h_t_board rotate -y*90 translate <-3.6, (cnt*off_set)+2.73, 9.65>
    pigment { White }
  }
  #declare cnt = cnt + 1
#end



// Church Tower roof

#declare h_tr_board =
  box {
    <0, 0, 0>, <1, 1, .05>
    scale <1.6, .2, 1>
    rotate -y*90
  }

difference {
  union {

    // front
    #declare cnt=0
    #declare off_set=.21
    #while (cnt<8)
      object { h_tr_board rotate -x*90 rotate z*30 translate <-3.45, 4.3, (cnt*off_set)+8.35>
      }
      #declare cnt = cnt + 1
    #end

    // rear
    #declare cnt=0
    #declare off_set=.21
    #while (cnt<7)
      object { h_tr_board rotate -x*90 rotate -z*30 translate <-5, 4.3, (cnt*off_set)+8.5>
      }
      #declare cnt = cnt + 1
    #end
  } // end union

  // left csg
  box {
    <0, 0, 0>, <2.5, 2.5, -3>
    rotate x*30
    translate <-5, 4.2, 8.1>
  }

  // right csg
  box {
    <0, 0, 0>, <.8, 2.5, 2.5>
    rotate y*90
    rotate -x*30
    translate <-4.9, 4.5, 10.61>
  }
texture { church_roof_tex rotate -x*60 }
translate -x*.05
} // end difference


difference {
  union {
    // left
    #declare cnt=0
    #declare off_set=.21
    #while (cnt<8)
      object { h_tr_board rotate -x*90 rotate y*90 rotate x*30 translate <-(cnt*off_set)-3.4, 4.3, 8.2>
      }
      #declare cnt = cnt + 1
    #end

    // right
    #declare cnt=0
    #declare off_set=.2
    #while (cnt<8)
      object { h_tr_board rotate -x*90 rotate -y*90 rotate -x*30 translate <-(cnt*off_set)-3.6, 4.3, 9.8>
      }
      #declare cnt = cnt + 1
    #end
  } // end union

    // front csg
    box {
    <0, 0, 0>, <2.5, 2.5, -3>
    rotate -y*90
    rotate z*30
    translate <-3.5, 4.2, 8>
  }

    // rear csg
    box {
    <0, 0, 0>, <2, 3, -3>
    rotate -y*90
    rotate -z*30
    translate <-8.08, 5, 8.2>
  }
texture { church_roof_tex rotate x*90 }
} // end difference



// * church clock

#declare church_clock =
  union {

  // hour body
  cylinder {
    <0, 0, 0>, <0, 0, .1>, 1
  }

  difference {
    cylinder {
      <0, 0, 0>, <0, 0, -.05>, 1
    }

    cylinder {
      <0, 0, .01>, <0, 0, -.06>, .85
    }
  } // end difference

  cylinder {
    <0, 0, 0>, <0, 0, -.025>, .03
  }

  // hour dots
  #declare cnt=0
  #while (cnt<360)
    sphere {
      <0, 0, 0>, .06
      pigment { Black }
      scale <1, 1, .4>
      translate x*.7
      rotate z*cnt
      translate z*.01
    }
    #declare cnt = cnt + 30
  #end

  // hands

  #declare hand =
    union {
      box {
        <-.03, -.15, -.02>, <.03, .33, -.021>
      }

      difference {
        sphere {
          <0, 0, 0>, .09
          scale <1, 1.5, .01>
          translate <0, .45, -.02>
        }

        cylinder {
          <0, 0, 0>, <0, 0, -.5>, .065
          scale <1, 1.5, 1>
          translate <0, .45, 0>
        }
      } // end difference

      box {
        <-.025, .54, -.02>, <.025, .7, -.021>
      }
    pigment { Gold }
    } // end union

  object { hand rotate -z*100}
  object { hand scale <.9, .85, 1> rotate z*175 }


  //glass front
  cylinder {
    <0, 0, -.04>, <0, 0, -.05>, .85
    pigment { Clear }
  }
  pigment { White }
  } // end union


object { church_clock scale .45 translate <-4.3, 3.5, 8.25> }
object { church_clock scale .45 rotate -y*90 translate <-3.55, 3.5, 9> }


// church door

union{
union {

  cylinder {
    <-1, 0, 0>, <-1, 2, 0>, .2
  }

  cylinder {
    <1, 0, 0>, <1, 2, 0>, .2
  }

  difference {
    torus {
      1, .2
      rotate x*90
    }

    box {
      <-1.5, 0, .6>, <1.5, -1.5, -.6>
    }
  translate y*2
  } // end difference
pigment { White }
scale <1.3, 1.3, .1>
} // end union


#declare church_door_tex =
  texture { T_Wood9
  normal {
    wood
    turbulence 0.04
    scale 0.15
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .3
  rotate y*rand(S1)*3
}



box {
  <-1.1, 3, 0>, <1.1, 3.7, .05>
  texture { church_door_tex }
}

box {
  <-1.1, 0, 0>, <0, 3, .05>
  texture { church_door_tex rotate -x*90 }
}

box {
  <0, 0, 0>, <1.1, 3, .05>
  texture { church_door_tex rotate x*88 }
}

#declare handle_cyl =
  cylinder {
    <0, 0, 0>, <0, 0, -.1>, .05
    pigment { Silver }
  }

#declare Handle =
  union {
    cylinder {
      <0, -.2, 0>, <0, .2, 0>, .055
    }

    sphere {
      <0, -.205, 0>, .07
    }

    sphere {
      <0, .21, 0>, .07
    }
  pigment { Silver }
  } // end union

object { handle_cyl translate <-.2, 1.1, 0> }
object { handle_cyl translate <-.2, 1.5, 0> }
object { handle_cyl translate <.2, 1.1, 0> }
object { handle_cyl translate <.2, 1.5, 0> }
object { Handle translate <-.2, 1.3, -.1> }
object { Handle translate <.2, 1.3, -.1> }

rotate -y*90
scale .5
translate <-3.6, -.75, 9>
} // end union


// church window

#declare church_window =
  union {
    difference {
      cylinder {
        <0, 0, 0>, <0, 0, -.1>, 1
      }

      cylinder {
        <0, 0, .1>, <0, 0, -.12>, .9
      }

    } // end difference

    box {
      <-.05, -.99, 0>, <.05, .99, -.1>
    }

    box {
      <-.99, -.05, 0>, <.99, .05, -.1>
    }

    cylinder {
      <0, 0, -.075>, <0, 0, 0>, .95
      pigment { crackle scale .4
      color_map {
        [0.0 Silver ]
        [.15 Gold ]
      }
      }
    }

  pigment { White }

  } // end union


object { church_window scale .4 rotate -y*90 translate <-3.62, 1.45, 7.5> }
object { church_window scale .4 rotate -y*90 translate <-3.62, 1.45, 10.5> }





// **  cemetary gate

#declare gate_pick_v =
union {
  cylinder {
    <0, 0, 0>, <0, 2, 0>, .03
  }

  sphere {
    0, .08
    translate <0, 2, 0>
  }

  cone {
    <0, 0, 0>, .08
    <0, .4, 0>, .001
    translate <0, 2, 0>
  }

pigment { Silver }
} // end union


#declare gate_pick_h =
union {
  box {
    <0, -.012, -.04>, <5.4, .012, .04>
    pigment { Silver }
  }



} // end union




#declare gate_row =
union {
  object { gate_pick_v }
  object { gate_pick_v translate x*1 }
  object { gate_pick_v translate x*2 }
  object { gate_pick_v translate x*3 }
  object { gate_pick_v translate x*4 }
  object { gate_pick_v translate x*5 }

  object { gate_pick_h translate <-.2, 1.5, 0> }
  object { gate_pick_h translate <-.2, .5, 0> }
}


// gate entrance

#declare gate_entrance =
union {
  cylinder {
    <-1.53, 0, 0>, <-1.53, 3, 0>, .035
  }

  cylinder {
    <1.53, 0, 0>, <1.53, 3, 0>, .035
  }

  difference {
    torus {
      1.53, .035
      rotate -x*90
    }

    box {
      <-1.6, 0, -.5>, <1.6, -1.6, .5>
    }

  translate y*3
  } // end difference


  #declare gate_entrance_v =
    cylinder {
      <0, 0, 0>, <0, 3, 0>, .03
    }

  #declare gate_entrance_tori =
    difference {
      torus {
        .365, .03
        rotate -x*90
      }

      box {
        <-.4, 0, -.05>, <.4, -.4, .05>
      }
    } // end difference


  #declare off_set = .365

  object {gate_entrance_v translate -x*.03 }
  object {gate_entrance_v translate -x*off_set }
  object {gate_entrance_v translate -x*2*off_set }
  object {gate_entrance_v translate -x*3*off_set }
  object {gate_entrance_v translate -x*4*off_set }

  object {gate_entrance_v translate x*.03 }
  object {gate_entrance_v translate x*off_set }
  object {gate_entrance_v translate x*2*off_set }
  object {gate_entrance_v translate x*3*off_set }
  object {gate_entrance_v translate x*4*off_set }


  object {gate_entrance_tori translate <-3*off_set, 3, 0> }
  object {gate_entrance_tori translate <-2*off_set, 3, 0> }
  object {gate_entrance_tori translate <-off_set-.015, 3, 0> }

  object {gate_entrance_tori translate <3*off_set, 3, 0> }
  object {gate_entrance_tori translate <2*off_set, 3, 0> }
  object {gate_entrance_tori translate <off_set+.015, 3, 0> }


  #declare gate_entrance_bar_h =
    box {
      <-1.5, -.012, -.04>, <1.5, .012, .04>
    }

  object { gate_entrance_bar_h translate y*.5 }
  object { gate_entrance_bar_h translate y*1.5 }
  object { gate_entrance_bar_h translate y*2.5 }

  box { // lock
    <.03, 1.5, -.02>, <.25, 1.75, .02>
  }

pigment { Silver }
} // end union

#declare gate =
union {
  object { gate_entrance }
  object { gate_row translate x*1.7 }
  object { gate_row translate -x*6.7 }
}

object { gate scale .5 rotate -y*90 translate <-3.56, -.7, 15.1> }

object { gate_row scale .5 rotate y*180 translate <-3.56, -.7, 18.2> }



// ** tree

// made by L-Parser, basic shape Tree07, lowered the recursions to 8

#declare l_base = object { cylinder { <0, 0, 0>, <0, 1.5, 0>, .75 } }
#declare col_12 = texture { T_Wood9 rotate x*90 }
#include "tree.inc"


// noose on tree

#declare noose =
union {

  cylinder {
    <0, 0, 0>, <0, .6, 0>, .02
  }

  torus {
    .05, .02
    rotate z*90
    translate y*.65
  }

  #declare noose_v =
    torus {
      .04, .02
      rotate z*13
    }

  object { noose_v }
  object { noose_v translate y*.04 }
  object { noose_v translate y*.08 }
  object { noose_v translate y*.12 }

  prism {
    cubic_spline
    0, 1, 14
    <.8, -2>, <0, 0>, <-.8, -2>, <0, -2.8>, <.8, -2>, <0, 0>, <-.8, -2>
    <.6, -2>, <0, -.2>, <-.6, -2>, <0, -2.6>, <.6, -2>, <0, -.2>, <-.6, -2>
    rotate -x*90
    scale <.2, .2, .04>
  }

pigment { MediumWood*1.6 }
} // end union

object { noose translate <2.9, 1.6, 18.5> }





// ** Camera front


#declare cam_rail_tex =
  texture { T_Wood31
  normal {
    wood
    turbulence 0.04
    scale 0.15
    slope_map {
      [0    <0.5, 1>]
      [0.1 <1.0, 0>]
      [0.5  <0.5,-1>]
      [0.9 <0.0, 0>]
      [1    <0.5, 1>]
    }
  }
  scale .2
  rotate y*rand(S1)*3
}


#declare fix =
  union {
    difference {
      torus {
        .1, .01
      }

      box {
        <-.11, -.11, -.11>, <.11, .11, 0>
      }
    } // end difference

    cylinder {
      <-.1, 0, 0>, <-.1, 0, -.05>, .01
    }

    cylinder {
      <.1, 0, 0>, <.1, 0, -.05>, .01
    }

  rotate -x*90
  pigment { Silver }
  } // end union



#declare cam_rail =
  union {

    difference {
      cylinder {
        <-.5, 0, 0>, <-.5, 0, 1>, .08
      }

      cylinder {
        <-.5, 0, -.1>, <-.5, 0, .1>, .05
      }
    } // end difference

    difference {
      cylinder {
        <.5, 0, 0>, <.5, 0, 1>, .08
      }

      cylinder {
        <.5, 0, -.1>, <.5, 0, .1>, .05
      }
    } // end difference

    cylinder {
      <-.5, 0, .9>, <-.5, 0, 1.1>, .05
    }

    cylinder {
      <.5, 0, .9>, <.5, 0, 1.1>, .05
    }

    box {
      <-.8, -.1, .25>, <.8, -.2, .35>
      texture { cam_rail_tex }
    }

    box {
      <-.8, -.1, .65>, <.8, -.2, .75>
      texture { cam_rail_tex }
    }

    box {
      <-.05, -.1, .35>, <.05, -.2, .65>
      texture { cam_rail_tex }
    }

    object { fix
      translate <-.5, -.06, .3>
    }

    object { fix
      translate <.5, -.06, .3>
    }

    object { fix
      translate <-.5, -.06, .7>
    }

    object { fix
      translate <.5, -.06, .7>
    }

    texture { T_Silver_3C }
  } // end union



// ** camera train

#declare roller =
  difference {
    cylinder  {
      <-.09, 0, 0>, <.09, 0, 0>, .08
    }

    torus {
      .079, 0.03
      rotate z*90
      scale <2.3, 1, 1>
    }
  texture { T_Chrome_2C }
  } // end difference



#declare axe =
union {
  object { roller translate <-.5, 0, 0> }

  object { roller translate <.5, 0, 0> }

  cylinder {
    <-.62, 0, 0>, <.62, 0, 0>, .01
    pigment { Black }
  }

} // end union


#declare supp =
   prism { // triangle shape out of POV-ray tutorial
    cubic_spline
    0, 1, 6,
    < 3, -5>, < 3,  5>, <-5,  0>, < 3, -5>, < 3,  5>, <-5,  0>
    pigment { Black }
    rotate z*90
    scale .02
  }


union { // positioning camera-rails & support
  object { cam_rail }
  object { cam_rail translate -z*1.02 }
  object { cam_rail translate -z*2.04 }
  union { // 2
    object { axe translate <0, .13, 0> }
    object { axe translate <0, .13, 1> }
    object { supp translate <-.34, .18, 0> }
    object { supp translate <.34, .18, 0> }
    object { supp translate <-.34, .18, 1> }
    object { supp translate <.34, .18, 1> }
    box {
      <-.5, .23, -.2>, <.5, .28, 1.2>
      texture { T_Chrome_1B }
    }
  translate <0, 0, -2.3>
  } // end union 1
  object { cam rotate y*165 scale .25 translate <0, 1, -1.65> translate y*.5}
scale .4
rotate -y*31
translate <1.3, -.9, -2.1>
} // end union 2


