// Persistence of Vision Raytracer
// Jumelles Leica Trinovid 8x20 BCA
/*
Leica Trinovid			8 x 20 BC/BCA
Magnification			8x
Front lens diameter		20 mm
Exit pupil				2.5 mm
Field of view			115 m/1000 m
Near focusing distance	3 m approx.
Twilight factor			12.6
Dimensions				92 x 60 x 35
(h x w x d in mm)		(folded)
Weight				    225/235 g
*/

/******************************************************************************
   A faire:
******************************************************************************/

#declare Jumelles_FGlossy=finish{
   phong 3
   phong_size 10
   }

#declare Jumelles_FShiny=finish{
   phong 3
   phong_size 30
   }

/******************************************************************************

        objets

******************************************************************************/

#declare Jumelles_Plaque1=object{
   union{
      difference {
         box {<0, -3, 0> <56, 0, 46>}
         box {<20, -4, -1> <36, 1, 11>}
         }
      cylinder {<3, -3, 0> <3, -3, 46>, 3}
      cylinder {<53, -3, 0> <53, -3, 46>, 3}
      }
   texture {
      pigment {Black}
      normal {crackle 1 scale 1}
      finish {Jumelles_FGlossy}
      }
   }

#declare Jumelles_Plaque2=object{
   cylinder {-.1*y, .1*y, 6}
   texture {
      pigment {
         image_map {
            png "leica.png"
            map_type 0 //plan
            interpolate 2
            once
            }
         scale 12
         translate <-6, -6, -6>
         rotate -90*x
         }
      finish {Dull}
      }
   }

#declare Jumelles_Plaque3=object{
   cylinder {0, 11*z, 7}
   texture {
      pigment {Black}
      normal {radial frequency 25 rotate 90*x}
      finish {phong 0.3 phong_size 3}
      }
   }

#declare Jumelles_plaque=union {
   object {Jumelles_Plaque1}
   object {Jumelles_Plaque2 translate <28, 0, 26>}
   object {Jumelles_Plaque3 translate <28, 0, 0>}
   }

#declare Jumelles_Tube1=object {
   cylinder {0, 8*z, 15}
   texture {
      pigment {Black}
      finish {phong .2 phong_size 3}
      }
   }

#declare Jumelles_Tube2D=object {
   cylinder {7*z, 13*z, 13}
   texture {pigment {Black}}
   texture {
      pigment {
         image_map {
            png "leica2.png"
            map_type 2 //cylindre
            interpolate 2
            once
            }
         scale 3
         scale <1, 1, -1>
         rotate -90*x
         translate 11*z
         rotate -40*z
         }
      finish {Jumelles_FShiny}
      }
   }

#declare Jumelles_Tube2G=object {
   cylinder {7*z, 13*z, 13}
   texture {
      pigment {Black}
      finish {Jumelles_FShiny}
      }
   }

#declare Jumelles_Tube3D=object {
   cylinder {12*z, 20*z, 15}
   texture {pigment {Black}}
   texture {
      pigment {
         image_map {
            png "trinovid.png"
            map_type 2 //cylindre
            interpolate 2
            once
            }
         scale 3
         scale <1, 1, -1>
         rotate -90*x
         translate 16*z
         rotate -40*z
         }
      finish {Jumelles_FShiny}
      }
   }

#declare Jumelles_Tube3G=object {
   union{
      cylinder {12*z, 20*z, 15}
      box {<-3, 0, 12> <3, 16, 20>}
      cylinder {12*z, 20*z, 3 translate 16*y}
      }
   texture {pigment {Black}}
   texture {
      pigment {
         image_map {
            png "8x20bca.png"
            map_type 2 //cylindre
            interpolate 2
            once
            }
         scale 3
         scale <1, 1, -1>
         rotate -90*x
         translate 16*z
         rotate -160*z
         }
      finish {Jumelles_FShiny}
      }
   }

#declare Jumelles_Tube4=object {
   cylinder {20*z, 66*z, 15}
   texture {
      pigment {Black}
      normal {crackle 1 scale 1}
      finish {Jumelles_FGlossy}
      }
   }

#declare Jumelles_Tube5=object {
   union{
      cylinder {66*z, 95*z, 15}
      box {<-3, 0, 66> <3, 16, 78>}
      cylinder {66*z, 78*z, 3 translate 16*y}
      }
   texture {
      pigment {Black}
      finish {Jumelles_FShiny}
      }
   }

#declare Jumelles_Tube6=object {
   cylinder {83*z, 87*z, 15.5}
   texture {
      pigment {Black}
      normal {radial frequency 50 rotate 90*x}
      finish {phong .3 phong_size 3}
      }
   }

#declare Jumelles_TubeD=union {
   object {Jumelles_Tube1}
   object {Jumelles_Tube2D}
   object {Jumelles_Tube3D}
   object {Jumelles_Tube4}
   object {Jumelles_Tube5}
   object {Jumelles_Tube6}
   }

#declare Jumelles_TubeG=union {
   object {Jumelles_Tube1}
   object {Jumelles_Tube2G}
   object {Jumelles_Tube3G}
   object {Jumelles_Tube4}
   object {Jumelles_Tube5}
   }

#declare Jumelles=union {
   object {Jumelles_plaque translate <0, 19, 20>}
   object {Jumelles_TubeD translate 0*x}
   object {Jumelles_TubeG translate 56*x}
   scale 0.1
   }
