// Persistence of Vision Raytracer
// Theme "A & D" 07-08/97
// Sizes in cm
// Proportions pour cadrage classique 800x600

global_settings {
   max_trace_level 6
   adc_bailout 1/255
   assumed_gamma 1.9
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#declare MAIN_POV=1
#include "common.inc"

#include "journal.inc"
#include "fauteuil.inc"
#include "jumelles.inc"

#render "Includes ok.\n"

//#declare WideLight = 1

#declare Vue_1= camera {
   perspective
   location  <-30, 100, 50>*.7
   up        y
   right     -4/3 * x
   look_at   <0, 0, 0>
   angle 30 //Attention: angle  la base et non sur la diagonale!
}

#declare Lampes=union{
   object {
      light_source {
         <-100, 500, 600>
         color White*1
         spotlight
         point_at <-100, 0, 0>
         radius 20//10
         falloff 30//15
         }
      }
   object {
      light_source {
         <100, 500, 600>
         color White*.6
         spotlight
         point_at <100, 0, 0>
         radius 20//10
         falloff 30//15
         }
      }
   }

#declare Lampes_E=union{
   object {
      light_source {
         <-100, 500, 600>
         color White
         spotlight
         point_at <-100, 0, 0>
         radius 10
         falloff 15
         area_light
         <30, 0, 0> <0, 30, 0> // lights spread out across this distance (x * y)
         4, 4
         adaptive 0 jitter
         }
      }
   object {
      light_source {
         <100, 500, 600>
         color White*.8
         spotlight
         point_at <100, 0, 0>
         radius 10
         falloff 15
         area_light
         <30, 0, 0> <0, 30, 0> // lights spread out across this distance (x * y)
         4, 4
         adaptive 0 jitter
         }
      }
   }

/******************************************************************************

        Scne complte

******************************************************************************/

#ifdef (WideLight)
   object {Lampes_E}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end

#declare Scene=union{
   object {Journal rotate -20*y translate <-22, 1, 13>}
   object {Ticket rotate -15*y translate <12, 1.5, 0>}
   object {Jumelles scale 1 rotate 65*y translate <-10, 3.5, 2>}
   object {Fauteuil translate <0, 0, 0>}
   }


camera {Vue_1}
object {Scene rotate 0*y translate <-4, 0, -5>}

