// Persistence of Vision Raytracer
// Mtronome type 1 (bois normal)


/******************************************************************************
   A faire:
******************************************************************************/



#ifndef (M3_COMMON)
   #ifndef (MAIN_POV)
      #include "common.inc"
   #end

/******************************************************************************

        textures

******************************************************************************/

#declare M3_TCuivre=texture {
   T_Gold_1A
   finish {Glossy metallic}
   }
#declare M3_TAcier=texture {
   T_Chrome_5A
   finish {Glossy metallic}
   }

/******************************************************************************

        objets communs

******************************************************************************/

#declare M3_Face=difference{
   box {<0, 0, -5> <.5, 20.616, 5>}
   plane {z, -5 rotate 14.04*x}
   plane {-z, -5 rotate -14.04*x}
   rotate 14.04*z
   translate 5*x
   }

#declare M3_Fond=difference{
   box {<0, 5, -5> <.5, 17, 5> translate -2*x}
   plane {z, -5 rotate 14.04*x}
   plane {-z, -5 rotate -14.04*x}
   rotate 14.04*z
   translate 5*x
   }

#declare M3_ext=object {
   difference {
      union {
         sphere {<0, 20, 0>, .5}

         sphere {<5, 0, 5>, .5}
         cylinder {<5, 0, 5>, <0, 20, 0>, .5}
         sphere {<-5, 0, 5>, .5}
         cylinder {<-5, 0, 5>, <0, 20, 0>, .5}
         sphere {<5, 0, -5>, .5}
         cylinder {<5, 0, -5>, <0, 20, 0>, .5}
         sphere {<-5, 0, -5>, .5}
         cylinder {<-5, 0, -5>, <0, 20, 0>, .5}

         cylinder {<-5, 0, -5>, <5, 0, -5>, .5}
         cylinder {<-5, 0, 5>, <5, 0, 5>, .5}
         cylinder {<-5, 0, -5>, <-5, 0, 5>, .5}
         cylinder {<5, 0, 5>, <5, 0, -5>, .5}

         object {M3_Face}
         object {M3_Face rotate 90*y}
         object {M3_Face rotate 180*y}
         object {M3_Face rotate 270*y}

         object {M3_Fond rotate -90*y}
         }
      box {<-5, 3, 4> <5, 15, 7> rotate -14.04*x}
      }
#ifdef (MAIN_POV)
   pigment {Black}
#else
   pigment {Red}
#end
   normal {
      bumps 0.1
      bump_size 0.1
      scale 20
      }
   finish {
      specular 1
      roughness 0.01
      reflection 0.13}
   }

#declare M3_Plaque=object{
   box {0, 1}
   pigment {
      image_map {
         png "regle.png"
         map_type 0 //plan
         interpolate 2
         once
         filter 0, 1
         }
      rotate -90*y
      }
   finish {Dull}
   scale <.5, 12, 1.4> translate <0, 5, -.7>
   translate -1.9*x rotate 14.04*z translate 5*x
   }

#declare M3_Poids=object {
   difference{
      box {<-.7, -1.2, -.3> <.7, 0, .3>}
      box {<-.2, -1.3, .2> <.2, 0.1, .4>}
      }
   texture {M3_TCuivre}
   }

#declare M3_Balancier1=object {
   box {<-.2, -3, -.1><.2, 13, .1>}
   texture {M3_TAcier}
   }

#declare M3_Cle=object {
   union {
      cylinder {-2*x, x, .1}
      sphere {0, 1 scale <.25, .25, .35> translate x}
      torus {1, .1 scale <.5, 1, .8> translate <.5, 0, 0> rotate -70*z translate x}
      }
   texture {T_Chrome_5E}
   }

#declare M3_COMMON=1
#end

/******************************************************************************

        reconstitution

******************************************************************************/

union {
   object{M3_ext}
   object{M3_Plaque rotate -90*y}
#switch (M0_Etat)
   #case (1)
   #declare M3_Alpha=6.2831/3*M0_Freq/60*0.1 //0.3 s d'observation
   #declare M3_R = 16-.0588*M0_Freq+.647
   #declare M3_Beta =0.7/M3_R
   #if (M0_Pos + degrees(M3_Alpha/2) > 50)
      #declare M0_Pos=M0_Pos-degrees(M3_Alpha)
      #end
   #declare M3_Ya=.4/2/ sin(M3_Alpha/2)
   #declare M3_Xb=.4/2/cos(M3_Alpha/2)
   #declare M3_Xc=13*sin(M3_Alpha/2)+0.4/2*cos(M3_Alpha/2)
   #declare M3_Yc=13*cos(M3_Alpha/2)-0.4/2*sin(M3_Alpha/2)
   #declare M3_Xd=13*sin(M3_Alpha/2)-0.4/2*cos(M3_Alpha/2)
   #declare M3_Yd=13*cos(M3_Alpha/2)+0.4/2*sin(M3_Alpha/2)
      union {
         object {
            prism {
               linear_sweep linear_spline -.1, .1, 5,
               <0, M3_Ya>, <M3_Xb, 0>, <0, -M3_Ya>, <-M3_Xb, 0>, <0, M3_Ya>  
               }
            texture {M3_TAcier}
            }
         object {
            prism {
               linear_sweep linear_spline -.1, 0.1, 5,
               <0, M3_Ya>, <-M3_Xd, M3_Yd>, <-M3_Xc, M3_Yc>, <-M3_Xb, 0>, <0, M3_Ya>  
               }
            texture {
               gradient x texture_map{
                  [0 pigment {Clear}]
                  [1 wood texture_map{
                     [0 M3_TAcier]
                     [1 average texture_map{
                        [.4/13/M3_Alpha M3_TAcier]
                        [2-.4/13/M3_Alpha pigment {Clear}]
                        }]
                     }
                  scale 2*(13-M3_Ya)
                  phase -M3_Ya/13
                  rotate 90*x]
                  }
               scale <0.4, 13, 1> translate -0.19*x rotate -degrees(M3_Alpha/2)*y
               }
            }
         object {
            prism {
               linear_sweep linear_spline -.1, .1, 5,
               <0, M3_Ya>, <M3_Xd, M3_Yd>, <M3_Xc, M3_Yc>, <M3_Xb, 0>, <0, M3_Ya>  
               }
            texture {
               gradient x texture_map{
                  [0 pigment {Clear}]
                  [1 wood texture_map{
                     [0 M3_TAcier]
                     [1 average texture_map{
                        [.4/13/M3_Alpha M3_TAcier]
                        [2-.4/13/M3_Alpha pigment {Clear}]
                        }]
                     }
                  scale 2*(13-M3_Ya)
                  phase -M3_Ya/13
                  rotate 90*x]
                  }
               scale <0.4, 13, 1> translate 0.2*x rotate degrees(M3_Alpha/2)*y
               }
            }
         object {
            intersection {
               cylinder {-2*y, y, 13}
               prism {
                  linear_sweep linear_spline -.1, .1, 4,
                  <0, M3_Ya>, <M3_Xd, M3_Yd>*1.5, <-M3_Xd, M3_Yd>*1.5, <0, M3_Ya>  
                  scale <1.01, 1, 1.01>
                  }
               }
            texture {
               wood texture_map{
                  [0 M3_TAcier]
                  [1 average texture_map{
                     [.4/13/M3_Alpha M3_TAcier]
                     [2-.4/13/M3_Alpha pigment {Clear}]
                     }]
                  }
               scale 2*(13-M3_Ya)
               phase -M3_Ya/13
               rotate 90*x
               }
            }
         object {
            intersection {
               difference {
                  cylinder {-2*y, y, M3_R}
                  cylinder {-3*y, 2*y, M3_R-1.2}
                  }
               prism {
                  linear_sweep linear_spline -.2, .2, 4,
                  <0, 0>,
                  <-2*M3_R*sin(M3_Alpha/2+M3_Beta), 2*M3_R*cos(M3_Alpha/2+M3_Beta)>,
                  <2*M3_R*sin(M3_Alpha/2+M3_Beta), 2*M3_R*cos(M3_Alpha/2+M3_Beta)>,
                  <0, 0>  
                  }
               }
            texture {
               radial texture_map {
                  [M3_Alpha/2/6.2831 average texture_map{
                     [1 M3_TCuivre]
                     [2 pigment {Clear}]
                     }]
                  [(M3_Alpha/2+M3_Beta)/6.2831 pigment {Clear}]
                  [1-(M3_Alpha/2+M3_Beta)/6.2831 pigment {Clear}]
                  [1-M3_Alpha/2/6.2831 average texture_map{
                     [1 M3_TCuivre]
                     [2 pigment {Clear}]
                     }]
                  }
                  rotate -90*y
               }
            }
         rotate -90*x rotate M0_Pos*z translate <0, 3, 4>
         }
      #break
   #else
      union {
         object {M3_Balancier1}
         object {M3_Poids translate (.0588*M0_Freq+.647)*y}
         rotate M0_Pos*z translate <0, 3, 4>
         }
      #break
   #end
   object{M3_Cle rotate M0_Cle*x translate <4, 3, 0>}
   translate .5*y
   }
