#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "golds.inc"
#include "metals.inc"
#include "glass.inc"
#include "woods.inc" 

#declare Boovatten = 
        pigment { color rgbf <0.80, 0.98, 1, 0.9> }
#declare Booglans =
        finish { ambient 0.12
                diffuse 0.11
                reflection 0.22
                refraction 1
                ior 1.33
                specular 0.52
                roughness 0.007
                phong 2
                phong_size 200
                }


camera  {
      location<-11,2.4,1> 
        look_at <0,1.2,17> 
                      }


light_source { <-20,5,16> White shadowless }                      
light_source { <0,1,-35> White  shadowless }   
       

light_source { 
        <-2.5,4,9>  White*.7 spotlight 
                point_at <-0.5,-1,10> 
                radius 17
                falloff 22
                }

light_source { 
        <-4,2,8>  White*.7 spotlight 
                point_at <0,5,9> 
                radius 15
                falloff 20
                }



light_source { 
        <-3,3.5,12>  White*.7 spotlight 
                point_at <-3,2,20> 
                radius 9
                falloff 12
                }

light_source { 
        <3,3.5,12>  White*.7 spotlight 
                point_at <3,2,20> 
                radius 9
                falloff 12
                }

light_source { 
        <-9,3.5,12>  White*.7 spotlight 
                point_at <-9,2,20> 
                radius 9
                falloff 12
                }

light_source { 
        <9,3.5,12>  White*.7 spotlight 
                point_at <9,2,20> 
                radius 9
                falloff 12
                }

light_source { 
        <-15,3.5,12>  White*.7 spotlight 
                point_at <-15,2,20> 
                radius 9
                falloff 12
                }

light_source { 
        <15,3.5,12>  White*.7 spotlight 
                point_at <15,2,20> 
                radius 9
                falloff 12
                }

declare a =
        union {
        cylinder {<-21,0,0>, <21,0,0> , 3 translate <0,3,0> }
        cylinder {<-21,0,0>, <21,0,0> , 3 translate <0,3,6> }  
        cylinder {<-21,0,0>, <21,0,0> , 3 translate <0,3,12> }  
        cylinder {<-21,0,0>, <21,0,0> , 3 translate <0,3,18> }  
        cylinder {<-21,0,0>, <21,0,0> , 3 translate <0,3,24> }
        
        cylinder {<-25,0,0>, <25,0,0> , 3 rotate <0,90,0> translate <-9,3,0> }  
        cylinder {<-25,0,0>, <25,0,0> , 3 rotate <0,90,0> translate <-3,3,0> }
        cylinder {<-25,0,0>, <25,0,0> , 3 rotate <0,90,0> translate <3,3,0> }
        cylinder {<-25,0,0>, <25,0,0> , 3 rotate <0,90,0> translate <9,3,0> }
        cylinder {<-25,0,0>, <25,0,0> , 3 rotate <0,90,0> translate <-15,3,0> }
        cylinder {<-25,0,0>, <25,0,0> , 3 rotate <0,90,0> translate <15,3,0> }

             }

difference {
        box { <-18,4.3,0> <18,6.3,27> }
        object {a}
        cylinder {<0,-5,0>, <0,10,0>,2.4 translate <0,0,9> }
        pigment { rgb 1} normal { wrinkles 0.1 scale 0.002}}

difference {
        box { <-18,4.3,0> <18,6.3,27> translate <0,6,0>}
        object {a translate <0,6,0> }
        pigment { rgb 1} normal { wrinkles 0.1 scale 0.002}
        }


#declare pelare =
        cylinder { <0,-1,0>, <0,4.3,0>,0.25 
        texture { pigment { bozo turbulence 4 omega 0.5 octaves 7
                color_map { [0.0 rgb 1] [1.0 rgb <0.7,0.7,0.6>] } scale 1.8}
                finish { reflection 0.15 phong 0.3 phong_size 60 }
                }}

#declare skydd =
        union {
#declare  n = 0            
while ( n < 360 )
        cylinder { <0,-1,0>, <0,0.3,0>, 0.04 pigment { color White }
                translate <0.22,0,0> rotate <0,n,0> }
        #declare n=n+15
#end                    
                }

#declare ex = -18
while ( ex < 22 )       
        object { skydd translate <ex,0,3> }
        object { pelare translate <ex,0,3> }
        object { skydd translate <ex,0,9> }
        object { pelare translate <ex,0,9> }
        object { skydd translate <ex,0,15> }
        object { pelare translate <ex,0,15> }
        object { skydd translate <ex,0,21> }
        object { pelare translate <ex,0,21> }
#declare ex = ex + 6
#end
object { pelare translate <0,4,9> }

        object { pelare translate <6,6,9> } 
        object { pelare translate <6,6,15> }
        object { pelare translate <12,6,9> } 
        object { pelare translate <12,6,15> }


//plane { x, -18 pigment { White }  } 
plane { x, 18 pigment { White } finish { Mirror} }   
plane { z, 21 pigment { rgb 0.75 }}   

#declare s = 0
while ( s < 28 )
cylinder { <0,-10,0>,<0,20,0>,0.02 rotate <45,0,0> translate <18,0,s - 3> 
pigment { color White }}
cylinder { <0,-10,0>,<0,20,0>,0.02  rotate <-45,0,0> translate <18,0,s - 5> 
pigment { color White }}
#declare s = s + 1
#end

box {< -18, -1 , 20.95 > < 18 , -.8 , 21 > pigment { color White }
finish { Glossy}}

box {< 17.95, -0.8 , 0 > < 18 , -1 , 21 > pigment { color White }
finish { Glossy}}

#declare ram =
difference { 
box { <-10.2,0.8,20.94> <-7.8,2.7,21> }
box { <-10,1,20 > <-8,2.5,21>}
        texture { T_Wood8 } }

box { <-10,1,20.98> <-8,2.5,21> pigment { 
        image_map {
        tga "bilder\apelsin.tga" } scale 2 translate <0,2.7,0> }}
object { ram }

box { <-4,1,20.98> <-2,2.5,21> pigment { 
        image_map {
        tga "bilder\dep\lightbox.tga" }scale 2 translate <0,2.7,0> }}
object { ram translate <6,0,0> }  

box { <2,1,20.98> <4,2.5,21>  pigment { 
        image_map {
        tga "bilder\ufo1.tga" }scale 2 translate <0,2.7,0> }}
object { ram translate <12,0,0> }   

box { <8,1,20.98> <10,2.5,21>  pigment { 
        image_map {
        tga "bilder\dep\cube.tga" }scale 2 translate <0,2.7,0> }}
object { ram translate <18,0,0> }   

box { <14,1,20.98> <16,2.5,21> pigment { 
        image_map {
        tga "bilder\dep\bumpcomp.tga" } scale 2 translate <0,2.7,0> }}
object { ram translate <24,0,0> }   
                                             



plane
        {
        y, -1
        texture
                {
                pigment { checker color rgb 0.5 color rgb 0.7 scale 0.44 }
                finish { reflection 0.2 phong 0.2 phong_size 40 }
                }
        rotate <0,45,0> }


 
#declare trappa =
union {
        #declare vi = 0 
        while ( vi < 360*1.5 )
                box { <0,0,-.17> <1.7,.075,.17> pigment { color White }
                rotate <0,vi,0>
                translate <0,vi*.0154,0>  }
                #declare vi = vi + 15
                #end
        }
object { trappa rotate <0,180,0> translate <0,-1,9> }

light_source { <-12,6.4,16> rgb<1,.7,.6>*.8  }

#declare r = 0
while ( r < 360*1.5 )
cylinder {<0,-1.01,0> , <0,0.5,0>, 0.018
        translate <-1.6,0,0> rotate<0,r,0> translate <0,r*.0154,9>
        pigment { color White }
        finish{ Glossy} }                         
#declare r = r + 15
#end

#declare r = 0
while ( r < 360*1.5 )
        torus {0.246,0.018 rotate <0,0,90> translate<-1.6,-.25,0>
        rotate<0,r,0> translate<0,r*0.0154,9> 
        pigment { color White }
        finish{ Glossy} }
#declare r = r + 15
#end


#declare s = 0
while ( s < 360*1.5 )
sphere {<0,0.5,0> ,0.05
        translate <-1.6,0,0> rotate<0,s,0> translate <0,s*.0154,9>
        texture { T_Wood8 } }
#declare s = s + 0.2
#end

#declare fontan =         
union {

difference {
        cylinder {<0,0,0>, <0,0.2,0>, 2 }
        cylinder {<0,0.01,0>, <0,0.21,0>, 1.7 }
        texture { pigment { bozo turbulence 4 omega 0.5 octaves 7
                color_map { [0.0 rgb 1] [1.0 rgb <0.7,0.7,0.6>] } scale 1.8}
                finish { reflection 0.15 phong 0.3 phong_size 60 }
                }}
        

cylinder {<0,0.02,0>, <0,0.16,0>, 1.7 
        texture {Boovatten}
        finish {Booglans}
        normal { waves 0.2 scale 0.4 }
        normal { wrinkles 0.2 scale 0.1 }}



#declare  n=0     
#declare parabel1 =
        union {
#while ( n < 1.2 )
sphere {<0,0,0>,0.0065   
pigment { color rgbf <0.920, 0.94, .95, 0.9> }
                        finish {Booglans}
                    translate <n,-2.777*n*(n - 1.2),0> }
#declare n = n + 0.01
#end
           }

#declare  n=0     
#declare parabel2 =
        union {
#while ( n < 1.2 )
sphere {<0,0,0>,0.0065   
pigment { color rgbf <0.920, 0.94, .95, 0.92> } 
                        finish {Booglans}
                    translate <n,-12.5*n*(n - 0.8),0> }
#declare n = n + 0.005
#end
           }


#declare vi = 0
while ( vi < 360 )
object { parabel1 rotate < 0, vi, 0 > }
object { parabel2 rotate <0, vi - 8, 0> }
#declare vi = vi + 16
#end
       }

object { fontan translate <-9,-1,12> }

light_source { 
        <-9,3,13>  White*.8 spotlight 
                point_at <-9,-1,12> 
                radius 25
                falloff 35
                }

light_source { 
        <-9,2.5,12>  rgb<0.94,0.92,1> spotlight 
                point_at <-9,-.8,12> 
                radius 9
                falloff 13
                }

light_source { 
        <-7,.5,12>  White  spotlight 
                point_at <-9,.5,12> 
                radius 9
                falloff 13
                }




