// Flamenco POV
// designed by "Luis G Galvez"
#include"Variable.inc"



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 1.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <61.124, -71.069, -16.943> // Attached to couple
  direction <0.0,     0.0,  2.2271>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-5.546, 0.285, -5.694>
}

// *******  L I G H T S *******
light_source {   // Spotlight SpotL2
  <25.236, -24.311, 21.549>
  color  rgb <0.871, 0.976, 1.024>
  spotlight
    point_at  <24.705, -23.798, 20.874>
    falloff   24.2  // outer radius (in deg)
      radius    24.2  // inner radius
  atmospheric_attenuation on
}

light_source {   // Spotlight SpotL001
  <25.236, -24.311, 21.549>
  color  rgb <0.871, 0.976, 1.024>
  spotlight
    point_at  <24.705, -23.798, 20.874>
    falloff   24.2  // outer radius (in deg)
      radius    24.2  // inner radius
}

light_source {   // Light003
  <151.934, -205.555, 102.186>
  color rgb <0.686, 0.580, 0.502>
}


// ********  TEXTURES  *******
//

#include "flamenco.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare BzPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.874222, -2.000000, 0.125778>, <-5.440225, -2.000000, 6.540481>, <-3.874222, -2.000000, 0.125778>, <-3.094334, -2.000000, 3.396019>, 
      <-5.874222, -1.000000, 0.125778>, <-5.440225, -1.000000, 6.540481>, <-3.874222, -1.000000, 0.125778>, <-3.094334, -1.000000, 3.396019>, 
      <-5.874222, 0.000000, 0.125778>, <-5.440225, 0.000000, 6.540481>, <-3.874222, 0.000000, 0.125778>, <-3.094334, 0.000000, 3.396019>, 
      <-5.874222, 1.000000, 0.125778>, <-5.440225, 1.000000, 6.540481>, <-3.874222, 1.000000, 0.125778>, <-3.094334, 1.000000, 3.396019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.094334, -2.000000, 3.396019>, <-2.314446, -2.000000, 6.666260>, <-1.000000, -2.000000, 0.000000>, <-0.157223, -2.000000, 3.333130>, 
      <-3.094334, -1.000000, 3.396019>, <-2.314446, -1.000000, 6.666260>, <-1.000000, -1.000000, 0.000000>, <-0.157223, -1.000000, 3.333130>, 
      <-3.094334, 0.000000, 3.396019>, <-2.314446, 0.000000, 6.666260>, <-1.000000, 0.000000, 0.000000>, <-0.157223, 0.000000, 3.333130>, 
      <-3.094334, 1.000000, 3.396019>, <-2.314446, 1.000000, 6.666260>, <-1.000000, 1.000000, 0.000000>, <-0.157223, 1.000000, 3.333130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.157223, -2.000000, 3.333130>, <0.685554, -2.000000, 6.666260>, <2.000000, -2.000000, 0.000000>, <2.842777, -2.000000, 3.333130>, 
      <-0.157223, -1.000000, 3.333130>, <0.685554, -1.000000, 6.666260>, <2.000000, -1.000000, 0.000000>, <2.842777, -1.000000, 3.333130>, 
      <-0.157223, 0.000000, 3.333130>, <0.685554, 0.000000, 6.666260>, <2.000000, 0.000000, 0.000000>, <2.842777, 0.000000, 3.333130>, 
      <-0.157223, 1.000000, 3.333130>, <0.685554, 1.000000, 6.666260>, <2.000000, 1.000000, 0.000000>, <2.842777, 1.000000, 3.333130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.842777, -2.000000, 3.333130>, <3.685554, -2.000000, 6.666260>, <5.000000, -2.000000, 0.000000>, <5.685554, -2.000000, 6.666260>, 
      <2.842777, -1.000000, 3.333130>, <3.685554, -1.000000, 6.666260>, <5.000000, -1.000000, 0.000000>, <5.685554, -1.000000, 6.666260>, 
      <2.842777, 0.000000, 3.333130>, <3.685554, 0.000000, 6.666260>, <5.000000, 0.000000, 0.000000>, <5.685554, 0.000000, 6.666260>, 
      <2.842777, 1.000000, 3.333130>, <3.685554, 1.000000, 6.666260>, <5.000000, 1.000000, 0.000000>, <5.685554, 1.000000, 6.666260>
    }
  }
  texture {
    Texture09
  }
  scale <4.0, 20.0, 2.0>
  rotate <90.0, 0.0, 43.645061>
  translate  <-2.712663, 27.738671, 15.779597>
}
#declare BzPtch2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.874222, -2.000000, 0.125778>, <-5.440225, -2.000000, 6.540481>, <-3.874222, -2.000000, 0.125778>, <-3.094334, -2.000000, 3.396019>, 
      <-5.874222, -1.000000, 0.125778>, <-5.440225, -1.000000, 6.540481>, <-3.874222, -1.000000, 0.125778>, <-3.094334, -1.000000, 3.396019>, 
      <-5.874222, 0.000000, 0.125778>, <-5.440225, 0.000000, 6.540481>, <-3.874222, 0.000000, 0.125778>, <-3.094334, 0.000000, 3.396019>, 
      <-5.874222, 1.000000, 0.125778>, <-5.440225, 1.000000, 6.540481>, <-3.874222, 1.000000, 0.125778>, <-3.094334, 1.000000, 3.396019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.094334, -2.000000, 3.396019>, <-2.314446, -2.000000, 6.666260>, <-1.000000, -2.000000, 0.000000>, <-0.157223, -2.000000, 3.333130>, 
      <-3.094334, -1.000000, 3.396019>, <-2.314446, -1.000000, 6.666260>, <-1.000000, -1.000000, 0.000000>, <-0.157223, -1.000000, 3.333130>, 
      <-3.094334, 0.000000, 3.396019>, <-2.314446, 0.000000, 6.666260>, <-1.000000, 0.000000, 0.000000>, <-0.157223, 0.000000, 3.333130>, 
      <-3.094334, 1.000000, 3.396019>, <-2.314446, 1.000000, 6.666260>, <-1.000000, 1.000000, 0.000000>, <-0.157223, 1.000000, 3.333130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.157223, -2.000000, 3.333130>, <0.685554, -2.000000, 6.666260>, <2.000000, -2.000000, 0.000000>, <2.842777, -2.000000, 3.333130>, 
      <-0.157223, -1.000000, 3.333130>, <0.685554, -1.000000, 6.666260>, <2.000000, -1.000000, 0.000000>, <2.842777, -1.000000, 3.333130>, 
      <-0.157223, 0.000000, 3.333130>, <0.685554, 0.000000, 6.666260>, <2.000000, 0.000000, 0.000000>, <2.842777, 0.000000, 3.333130>, 
      <-0.157223, 1.000000, 3.333130>, <0.685554, 1.000000, 6.666260>, <2.000000, 1.000000, 0.000000>, <2.842777, 1.000000, 3.333130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.842777, -2.000000, 3.333130>, <3.685554, -2.000000, 6.666260>, <5.000000, -2.000000, 0.000000>, <5.685554, -2.000000, 6.666260>, 
      <2.842777, -1.000000, 3.333130>, <3.685554, -1.000000, 6.666260>, <5.000000, -1.000000, 0.000000>, <5.685554, -1.000000, 6.666260>, 
      <2.842777, 0.000000, 3.333130>, <3.685554, 0.000000, 6.666260>, <5.000000, 0.000000, 0.000000>, <5.685554, 0.000000, 6.666260>, 
      <2.842777, 1.000000, 3.333130>, <3.685554, 1.000000, 6.666260>, <5.000000, 1.000000, 0.000000>, <5.685554, 1.000000, 6.666260>
    }
  }
  texture {
    Texture09
  }
  scale <4.0, 20.0, 2.0>
  rotate <90.0, 0.0, 43.645061>
  translate  <-40.491069, 6.154109, 16.256742>
}
union { // curtain
  object { BzPtch001 }
  object { BzPtch2 }
}






#declare shoe2 = union {
  sphere { // Sphere34
    <0,0,0>,1
    texture {
      SKIN1
    }
    scale <0.2, 0.2, 0.4>
    rotate <-76.079613, -17.839745, 10.440318>
    translate  <0.056744, 0.305367, 0.124229>
  }
  sphere { // Sphere35
    <0,0,0>,1
    texture {
      Texture6
    }
    scale <0.35, 1.0, 0.2>
    rotate <76.492592, 15.394364, -165.713654>
    translate  <0.19914, 0.246176, -0.6057>
  }
  cone { // Cone001
    <0,0,0>, 0.2, <0,0,1>, 0.6
    open
    texture {
      Texture6
    }
    scale <0.421053, 0.421053, 0.6>
    rotate <-15.01522, -60.548233, -60.406502>
    translate  <0.159733, -0.417218, -0.18892>
  }
  scale 1.5
  rotate <70.92276, 15.102254, 24.392796>
  translate  <0.131251, 0.0, -7.350061>
}
#declare rodilla2 = union {
  sphere { // Sphere33
    <0,0,0>,1
    scale <0.6, 0.6, 3.2>
    translate  <0.368195, 0.136496, -3.949975>
  }
  object { shoe2 }
  rotate <-60.118965, -34.128593, 24.935741>
  translate  <-1.297355, 0.651517, -7.897436>
}
#declare pierna2 = union {
  sphere { // Sphere31
    <0,0,0>,1
    scale <1.0, 1.0, 4.0>
    translate  <-0.183602, -0.045498, -4.843422>
  }
  object { rodilla2 }
  scale 1.1
  rotate <3.864937, 6.413872, 54.216629>
  translate  <2.153953, 0.089068, -10.92216>
}
#declare head3 = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.45, 2.0>
    rotate <43.262314, 9.178192, -2.169528>
    translate  <-0.400624, 2.333847, 1.235384>
  }
  sphere { // head2
    <0,0,0>,1
    texture {
      SKIN
      rotate <-3.463167, 13.030891, -77.621086>
    }
    scale <1.4, 1.68, 2.1>
    rotate <39.979759, -3.334734, -7.437582>
    translate  <0.0, -0.242209, 3.633136>
  }
  sphere { // head4
    <0,0,0>,1
    texture {
      Texture5
    }
    scale <1.4, 1.4, 2.4>
    rotate <65.370293, 8.217477, 6.442473>
    translate  <0.278217, 0.019903, 4.07472>
  }
  torus { // Torus002
    1.1, 0.9  rotate -x*90
    texture {
      Texture5
    }
    scale 0.66482
    rotate <24.484533, -3.305712, -175.940018>
    translate  <-0.11857, 0.377678, 5.951055>
  }
  torus { // Torus001
    1.115, 0.115  rotate -x*90
    texture {
      Texture08
    }
    scale 0.443213
    rotate <-86.657188, -39.474018, 102.620773>
    translate  <1.316259, 0.314342, 2.30572>
  }
  sphere { // Sphere011
    <0,0,0>,1
    texture {
      SKIN
    }
    scale 0.221607
    rotate <-26.308699, -31.991884, 131.335175>
    translate  <0.180531, -1.146861, 2.138426>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    texture {
      Texture06
    }
    scale <1.052632, 1.052632, 0.526316>
    rotate <125.986214, 20.254642, 23.669807>
    translate  <0.284473, -0.378217, 5.273356>
  }
  scale 0.95
  rotate <-42.126884, -3.660993, -72.061371>
  translate  <-1.97415, -1.072081, 7.391786>
}
#declare arm3 = union {
  sphere { // Sphere28
    <0,0,0>,1
    scale 0.6
    translate  <0.005154, 0.077216, 0.01342>
  }
  cone { // Cone002
    <0,0,0>, 0.3, <0,0,1>, 1.0
    scale <0.554017, 0.554017, 3.047091>
    rotate <-0.79079, 49.441811, 179.172409>
    translate  <2.302219, 0.053406, -1.959831>
  }
  sphere { // Sphere27
    <0,0,0>,1
    texture {
      SKIN
    }
    scale <0.166667, 0.333333, 1.333333>
    rotate <92.926514, -82.557831, 8.519144>
    translate  <2.577334, -1.089377, -1.947444>
  }
  rotate <113.351639, -9.510644, 39.166916>
  translate  <0.0246, -0.115451, -5.297338>
}
#declare uprarm3 = union {
  sphere { // Sphere26
    <0,0,0>,1
    scale 0.6
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 5.0>
    translate  <0.072674, -0.081882, -5.202461>
  }
  object { arm3 }
  scale 1.4
  rotate <95.30265, -5.706514, -0.034734>
  translate  <-1.749199, 0.597165, -0.215982>
}
#declare arm4 = union {
  sphere { // Sphere42
    <0,0,0>,1
    scale <0.4, 0.2, 1.2>
    rotate <-117.347893, 45.59317, -176.932205>
    translate  <-0.021424, -0.383141, -4.361199>
  }
  sphere { // Sphere46
    <0,0,0>,1
    scale 0.6
    translate  <-0.003618, -0.021733, 0.174432>
  }
  cone { // Cone003
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    texture {
      SKIN1
    }
    scale <0.609418, 0.609418, 4.432133>
    rotate <3.027212, 8.74472, -29.211542>
    translate  <-0.517774, 0.572893, -4.185626>
  }
  rotate <121.421883, -14.208352, -143.027466>
  translate  <0.0246, -0.115451, -5.297338>
}
#declare uprarm4 = union {
  sphere { // Sphere36
    <0,0,0>,1
    scale 0.6
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 5.0>
    translate  <-0.097438, 0.0, -5.087996>
  }
  object { arm4 }
  scale 1.4
  rotate <-93.736778, -3.087068, 177.650742>
  translate  <1.980526, 0.74974, 0.649653>
}
#declare TapSwp2 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  16  // control points
  <-1.27615, -0.151101>,
  <-0.74047, -0.504117>,
  <-1.14068, -1.119838>,
  <-0.498315, -0.839964>,
  <0.093787, -1.328253>,
  <0.557751, -0.834958>,
  <1.208415, -1.151101>,
  <0.744692, -0.239677>,
  <1.187573, 0.838479>,
  <0.218835, 0.640485>,
  <-0.530536, 0.964868>,
  <-0.968738, 1.057314>,
  <-0.697711, 0.418897>,
  <-1.27615, -0.151101>,
  <-0.74047, -0.504117>,
  <-1.14068, -1.119838>
  rotate <90,0,90>
  texture {
    Texture6
  }
  scale 2.105263
  rotate <97.899895, 20.77202, -136.549988>
  translate  <-1.233162, -1.03693, -0.058745>
}
#declare TapSwp001 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  16  // control points
  <-1.27615, -0.151101>,
  <-0.74047, -0.504117>,
  <-1.14068, -1.119838>,
  <-0.498315, -0.839964>,
  <0.093787, -1.328253>,
  <0.557751, -0.834958>,
  <1.208415, -1.151101>,
  <0.744692, -0.239677>,
  <1.187573, 0.838479>,
  <0.218835, 0.640485>,
  <-0.530536, 0.964868>,
  <-0.968738, 1.057314>,
  <-0.697711, 0.418897>,
  <-1.27615, -0.151101>,
  <-0.74047, -0.504117>,
  <-1.14068, -1.119838>
  rotate <90,0,90>
  texture {
    Texture6
  }
  scale <2.105263, 2.105263, 0.8>
  rotate <5.067658, -77.129997, -159.722778>
  translate  <1.76564, -0.342761, 1.191549>
}
#declare armsrot1 = union {
  sphere { // Sphere29
    <0,0,0>,1
    texture {
      Texture6
    }
    scale <3.0, 1.2, 0.8>
    rotate <-2.863171, -18.52067, 2.752944>
    translate  <-0.009187, -0.012273, 0.154777>
  }
  object { uprarm3 }
  object { uprarm4 }
  object { TapSwp2 }
  object { TapSwp001 }
  rotate <-1.224535, 5.322139, 41.560658>
  translate  <0.180996, -0.068528, 5.955316>
}
#declare BzPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.101318, 1.755033, -2.075009>, <0.635589, -4.802143, -0.448447>, <4.869641, -8.991547, -4.107360>, <9.077244, -9.046633, -4.107360>, 
      <2.863866, -0.264453, -2.746962>, <2.837591, -2.857499, -2.746962>, <5.651782, -5.016206, -2.746962>, <9.117623, -5.061581, -2.746962>, 
      <3.581613, -0.022251, -1.386564>, <3.581613, -3.314152, -1.386564>, <6.094333, -6.007526, -1.386564>, <9.165434, -6.007526, -1.386564>, 
      <3.690210, -0.060775, -0.026166>, <3.690210, -2.873306, -0.026166>, <6.154061, -5.174467, -0.026166>, <9.165434, -5.174467, -0.026166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.077244, -9.046633, -4.107360>, <13.284847, -9.101719, -4.107360>, <13.730131, -3.091695, -1.740054>, <12.972619, 2.512655, -0.249809>, 
      <9.117623, -5.061581, -2.746962>, <12.583464, -5.106955, -2.746962>, <12.310641, -3.022497, 4.446188>, <12.336915, -0.429452, 4.446188>, 
      <9.165434, -6.007526, -1.386564>, <12.236536, -6.007526, -1.386564>, <12.110591, -3.314152, 4.702661>, <12.110591, -0.022251, 4.702661>, 
      <9.165434, -5.174467, -0.026166>, <12.176808, -5.174467, -0.026166>, <12.001995, -2.873306, 6.063059>, <12.001995, -0.060775, 6.063059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <12.972619, 2.512655, -0.249809>, <12.215107, 8.117004, 1.240436>, <13.429532, 8.133836, -2.820972>, <9.221929, 8.187518, -2.815905>, 
      <12.336915, -0.429452, 4.446188>, <12.363190, 2.163593, 4.446188>, <12.669281, 3.362376, -2.692302>, <9.203440, 4.760095, -2.572585>, 
      <12.110591, -0.022251, 4.702661>, <12.110591, 3.269650, 4.702661>, <12.236536, 6.671739, -1.008365>, <9.165434, 6.671739, -1.008365>, 
      <12.001995, -0.060775, 6.063059>, <12.001995, 2.751756, 6.063059>, <12.176808, 5.185031, 0.267842>, <9.165434, 5.185031, 0.267842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.221929, 8.187518, -2.815905>, <5.014326, 8.241199, -2.810837>, <1.567047, 8.312210, -3.701571>, <1.101318, 1.755033, -2.075009>, 
      <9.203440, 4.760095, -2.572585>, <5.737599, 6.157813, -2.452867>, <2.890140, 2.328592, -2.746962>, <2.863866, -0.264453, -2.746962>, 
      <9.165434, 6.671739, -1.008365>, <6.094333, 6.671739, -1.008365>, <3.581613, 3.269650, -1.386564>, <3.581613, -0.022251, -1.386564>, 
      <9.165434, 5.185031, 0.267842>, <6.154061, 5.185031, 0.267842>, <3.690210, 2.751756, -0.026166>, <3.690210, -0.060775, -0.026166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.690210, -0.060775, -0.026166>, <3.690210, -2.873306, -0.026166>, <6.154061, -5.174467, -0.026166>, <9.165434, -5.174467, -0.026166>, 
      <3.798806, -0.099299, 1.334232>, <3.798806, -2.432459, 1.334232>, <6.213789, -4.341408, 1.334232>, <9.165434, -4.341408, 1.334232>, 
      <6.320371, 0.051718, 7.304117>, <6.320371, -1.011546, 7.304117>, <7.642061, -2.570841, 7.369769>, <9.257460, -2.570841, 7.369769>, 
      <6.754404, 0.051718, 8.664515>, <6.754404, -0.751022, 8.664515>, <7.880779, -1.752485, 8.697341>, <9.257460, -1.752485, 8.697341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.165434, -5.174467, -0.026166>, <12.176808, -5.174467, -0.026166>, <12.001995, -2.873306, 6.063059>, <12.001995, -0.060775, 6.063059>, 
      <9.165434, -4.341408, 1.334232>, <12.117080, -4.341408, 1.334232>, <11.893398, -2.432459, 7.423457>, <11.893398, -0.099299, 7.423457>, 
      <9.257460, -2.570841, 7.369769>, <10.872859, -2.570841, 7.369769>, <12.194550, -1.011546, 7.304117>, <12.194550, 0.051718, 7.304117>, 
      <9.257460, -1.752485, 8.697341>, <10.634141, -1.752485, 8.697341>, <11.760517, -0.751022, 8.664515>, <11.760517, 0.051718, 8.664515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <12.001995, -0.060775, 6.063059>, <12.001995, 2.751756, 6.063059>, <12.176808, 5.185031, 0.267842>, <9.165434, 5.185031, 0.267842>, 
      <11.893398, -0.099299, 7.423457>, <11.893398, 2.233862, 7.423457>, <12.117080, 3.698324, 1.544049>, <9.165434, 3.698324, 1.544049>, 
      <12.194550, 0.051718, 7.304117>, <12.194550, 1.114981, 7.304117>, <10.872859, 1.591313, 7.358776>, <9.257460, 1.591313, 7.358776>, 
      <11.760517, 0.051718, 8.664515>, <11.760517, 0.854457, 8.664515>, <10.634141, 1.314438, 8.691845>, <9.257460, 1.314438, 8.691845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.165434, 5.185031, 0.267842>, <6.154061, 5.185031, 0.267842>, <3.690210, 2.751756, -0.026166>, <3.690210, -0.060775, -0.026166>, 
      <9.165434, 3.698324, 1.544049>, <6.213789, 3.698324, 1.544049>, <3.798806, 2.233862, 1.334232>, <3.798806, -0.099299, 1.334232>, 
      <9.257460, 1.591313, 7.358776>, <7.642061, 1.591313, 7.358776>, <6.320371, 1.114981, 7.304117>, <6.320371, 0.051718, 7.304117>, 
      <9.257460, 1.314438, 8.691845>, <7.880779, 1.314438, 8.691845>, <6.754404, 0.854457, 8.664515>, <6.754404, 0.051718, 8.664515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.754404, 0.051718, 8.664515>, <6.754404, -0.751022, 8.664515>, <7.880779, -1.752485, 8.697341>, <9.257460, -1.752485, 8.697341>, 
      <7.188436, 0.051718, 10.024913>, <7.188436, -0.490498, 10.024913>, <8.119497, -0.934128, 10.024913>, <9.257460, -0.934128, 10.024913>, 
      <8.589431, 0.256423, 11.012077>, <8.589431, 0.008253, 11.012077>, <8.850591, -0.194796, 11.012077>, <9.169786, -0.194796, 11.012077>, 
      <8.028165, 0.204831, 12.521149>, <8.028165, -0.275005, 12.521149>, <8.540309, -0.667598, 12.521149>, <9.166263, -0.667598, 12.521149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.257460, -1.752485, 8.697341>, <10.634141, -1.752485, 8.697341>, <11.760517, -0.751022, 8.664515>, <11.760517, 0.051718, 8.664515>, 
      <9.257460, -0.934128, 10.024913>, <10.395423, -0.934128, 10.024913>, <11.326484, -0.490498, 10.024913>, <11.326484, 0.051718, 10.024913>, 
      <9.169786, -0.194796, 11.012077>, <9.488982, -0.194796, 11.012077>, <9.750142, 0.008253, 11.012077>, <9.750142, 0.256423, 11.012077>, 
      <9.166263, -0.667598, 12.521149>, <9.792217, -0.667598, 12.521149>, <10.304362, -0.275005, 12.521149>, <10.304362, 0.204831, 12.521149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.760517, 0.051718, 8.664515>, <11.760517, 0.854457, 8.664515>, <10.634141, 1.314438, 8.691845>, <9.257460, 1.314438, 8.691845>, 
      <11.326484, 0.051718, 10.024913>, <11.326484, 0.593933, 10.024913>, <10.395423, 1.037564, 10.024913>, <9.257460, 1.037564, 10.024913>, 
      <9.750142, 0.256423, 11.012077>, <9.750142, 0.504594, 11.012077>, <9.769980, 0.156716, 11.155526>, <9.265699, 0.156716, 11.155526>, 
      <10.304362, 0.204831, 12.521149>, <10.304362, 0.684667, 12.521149>, <9.962426, 1.143219, 14.518601>, <9.252934, 1.143219, 14.518601>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.257460, 1.314438, 8.691845>, <7.880779, 1.314438, 8.691845>, <6.754404, 0.854457, 8.664515>, <6.754404, 0.051718, 8.664515>, 
      <9.257460, 1.037564, 10.024913>, <8.119497, 1.037564, 10.024913>, <7.188436, 0.593933, 10.024913>, <7.188436, 0.051718, 10.024913>, 
      <9.265699, 0.156716, 11.155526>, <8.761418, 0.156716, 11.155526>, <8.589431, 0.504594, 11.012077>, <8.589431, 0.256423, 11.012077>, 
      <9.252934, 1.143219, 14.518601>, <8.543082, 1.143219, 14.518601>, <8.028165, 0.684667, 12.521149>, <8.028165, 0.204831, 12.521149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <8.028165, 0.204831, 12.521149>, <8.028165, -0.275005, 12.521149>, <8.540309, -0.667598, 12.521149>, <9.166263, -0.667598, 12.521149>, 
      <7.466899, 0.153238, 14.030221>, <7.466899, -0.558263, 14.030221>, <8.230027, -1.140400, 14.030221>, <9.162740, -1.140400, 14.030221>, 
      <7.199858, 0.262616, 17.770225>, <7.199858, -0.431865, 17.770225>, <8.117206, -1.000077, 17.770225>, <9.238408, -1.000077, 17.770225>, 
      <7.543899, 0.295716, 17.713363>, <7.543899, -0.192671, 17.713363>, <8.282628, -0.592261, 17.713363>, <9.185519, -0.592261, 17.713363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.166263, -0.667598, 12.521149>, <9.792217, -0.667598, 12.521149>, <10.304362, -0.275005, 12.521149>, <10.304362, 0.204831, 12.521149>, 
      <9.162740, -1.140400, 14.030221>, <10.095453, -1.140400, 14.030221>, <10.858581, -0.558263, 14.030221>, <10.858581, 0.153238, 14.030221>, 
      <9.238408, -1.000077, 17.770225>, <10.359610, -1.000077, 17.770225>, <11.276958, -0.431865, 17.770225>, <11.276958, 0.262616, 17.770225>, 
      <9.185519, -0.592261, 17.713363>, <10.088410, -0.592261, 17.713363>, <10.827140, -0.192671, 17.713363>, <10.827140, 0.295716, 17.713363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.304362, 0.204831, 12.521149>, <10.304362, 0.684667, 12.521149>, <9.962426, 1.143219, 14.518601>, <9.252934, 1.143219, 14.518601>, 
      <10.858581, 0.153238, 14.030221>, <10.858581, 0.864739, 14.030221>, <10.154872, 2.129723, 17.881676>, <9.239809, 2.129723, 17.881676>, 
      <11.276958, 0.262616, 17.770225>, <11.276958, 0.957097, 17.770225>, <10.234911, 0.635453, 15.872565>, <9.226172, 0.635453, 15.872565>, 
      <10.827140, 0.295716, 17.713363>, <10.827140, 0.784103, 17.713363>, <10.088410, 1.183692, 17.713363>, <9.185519, 1.183692, 17.713363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.252934, 1.143219, 14.518601>, <8.543082, 1.143219, 14.518601>, <8.028165, 0.684667, 12.521149>, <8.028165, 0.204831, 12.521149>, 
      <9.239809, 2.129723, 17.881676>, <8.324747, 2.129723, 17.881676>, <7.466899, 0.864739, 14.030221>, <7.466899, 0.153238, 14.030221>, 
      <9.226172, 0.635453, 15.872565>, <8.217433, 0.635453, 15.872565>, <7.199858, 0.957097, 17.770225>, <7.199858, 0.262616, 17.770225>, 
      <9.185519, 1.183692, 17.713363>, <8.282628, 1.183692, 17.713363>, <7.543899, 0.784103, 17.713363>, <7.543899, 0.295716, 17.713363>
    }
  }
  texture {
    Texture6
  }
  scale <0.95, 0.8, 0.8>
  rotate <13.113197, 12.704459, -136.749283>
  translate  <10.540272, 5.56863, -4.535257>
}
#declare Group002 = union {
  object { head3 }
  object { armsrot1 }
  object { BzPtch002 }
  rotate <3.355022, 20.180201, 24.983728>
  translate  <-0.428014, 0.172771, -9.200867>
}
#declare shoe3 = union {
  sphere { // Sphere40
    <0,0,0>,1
    texture {
      SKIN1
    }
    scale 0.2
    translate  <-0.226651, 0.182609, 0.119509>
  }
  sphere { // Sphere41
    <0,0,0>,1
    texture {
      Texture6
    }
    scale <0.2, 0.9, 0.35>
    rotate <-8.928286, 20.0, -76.140862>
    translate  <-0.750948, -0.056391, 0.131964>
  }
  cone { // Cone2
    <0,0,0>, 0.2, <0,0,1>, 0.6
    open
    texture {
      Texture6
    }
    scale <0.4, 0.4, 0.6>
    rotate <-74.990562, 41.075096, 6.836899>
    translate  <-0.232668, -0.428832, -0.074627>
  }
  scale 1.5
  rotate <69.637871, -2.793635, -39.760941>
  translate  <0.131251, 0.0, -7.350061>
}
#declare rodilla3 = union {
  sphere { // Sphere39
    <0,0,0>,1
    scale <0.6, 0.6, 3.2>
    translate  <-0.1663, 0.178771, -4.131734>
  }
  object { shoe3 }
  rotate <3.417177, -19.824232, 4.010852>
  translate  <-0.664587, 0.415552, -6.311647>
}
#declare pierna3 = union {
  sphere { // Sphere37
    <0,0,0>,1
    scale <1.0, 1.0, 4.0>
    translate  <-0.177847, 0.840837, -4.663767>
  }
  object { rodilla3 }
  scale 1.1
  rotate <-0.074176, 13.747857, -0.682783>
  translate  <2.327998, 0.595929, -10.911299>
}
#declare woman = union {
  object { pierna2 }
  object { Group002 }
  object { pierna3 }
  texture {
    SKIN1
  }
  rotate <-0.809269, -4.514344, 136.170715>
  translate  <-6.962423, 4.307418, 1.873829>
}
#declare shoe1 = union {
  sphere { // Sphere15
    <0,0,0>,1
    texture {
      Texture7
    }
    scale <0.35, 0.35, 0.4>
    translate  <-0.003848, -0.070532, 0.071651>
  }
  sphere { // Sphere16
    <0,0,0>,1
    texture {
      Texture7
    }
    scale <0.5, 1.2, 0.3>
    rotate <6.716228, -1.553026, 0.903742>
    translate  <0.131734, -0.961717, -0.243051>
  }
  scale 1.5
  rotate <-10.682463, 0.0, 0.0>
  translate  <0.131251, 0.0, -7.350061>
}
#declare rodilla1 = union {
  sphere { // Sphere13
    <0,0,0>,1
    texture {
      Texture4
    }
    scale 0.8
    translate  <0.067676, -0.089225, -0.736427>
  }
  sphere { // Sphere14
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <0.8, 0.8, 3.5>
    rotate <3.455082, 0.435652, -0.085781>
    translate  <0.191783, -0.287573, -3.765228>
  }
  object { shoe1 }
  rotate <125.412186, 0.0, 0.0>
  translate  <-0.46487, -0.360229, -7.761549>
}
#declare pierna1 = union {
  sphere { // Sphere11
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <1.3, 1.3, 2.0>
    translate  <-0.437612, 0.0, 0.0>
  }
  sphere { // Sphere12
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <1.0, 1.0, 4.0>
    translate  <-0.195927, 0.0, -4.183486>
  }
  object { rodilla1 }
  rotate <-109.750069, 2.398705, 28.354029>
  translate  <1.416518, -0.012069, -10.14537>
}
#declare shoe = union {
  sphere { // Sphere010
    <0,0,0>,1
    texture {
      Texture7
    }
    scale <0.5, 1.2, 0.3>
    rotate <0.558674, 0.0, 0.0>
    translate  <0.0, -1.586895, -0.213895>
  }
  scale 1.5
  rotate <-10.477961, 0.0, 0.0>
  translate  <0.131251, 0.0, -7.350061>
}
#declare rodilla = union {
  sphere { // Sphere008
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <0.6, 0.6, 1.0>
    rotate <-4.959991, -1.713683, 0.366154>
    translate  <0.204999, -0.274681, -0.909469>
  }
  sphere { // Sphere10
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <0.8, 0.6, 4.0>
    rotate <-3.609779, 0.0, 0.0>
    translate  <0.066575, -0.573868, -3.838569>
  }
  object { shoe }
  rotate <23.684462, 0.0, 0.0>
  translate  <-0.525004, 0.0, -6.825056>
}
#declare pierna = union {
  sphere { // Sphere9
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <1.3, 1.3, 2.0>
    translate  <0.291741, -0.010117, 0.07223>
  }
  sphere { // Sphere007
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <1.0, 1.0, 4.0>
    translate  <-0.195927, 0.0, -4.183486>
  }
  object { rodilla }
  rotate -12.719515*x
  translate  <-1.343583, 0.0, -10.0>
}
#declare hat = union {
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0, 0.5
    texture {
      Texture07
    }
    scale 2.410265
    rotate 48.910706*x
    translate  <0.0, -6.846463, 0.106976>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    texture {
      Texture07
    }
    scale <1.4, 1.4, 1.0>
    rotate 50.945602*x
    translate  <0.0, -6.855909, 0.067656>
  }
  texture {
    Texture05
  }
  scale 1.2
  rotate <-52.656498, 5.498226, -7.515075>
  translate  <0.090316, 4.770177, -1.969785>
}
#declare head = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    texture {
      SKIN
    }
    scale <0.8, 0.6, 2.0>
    translate  <-0.051556, 0.484418, 0.77334>
  }
  sphere { // head1
    <0,0,0>,1
    scale <1.4, 1.68, 2.1>
    translate  <0.0, -0.242209, 3.633136>
  }
  object { hat }
  sphere { // Sphere012
    <0,0,0>,1
    texture {
      SKIN
    }
    scale <0.3, 0.5, 0.2>
    rotate <-107.357094, -14.577815, 46.441654>
    translate  <-0.507155, -1.68663, 2.961111>
  }
  sphere { // head6
    <0,0,0>,1
    texture {
      Texture5
    }
    scale <1.6, 1.44, 1.8>
    rotate <28.389669, 3.815237, 5.425698>
    translate  <-0.025103, 0.161418, 3.784939>
  }
  texture {
    SKIN
  }
  rotate <66.044914, 15.165174, -1.420914>
  translate  <-0.766889, -1.66116, -1.90627>
}
#declare chest = union {
  sphere { // Sphere005
    <0,0,0>,1
    texture {
      Texture4
    }
    translate  <-1.092717, 0.0, -6.087996>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <3.0, 2.0, 4.0>
    translate  -3.0*z
  }
  sphere { // Sphere006
    <0,0,0>,1
    texture {
      Texture4
    }
    scale <2.124777, 1.460726, 1.48537>
    translate  <-0.103112, 0.0, -8.556432>
  }
  sphere { // Sphere8
    <0,0,0>,1
    texture {
      Texture4
    }
    translate  <-1.092717, 0.0, -7.314656>
  }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      Texture4
    }
    translate  <0.855727, 0.0, -7.366212>
  }
  sphere { // Sphere6
    <0,0,0>,1
    translate  <0.907283, 0.0, -6.087996>
  }
  texture {
    Texture06
  }
  rotate 25.367897*x
  translate  <0.0, -2.629035, -1.928607>
}
#declare arm1 = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 4.7>
    rotate <5.303146, 0.458778, -0.150764>
    translate  <-0.141719, 0.234961, -5.379454>
  }
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      SKIN
    }
    scale <0.6, 0.3, 1.0>
    rotate <-24.648573, 28.9951, -10.937456>
    translate  <-0.573817, 0.106284, -6.120188>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.8
    translate  <-0.052362, -0.377229, -0.5394>
  }
  rotate <-123.974945, 13.415415, 142.853317>
  translate  <-0.182049, -0.146938, -5.496441>
}
#declare uprarm1 = union {
  sphere { // Sphere3
    <0,0,0>,1
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 4.5>
    translate  <-0.086763, 0.140807, -4.922478>
  }
  object { arm1 }
  rotate <34.789299, -27.161867, -133.384445>
  translate  4.0*x
}
#declare arm = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 5.5>
    rotate <0.914731, -0.48782, 0.018267>
    translate  <0.086749, -0.013542, -5.630049>
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      SKIN
    }
    scale <0.6, 0.6, 1.0>
    translate  <0.090344, -0.022329, -5.883406>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 0.7
    translate  <0.008164, 0.01131, -0.14846>
  }
  rotate <125.018707, 22.000326, -75.613922>
  translate  <-0.097438, 0.0, -5.931894>
}
#declare uprarm = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.7
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 6.0>
    rotate <-0.705717, 0.012842, -0.050616>
    translate  <0.018644, -0.092915, -5.905006>
  }
  object { arm }
  rotate <-89.755692, 41.693897, -54.02829>
  translate  <-3.826962, 0.074286, 0.134866>
}
#declare armsrot = union {
  object { uprarm1 }
  object { uprarm }
  sphere { // Sphere004
    <0,0,0>,1
    scale <4.8, 1.5, 1.0>
    rotate <-0.017562, -1.521317, 1.323985>
    translate  <0.055309, 0.138748, 0.239219>
  }
  texture {
    Texture06
  }
  rotate 25.367897*x
  translate  <0.0, -2.629035, -1.928607>
}
#declare man = union {
  object { pierna1 }
  object { pierna }
  object { head }
  object { chest }
  object { armsrot }
  texture {
    SKIN
  }
  rotate 4.746073*x
}
#declare pegs = union {
  sphere { // Sphere17
    <0,0,0>,1
    scale <0.2, 0.08, 0.15>
    rotate -45.0*z
    translate  <0.893432, 0.919442, -0.272419>
  }
  sphere { // Sphere20
    <0,0,0>,1
    scale <0.2, 0.08, 0.15>
    rotate -60.0*z
    translate  <0.89416, 0.206134, -0.271792>
  }
  sphere { // Sphere21
    <0,0,0>,1
    scale <0.2, 0.08, 0.15>
    translate  <0.889688, -0.527671, -0.271792>
  }
  sphere { // Sphere22
    <0,0,0>,1
    scale <0.2, 0.08, 0.15>
    rotate 30.0*z
    translate  <-0.876183, -0.521218, -0.284315>
  }
  sphere { // Sphere23
    <0,0,0>,1
    scale <0.2, 0.08, 0.15>
    rotate 15.0*z
    translate  <-0.887751, 0.92111, -0.279913>
  }
  sphere { // Sphere24
    <0,0,0>,1
    scale <0.2, 0.08, 0.15>
    rotate -90.0*z
    translate  <-0.90097, 0.194896, -0.279913>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.06, 0.06, 0.6>
    rotate <0.0, 0.0, -90.0>
    translate  <-0.901883, 0.898752, -0.238734>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.06, 0.06, 0.6>
    rotate <0.0, 0.0, -90.0>
    translate  <-0.923699, 0.191872, -0.238734>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.06, 0.06, 0.6>
    rotate <0.0, 0.0, -90.0>
    translate  <-0.914331, -0.504612, -0.238734>
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.06, 0.06, 0.6>
    rotate <0.0, 0.0, -90.0>
    translate  <0.880284, 0.894217, -0.238734>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.06, 0.06, 0.6>
    rotate <0.0, 0.0, -90.0>
    translate  <0.90225, 0.203602, -0.238734>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.06, 0.06, 0.6>
    rotate <0.0, 0.0, -90.0>
    translate  <0.901523, -0.507508, -0.226211>
  }
  texture {
    Polished_Chro2
  }
  scale <1.0, 1.0, 0.8>
  translate  0.15*z
}
#declare tensors = union {
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.08, 0.08, 2.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.008343, -0.657178, 0.259861>
  }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.08, 0.08, 2.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.008343, 0.042822, 0.259861>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Chro2
    }
    scale <0.08, 0.08, 2.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.008343, 0.742822, 0.259861>
  }
  texture {
    Polished_Chro2
  }
}
#declare TraSwp001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  16  // control points
  <-0.65692, 1.059007>,
  <-1.0, 0.770744>,
  <-1.0, -1.0>,
  <-0.674547, -1.289175>,
  <-0.526247, -1.505406>,
  <0.45904, -1.501498>,
  <0.653234, -1.301355>,
  <1.0, -1.0>,
  <0.984369, 0.770744>,
  <0.643634, 1.071773>,
  <0.503908, 1.310017>,
  <0.002605, 1.380357>,
  <-0.503908, 1.304807>,
  <-0.65692, 1.059007>,
  <-1.0, 0.770744>,
  <-1.0, -1.0>
  rotate -x*90
  scale <0.80249, 1.041581, 0.5>
  translate  <-0.010395, 0.124743, 0.0>
}
#declare CSG001 = difference {
  object { TraSwp001 }
  superellipsoid { // SuprQ001
    <0.3, 0.1>
    scale <0.2, 1.0, 1.0>
    translate  <-0.293379, 0.042737, -0.074531>
  }
  superellipsoid { // SuprQ2
    <0.3, 0.1>
    scale <0.2, 1.0, 1.0>
    translate  <0.392879, 0.04646, -0.133101>
  }
  texture {
    Texture03
    rotate <-53.52018, -1.312219, -86.218948>
  }
  scale <1.0, 1.0, 0.7>
  translate  0.1*z
}
#declare head5 = union {
  object { pegs }
  object { tensors }
  object { CSG001 }
  scale <9.0, 8.0, 8.0>
  rotate <-13.010159, -0.702091, -90.771233>
  translate  <67.84158, -0.500235, -1.955719>
}
#declare HgtFld7 = object { 
  height_field {
    tga "C:\POVRAY3\GITARRA1.TGA"
    water_level 0.18
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Texture04
    scale 2.0
  translate <-0.998739, -1.006911, 0.000000>
  }
  scale <30.0, 40.0, 1.0>
  rotate -90.0*z
  translate  10.0*z
}
#declare HgtFld8 = object { 
  height_field {
    tga "C:\POVRAY3\GITARRA3.TGA"
    water_level 0.0379
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Texture03
    scale 2.0
  translate <-1.003350, -1.007931, 0.000000>
  }
  scale <30.0, 40.0, 10.0>
  rotate -90.0*z
}
#declare CSG2 = difference {
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1 
    texture {
      Texture03
    }
    scale <4.0, 3.5, 50.0>
    translate  <-0.207502, 1.014422, -1.462094>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture01
    }
    scale <10.0, 10.0, 60.0>
    rotate -0.1*z
    translate  <0.041159, 10.813563, -0.086507>
  }
  scale <1.1, 2.0, 1.6>
  rotate <90.0, -0.406048, -90.006409>
  translate  <96.025482, 1.451913, 11.647172>
}
#declare body = union {
  object { HgtFld7 }
  object { HgtFld8 }
  object { CSG2 }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1 
    texture {
      Texture01
    }
    scale <2.0, 2.5, 15.0>
    rotate <-90.020996, 0.010801, -1.72123>
    translate  <-19.269765, -5.647539, 11.674301>
  }
  scale <1.0, 1.0, 0.56>
  rotate -0.664911*z
  translate  <-39.98083, -0.752394, -4.37797>
}
#declare strings = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    texture {
      Copper_Metal1
    }
    scale <0.06, 0.06, 115.0>
    rotate <89.993477, 90.0, 102.01992>
    translate  <-6.766499, -4.94677, 3.70726>
  }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1 
    texture {
      Copper_Metal1
    }
    scale <0.08, 0.08, 115.0>
    rotate <89.993477, 90.0, 102.01992>
    translate  <-7.016535, -3.773108, 3.70726>
  }
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1 
    texture {
      Copper_Metal1
    }
    scale <0.1, 0.1, 115.0>
    rotate <89.993477, 90.0, 102.01992>
    translate  <-7.26657, -2.599447, 3.70726>
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1 
    texture {
      Copper_Metal1
    }
    scale <0.12, 0.12, 115.0>
    rotate <89.993477, 90.0, 102.01992>
    translate  <-7.516605, -1.425785, 3.70726>
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1 
    texture {
      Copper_Metal1
    }
    scale <0.13, 0.13, 115.0>
    rotate <89.993477, 90.0, 102.01992>
    translate  <-7.766641, -0.252123, 3.70726>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1 
    texture {
      Copper_Metal1
    }
    scale <0.14, 0.14, 115.0>
    rotate <89.993477, 90.0, 102.01992>
    translate  <-8.016676, 0.921539, 3.70726>
  }
  rotate -12.691339*z
  translate  <-51.057848, 1.617833, 0.0>
}
#declare traste = union {
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <33.319596, 10.928893, 3.271395>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <38.544998, 12.022659, 3.271395>
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <43.7704, 13.116425, 3.271395>
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <48.995802, 14.210192, 3.271395>
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <54.221204, 15.303958, 3.271395>
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <59.446605, 16.397725, 3.271395>
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <64.672007, 17.491491, 3.271395>
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <69.897409, 18.585257, 3.271395>
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <75.122811, 19.679024, 3.271395>
  }
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <80.348213, 20.77279, 3.271395>
  }
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <85.573615, 21.866556, 3.271395>
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <90.799016, 22.960323, 3.271395>
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.076043, 0.213546, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <96.024418, 24.054089, 3.271395>
  }
  cylinder { // Cylndr39
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.2, 0.2, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <101.24982, 25.147856, 3.271395>
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1 
    texture {
      Polished_Bras1
    }
    scale <0.4, 0.4, 8.0>
    rotate <-179.703232, -90.0, -78.474464>
    translate  <105.371491, 26.161932, 3.397923>
  }
  rotate -12.691339*z
  translate  <-51.674224, 1.474375, -0.169817>
}
#declare holders = union {
  sphere { // Sphere25
    <0,0,0>,1
    texture {
      Texture05
    }
    scale 0.4
    translate  <-6.779689, -5.994433, 0.0>
  }
  sphere { // Sphere47
    <0,0,0>,1
    texture {
      Texture05
    }
    scale 0.4
    translate  <-7.000911, -4.755191, 0.0>
  }
  sphere { // Sphere48
    <0,0,0>,1
    texture {
      Texture05
    }
    scale 0.4
    translate  <-7.246298, -3.612613, 0.0>
  }
  sphere { // Sphere49
    <0,0,0>,1
    texture {
      Texture05
    }
    scale 0.4
    translate  <-7.462925, -2.426296, 0.0>
  }
  sphere { // Sphere50
    <0,0,0>,1
    texture {
      Texture05
    }
    scale 0.4
    translate  <-7.706016, -1.261848, 0.0>
  }
  sphere { // Sphere51
    <0,0,0>,1
    texture {
      Texture05
    }
    scale 0.4
    translate  <-7.922644, -0.046773, 0.0>
  }
  rotate -12.691339*z
  translate  <-50.748993, 3.008354, 4.137387>
}
#declare guitar = union {
  object { head5 }
  object { body }
  object { strings }
  object { traste }
  object { holders }
  box { // brace
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture03
    }
    scale <0.5, 12.0, 1.0>
    rotate -1.055734*z
    translate  <-23.819052, 1.111293, -8.571639>
  }
  scale 0.13
  rotate <119.58622, -30.209463, -21.671848>
  translate  <1.885161, -5.258538, -4.545236>
}
#declare guitarrist = union {
  object { man }
  object { guitar }
  superellipsoid { // SuprQ002
    <0.05, 0.03>
    texture {
      Texture03
      rotate <158.482727, 87.321419, 150.03418>
    }
    scale <2.0, 1.0, 4.4>
    rotate 36.18148*z
    translate  <3.375548, -6.275047, -20.218462>
  }
  scale 1.2
  rotate -147.386047*z
  translate  <16.162383, -15.802138, 4.912034>
}
union { // couple
  object { woman }
  object { guitarrist }
  rotate -129.349487*z
}


plane { // Plane001
  z,0
  texture {
    Texture02
    scale <1.977116, 1.991485, 1.0>
  translate <-0.977116, -1.005854, 0.000000>
  }
  scale <4.0, 4.0, 1.0>
  translate  <0.0, -5.027872, -24.711454>
}




