//==========================================================================================
//      INCLUDE FILES
//==========================================================================================
#include "colors.inc" #include "shapes.inc"
#include "mestex.inc"
#include "nouvtex.inc" 
#include "versky.inc"
#include "aebat1.inc" #include "aebat2.inc" #include "aebat3.inc"
#include "aebat4.inc" 
#include "aebat5.inc" #include "aebat6.inc" #include "aebat7.inc" 
#include "aebat8.inc" #include "aebat9.inc" #include "aebat10.inc"
#include "tuture.inc"
#include "aesol.inc"
//==========================================================================================
//      OUR EYES
//==========================================================================================
camera {sky <0,1,.05> location <40,15,0> direction <0,0,1> look_at <0,15,-.2>}
//camera {location <40,125,0> direction <0,0,2> look_at <39.9,15,0> translate x*-80 orthographic}

//==========================================================================================
//      MOVIE SCREENS
//==========================================================================================
#declare Struct=union {
cylinder {<.1,1.2,0>,<.5,1,0>,.005 texture {T_Chrome_5E}} cylinder {<.1,1.2,0>,<0,1,0>,.01 texture {T_Chrome_5E}}
cylinder {<.1,1.2,0>,<-.5,1.3,0>,.005 texture {T_Chrome_5E}}cylinder {<.05,1,0>,<-.5,1.3,0>,.005 texture {T_Chrome_5E}}         
}
#declare Dia= union {
box {<0,0,0>,<1,1,.1> pigment {image_map {gif "meep.gif"}} finish {diffuse 2}}
object {Struct}
object {Struct scale <-1,1,1> translate x*1}
union { object {Struct} object {Struct scale <-1,1,1> translate x*1} scale <1,-1,1> translate y*1}  
union { object {Struct} object {Struct scale <-1,1,1> translate x*1} scale <1,-1,1> translate y*1 rotate z*90 scale <-1,1,1>}  
union { object {Struct} object {Struct scale <-1,1,1> translate x*1} scale <1,-1,1> translate y*1 rotate z*90 translate x*1}
}

#declare Dia2= union {
box {<0,0,0>,<1,1,.1> pigment {image_map {tga "txtutil.tga"}} finish {diffuse 2}}
object {Struct}   
object {Struct scale <-1,1,1> translate x*1}
union { object {Struct} object {Struct scale <-1,1,1> translate x*1} scale <1,-1,1> translate y*1}  
union { object {Struct} object {Struct scale <-1,1,1> translate x*1} scale <1,-1,1> translate y*1 rotate z*90 scale <-1,1,1>}  
union { object {Struct} object {Struct scale <-1,1,1> translate x*1} scale <1,-1,1> translate y*1 rotate z*90 translate x*1}
}
  
object {Dia translate x*-.5 rotate y*-90 scale <1,12,12>
translate <-30,15,5>}
object {Dia2 translate x*-.5 rotate y*-90 scale <1,10,10> rotate y*35
translate <-32,10,30>}

//==========================================================================================
//      VEHICLES
//==========================================================================================
#declare machin = union {
#declare r1=seed(2)
#declare boucle=1
#while (boucle < 30)
object {Tuture1 
         scale (.6+rand(r1)*.2) 
         rotate y*(180+rand(r1)*10) 
         translate <-50+rand(r1)*200,rand(r1)*20,-15+rand(r1)*40>
         }
object {Tuture2 
         scale (.6+rand(r1)*.2) 
         rotate y*(0+rand(r1)*10) 
         translate <-50+rand(r1)*200,rand(r1)*20,-15+rand(r1)*40>
         }
#declare boucle=boucle+1
#end
}

object {machin translate x*-80 scale .4 translate y*20 rotate y*-40}
object {machin translate x*-80 scale .4 translate y*3 rotate y*-90 translate <-5,0,0>}
object {machin translate x*-80 scale .4 translate y*10 rotate y*-90 translate <-70,0,-40>}
object {machin translate x*-80 scale .4 translate y*15 rotate y*-90 translate <-90,0,-40>}

//==========================================================================================
//      BUILDINGS
//==========================================================================================

object {Aebat1 scale .2  rotate y*12  translate <-35,10,-10>}
object {Aebat2 scale .04 rotate y*35  translate <5,0,10>}
object {Aebat3 scale  1  rotate y*55  translate <0,0,-10>}
object {Aebat4 scale .01 rotate y*35  translate <-30,25,40>}
object {Aebat5 scale .6 rotate y*-15  translate <-25,0,-15>}
object {Aebat6 scale .6 rotate y*60  translate <-65,0,5>}
object {Aebat7 scale .3 rotate y*0  translate <-70,0,-60>}
object {Aebat1 scale .2  rotate y*-32  translate <-60,10,-50>}
object {Aebat8 scale  .5  rotate y*30  translate <-60,0,-65>}
object {Aebat6 scale .4 rotate y*-60  translate <-40,0,-40>}
object {Aebat5 scale .6 rotate y*-15  translate <-20,0,-35>}
object {Aebat1 scale .2  rotate y*-32  translate <-15,10,-40>}
object {Aebat1 scale .2  rotate y*-32  translate <-70,10,-30>}
object {Aebat8 scale  .9  rotate y*30  translate <-60,0,-20>}
object {Aebat6 scale .2 rotate y*-60  translate <-10,0,0>}
object {Aebat5 scale .45 rotate y*-15  translate <-30,0,5>}
object {Aebat9 scale  .8  rotate y*60  translate <-10,0,25>}
object {Aebat5 scale 1.2 rotate y*-15  translate <-60,0,35>}
object {Aebat10 scale 2 rotate y*-15  translate <-80,0,30>}
object {Aebat10 scale <3,4,3> rotate y*-85  translate <-120,0,30>}
object {Aebat10 scale <3,7,3> rotate y*-85  translate <-135,0,5>}

//==========================================================================================
//      GROUND
//==========================================================================================
union {
plane {y,0 pigment {checker color White color Gray70 scale 20} 
        finish {reflection .5}}
object {pavement}
translate y*-.5
}
//==========================================================================================
//      LIGHTS ON !
//==========================================================================================
light_source {<300,300,300> White*.9 atmosphere off}
light_source {<-30,200,-200> White*.9 atmosphere off}
//==========================================================================================
//      ENVIRONNEMENT, ATMOSPHERIC EFFECTS, SKY,...
//==========================================================================================
fog {distance 80 fog_type 2 rgbt <.2,1,.7,.1>*.7 fog_alt 10 fog_offset 3 turbulence 1}
fog {distance 200 fog_type 2 rgb <.2,1,.7>*.5 fog_alt .1 fog_offset 30 turbulence 1}
sphere {0,3000 texture {Ciel_Vert scale 1000 finish {diffuse 0 ambient .4} }hollow}
//==========================================================================================
//      SETTINGS
//==========================================================================================
#max_trace_level 15
