#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "shapes.inc"
#include "candelab.inc"
#include "cruche.inc"
#include "casserol.inc"

#declare Brick_Texture = texture {
    pigment {
        brick Gray10, Gray15
    }
    normal {
        brick 0.075
    }
    finish {
        crand 0.0003
        diffuse 0.6 ambient 0.20
    }
/*    scale <0.1, 0.1, 0.05> */
    scale <0.01, 0.01, 0.005>
    translate <0.025, 0.030, 0.025>
}

#declare Haut_Cad=90
#declare Long_Cad=114

#declare camera_location = <0, 20, -220>
#declare camera_look_at = <0, 10, 0>

#declare flare_position = <-4, 17.5, -147>
#declare flare_brightness = 0.5
#declare flare_type = 2

#include "LensFlar.inc"

camera {location camera_location look_at camera_look_at}
camera
  {
  location <0,20,-220>
  look_at <0,10,0>
  }

light_source { <-50, 30, -200> colour Gray40 atmosphere off}
light_source { <-30, 30, -200> colour Gray40 atmosphere off}
light_source { < Long_Cad/2,  Haut_Cad,  -20> colour White*6 spotlight
             point_at <Long_Cad/2,Haut_Cad/2,10>
             radius 135 falloff 1 tightness 1
             adaptive 1
             jitter
             }

#declare Toile = box {<0,0,0>,<1,1,1>
                     pigment { image_map { tga "picasso.tga" } }
                     }

#declare Bord1 =
union
  {
  box {<0,0,0>,<1,1,1>}
  cylinder {<0,0,0>,<0,1,0>,0.5 translate <0.5,0,0>}
  }

#declare Bord2 =
difference
  {
  box {<0,0,0>,<1,1,1>}
  cylinder {<0,0,0>,<0,1,0>,0.5 scale<1,1.2,1> translate <1,-0.1,0>}
  }

#declare BordH =
difference
  {
  union
    {
    object {Bord1 texture {Gold_Metal}}
    object {Bord2 pigment {Grey} translate x*1}
    scale <2,Haut_Cad,2>
    }
  box {<0,0,0>,<1,1,1> rotate <0,0,45> scale <10,10,10> translate <5,-5,-5> pigment {Grey}}
  box {<0,0,0>,<1,1,1> rotate <0,0,45> scale <10,10,10> translate <5,Haut_Cad-5,-5> pigment {Grey}}
  }

#declare BordL =
difference
  {
  union
    {
    object {Bord1 texture {Gold_Metal}}
    object {Bord2 pigment {Grey} translate x*1}
    scale <2,Long_Cad,2>
    }
  box {<0,0,0>,<1,1,1> rotate <0,0,45> scale <10,10,10> translate <5,-5,-5> pigment {Grey}}
  box {<0,0,0>,<1,1,1> rotate <0,0,45> scale <10,10,10> translate <5,Long_Cad-5,-5> pigment {Grey}}
  }

#declare Applique = cylinder {<0,0,0>,<1,0,0>,0.5 texture {Gold_Metal}}

#declare Candle_bc = torus {1.4 0.6}

#declare Carafe =
union {
  object {Cruche texture { Cruche_Texture } scale <5, 5, 5>}
  object {Cruche_bc texture { Cruche_Texture } rotate <90,0,0> translate <-10,12,0>}
}

#declare Table_top = box {<0,0,0>,<1,1,1>
                         texture {T_Wood25} }

#declare Mur = box {<0,0,0>,<1,1,1>
                         texture {Brick_Texture} }

#declare Cadre =
union {
   object {BordH}
   object {BordH rotate <180,180,0> translate <Long_Cad-4,Haut_Cad+4,0>}
   object {BordL rotate <0,0,-90> translate <-4,Haut_Cad,0>}
   object {BordL rotate <0,0,90> translate <Long_Cad,4,0>}
   object {Toile scale <106,82,0.1> translate <4,4,2>}
   object {Applique scale <40,2,2> translate <(Long_Cad/2)-26,Haut_Cad-4,-24>}
}

#declare Atmosphere1 = atmosphere {
    type 4
    samples 30
    distance 500
    scattering 0.1
    aa_level 8
    aa_threshold 0.1
    jitter 0.1
}

#declare FadeDst = 1.75
#declare FadePwr = 6.50 //3.25

#declare Flame =
union {
    light_source {<0, 7,   -1> Red    * 0.5 fade_distance FadeDst fade_power FadePwr * 1.25}
    light_source {<0, 6,   -1> Red    * 1.0 fade_distance FadeDst fade_power FadePwr}
    light_source {<0, 5,   -1> Red    * 1.2 fade_distance FadeDst fade_power FadePwr}
    light_source {<0, 4,   -1> Red    * 1.2 fade_distance FadeDst fade_power FadePwr}
    light_source {<0, 3,   -1> Orange * 1.3 fade_distance FadeDst fade_power FadePwr}
    light_source {<0, 2,   -1> Orange * 1.4 fade_distance FadeDst fade_power FadePwr}
    light_source {<0, 1,   -1> Yellow * 1.4 fade_distance FadeDst fade_power FadePwr}
    light_source {<0, 0,   -1> Orange * 1.5 fade_distance FadeDst fade_power FadePwr}
    light_source {<0, -0.25,-1> NeonBlue fade_distance 0.75 * FadeDst fade_power 1.5}
}

#declare Candelabre =
union {
  object {Candle_base texture { Gold_Metal } scale <10, 10, 10>}
  object {Candle_h texture { Gold_Metal } scale <10, 10, 10>}
  cylinder {<0,0,0>,<1,0,0>,0.5 texture {Gold_Metal} scale <2.5,1,1> translate <-2.5,11,0>}
  sphere {<0,0,0>,0.5 texture {Gold_Metal} scale <1,2,2> translate <-2.7,11,0>}
  object {Candle_bc texture { Gold_Metal } rotate <90,0,0> translate <-5,1.5,0>}
  object {Candle pigment { Grey } translate y*16}
  object {Candle_m pigment { Black } translate y*26}
  object {Flame translate y*27.5}
}

object {Candelabre translate <-4,-10,-147>}
object {Carafe rotate <0,25,0> translate <-20,-13,-150>}
object {Casserole scale <2,2,2> rotate <0,-45,0> translate <15,-13,-140>}
object {Table_top scale <70,2,30> translate <-40,-14,-160>}
object {Cadre rotate <-5,0,0>}
object {Mur scale <800,800,1> translate <-400,-200,2>}

atmosphere { Atmosphere1 }
