// Persistence of Vision Ray Tracer Scene Description File
// File: boards.inc
// Vers: 3.01 Watcom Win32
// Desc: File to create box composed of multiple boards
// Date: June 13, 1997
// Auth: Sonya Roberts
// Note: Set up as many or as few of the following variables as you wish, then
//       #include this file to use it.  Object composed of boards will be created,
//       from <0,0,0> to the coordinates given in Dimens.

#ifndef(True)		#declare True=1				#end
#ifndef(False)		#declare False=0			#end
#ifndef(Dimens)		#declare Dimens=<10,.25,15>		#end	// Area to be filled with board (measured from 0,0,0) - MUST BE POSITIVE, NON-ZERO
#ifndef(Mater1)		#declare Mater1=texture{T_Wood7}	#end	// Material to be used
#ifndef(Mater2)		#declare Mater2=texture{T_Wood23}	#end	// Material to be used
#ifndef(Mater3)		#declare Mater3=texture{T_Wood10}	#end	// Material to be used
#ifndef(Mater4)		#declare Mater4=texture{T_Wood13}	#end	// Material to be used
#ifndef(NumBoards)	#declare NumBoards=<12,1,3>		#end	// Approx. number of boards to be placed in each direction - MUST BE POSITIVE, NON-ZERO
#ifndef(Variance)	#declare Variance=.25			#end	// Variance in size of boards (percentage) - MUST BE LESS THAN 1
#ifndef(BSD)		#declare BSD=seed(1)			#end	// Seed value for random number

#if (Variance >1)	#error "Cannot create BOARDS object - Variance must be less than 1 (100%)"	#end
#if (Variance <0)	#debug "Negative Variance switched to positive"	#declare Variance=-Variance	#end

#if (Dimens.x=0 | Dimens.y=0 | Dimens.z=0)	#error "Cannot create BOARDS object - one or more dimensions equals zero"	#end
#if (Dimens.x<0)	#debug "Negative X Dimens switched to positive"	#declare Dimens=<-Dimens.x,Dimens.y,Dimens.z>	#end
#if (Dimens.y<0)	#debug "Negative Y Dimens switched to positive"	#declare Dimens=<Dimens.x,-Dimens.y,Dimens.z>	#end
#if (Dimens.z<0)	#debug "Negative Z Dimens switched to positive"	#declare Dimens=<Dimens.x,Dimens.y,-Dimens.z>	#end

#if (NumBoards.x=0 | NumBoards.y=0 | NumBoards.z=0)	#error "Cannot create BOARDS object - Number of boards in one or more dimensions equals zero"	#end
#if (NumBoards.x<0)	#debug "Negative X NumBoards switched to positive"	#declare NumBoards=<-NumBoards.x,NumBoards.y,NumBoards.z>	#end
#if (NumBoards.y<0)	#debug "Negative Y NumBoards switched to positive"	#declare NumBoards=<NumBoards.x,-NumBoards.y,NumBoards.z>	#end
#if (NumBoards.z<0)	#debug "Negative Z NumBoards switched to positive"	#declare NumBoards=<NumBoards.x,NumBoards.y,-NumBoards.z>	#end

union {
	#declare Y1=0
	#while (Y1<Dimens.y)
		#if (NumBoards.y=1)
			#declare HeightY=Dimens.y
		      #else
			#declare BaseY=Dimens.y/NumBoards.y
			#declare HeightY=BaseY-(BaseY*Variance)+(rand(BSD)*(BaseY*Variance*2))
			#if ((Y1+HeightY)>Dimens.y)
				#declare HeightY=Dimens.y-Y1
			#end
		#end
		#declare X1=0
		#while (X1<Dimens.x)
			#if (NumBoards.x=1)
				#declare WidthX=Dimens.x
			      #else
				#declare BaseX=Dimens.x/NumBoards.x
				#declare WidthX=BaseX-(BaseX*Variance)+(rand(BSD)*(BaseX*Variance*2))
				#if ((X1+WidthX)>Dimens.x)
					#declare WidthX=Dimens.x-X1
				#end
			#end
			#declare Z1=0
			#while (Z1<Dimens.z)
				#if (NumBoards.z=1)
					#declare LengthZ=Dimens.z
				      #else
					#declare BaseZ=Dimens.z/NumBoards.z
					#declare LengthZ=BaseZ-(BaseZ*Variance)+(rand(BSD)*(BaseZ*Variance*2))
					#if ((Z1+LengthZ)>Dimens.z)
						#declare LengthZ=Dimens.z-Z1
					#end
				#end
				box {
					<X1,Y1,Z1>,<X1+WidthX,Y1+HeightY,Z1+LengthZ>
					#declare UseMater=val(str(rand(BSD),4,2))
					#switch (UseMater)
						#range (0,.25)
							texture {Mater1	rotate <rand(BSD)*360,rand(BSD)*360,rand(BSD)*360>}
						#break
						#range (.26,.5)
							texture {Mater2	rotate <rand(BSD)*360,rand(BSD)*360,rand(BSD)*360>}
						#break
						#range (.51,.75)
							texture {Mater3	rotate <rand(BSD)*360,rand(BSD)*360,rand(BSD)*360>}
						#break
						#range (.76,1)
							texture {Mater4	rotate <rand(BSD)*360,rand(BSD)*360,rand(BSD)*360>}
						#break
					#end
				}
				#declare Z1=Z1+LengthZ
			#end
			#declare X1=X1+WidthX
		#end
		#declare Y1=Y1+HeightY
	#end
}
