// Persistence of Vision Ray Tracer Scene Description File
// File: isitart.pov
// Vers: 3.02 Watcom Win32
// Desc: Museum Scene
// Date: October 31, 1997
// Auth: Sonya Roberts
// Note: 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "shapes.inc"
#include "stones.inc"
#include "stones2.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "glass.inc"

#include "custom.inc"

#declare True=1
#declare False=0

camera {
	location	<0,5.5,-12>
	up		<0,1.33,0>
	right		<1,0,0>
	look_at		<0,5.5,-0>
}

atmosphere {
	type 4
	samples 40
	distance 60
	scattering 0.2
	aa_level 4
	aa_threshold 0.15
	jitter 0.3
}

light_source {
	<0,8,-25>
	color Gray30
	atmosphere off
}

// ---- Create Empty Room ----
object {
	union {
		difference {
			box {<-21,-1,-31>,<21,13,1>}
			box {<-20,-.1,-30>,<20,12,0>}
			pigment {color White}
			normal {bumps .1 scale <.05,.05,.05>}
			finish {ambient .2}
		}
		object {
			#declare Dimens=<40,.099,30>
			#declare NumBoards=<80,1,3>
			#include "boards.inc"
			translate <-20,-.1,-30>
		}
		difference {
			box {<-20,0,-.1>,<20,.75,0>}
			cylinder {<-20,0,0>,<20,0,0>,.075	scale <1,4,1>	translate <0,.75,-.1>}
			texture {T_Wood2}
		}
		union {
			#declare X1=-15
			#while (X1<=15)
				box {<X1-.5,11,-30>,<X1+.5,12,0>}
				#declare X1=X1+10
			#end
			texture {T_Wood2}
		}
	}
}

// ---- Sculpture On Stand Off To One Side ----
object {
	union {
		box {<-.5,0,-.5>,<.5,3,.5>	texture {T_Stone5}}
		julia_fractal {
			<-0.1,-0.053,-0.83,-0.025>
			quaternion
			sqr
			max_iteration 9
			precision 18
			rotate x*90
			translate <0,4,0>
			texture {T_Chrome_3D}
		}
		rotate y*-10
	}
	translate <-4,0,-1>
}

// ---- Lights Pointing at Picture ----
#declare PotLight=
object {
	union {
		union {
			cylinder {<0,0,0>,<0,-1,0>,.03}
			intersection {
				torus {.5,.05	rotate x*90}
				box {<-.6,0,-.1>,<.6,.6,.1>}
				translate <0,-.5,0>
				scale <1,1.5,2>
				translate <0,-1,0>
			}
			cylinder {<-.5,-1.6,0>,<-.25,-1.6,0>,.025}
			cylinder {<.5,-1.6,0>,<.25,-1.6,0>,.025}
			texture {WhiteEnamel}
		}
		union {
			difference {
				superellipsoid {
					<.95,.05>				// Cylinder with Rounded Edges
					rotate x*90				// Rotate so axis is vertical
					translate <0,.95,0>			// Move so origin near bottom
					scale <.3,.5,.3>			// Scale to .3 units in radius, 1 unit high
					texture {T_Silver_4A}			// Dull Silver
				}
				union {
					cylinder {<0,-.1,0>,<0,.7,0>,.25}	// Hollow out inside
					sphere {<0,.7,0>,.25}
					texture {T_Silver_4E}			// Polished Silver
				}
			}
			light_source {					// Light from Pot Lights
				<0,0,0>
				color White
				spotlight
				point_at <0,-11,0>
				radius 50
				falloff 80
				tightness 20
			}
			translate <0,-.5,0>
			rotate x*-50
			translate <0,-1.6,0>
		}
	}
}

object {PotLight	rotate y*50	translate <-4,12,-2.5>}
object {PotLight	rotate y*-25	translate <4,12,-2.5>}


// ---- Framed Picture on Wall ----
object {
	union {
		cylinder {<-3,2,-.1>,<-3,10,-.1>,.1}
		cylinder {<3,2,-.1>,<3,10,-.1>,.1}
		cylinder {<-3,2,-.1>,<3,2,-.1>,.1}
		cylinder {<-3,10,-.1>,<3,10,-.1>,.1}
		sphere {<-3,2,-.1>,.1}
		sphere {<-3,10,-.1>,.1}
		sphere {<3,2,-.1>,.1}
		sphere {<3,10,-.1>,.1}
		box {
			<-3,2,-.01>,<3,10,0>
			pigment {
				image_map {
					tga "winseat.tga"
				}
				scale <6,8,1>
				translate <-3,2,0>
			}
			finish {ambient .3}			
		}
	}
	translate <1,0,0>
}
