// Persistence of Vision Ray Tracer Scene Description File
// File: winseat3.pov
// Vers: 3.02 Watcom Win32
// Desc: MY version of the infamous WinSeat image
// Date: October 30, 1997
// Auth: Sonya Roberts
// Note: Hehehe!

// ==== Standard Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "shapes.inc"
#include "stones.inc"
#include "stones2.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "glass.inc"

camera {
	location	<0,200,-150>
	up		<0,1.33,0>
	right		<1,0,0>
	look_at		<0,200,-140>
}

light_source {
	<-2500,350,50>,
	color White
}

light_source {
	<2500,2500,-250>,
	color Gray30
	shadowless
}

object {
	sphere {<0,0,0>,5000}
	hollow
	texture {
		pigment {
			gradient y
			color_map {
				[0	color LightBlue]
				[1.0	color NavyBlue]
			}
			scale <1,5000,1>
		}
	}
}

#declare Snow=
texture {
	pigment {color rgb <.985,.985,1>}
	finish {
		phong .1
		ambient .4
	}
}

object {
	height_field {					// Mountains
		tga "mountain.tga"
		water_level .299
	}
	translate <-.5,-.3,-.25>
	scale <2500,400,2000>
	texture {T_Stone3}
}

object {
	height_field {					// Snow on Mountains
		tga "mountain.tga"
		water_level .294
		smooth
	}
	translate <-.499,-.298,-.249>
	scale <2500,405,2000>
	texture {Snow}
}

object {
	height_field {					// Foothills
		tga "mountain.tga"
		water_level .299
		smooth
	}
	translate <-.5,-.3,-.75>
	rotate y*180
	scale <1000,75,1000>
	texture {
		pigment {color PaleGreen}
	}
}

object {
	plane {<0,1,0>,0}
	texture {
		pigment {color PaleGreen}
	}
}

object {
	union {
		difference {
			union {
				sphere {<0,0,0>,10.1	scale <3,1,1>	translate <51,0,0>}
				cylinder {<-51,0,0>,<51,0,0>,10.1}
			}
			cylinder {<-20,0,0>,<20,0,0>,10	texture {pigment {color Wheat}}}
			superellipsoid {<.1,.1>	scale <.55,.75,1>	translate <0,0,10>}
		}
		difference {
			superellipsoid {<.1,.1>	scale <.6,.8,.075>	translate <0,0,10>}
			superellipsoid {<.1,.1>	scale <.5,.7,1>		translate <0,0,10>}
			texture {T_Brass_4C}
		}
		union {
			cylinder {<0,0,0>,<0,0,30>,.5}
			box {<0,-.5,0>,<10,.5,30>}
			union {
				torus {.4,.1	rotate z*90	translate <-1,0,0>}
				cylinder {<-1,0,0>,<0,0,0>,.5}
				difference {
					sphere {<0,0,0>,.5}
					box {<-2,-1,-1>,<0,1,1>}
					scale <4,1,1>
				}
				texture {T_Chrome_4C}
				scale <2,2,2>
				rotate y*5
				translate <0,.5,10>
			}
			union {
				torus {.4,.1	rotate z*90	translate <-1,0,0>}
				cylinder {<-1,0,0>,<0,0,0>,.5}
				difference {
					sphere {<0,0,0>,.5}
					box {<-2,-1,-1>,<0,1,1>}
					scale <4,1,1>
				}
				texture {T_Chrome_4C}
				scale <2,2,2>
				rotate y*5
				translate <0,.5,25>
			}
			texture {T_Chrome_3B}
			rotate y*-5
			translate <2,-2,10>
		}
		light_source {
			<-10,0,0>
			color Gray30
		}
		light_source {
			<10,0,0>
			color Gray30
		}
		texture {T_Chrome_2C}
	}
	translate <0,200,-158.5>
}

