// Make a rivet

#declare Rivet = torus {
	0.0625, 0.0375
	scale <0.2,0.1,0.2>
}

// Make the outer strengthening ribs that will run around the outside of
// the light

#declare Outer_Strengthener = difference {
	union {
		difference {
			cylinder {<-0.55,0,0> <0.575,0,0> 0.425}
			box {<-0.56,-0.426,0> <0.576,0.426,-0.426> rotate <-11.25,0,0>}
			box {<-0.56,-0.426,0> <0.576,0.426,0.426> rotate <11.25,0,0>}
		}
		box {<-0.55,0,-0.005> <0.575,0.42,0.005> rotate <11.25,0,0>}
		cylinder {<-0.55,0.42,0> <0.575,0.42,0> 0.005 rotate <11.25,0,0>}
		box {<-0.55,0,-0.005> <0.575,0.42,0.005> rotate <-11.25,0,0>}
		cylinder {<-0.55,0.42,0> <0.575,0.42,0> 0.005 rotate <-11.25,0,0>}
	}
	cylinder {<-0.56,0,0> <0.576,0,0> 0.35}
}

// Make the light shade rotated "forward" a bit

#declare Light_Shade = mesh {
	triangle {<0,-0.55,0.45> <0,-0.55,-0.45> <0,-1.35,-0.6>}
	triangle {<0,-0.55,0.45> <0,-1.35,-0.6> <0,-1.35,0.6>}
	translate <0,0.55,0>
	rotate <0,0,-20>
	translate <-0.65,-0.55,0>
}

// Make the chrome tightening knobs

#declare Tightening_Knob = difference {
	cylinder {<0,0,0> <0,0,-0.025> 0.075}
	sphere {<0,0,0> 0.075 scale <1,1,0.5> translate <0,0,-0.0525>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,30>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,60>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,90>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,120>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,150>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,180>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,210>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,240>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,270>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,300>}
	cylinder {<0.077,0,-0.026> <0.077,0,0.001> 0.015 scale <1,2,1> rotate <0,0,330>}
}

#declare Fastening_Bolt = union {
	intersection {
		difference {
			cylinder {<0,0,0> <0,0.05,0> 0.075}
			box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076>}
			box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,60,0>}
			box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,120,0>}
			box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,180,0>}
			box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,240,0>}
			box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,300,0>}
		}
		sphere {<0,0,0> 0.1 scale <1,0.5,1> translate <0,0.005,0>}
		texture {
			Chrome_Texture
			finish {Shiny}
		}
	}
	union {
		cylinder {<0,0.05,0> <0,0.175,0> 0.035
			texture {
				Chrome_Texture
				finish {Shiny}
				normal {
					gradient y
					triangle_wave
					scale <1,0.02,1>
					rotate <0,0,20>
				}
			}
		}
		cone {<0,0.175,0> 0.035 <0,0.1875,0> 0.0135
			texture {
				Chrome_Texture
				finish {Shiny}
			}
		}
	}
}

// Union everything together and make the main body of the light: Body,
// strengthening ribs, back (with air holes), mounting bracket, tightening
// knobs (so it won't fall off), lens (so it can focus), shades (so the
// light doesn't go everywhere) and last but not least, the mounting bolt
// (so it won't fall off the lighting rack if you were going to mount it).

union {

	// Add the knob

	union {
		object {Tightening_Knob translate <0,0,-0.452>}
		object {Tightening_Knob rotate <0,180,0> translate <0,0,0.452>}
		texture {
			Chrome_Texture
			finish {Shiny}
		}
	}

	// Make the lens and give it a texture

	union {
		difference {
			cone {<-0.05,0,0> 0.075 <0,0,0> 0.15}
			cylinder {<-0.06,0,0> <0.01,0,0> 0.075}
		}
		difference {
			cone {<-0.05,0,0> 0.15 <0,0,0> 0.25}
			cylinder {<-0.06,0,0> <0.01,0,0> 0.15}
		}
		difference {
			cone {<-0.05,0,0> 0.25 <0,0,0> 0.35}
			cylinder {<-0.06,0,0> <0.01,0,0> 0.25}
		}
		difference {
			sphere {<0,0,0> 0.075 scale <0.5,1,1>}
			box {<0,-0.076,-0.076> <0.076,0.076,0.076>}
		}
		texture {
			pigment {Clear}
			finish {
				Shiny
				refraction 1
				ior 1.2
				reflection 0.2
			}
		}
		translate <-0.65,0,0>
	}

	// Make it

	union {
		difference {
			union {
				cylinder {<-0.55,0,0> <-0.75,0,0> 0.5}
				cylinder {<-0.575,0,0> <-0.725,0,0> 0.525}
				cylinder {<-0.775,0,0> <-0.75,0,0> 0.425}
			}
			cylinder {<-0.776,0,0> <0.54,0,0> 0.35}
		}
		torus {0.5, 0.025 rotate <0,0,90> translate <-0.575,0,0>}
		torus {0.5, 0.025 rotate <0,0,90> translate <-0.725,0,0>}
		cylinder {<-0.55,0,0> <0.575,0,0> 0.35}
		object {Outer_Strengthener}
		object {Outer_Strengthener rotate <45,0,0>}
		object {Outer_Strengthener rotate <90,0,0>}
		object {Outer_Strengthener rotate <135,0,0>}
		object {Outer_Strengthener rotate <180,0,0>}
		object {Outer_Strengthener rotate <225,0,0>}
		object {Outer_Strengthener rotate <270,0,0>}
		object {Outer_Strengthener rotate <315,0,0>}

		difference {
			union {
				cylinder {<0.575,0,0> <0.6,0,0> 0.425}
				cylinder {<0.575,0,0> <0.625,0,0> 0.4}
				cylinder {<0.625,0,0> <0.7,0,0> 0.275}
				cylinder {<0.625,0,0> <0.725,0,0> 0.25}
				cylinder {<0.725,0,0> <0.75,0,0> 0.05}
				torus {0.4, 0.025 rotate <0,0,90> translate <0.6,0,0>}
				torus {0.25, 0.025 rotate <0,0,90> translate <0.7,0,0>}
				torus {0.025, 0.025 rotate <0,0,90> translate <0.75,0,0>}
			}
			cylinder {<0.55,0,0> <0.6,0,0> 0.4}
			cylinder {<0.6,0,0> <0.7,0,0> 0.25}

			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035}
			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035 rotate <45,0,0>}
			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035 rotate <90,0,0>}
			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035 rotate <135,0,0>}
			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035 rotate <180,0,0>}
			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035 rotate <225,0,0>}
			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035 rotate <270,0,0>}
			cylinder {<0.55,0.35,0> <0.65,0.35,0> 0.035 rotate <315,0,0>}

			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <30,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <60,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <90,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <120,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <150,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <180,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <210,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <240,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <270,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <300,0,0>}
			cylinder {<0.7,0.15,0> <0.75,0.15,0> 0.035 rotate <330,0,0>}
		}

		union {
			cylinder {<0,0,-0.425> <0,0,-0.45> 0.1}
			cylinder {<0,0,0.425> <0,0,0.45> 0.1}
			box {<-0.1,0,-0.425> <0.1,0.575,-0.45>}
			box {<-0.1,0,0.425> <0.1,0.575,0.45>}
			box {<-0.1,0.6,0.4> <0.1,0.625,-0.4>}

			// Add the Fastener
			object {Fastening_Bolt translate <0,0.55,0>}

			difference {
				union {
					cylinder {<-0.1,0.575,-0.4> <0.1,0.575,-0.4> 0.05}
					cylinder {<-0.1,0.575,0.4> <0.1,0.575,0.4> 0.05}
				}
				cylinder {<-0.11,0.575,-0.4> <0.11,0.575,-0.4> 0.025}
				cylinder {<-0.11,0.575,0.4> <0.11,0.575,0.4> 0.025}
				box {<-0.11,0.524,-0.4> <0.11,0.626,0.4>}
				box {<-0.11,0.524,-0.451> <0.11,0.575,0.451>}
			}
			rotate <0,0,Bracket_Rotation>
		}

		object {
			Light_Shade
			translate <0.65,0.55,0>
			rotate <0,0,20>
			rotate <0,0,Bottom_Shade_Rotation>
			translate <-0.65,-0.55,0>
		}
		object {Light_Shade rotate <90,0,0>}
		object {Light_Shade rotate <180,0,0>}
		object {Light_Shade rotate <270,0,0>}

		union {
			cylinder {<-0.65,-0.5,-0.5375> <-0.65,0.5,-0.5375> 0.0125}
			cylinder {<-0.65,-0.5,0.5375> <-0.65,0.5,0.5375> 0.0125}
			cylinder {<-0.65,-0.5375,-0.5> <-0.65,-0.5375,0.5> 0.0125}
			cylinder {<-0.65,0.5375,-0.5> <-0.65,0.5375,0.5> 0.0125}

			cylinder {<-0.65,-0.46,-0.5375> <-0.65,0.46,-0.5375> 0.0145}
			cylinder {<-0.65,-0.46,0.5375> <-0.65,0.46,0.5375> 0.0145}
			cylinder {<-0.65,-0.5375,-0.46> <-0.65,-0.5375,0.46> 0.0145}
			cylinder {<-0.65,0.5375,-0.46> <-0.65,0.5375,0.46> 0.0145}

			difference {
				union {
					torus {0.0375, 0.0125 rotate <0,0,90> translate <-0.65,-0.5,-0.5>}
					torus {0.0375, 0.0125 rotate <0,0,90> translate <-0.65,0.5,-0.5>}
					torus {0.0375, 0.0125 rotate <0,0,90> translate <-0.65,-0.5,0.5>}
					torus {0.0375, 0.0125 rotate <0,0,90> translate <-0.65,0.5,0.5>}
				}
				box {<-0.6,-0.5,-0.55> <-0.7,0.5,0.55>}
				box {<-0.6,-0.55,-0.5> <-0.7,0.55,0.5>}
			}
		}

		object {Rivet translate <-0.7,0.525,0> rotate <45,0,0>}
		object {Rivet translate <-0.7,0.525,0> rotate <135,0,0>}
		object {Rivet translate <-0.7,0.525,0> rotate <225,0,0>}
		object {Rivet translate <-0.7,0.525,0> rotate <315,0,0>}

		object {Rivet translate <-0.6,0.525,0> rotate <45,0,0>}
		object {Rivet translate <-0.6,0.525,0> rotate <135,0,0>}
		object {Rivet translate <-0.6,0.525,0> rotate <225,0,0>}
		object {Rivet translate <-0.6,0.525,0> rotate <315,0,0>}

		object {Rivet translate <-0.5,0.425,0> rotate <5.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <39.375,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <50.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <84.375,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <95.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <129.375,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <140.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <174.375,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <185.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <219.375,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <230.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <264.375,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <275.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <309.375,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <320.625,0,0>}
		object {Rivet translate <-0.5,0.425,0> rotate <354.375,0,0>}

		object {Rivet translate <0.525,0.425,0> rotate <5.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <39.375,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <50.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <84.375,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <95.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <129.375,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <140.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <174.375,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <185.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <219.375,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <230.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <264.375,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <275.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <309.375,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <320.625,0,0>}
		object {Rivet translate <0.525,0.425,0> rotate <354.375,0,0>}

		texture {
			pigment {
				Gray20
			}
			finish {
				ambient 1
			}
		}
		texture {
			pigment {Clear}
			finish {
				Shiny
				reflection 0.2
			}
		}
	}
}
