// Start the scene...
// Include the necessary files

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

// Add the camera

camera {location <0.5,3.5,-2> look_at <0,0,0> scale 0.8}

// Add the SLOW area lights and two spotlights
// Add the spotlights to balance the contrast of the shadows of the area
// lights.

light_source {<5,5,-5> Gray20
	spotlight
	point_at <0,0,0>
	radius 35
	falloff 45
	tightness 50
	shadowless
}

light_source {<0,5,5> Gray75
	spotlight
	point_at <0,0,0.1>
	radius 35
	falloff 45
	tightness 50
	shadowless
}

light_source {
	<0,0,0>
	White
	area_light
	<-0.6,-0.6,0>, <0.6,0.6,-0.01>,5,5
	jitter
	rotate <45,-45,0>
	translate <5,5,-5>
}

light_source {
	<0,0,0>
	White
	area_light
	<-0.6,-0.6,0>, <0.6,0.6,-0.01>,5,5
	jitter
	rotate <45,-45,0>
	translate <5,5,-5>
}

// Redeclare the wood texture the way it needs to be

#declare Wood_Texture = texture {
	T_Wood1
	finish {
		Shiny
		reflection 0.3
	}
	rotate <0,90,0>
}

// Add a second layer so that the planks will stand out against each other

texture {
	pigment {
		bozo
		color_map {
			[0 Yellow filter 1]
			[0.5 Brown filter 0.65]
			[1 Yellow filter 1]
		}
		scale 4
	}
}

// Declare the planks so that they all have different textures and colors

#declare Plank1 = union {
	box {<-2.5,0,0> <0,-0.1,0.3> texture {Wood_Texture scale <2,1,1>}}
	box {<2.5,0,0> <0,-0.1,0.3> texture {Wood_Texture scale <1.75,1,1> translate <5,2,8>}}
	box {<-2.5,0,0> <-5,-0.1,0.3> texture {Wood_Texture scale <1.9,1,1> translate <-1,32,6>}}
	box {<2.5,0,0> <5,-0.1,0.3> texture {Wood_Texture scale <1.8,1,1> translate <5,7,23>}}
}

#declare Plank2 = union {
	box {<-2.5,0,0> <0,-0.1,0.3> texture {Wood_Texture scale <1.75,1,1> translate <10,-4,2>}}
	box {<2.5,0,0> <0,-0.1,0.3> texture {Wood_Texture scale <2,1,1> translate <5,2,8>}}
	box {<-2.5,0,0> <-5,-0.1,0.3> texture {Wood_Texture scale <1.8,1,1> translate <3,8,2>}}
	box {<2.5,0,0> <5,-0.1,0.3> texture {Wood_Texture scale <1.95,1,1> translate <17,-5,3>}}
}

#declare Plank3 = union {
	box {<-2.5,0,0> <0,-0.1,0.3> texture {Wood_Texture scale <1.5,1,1> translate <-2,1,-3>}}
	box {<2.5,0,0> <0,-0.1,0.3> texture {Wood_Texture scale <2,1,1> translate <7,0,3>}}
	box {<-2.5,0,0> <-5,-0.1,0.3> texture {Wood_Texture scale <2,1,1> translate <1,2,2>}}
	box {<2.5,0,0> <5,-0.1,0.3> texture {Wood_Texture scale <1.85,1,1> translate <54,7,3>}}
}

// Union them together so that we get a nice shiny floor of polished wood

union {
	object {Plank1 translate <1,0,0>}
	object {Plank2 translate <-9,0,0>}
	object {Plank2 translate <-0.5,0,-0.3>}
	object {Plank3 translate <-1,0,-0.6>}
	object {Plank1 translate <-0.2,0,-0.9>}
	object {Plank3 translate <1.5,0,-1.2>}
	object {Plank1 translate <0,0,-1.5>}
	object {Plank2 translate <0.25,0,-1.8>}
	object {Plank3 translate <0.8,0,-2.1>}
	object {Plank1 translate <-0.4,0,-2.4>}
	object {Plank2 translate <2,0,0.3>}
	object {Plank3 translate <-8,0,0.3>}
	object {Plank3 translate <1.5,0,0.6>}
	object {Plank3 translate <-8.5,0,0.6>}
	object {Plank1 translate <-0.75,0,0.9>}
	object {Plank2 translate <-1,0,1.2>}
	object {Plank1 translate <0,0,1.5>}
	object {Plank2 translate <2,0,1.8>}
	object {Plank1 translate <-8,0,1.8>}
	object {Plank3 translate <-2,0,2.1>}
	object {Plank1 translate <-8.5,0,2.4>}
	object {Plank1 translate <1.5,0,2.4>}
	object {Plank2 translate <-0.5,0,2.7>}
	object {Plank3 translate <2.5,0,3>}
	object {Plank1 translate <-0.5,0,3.3>}
	object {Plank2 translate <4,0,3.6>}
	object {Plank3 translate <5,0,3.9>}
	rotate <0,-10,0>
}

// Place the lights from Light.inc with the bottom shade rotated so as it
// does not cut through the floor

#declare Bottom_Shade_Rotation = -78.5
#declare Bracket_Rotation = 32.4

object {
	#include "LBSetup.inc"
	scale 0.5
	rotate <0,0,-8>
	rotate <0,45,0>
	translate <-1,0.275,0>
}

//<-0.7286627091926277,0.2210704233779747,-0.2713372908073724>

#declare Bottom_Shade_Rotation = -20
#declare Bracket_Rotation = 0

object {
	#include "LBSetup.inc"
	scale 0.5
	rotate <0,-95,0>
	translate <0.6,0.7,-0.05>
}

//<-0.45,0,-0.2>-<0.8,0.7,0.3>

// Plantation Pine wood texture for the crates

#declare Crate_Wood_1 = texture {
	pigment {
		wood
		turbulence 0.05
		color_map {
			[0, 0.2 color rgb <0.9529412, 0.7647059, 0.5568628> color rgb <1, 0.7176471, 0.4627451>]
			[0.2, 0.22 color rgb <1, 0.7176471, 0.4627451> color rgb <1, 0.7372549, 0.5568628>]
			[0.22, 0.41 color rgb <1, 0.7372549, 0.5568628> color rgb <0.8352941, 0.6039216, 0>]
			[0.41, 0.43 color rgb <0.8352941, 0.6039216, 0> color rgb <1, 0.7882353, 0.5803922>]
			[0.43, 0.63 color rgb <1, 0.7882353, 0.5803922> color rgb <0.8352941, 0.5764706, 0.3019608>]
			[0.63, 0.65 color rgb <0.8352941, 0.5764706, 0.3019608> color rgb <0.8352941, 0.6509804, 0.509804>]
			[0.65, 0.68 color rgb <0.8352941, 0.6509804, 0.509804> color rgb <0.8117647, 0.627451, 0.5333334>]
			[0.68, 0.7 color rgb <0.8117647, 0.627451, 0.5333334> color rgb <1, 0.8352941, 0.627451>]
			[0.7, 1 color rgb <1, 0.8352941, 0.627451> color rgb <0.8588235, 0.6941177, 0.5568628>]
		}
		frequency 2
	}
	scale <0.3,0.3,2>
	rotate <0,-89,0>
}

// Make a second layer for contrast

texture {
	pigment {
		bozo
		color_map {
			[0 Clear]
			[0.5 White filter 0.8]
			[0 Clear]
		}
	}
	scale 2
}

#declare Nail = cylinder {<0,0,-0.0001> <0,0,0.00001> 0.025 scale <0.2,0.2,1>}

// Declare the small crate

#declare Crate1 = union {
	box {<-0.625,0,-0.3> <0.625,0.1,-0.35> texture {Crate_Wood_1}}
	box {<-0.625,0.6,-0.3> <0.625,0.7,-0.35> texture {Crate_Wood_1 translate <10,2,-3>}}

	box {<-0.625,0,0.3> <0.625,0.1,0.35> texture {Crate_Wood_1 translate <11,-5,2>}}
	box {<-0.625,0.6,0.3> <0.625,0.7,0.35> texture {Crate_Wood_1 translate <2,-6,0>}}

	box {<-0.625,0.1,-0.3> <-0.525,0.6,-0.35> texture {Crate_Wood_1 rotate <0,90,0> translate <13,0,8>}}
	box {<0.625,0.1,-0.3> <0.525,0.6,-0.35> texture {Crate_Wood_1 rotate <0,90,0> translate <12,4,0.5>}}

	box {<-0.625,0.1,0.3> <-0.525,0.6,0.35> texture {Crate_Wood_1 rotate <0,90,0> translate <0,3,-9>}}
	box {<0.625,0.1,0.3> <0.525,0.6,0.35> texture {Crate_Wood_1 rotate <0,90,0> translate <7,-4,2>}}

	intersection {
		box {<-0.7,-0.05,-0.3> <0.7,0.05,-0.35> texture {Crate_Wood_1 translate <1,4.5,-2>} rotate <0,0,-24.5> translate <0,0.35,0>}
		box {<-0.6,0.1,-0.29> <0.6,0.6,-0.36>}
	}

	box {<-0.525,0.65,-0.3> <-0.625,0.7,0.3> texture {Crate_Wood_1 rotate <0,90,0> translate <-20,-50,10>}}
	box {<0.525,0.65,-0.3> <0.625,0.7,0.3> texture {Crate_Wood_1 rotate <0,90,0> translate <3,10,-5>}}

	intersection {
		box {<-0.7,0.65,0.05> <0.7,0.7,-0.05> texture {Crate_Wood_1 translate <-2,-7,1>} rotate <0,29.5,0>}
		box {<-0.525,0.64,-0.3> <0.525,0.71,0.3>}
	}

	box {<-0.625,0.05,-0.3> <0.625,0.35,0.35> texture {Crate_Wood_1 translate <-8,4,-1>}}
	box {<-0.625,0.35,-0.3> <0.625,0.65,0> texture {Crate_Wood_1 translate <-6,3,8>}}
	box {<-0.625,0.35,0> <0.625,0.65,0.35> texture {Crate_Wood_1 translate <4,17,-5>}}

	union {
		// Front Nails
		object {Nail translate <-0.575,0.025,-0.35>}
		object {Nail translate <-0.575,0.075,-0.35>}

		object {Nail translate <-0.575,0.625,-0.35>}
		object {Nail translate <-0.575,0.675,-0.35>}

		object {Nail translate <0.575,0.025,-0.35>}
		object {Nail translate <0.575,0.075,-0.35>}

		object {Nail translate <0.575,0.625,-0.35>}
		object {Nail translate <0.575,0.675,-0.35>}

		object {Nail translate <-0.55,0.125,-0.35>}
		object {Nail translate <-0.6,0.125,-0.35>}

		object {Nail translate <-0.55,0.575,-0.35>}
		object {Nail translate <-0.6,0.575,-0.35>}

		object {Nail translate <0.55,0.125,-0.35>}
		object {Nail translate <0.6,0.125,-0.35>}

		object {Nail translate <0.55,0.575,-0.35>}
		object {Nail translate <0.6,0.575,-0.35>}

		object {Nail translate <-0.525,0.02,-0.35> rotate <0,-24.5,0> translate <0,0.35,0>}
		object {Nail translate <-0.525,-0.02,-0.35> rotate <0,-24.5,0> translate <0,0.35,0>}

		object {Nail translate <0.525,0.02,-0.35> rotate <0,-24.5,0> translate <0,0.35,0>}
		object {Nail translate <0.525,-0.02,-0.35> rotate <0,-24.5,0> translate <0,0.35,0>}

		// Top Nails
		object {Nail rotate <90,0,0> translate <-0.55,0.7,-0.275>}
		object {Nail rotate <90,0,0> translate <-0.6,0.7,-0.275>}

		object {Nail rotate <90,0,0> translate <-0.55,0.7,0.275>}
		object {Nail rotate <90,0,0> translate <-0.6,0.7,0.275>}

		object {Nail rotate <90,0,0> translate <0.55,0.7,-0.275>}
		object {Nail rotate <90,0,0> translate <0.6,0.7,-0.275>}

		object {Nail rotate <90,0,0> translate <0.55,0.7,0.275>}
		object {Nail rotate <90,0,0> translate <0.6,0.7,0.275>}

		object {Nail rotate <90,0,0> translate <-0.55,0.7,0.02> rotate <0,29.5,0>}
		object {Nail rotate <90,0,0> translate <-0.55,0.7,-0.02> rotate <0,29.5,0>}

		object {Nail rotate <90,0,0> translate <0.55,0.7,0.02> rotate <0,29.5,0>}
		object {Nail rotate <90,0,0> translate <0.55,0.7,-0.02> rotate <0,29.5,0>}
		texture {
			Chrome_Texture
			pigment {Gray30}
			finish {crand 0.06}
		}
	}
	translate <0.175,0,0.15>
	texture {Crate_Wood_1}
}

// Place the small crate so the stage light will "balance" on it

object {
	Crate1
	translate <0.6,0,-0.05>
}

// Make the spare bolts from the lights' fasteners

#declare Bolt = intersection {
	difference {
		cylinder {<0,0,0> <0,0.1,0> 0.075}
		cylinder {<0,-0.01,0> <0,0.11,0> 0.035
			texture {
				Chrome_Texture
				finish {Shiny}
				normal {
					gradient y
					triangle_wave
					scale <1,0.02,1>
					rotate <0,0,20>
				}
			}
		}
		box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076>}
		box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,60,0>}
		box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,120,0>}
		box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,180,0>}
		box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,240,0>}
		box {<-0.075,-0.001,0.0625> <0.075,0.051,0.076> rotate <0,300,0>}
	}
	sphere {<0,0,0> 0.1 scale <1,0.5,1> translate <0,0.005,0>}
	texture {
		Chrome_Texture
		finish {Shiny}
	}
}

// Place the bolts with one leaning on to the other

union {
	object {Bolt}
	object {
		Bolt
		translate <-0.0625,0,0>
		rotate <0,0,-29>
		translate <0.0625,0,0>
		translate <0.09,0,0>
	}
	scale 0.5
	translate <-1.3,0,-0.8>
}

// Make and place the first cable

union {
	intersection {
		torus {0.1105352116885, 0.01 rotate <0,0,90>}
		box {<-0.011,0.1215352116885,0> <0.011,0,-0.121>}
		translate <0,0.1105352116885,0>
	}
	union {
		intersection {
			torus {0.1105352116885, 0.01 rotate <0,0,90>}
			box {<-0.011,-0.1215352116885,0> <0.011,0,0.121>}
			translate <0,0.1105352116885,-0.221070423376>
		}
		difference {
			torus {0.5,0.01}
			box {<-0.511,0.011,0> <0.511,-0.011,-0.511> rotate <0,20,0>}
			box {<-0.511,0.011,0> <0.511,-0.011,0.511>}
			translate <-0.5,0,-0.221070423376>
		}
		difference {
			torus {0.5,0.01}
			box {<-0.511,0.011,0> <0.511,-0.011,-0.511> rotate <0,-160,0>}
			box {<-0.511,0.011,0> <0.511,-0.011,-0.511>}
			translate <0.9396926207859,0,-0.3420201433257>
			translate <-0.5,0,-0.221070423376>
		}
		intersection {
			torus {1,0.01}
			box {<0,-0.011,-1.011> <1.011,0.011,0>}
			translate <-1.060307379215,0,-0.563090566701>
		}
		intersection {
			torus {1,0.01}
			box {<0,-0.011,1.011> <-1.011,0.011,0>}
			translate <-1.060307379215,0,-2.563090566701>
		}
		translate <0,0,0.1105352116885>
		rotate <0,20,0>
		translate <0,0,-0.1105352116885>
	}
	rotate <0,-45,0>
	translate <-0.7286627091926277,0,-0.2713372908073724>
	pigment {Gray50}
	finish {Shiny}
	scale <1,0.995,1>
	translate <0,0.009,0>
}

// <0.5662271497,0.7,0.3360254455>
// Make and place the second cable

union {
	intersection {
		torus {0.1, 0.01 rotate <0,0,90>}
		box {<-0.011,0,0.111> <0.011,0.111,0>}
		translate <0,0.6,0>
	}
	cylinder {<0,0.6,0.1> <0,0.49,0> 0.01}
	intersection {
		torus {0.1, 0.01 rotate <0,0,90>}
		box {<-0.011,0,-0.111> <0.011,-0.111,0>}
		translate <0,0.11,0.1>
	}
	intersection {
		torus {2, 0.01}
		box {<-2.011,-0.011,0> <2.011,0.011,2.011>}
		translate <2,0.01,0.1>
	}
	rotate <0,-5,0>
	translate <0.5662271497,0,0.3360254455>
	translate <0,0,0.1>
	pigment {Gray50}
	finish {Shiny}
}

// Declare the texture for the clapper

#declare Clapperboard_Clapper_Texture = texture {
	pigment {
		gradient x
		color_map {
			[0 Black]
			[0.5 Black]
			[0.5 White]
			[1 White]
		}
		translate <-30,-30,0>	// to get rid of the middle repeat
	}
}

// Declare the body texture

#declare Clapperboard_Body_Texture = texture {
	pigment {
		image_map {
			tga
			"Clapper.tga"
			interpolate 2
		}
		scale <1.6,1.1,1>
		translate <-0.8,-0.7,0>
	}
}

// Add a shiny layer on top

texture {
	pigment {
		color Clear
	}
	finish {
		Shiny
	}
}

// Declare the clapperboard

#declare Clapperboard = union {
	box {<-0.8,-0.6,-0.025> <0.8,0.4,0.025>}
	box {<-0.7,-0.7,-0.025> <0.7,-0.6,0.025>}
	cylinder {<-0.7,-0.6,-0.025> <-0.7,-0.6,0.025> 0.1}
	cylinder {<0.7,-0.6,-0.025> <0.7,-0.6,0.025> 0.1}
	box {<-0.8,0.4,-0.05> <0.8,0.55,0.05>
		texture {
			Clapperboard_Clapper_Texture
			rotate <0,0,-45>
			scale 0.25
			translate <0,0.55,0>
		}
	}
	union {
		box {<-0.075,0,-0.05> <1.525,0.075,0.05>}
		box {<0,-0.075,-0.05> <1.525,0.075,0.05>}
		cylinder {<0,0,-0.05> <0,0,0.05> 0.075}
		texture {
			Clapperboard_Clapper_Texture
			rotate <0,0,45>
			scale 0.25
			translate <0,5.5,0>
		}
		rotate <0,0,12>
		translate <-0.8,0.65,0>
	}
	texture {
		Clapperboard_Body_Texture
	}
}

// Place the clapperboard

object {
	Clapperboard
	rotate <88,0,0>
	translate <0,0.045,0>
	scale 0.5
	translate <0.35,0,-1.15>
}

#declare Nail = object {
	Nail
	scale 1.2
}

// Declare the second crate

#declare Crate2 = union {
	difference {
		box {<-1,0,-1> <1,2,1>}
		box {<0.9,0,-0.8> <1.1,1.8,0.8>}
		box {<0.9,0,-0.8> <1.1,1.8,0.8> rotate <0,90,0>}
	}
	box {<0.9,0,-0.8> <1,0.2,0.8>
		texture {
			Crate_Wood_1
			rotate <0,-90,0>
		}
	}
	box {<0.9,0,-0.8> <1,0.2,0.8>
		texture {
			Crate_Wood_1
			rotate <0,-90,0>
			translate <2,-6,1>
		}
		rotate <0,90,0>
	}
	union {
		object {Nail translate <0.85,0.05,-1>}
		object {Nail translate <0.95,0.05,-1>}
		object {Nail translate <0.75,0.05,-1>}
		object {Nail translate <0.75,0.15,-1>}

		object {Nail translate <-0.85,0.05,-1>}
		object {Nail translate <-0.95,0.05,-1>}
		object {Nail translate <-0.75,0.05,-1>}
		object {Nail translate <-0.75,0.15,-1>}

		object {Nail translate <0.85,0.95,-1>}
		object {Nail translate <0.95,0.95,-1>}
		object {Nail translate <0.75,0.95,-1>}
		object {Nail translate <0.75,0.85,-1>}

		object {Nail translate <-0.85,0.95,-1>}
		object {Nail translate <-0.95,0.95,-1>}
		object {Nail translate <-0.75,0.95,-1>}
		object {Nail translate <-0.75,0.85,-1>}
		texture {
			Chrome_Texture
			pigment {Gray30}
			finish {crand 0.06}
		}
	}
	union {
		object {Nail translate <0.85,0.05,-1>}
		object {Nail translate <0.95,0.05,-1>}
		object {Nail translate <0.75,0.05,-1>}
		object {Nail translate <0.75,0.15,-1>}

		object {Nail translate <-0.85,0.05,-1>}
		object {Nail translate <-0.95,0.05,-1>}
		object {Nail translate <-0.75,0.05,-1>}
		object {Nail translate <-0.75,0.15,-1>}

		object {Nail translate <0.85,0.95,-1>}
		object {Nail translate <0.95,0.95,-1>}
		object {Nail translate <0.75,0.95,-1>}
		object {Nail translate <0.75,0.85,-1>}

		object {Nail translate <-0.85,0.95,-1>}
		object {Nail translate <-0.95,0.95,-1>}
		object {Nail translate <-0.75,0.95,-1>}
		object {Nail translate <-0.75,0.85,-1>}
		texture {
			Chrome_Texture
			pigment {Gray30}
			finish {crand 0.06}
		}
		rotate <0,-90,0>
	}
	texture {
		Crate_Wood_1
		rotate <0,-90,0>
		rotate <90,0,0>
	}
}

// Place the second crate in the back of the scene to fill the space with a
// reflection

object {
	Crate2
	rotate <0,40,0>
	translate <-0.3,0,3>
}

// And now render the image: that will take a lot of time due to the large
// sample rate of the area lights and the anti-aliasing level of 0
