
// Candle providing illumination
// Set TrueCandle = 1.0 to get full model

#declare CandlePos = <-10, 0, 3>

#declare WaxTex = texture {
   pigment {
     color rgbft<1.000, 1.000, 1.000, 0.0, 0.0>
   }
   finish {
     diffuse 0.340
     ambient 0.200
     reflection 0.050
     specular 0.400
     roughness 0.0100
   }
}

#declare Polished_Brass = texture
{
  pigment
  {
    colour rgb<0.576,0.420,0.192>
  }
  finish {
    diffuse 0.8
    brilliance 6.0
    phong 0.8    phong_size 120
    reflection 0.4
    metallic
  }
}

#if (TrueCandle)
#include "CandleBase.inc"
#include "CandleGlass.inc"

union {
  object { CandleBase texture { Polished_Brass } translate .2*y }
  object { CandleGlass
         pigment { color rgbt<1, 1, 1, .95> }
         finish { phong_size 200 phong 0.8 reflection 0.4 refraction on ior 1.5 }
         translate .2*y
  }
#else
union {
#end
  cylinder
  {
    3*y,  5*y,  .3
    texture { WaxTex }
  }
  cylinder
  {
    5*y, 5.5*y, .025
    pigment { color rgb<0, 0, 0> }
  }
  sphere
  {
    0
    1      // radius of sphere
    pigment { color rgbt <1, 1, 1, 1> }
    halo { emitting spherical_mapping linear
      color_map
      {
        [0.00 color rgbt<0.792, 0.792, 0.24, 1>]
        [1.00 color rgbt<1.000, 1.000, .3, -1>]
      }
      samples 10
    }
    hollow
    scale <.25,0.5,.25>
    translate 5.8*y
  }
  translate CandlePos
}

light_source
{
  5.75*y // light's position (translated below)
  color rgb <.6, .6, .1>
  fade_distance 10
  fade_power 2
  translate CandlePos
}
