
// Pair of Dice Showing 10 (a 4 and a 6)
// Set TrueDice = 1.0 to get the final dice model

#declare Ivory =
texture
{
  pigment
  {
    colour rgb<0.996,1.000,0.980>
  }
  finish {
    phong_size 80
    phong 0.8
    reflection 0.25
  }
}

#declare DieDim = 0.3

#declare DiePip =
sphere
{
  <0, 0.0, 0> // center of sphere <X Y Z>
  0.05       // radius of sphere
  pigment { color <0, 0, 0> }
}

#declare DieCube =
superellipsoid
{
  <0.1, 0.1>
  texture { Ivory }
  scale < DieDim, DieDim,  DieDim>
}

#if (TrueDice)

#declare Die =
difference
{
  object { DieCube }
  // topface - 1
  object { DiePip translate DieDim*y }
  // 2 pip face
  object { DiePip translate <-DieDim, DieDim/2, DieDim/2> }
  object { DiePip translate <-DieDim, -DieDim/2, -DieDim/2> }
  // 3 pip face
  object { DiePip translate <-DieDim/2, -DieDim/2, DieDim> }
  object { DiePip translate <0, 0, DieDim> }
  object { DiePip translate <DieDim/2, DieDim/2, DieDim> }
  // 4 pip face
  object { DiePip translate <DieDim, -DieDim/2, -DieDim/2> }
  object { DiePip translate <DieDim, -DieDim/2,  DieDim/2> }
  object { DiePip translate <DieDim,  DieDim/2, -DieDim/2> }
  object { DiePip translate <DieDim,  DieDim/2,  DieDim/2> }
  // 5 pip face
  object { DiePip translate <-DieDim/2, -DieDim/2, -DieDim> }
  object { DiePip translate < DieDim/2, -DieDim/2, -DieDim> }
  object { DiePip translate <0, 0, -DieDim> }
  object { DiePip translate <-DieDim/2,  DieDim/2, -DieDim> }
  object { DiePip translate < DieDim/2,  DieDim/2, -DieDim> }
  // botface - 6
  object { DiePip translate <DieDim/2, -DieDim, DieDim/2> }
  object { DiePip translate <DieDim/2, -DieDim, 0> }
  object { DiePip translate <DieDim/2, -DieDim, -DieDim/2> }
  object { DiePip translate <-DieDim/2, -DieDim, DieDim/2> }
  object { DiePip translate <-DieDim/2, -DieDim, 0> }
  object { DiePip translate <-DieDim/2, -DieDim, -DieDim/2> }
}

#else

#declare Die =
object { DieCube }

#end

object // 6
{
  Die
  rotate 180*z
  translate <7, DieDim, 0>
  rotate 20*y
}

object // 4
{
  Die
  rotate 90*z
  translate <7.5, DieDim, 0>
}
