
// Eyeglasses
// Set TrueGlasses = 1.0 for the full model
#declare Polished_Brass = texture
{
  pigment
  {
    colour rgb<0.576,0.420,0.192>
  }
  finish {
    diffuse 0.8
    brilliance 6.0
    phong 0.8    phong_size 120
    reflection 0.4
  }
}

#declare Bridgey = 0.5

#declare NosePiece =
sphere
{
  <0, 0, 0> // center of sphere <X Y Z>
  0.4       // radius of sphere
  scale <.2, 1, .5>
}

#declare LensFrame =
union
{
  torus
  {
    1.0,
    0.05
    texture { Polished_Brass }
  }
#if (TrueGlasses)
  difference
  {
    sphere
    {
      <0, 2.82, 0> // center of sphere <X Y Z>
      3.0       // radius of sphere
    }
    box
    {
      <-4, 0, -4> <4, 6, 4>
    }
  }
  pigment { color rgbt<1, 1, 1, 1> }
  finish { phong_size 200 phong 0.8 reflection 0.4 refraction on ior 1.5 }
#end
  rotate -90*x
  translate 1.05*y
  scale <1, .9, 1.5>
}

#declare EarLength = 4.0
#declare EarThickness = 0.1
#declare EarRadius = 1.0

#declare EarPiece =
union {
  difference {
    torus
    {
      EarRadius, EarThickness
    }
    box
    {
      <-2, -1, 0>
      < 2,  1, -2>
    }
    rotate <0,0, 90>
    translate EarLength*z
  }
  cylinder
  {
    0*z,  EarLength*z,  EarThickness
    translate -EarRadius*y
  }
  scale <.5, .5, 1>
}

union {
  object {
    LensFrame
    translate 1.4*x
  }
  object {
    LensFrame
    translate -1.4*x
  }
  object {
    EarPiece
    translate <2.3, EarRadius+Bridgey, 0>
  }
  object {
    EarPiece
    rotate <4, 45, 0>
    translate <-2.3, EarRadius+Bridgey, 0>
  }
  difference { // bridge - torus cut in half
    torus
    {
      0.5,
      0.05
    }
    box
    {
      <-1, -1, 0>
      < 1,  1, .6>
    }
    scale <1.0, 1.5, 0.25>
    translate Bridgey*y
  }
  object {
    NosePiece
    rotate -5*z
    translate <0.3, 1.25, 0>
  }
  object {
    NosePiece
    rotate 5*z
    translate <-0.3, 1.25, 0>
  }
  texture { Polished_Brass }
  rotate <12, -10, 0>
  translate <-1, 0, -5>
}
