
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

global_settings
{
  radiosity { distance_maximum 30 }
  max_trace_level 5  assumed_gamma 2.2
}

// ----------------------------------------
#declare CameraPos = <0.0, 25, -22.0>
#declare Angle = 40
#declare LookAt = <-3, 0, 0>
//#declare CameraPos = <0, 10, -25.0>
//#declare Angle = 10
//#declare LookAt = <0, 4, 8>

camera
{
  location  CameraPos
  look_at   LookAt
  angle Angle
}

light_source
{
  0*x // light's position (translated below)
  color rgb <0.5, 0.5, 0.5>
  translate CameraPos
  shadowless
}

// ----------------------------------------
// scene description -
//          One sheet of music notation - Minuet
//          Book of Rules
//          Two dice
//          Pen in inkwell
//          Lit Candle providing light
//          Eyeglasses
//          Desk

// setting the following declarations to zero results in a simplified object being modelled.
#declare TrueDesk = 1.0
#declare TrueRules = 1.0
#declare TrueMusic = 1.0
#declare TrueDice = 1.0
#declare TrueCandle = 1.0
#declare TruePen = 1.0
#declare TrueGlasses = 1.0

#include "Desktop.inc"
#include "Rules.inc"
#include "Sheet.inc"
#include "Dice.inc"
#include "Candle.inc"
#include "Pen.inc"
#include "Glasses.inc"
