// Pen and Inkwell
// Set TruePen = 1.0 to get complete model

#declare Penx = 0.0
#declare Peny = 0.0
#declare Penz = 8.0

#if (TruePen)
#include "BottleTop.inc"
#include "Quill.inc"
#include "Feather.inc"

union {
  box // ink
  {
    <-1.4, 0.1, -.9>  // one corner position <X1 Y1 Z1>
    < 1.4, 1.9,  .9>  // other corner position <X2 Y2 Z2>
    pigment { color rgb <.1, 0, .1> }
  }
  merge { // bottle
    difference {
      box { <-1.5, 0, -1> <1.5, 2, 1> }
      box { <-1.4, 0.1, -.9> <1.4, 2.1, .9> }
    }
    object { BottleTop }
    #declare BotRot=30
    #while (BotRot < 180)
      sphere { <0, 0, 0> .75 scale <1, .3, .1> translate <.75,0,-1> rotate BotRot*z }
      #declare BotRot=BotRot+30
    #end
    pigment { color rgbt<1,1,1,.95> }
    finish { phong_size 200 phong 0.8 reflection 0.4 refraction on ior 1.5 }
  }
  rotate -10*y
  translate <Penx, Peny, Penz-1.0>
}

union { // quillpen
  object { Quill pigment {color rgb<1,1,1>} }
  object
  {
    Feather
    pigment
    {
      gradient y
      color_map { [ 0.5 color rgb<.4, .4, .4> ] [ 1.0 color rgb <.6, .6, .6> ] }
      scale <1, .2, 1>
      rotate 10*z
    }
  }
  rotate <-30, -10, 0>
  translate <Penx, Peny+1, Penz>
}

#else

box
{
  <-1.5, 0, -1>  // one corner position <X1 Y1 Z1>
  < 1.5,  2,  1>  // other corner position <X2 Y2 Z2>
  pigment { color rgb <.1, 0, .1> }
  rotate -10*y
  translate <Penx, Peny, Penz-1.0>
}

cylinder
{
  2*y, 9*y, .1
  pigment { color rgb <1,1,1> }
  rotate <-30, -10, 0>
  translate <Penx, Peny, Penz>
}
#end
