
// Rules.inc - Rule Book
// Set TrueRules = 1.0 to get complete model

#declare Gold_Metal = texture
{
  pigment
  {
    colour rgb<0.847,0.847,0.098>
  }
  finish {
    ambient 0.2
    diffuse 0.7
    brilliance 6.0
    phong 0.75    phong_size 80    metallic
    reflection 0.25
  }
}


// create a box that extends between the 2 specified points
#if (TrueRules)
union
{
  difference // cover
  {
    superellipsoid
    {
      <0.05, 0.12>
      scale <2.5, 0.25, 4>
    }
    box { <-2.4, -.15, -5> <3, 0.15, 5> }
    cylinder { <-2.2, 0.25, -5>, <-2.2, 0.25, 5>, .1 }
    pigment { color rgb<0.05, 0.05, 0.05> }
    normal { bumps 0.3 scale .05 }
    finish {
      phong_size 10
      phong 0.1
    }
  }
  union {
    text {
      ttf "OLDENG.TTF",
     "Musikalisches",
      0.15, <0.1, 0, 0>
      rotate 90*x
      translate 1*z
    }
    text {
      ttf "OLDENG.TTF",
      "  Wurfelspiel",
      0.15, <0.1, 0, 0>
      rotate 90*x
    }
    text {
      ttf "OLDENG.TTF", // has no umlaut
      "..",
      0.15, <0, 0, 0>
      rotate 90*x
      translate <1.75, 0, .55>
    }
    text {
      ttf "OLDENG.TTF", // has no umlaut
      "~",
      0.15, <0, 0, 0>
      rotate 90*x
      translate <0.65, 0, -.75>
      scale <4, 1, 1>
    }
    text {
      ttf "OLDENG.TTF", // has no umlaut
      "Wolfgang Amadeus Mozart",
      0.15, <0, 0, 0>
      rotate 90*x
      translate <1.5, 0, -2.5>
      scale <.5, 1, .5>
    }
    texture { Gold_Metal }
    scale <.5, .5, 1>
    translate <-1.6, 0.3, 1>
  }
  box { <-2.4, -.15, -3.7> <2.2, 0.15, 3.7> pigment { color rgb<1,1,1> } } // pages
  translate <-10, .25, 0>
  rotate -30*y
}

#else

box
{
  <-2.5, 0.00, -4>  // one corner position <X1 Y1 Z1>
  < 2.5, 0.5,  4>  // other corner position <X2 Y2 Z2>
  pigment { color <0, 0, 0> }
  translate -10*x
  rotate -30*y
}

#end
