//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 9 lights, 23 textures and 179 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/27/1998    (27.04.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.65212,0.65212,0.29988>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 50
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <14.100, -26.800, 9.350>
  direction <0.0,     0.0,  1.9592>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-3.375, -1.330, 5.808>
}

//
// *******  L I G H T S *******
//

light_source {   // Spotlight SpotL001
  <0.038, -5.384, 7.347>
  color  rgb <0.596, 0.596, 0.596>
  spotlight
    point_at  <0.038, -4.609, 6.714>
    falloff   18.70  // outer radius (in deg)
      radius    14.10  // inner radius
  atmospheric_attenuation on
}

light_source { // AreaL3
  <4.930, -10.250, 12.420>
  color  rgb<2.008, 2.008, 0.714>
  area_light <0.120, 0.000, 0.000>, <0.000, -0.000, -0.360>, 1, 3
  adaptive 1
  jitter
  atmospheric_attenuation on
}


light_source { // AreaL001
  <-7.000, -1.800, 6.000>
  color  rgb<2.008, 1.020, -0.910>
  area_light <-0.000, 0.100, 0.000>, <0.000, 0.000, -0.300>, 1, 3
  adaptive 1
  jitter
  atmospheric_attenuation on
}



//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  TEXTURES  *******
//

#include "klavier.inc"
#include "feuer.inc"

//
// ********  REFERENCED OBJECTS  *******
//

#declare Cylndr002 = object {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    texture {
      Weiss
    }
    scale <0.270685, 0.211551, 0.05>
    translate  <-5.144628, -8.061888, 0.0>
  }
}


// Include contains 'TraSwp3'
#include "klavier.in1"

#declare TraSwp3 = object {
  TraSwp3_Raw
  scale <0.2, 0.2, 30.0>
  rotate <-180.0, -90.0, 0.0>
  translate  <-35.2, -0.19, 0.19>
}


// Include contains 'TraSwp003'
#include "klavier.in2"

#declare TraSwp003 = object {
  TraSwp003_Raw
  scale 2.0
  rotate 90.0*x
  translate  <14.0, 1.0, 2.5>
}
//
// Include file contains 'RotSwp001'
//
#include "klavier.in3"
#declare RotSwp001 = object {
  RotSwp001_Raw
  translate  2.5*z
}
//
// Include file contains 'RotSwp002'
//
#include "klavier.in4"
#declare RotSwp002 = object {
  RotSwp002_Raw
}
#declare Kerzenstaender = union {
  torus { // Torus001
    2.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.5>
  }
  object { TraSwp003 }
  object { RotSwp001 }
  object { RotSwp002 }
  texture {
    Bronze_Metal1
  }
}
//
// Include file contains 'RotSwp003'
//
#include "klavier.in5"
#declare RotSwp003 = object {
  RotSwp003_Raw
  texture {
    Jade1
  }
  translate  7.78*z
}
#declare BzPtch002 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <0.018537, 0.000000, 1.809024>, <0.018537, -1.000000, 1.809024>, <2.018537, -1.000000, 1.809024>, <2.018537, 0.000000, 1.809024>,
      <2.246585, 0.000000, 2.981463>, <2.246585, -1.000000, 2.981463>, <4.246585, -1.000000, 2.981463>, <4.246585, 0.000000, 2.981463>,
      <-1.190976, 0.000000, 4.917805>, <-1.190976, -1.000000, 4.917805>, <0.809024, -1.000000, 4.917805>, <0.809024, 0.000000, 4.917805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>,
      <2.018537, 0.000000, 1.809024>, <2.018537, 1.000000, 1.809024>, <0.018537, 1.000000, 1.809024>, <0.018537, 0.000000, 1.809024>,
      <4.246585, 0.000000, 2.981463>, <4.246585, 1.000000, 2.981463>, <2.246585, 1.000000, 2.981463>, <2.246585, 0.000000, 2.981463>,
      <0.809024, 0.000000, 4.917805>, <0.809024, 1.000000, 4.917805>, <-1.190976, 1.000000, 4.917805>, <-1.190976, 0.000000, 4.917805>
    }
  }
  texture {
    Rusty_Iron1
  }
  scale <0.1, 0.1, 0.5>
  translate  13.0*z
}
#declare Kerze = union {
  object { RotSwp003 }
  object { BzPtch002 }
  cylinder { // Flamme
    <0,0,1>, <0,0,0>, 1
    texture {
      Feuer
    }
    hollow
    scale <0.4, 0.4, 3.0>
    translate  <0.05, 0.0, 14.0>
  }
}
#declare KStaender_m_K = union { // KStaender_m_K
  object { Kerzenstaender }
  object { Kerze }
  scale 0.1
  rotate 90.0*z
  translate  <-7.0, -1.8, 4.45>
}
#declare BzPtch003 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -0.550000, 0.000000>, <-0.578183, -0.333923, 0.000000>, <0.000000, -0.333923, 0.000000>,
      <-0.719075, 0.000000, 1.421642>, <-0.719075, -0.550000, 1.421642>, <-0.560192, -0.333923, 1.421642>, <-0.378872, -0.333923, 1.502494>,
      <1.464252, 0.000000, 3.223456>, <1.464252, -1.808328, 3.223456>, <2.020037, -1.097895, 3.223456>, <4.185640, -1.097895, 3.223456>,
      <-3.667871, 0.000000, 6.818730>, <-3.667871, -0.550000, 6.818730>, <-3.382763, -0.333923, 6.818730>, <-2.804580, -0.333923, 6.818730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.333923, 0.000000>, <0.578183, -0.333923, 0.000000>, <1.000000, -0.550000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <-0.378872, -0.333923, 1.502494>, <-0.197551, -0.333923, 1.583346>, <0.262078, -0.550000, 1.583346>, <0.262078, 0.000000, 1.583346>,
      <4.185640, -1.097895, 3.223456>, <6.351243, -1.097895, 3.223456>, <6.950683, -1.808328, 3.223456>, <6.950683, 0.000000, 3.223456>,
      <-2.804580, -0.333923, 6.818730>, <-2.226397, -0.333923, 6.818730>, <-1.667871, -0.550000, 6.818730>, <-1.667871, 0.000000, 6.818730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 0.550000, 0.000000>, <0.578183, 0.333923, 0.000000>, <0.000000, 0.333923, 0.000000>,
      <0.262078, 0.000000, 1.583346>, <0.262078, 0.550000, 1.583346>, <-0.197551, 0.333923, 1.583346>, <-0.378872, 0.333923, 1.502494>,
      <6.950683, 0.000000, 3.223456>, <6.950683, 1.808328, 3.223456>, <6.351243, 1.097895, 3.223456>, <4.185640, 1.097895, 3.223456>,
      <-1.667871, 0.000000, 6.818730>, <-1.667871, 0.550000, 6.818730>, <-2.226397, 0.333923, 6.818730>, <-2.804580, 0.333923, 6.818730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.333923, 0.000000>, <-0.578183, 0.333923, 0.000000>, <-1.000000, 0.550000, 0.000000>, <-1.000000, 0.000000, 0.000000>,
      <-0.378872, 0.333923, 1.502494>, <-0.560192, 0.333923, 1.421642>, <-0.719075, 0.550000, 1.421642>, <-0.719075, 0.000000, 1.421642>,
      <4.185640, 1.097895, 3.223456>, <2.020037, 1.097895, 3.223456>, <1.464252, 1.808328, 3.223456>, <1.464252, 0.000000, 3.223456>,
      <-2.804580, 0.333923, 6.818730>, <-3.382763, 0.333923, 6.818730>, <-3.667871, 0.550000, 6.818730>, <-3.667871, 0.000000, 6.818730>
    }
  }
  scale <0.3, 0.5, 0.8>
  rotate 90.0*y
  translate  1.0*x
}
//
// Include file contains 'RotSwp5'
//
#include "klavier.in6"
#declare RotSwp5 = object {
  RotSwp5_Raw
  translate  2.5*z
}
//
// Include file contains 'RotSwp6'
//
#include "klavier.in7"
#declare RotSwp6 = object {
  RotSwp6_Raw
}
#declare Kerzenstaende2 = union {
  torus { // Torus3
    2.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.5>
  }
  object { RotSwp5 }
  object { RotSwp6 }
  texture {
    Bronze_Metal1
  }
}
//
// Include file contains 'RotSwp7'
//
#include "klavier.in8"
#declare RotSwp7 = object {
  RotSwp7_Raw
  texture {
    Jade1
  }
  translate  7.78*z
}
#declare BzPtch6 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <0.018537, 0.000000, 1.809024>, <0.018537, -1.000000, 1.809024>, <2.018537, -1.000000, 1.809024>, <2.018537, 0.000000, 1.809024>,
      <2.246585, 0.000000, 2.981463>, <2.246585, -1.000000, 2.981463>, <4.246585, -1.000000, 2.981463>, <4.246585, 0.000000, 2.981463>,
      <-1.190976, 0.000000, 4.917805>, <-1.190976, -1.000000, 4.917805>, <0.809024, -1.000000, 4.917805>, <0.809024, 0.000000, 4.917805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>,
      <2.018537, 0.000000, 1.809024>, <2.018537, 1.000000, 1.809024>, <0.018537, 1.000000, 1.809024>, <0.018537, 0.000000, 1.809024>,
      <4.246585, 0.000000, 2.981463>, <4.246585, 1.000000, 2.981463>, <2.246585, 1.000000, 2.981463>, <2.246585, 0.000000, 2.981463>,
      <0.809024, 0.000000, 4.917805>, <0.809024, 1.000000, 4.917805>, <-1.190976, 1.000000, 4.917805>, <-1.190976, 0.000000, 4.917805>
    }
  }
  texture {
    Rusty_Iron1
  }
  scale <0.1, 0.1, 0.5>
  translate  13.0*z
}
#declare Kerze2 = union {
  object { RotSwp7 }
  object { BzPtch6 }
  cylinder { // Flamme2
    <0,0,1>, <0,0,0>, 1
    texture {
      Feuer
    }
    scale <0.4, 0.4, 3.0>
    translate  <0.05, 0.0, 14.0>
  }
}
#declare KStaender_m_K2 = union {
  object { Kerzenstaende2 }
  object { Kerze2 }
  scale 0.3
  translate  <6.7, 0.0, 1.4>
}
#declare Torus002 = object {
  torus { // Torus002
    1.75, 0.25  rotate -x*90
    scale <0.2, 0.4, 0.4>
    rotate -90.0*x
    translate  2.0*z
  }
}


#declare TraSwp25 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.1, -0.0>,
  <0.1, -0.0>,
  <0.1, 0.5>,
  <0.06, 0.5>,
  <0.06, 1.0>,
  <-0.1, 1.0>,
  <-0.1, -0.0>
  rotate -x*90
  scale <1.0, 1.0, 0.4>
  rotate -90.0*z
  translate  <-2.6, 4.31, 3.5>
}
#declare TraSwp24 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <0.1, -0.0>,
  <-0.1, -0.0>,
  <-0.1, 0.5>,
  <-0.06, 0.5>,
  <-0.06, 1.0>,
  <0.06, 1.0>,
  <0.06, 0.5>,
  <0.1, 0.5>,
  <0.1, -0.0>
  rotate -x*90
  scale <1.0, 1.0, 0.4>
  rotate -90.0*z
  translate  <-2.6, 4.1, 3.5>
}
#declare TraSwp23 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <0.1, -0.0>,
  <-0.1, -0.0>,
  <-0.1, 0.5>,
  <-0.06, 0.5>,
  <-0.06, 1.0>,
  <0.1, 1.0>,
  <0.1, -0.0>
  rotate -x*90
  scale <1.0, 1.0, 0.4>
  rotate -90.0*z
  translate  <-2.6, 3.89, 3.5>
}
#declare TraSwp26 = object {
  object { // TraSwp26->TraSwp25
    TraSwp25
    rotate <0.0, 0.0, 0.0>
    translate  -0.63*y
  }
}
#declare TraSwp27 = object {
  object { // TraSwp27->TraSwp26
    TraSwp26
    translate  <-0.0, -0.84, 0.0>
  }
}
#declare TraSwp28 = object {
  object { // TraSwp28->TraSwp27
    TraSwp27
    translate  -0.63*y
  }
}
#declare TraSwp29 = object {
  object { // TraSwp29->TraSwp28
    TraSwp28
    translate  -0.84*y
  }
}
#declare TraSwp30 = object {
  object { // TraSwp30->TraSwp29
    TraSwp29
    translate  -0.63*y
  }
}
#declare TraSwp31 = object {
  object { // TraSwp31->TraSwp30
    TraSwp30
    translate  -0.84*y
  }
}
#declare TraSwp32 = object {
  object { // TraSwp32->TraSwp31
    TraSwp31
    translate  -0.64*y
  }
}
#declare TraSwp33 = object {
  object { // TraSwp33->TraSwp32
    TraSwp32
    translate  -0.85*y
  }
}
#declare TraSwp34 = object {
  object { // TraSwp34->TraSwp33
    TraSwp33
    translate  -0.63*y
  }
}
#declare TraSwp35 = object {
  object { // TraSwp35->TraSwp34
    TraSwp34
    translate  -0.85*y
  }
}
#declare TraSwp37 = object {
  object { // TraSwp37->TraSwp23
    TraSwp23
    rotate <-0.0, -0.0, 0.0>
    translate  -0.84*y
  }
}
#declare TraSwp38 = object {
  object { // TraSwp38->TraSwp37
    TraSwp37
    translate  <-0.0, -0.63, 0.0>
  }
}
#declare TraSwp39 = object {
  object { // TraSwp39->TraSwp38
    TraSwp38
    translate  -0.84*y
  }
}
#declare TraSwp40 = object {
  object { // TraSwp40->TraSwp39
    TraSwp39
    translate  -0.63*y
  }
}
#declare TraSwp41 = object {
  object { // TraSwp41->TraSwp40
    TraSwp40
    translate  -0.84*y
  }
}
#declare TraSwp42 = object {
  object { // TraSwp42->TraSwp41
    TraSwp41
    translate  -0.63*y
  }
}
#declare TraSwp43 = object {
  object { // TraSwp43->TraSwp42
    TraSwp42
    translate  -0.85*y
  }
}
#declare TraSwp44 = object {
  object { // TraSwp44->TraSwp43
    TraSwp43
    translate  -0.64*y
  }
}
#declare TraSwp45 = object {
  object { // TraSwp45->TraSwp44
    TraSwp44
    translate  -0.85*y
  }
}
#declare TraSwp46 = object {
  object { // TraSwp46->TraSwp45
    TraSwp45
    translate  -0.63*y
  }
}
#declare TraSwp48 = object {
  object { // TraSwp48->TraSwp24
    TraSwp24
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, -0.63, 0.0>
  }
}
#declare TraSwp49 = object {
  object { // TraSwp49->TraSwp48
    TraSwp48
    translate  -0.21*y
  }
}
#declare TraSwp50 = object {
  object { // TraSwp50->TraSwp49
    TraSwp49
    translate  -0.63*y
  }
}
#declare TraSwp51 = object {
  object { // TraSwp51->TraSwp50
    TraSwp50
    translate  -0.63*y
  }
}
#declare TraSwp52 = object {
  object { // TraSwp52->TraSwp51
    TraSwp51
    translate  -0.21*y
  }
}
#declare TraSwp53 = object {
  object { // TraSwp53->TraSwp52
    TraSwp52
    translate  -0.63*y
  }
}
#declare TraSwp54 = object {
  object { // TraSwp54->TraSwp53
    TraSwp53
    translate  -0.63*y
  }
}
#declare TraSwp55 = object {
  object { // TraSwp55->TraSwp54
    TraSwp54
    translate  -0.21*y
  }
}
#declare TraSwp56 = object {
  object { // TraSwp56->TraSwp55
    TraSwp55
    translate  -0.63*y
  }
}
#declare TraSwp57 = object {
  object { // TraSwp57->TraSwp56
    TraSwp56
    translate  -0.64*y
  }
}
#declare TraSwp58 = object {
  object { // TraSwp58->TraSwp57
    TraSwp57
    translate  -0.21*y
  }
}
#declare TraSwp59 = object {
  object { // TraSwp59->TraSwp58
    TraSwp58
    translate  -0.64*y
  }
}
#declare TraSwp60 = object {
  object { // TraSwp60->TraSwp59
    TraSwp59
    translate  -0.63*y
  }
}
#declare TraSwp61 = object {
  object { // TraSwp61->TraSwp60
    TraSwp60
    translate  -0.21*y
  }
}
#declare TraSwp62 = object {
  object { // TraSwp62->TraSwp61
    TraSwp61
    translate  -0.64*y
  }
}
#declare TraSwp63 = object {
  object { // TraSwp63->TraSwp62
    TraSwp62
    translate  -0.63*y
  }
}
#declare SuprQ11 = object {
  superellipsoid { // SuprQ11
    <0.1, 0.1>
    scale <0.25, 0.04, 0.15>
    translate  <-1.84, -4.225, 3.9>
  }
}
#declare SuprQ13 = object {
  object { // SuprQ13->SuprQ11
    SuprQ11
    translate  <-0.0, 0.42, 0.0>
  }
}
#declare SuprQ14 = object {
  object { // SuprQ14->SuprQ13
    SuprQ13
    translate  0.42*y
  }
}
#declare SuprQ15 = object {
  object { // SuprQ15->SuprQ14
    SuprQ14
    translate  0.21*y
  }
}
#declare SuprQ16 = object {
  object { // SuprQ16->SuprQ15
    SuprQ15
    translate  0.43*y
  }
}
#declare SuprQ18 = object {
  object { // SuprQ18->SuprQ16
    SuprQ16
    translate  0.42*y
  }
}
#declare SuprQ19 = object {
  object { // SuprQ19->SuprQ18
    SuprQ18
    translate  0.42*y
  }
}
#declare SuprQ20 = object {
  object { // SuprQ20->SuprQ19
    SuprQ19
    translate  0.21*y
  }
}
#declare SuprQ21 = object {
  object { // SuprQ21->SuprQ20
    SuprQ20
    translate  0.43*y
  }
}
#declare SuprQ23 = object {
  object { // SuprQ23->SuprQ21
    SuprQ21
    translate  0.42*y
  }
}
#declare SuprQ24 = object {
  object { // SuprQ24->SuprQ23
    SuprQ23
    translate  0.42*y
  }
}
#declare SuprQ25 = object {
  object { // SuprQ25->SuprQ24
    SuprQ24
    translate  0.21*y
  }
}
#declare SuprQ26 = object {
  object { // SuprQ26->SuprQ25
    SuprQ25
    translate  0.43*y
  }
}
#declare SuprQ28 = object {
  object { // SuprQ28->SuprQ26
    SuprQ26
    translate  0.42*y
  }
}
#declare SuprQ29 = object {
  object { // SuprQ29->SuprQ28
    SuprQ28
    translate  0.42*y
  }
}
#declare SuprQ30 = object {
  object { // SuprQ30->SuprQ29
    SuprQ29
    translate  0.21*y
  }
}
#declare SuprQ34 = object {
  object { // SuprQ34->SuprQ30
    SuprQ30
    translate  0.42*y
  }
}
#declare SuprQ35 = object {
  object { // SuprQ35->SuprQ34
    SuprQ34
    translate  0.21*y
  }
}
#declare SuprQ36 = object {
  object { // SuprQ36->SuprQ35
    SuprQ35
    translate  0.21*y
  }
}
#declare SuprQ37 = object {
  object { // SuprQ37->SuprQ36
    SuprQ36
    translate  0.42*y
  }
}
#declare SuprQ38 = object {
  object { // SuprQ38->SuprQ37
    SuprQ37
    translate  0.21*y
  }
}
#declare SuprQ39 = object {
  object { // SuprQ39->SuprQ38
    SuprQ38
    translate  0.42*y
  }
}
#declare SuprQ41 = object {
  object { // SuprQ41->SuprQ39
    SuprQ39
    translate  0.42*y
  }
}
#declare SuprQ42 = object {
  object { // SuprQ42->SuprQ41
    SuprQ41
    translate  0.42*y
  }
}
#declare BzPtch3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.010991, -5.928704, -0.016990>, <0.775987, -5.939112, -0.016990>, <1.422338, -5.951410, -0.009344>, <1.425346, -5.956033, 0.000000>,
      <-0.173129, -0.177024, 0.309374>, <1.451691, -0.240511, 0.309374>, <2.781414, -0.300961, 0.169716>, <2.781811, -0.311356, -0.000978>,
      <0.000419, 2.481978, 2.450881>, <1.356982, 2.481749, 2.450881>, <2.466896, 2.474565, 1.340988>, <2.466894, 2.466014, -0.015548>,
      <0.283642, 6.123508, 0.000022>, <0.768732, 6.123426, 0.000022>, <0.882412, 2.543235, 0.002961>, <0.882411, 2.539009, -0.000063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.425346, -5.956033, 0.000000>, <1.428354, -5.960657, 0.009344>, <0.786924, -5.955924, 0.016990>, <-0.000054, -5.945517, 0.016990>,
      <2.781811, -0.311356, -0.000978>, <2.782208, -0.321750, -0.171672>, <1.453134, -0.278311, -0.311331>, <-0.171686, -0.214823, -0.311331>,
      <2.466894, 2.466014, -0.015548>, <2.466893, 2.457462, -1.372085>, <1.356976, 2.450653, -2.481978>, <0.000413, 2.450881, -2.481978>,
      <0.882411, 2.539009, -0.000063>, <0.882410, 2.534782, -0.003087>, <0.768730, 6.107818, -0.000022>, <0.283639, 6.107900, -0.000022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000054, -5.945517, 0.016990>, <-0.787032, -5.935110, 0.016990>, <-1.433383, -5.922812, 0.009344>, <-1.436391, -5.918188, 0.000000>,
      <-0.171686, -0.214823, -0.311331>, <-1.796506, -0.151335, -0.311331>, <-3.126229, -0.090885, -0.171672>, <-3.126625, -0.080490, -0.000978>,
      <0.000413, 2.450881, -2.481978>, <-1.356150, 2.451110, -2.481978>, <-2.466064, 2.458294, -1.372085>, <-2.466063, 2.466845, -0.015548>,
      <0.283639, 6.107900, -0.000022>, <-0.201451, 6.107981, -0.000022>, <-0.881555, 2.535079, -0.003087>, <-0.881555, 2.539306, -0.000063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.436391, -5.918188, 0.000000>, <-1.439399, -5.913565, -0.009344>, <-0.797969, -5.918297, -0.016990>, <-0.010991, -5.928704, -0.016990>,
      <-3.126625, -0.080490, -0.000978>, <-3.127022, -0.070096, 0.169716>, <-1.797948, -0.113536, 0.309374>, <-0.173129, -0.177024, 0.309374>,
      <-2.466063, 2.466845, -0.015548>, <-2.466061, 2.475397, 1.340988>, <-1.356145, 2.482207, 2.450881>, <0.000419, 2.481978, 2.450881>,
      <-0.881555, 2.539306, -0.000063>, <-0.881554, 2.543533, 0.002961>, <-0.201449, 6.123590, 0.000022>, <0.283642, 6.123508, 0.000022>
    }
  }
  scale 0.1
  rotate -90.0*z
  translate  <-2.019239, -0.7, 0.59119>
}




#declare TraSwp002 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  7  // control points
  <-0.83926, -0.880943>,
  <-1.0, 1.0>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <-0.83926, -0.880943>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    Silver_Textur1
  }
  scale <0.5, 0.5, 0.025>
  rotate -1.0*y
  translate  <-0.25, -0.7, 0.24>
}


#declare Cube23 = object {
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.133176, 0.231678, 4.073286>
    rotate -15.0*y
    translate  1.5*x
  }
}




//
// ********  OBJECTS  *******
//

#declare TraSwp004 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.052062, 1.338139>,
  <-1.0, 1.0>,
  <-1.0, -1.0>,
  <1.015631, -1.151101>,
  <1.262049, -0.710122>,
  <0.716508, -0.172575>,
  <1.58204, 0.57547>,
  <1.218835, 1.187573>,
  <0.052062, 1.338139>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  scale <0.625487, 0.625487, 0.031274>
  translate  <-5.519141, -7.920945, -0.113234>
}
#declare Farbtablett = difference {
  object { TraSwp004 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.15, 0.15, 1.0>
    translate  <-5.105205, -7.671843, -0.377448>
  }
  translate  <0.378513, -0.715473, 3.128906>
}
union { // Tablett_m_Farbe
  object { Cylndr002 }
  object { // Cylndr3->Cylndr002
    Cylndr002
    texture {
      Schwarz
    }
    translate  <0.611048, -0.137979, 0.0>
  }
  object { // Cylndr4->Cylndr002
    Cylndr002
    texture {
      Blau2
    }
    translate  <-0.039422, -1.084117, 0.0>
  }
  object { // Cylndr5->Cylndr002
    Cylndr002
    texture {
      Blau1
    }
    translate  <-0.236535, -0.453358, 0.0>
  }
  object { Farbtablett }
  texture {
    Cherry_Wood3
  }
}


lathe { // RotSwp005
  quadratic_spline
  13  // control points
  <-0.013209, 0.01738>,
  <0.008825, 0.0038>,
  <2.673866, -0.010751>,
  <2.490558, 0.283317>,
  <1.1775, 0.416192>,
  <0.887304, 1.119091>,
  <1.191547, 1.714532>,
  <0.912369, 2.169235>,
  <0.856582, 3.17115>,
  <1.359428, 3.58982>,
  <0.903138, 4.244219>,
  <2.118055, 4.91017>,
  <-0.004994, 5.060745>
  rotate <90,0,90>
  texture {
    Bronze_Metal1
  }
  scale <0.3, 0.3, 0.6>
  translate  <-5.036287, -8.591166, 0.0>
}




box { // Decke
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Chrome_Metal1
  }
  scale <20.0, 20.0, 0.1>
  translate  15.0*z
}


union { // Fussleisten
  object { TraSwp3 }
  object { // TraSwp4->TraSwp3
    TraSwp3
    rotate <-0.0, -0.0, -0.0>
    translate  <25.6, 0.0, 0.0>
  }
  texture {
    Dark_Wood2
  }
}


object { // KStaender_m_K1->KStaender m K
  KStaender_m_K
  rotate <0.0, 0.0, 0.0>
  translate  14.0*x
}


#declare Bilderrahmen = difference {
  superellipsoid { // SuprQ004
    <0.2, 0.2>
    scale <1.8, 0.5, 1.4>
  }
  superellipsoid { // SuprQ005
    <0.1, 0.1>
    scale <1.6, 0.3, 1.2>
    translate  -0.2*y
  }
  texture {
    Cherry_Wood2
  }
}
union { // Bild
  box { // Bildflaeche
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 0.00001, 1.2>
    translate  -0.1*y
    texture {
      Texture03
      scale <2.2, 3.0, 1.0>
      rotate <-90.0, -90.0, 0.0>
      translate <-1.500000, 0.000000, -1.100000>
    }
  }
  object { Bilderrahmen }
  scale <1.2, 0.5, 1.2>
  translate  <0.0, -0.33, 10.0>
}


//
// Include file contains 'RotSwp004'
//
#include "klavier.in9"
#declare RotSwp004 = object {
  RotSwp004_Raw
}
#declare Kerzen = union {
  object { KStaender_m_K2 }
  object { // KStaender_m_K3->KStaender m K2
    KStaender_m_K2
    rotate <0.0, 0.0, -60.0>
    translate  -0.0*x
  }
  object { // KStaender_m_K4->KStaender m K2
    KStaender_m_K2
    rotate <0.0, 0.0, -120.0>
    translate  -0.0*x
  }
  object { // KStaender_m_K5->KStaender m K2
    KStaender_m_K2
    rotate <0.0, 0.0, -180.0>
    translate  -0.0*x
  }
  object { // KStaender_m_K6->KStaender m K2
    KStaender_m_K2
    rotate <0.0, 0.0, -240.0>
    translate  -0.0*x
  }
  object { // KStaender_m_K7->KStaender m K2
    KStaender_m_K2
    rotate <0.0, 0.0, -300.0>
    translate  -0.0*x
  }
}
#declare Kette = union {
  object { Torus002 }
  object { // Torus9->Torus002
    Torus002
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 1.0>
  }
  object { // Torus10->Torus002
    Torus002
    rotate <0.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 2.0>
  }
  object { // Torus11->Torus002
    Torus002
    rotate <0.0, 0.0, 90.0>
    translate  <-0.0, 0.0, 3.0>
  }
  object { // Torus12->Torus002
    Torus002
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 0.0, 4.0>
  }
  object { // Torus13->Torus002
    Torus002
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 5.0>
  }
  object { // Torus14->Torus002
    Torus002
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, -0.0, 6.0>
  }
  object { // Torus15->Torus002
    Torus002
    rotate <0.0, 0.0, 90.0>
    translate  <-0.0, 0.0, 7.0>
  }
  object { // Torus16->Torus002
    Torus002
    rotate <0.0, 0.0, -0.0>
    translate  <0.0, 0.0, 8.0>
  }
  object { // Torus17->Torus002
    Torus002
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, -0.0, 9.0>
  }
  object { // Torus18->Torus002
    Torus002
    rotate <0.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 10.0>
  }
}
union { // Kronenleuchter
  object { RotSwp004 }
  object { BzPtch003 }
  object { Kerzen }
  object { Kette }
  object { // BzPtch5->BzPtch003
    BzPtch003
    rotate -180.0*z
  }
  object { // BzPtch9->BzPtch003
    BzPtch003
    rotate -60.0*z
  }
  object { // BzPtch10->BzPtch003
    BzPtch003
    rotate -120.0*z
  }
  object { // BzPtch11->BzPtch003
    BzPtch003
    rotate 60.0*z
  }
  object { // BzPtch12->BzPtch003
    BzPtch003
    rotate 120.0*z
  }
  texture {
    Gold_Metal1
  }
  scale 0.4
  translate  <2.25, -10.25, 10.0>
}


box { // Boden
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Chrome_Metal1
  }
  scale <20.0, 20.0, 0.1>
  translate  -0.1*z
}


#declare TraSwp2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.481042, -6.012967>,
  <1.0, -6.012967>,
  <1.0, 1.0>,
  <-1.0, 1.000001>,
  <-1.234192, -1.61845>,
  <-2.908346, -2.002321>,
  <-2.91151, -2.715326>,
  <-1.286094, -2.814054>,
  <-1.481042, -6.012967>
  rotate -x*90
  scale <1.0, 1.0, 0.5>
  rotate 90.0*x
  translate  <0.0, 5.0, 6.0>
}
#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.481042, -6.012967>,
  <1.0, -6.012967>,
  <1.0, 1.0>,
  <-1.0, 1.000001>,
  <-1.234192, -1.61845>,
  <-2.908346, -2.002321>,
  <-2.91151, -2.715326>,
  <-1.286094, -2.814054>,
  <-1.481042, -6.012967>
  rotate -x*90
  scale <1.0, 1.0, 0.5>
  rotate 90.0*x
  translate  <0.0, -5.0, 6.0>
}
#declare KGehaeuse = union {
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.23, 5.0, 0.1>
    translate  <-0.229829, -0.25, 0.096517>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 5.0, 0.1>
    rotate -86.5*y
    translate  <-1.279632, -0.25, 1.64452>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 5.0, 0.1>
    rotate 3.5*y
    translate  <-2.081726, -0.25, 3.33421>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.175, 5.0, 0.1>
    rotate -90.0*y
    translate  <-2.813406, -0.25, 3.458269>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 5.0, 0.1>
    rotate -85.0*y
    translate  <-1.009811, -0.25, 5.168815>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 5.0, 0.1>
    rotate -90.0*y
    translate  <0.9, -0.25, 3.5>
  }
  object { TraSwp2 }
  object { TraSwp001 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 0.1>
    translate  <0.0, -0.25, 6.9>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 5.0, 0.1>
    translate  <-2.706754, -0.25, 3.518481>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.1, 0.1>
    translate  <-2.0, 4.5, 3.518>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.1, 0.1>
    translate  <-2.0, -5.0, 3.518>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 4.75, 0.85>
    rotate <-0.000006, 2.822829, 0.000001>
    translate  <-1.267435, -0.25, 5.119415>
  }
  superellipsoid { // SuprQ002
    <0.1, 0.1>
    scale <-0.369619, -1.5, -0.045746>
    rotate -180.0*z
    translate  <-1.720188, -0.25, 4.774588>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 5.0, 0.05>
    translate  <-1.340392, -0.25, 3.677337>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 4.75, 0.15>
    rotate <-0.00004, 5.633254, 0.000018>
    translate  <-1.449651, -0.25, 5.677959>
  }
  texture {
    Cherry_Wood1
  }
  translate  0.25*y
}
#declare Tasten_weiss = union {
  object { TraSwp25 }
  object { TraSwp24 }
  object { TraSwp23 }
  box { // Taste2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.1, 0.2>
    translate  <-2.1, -4.54, 3.7>
  }
  box { // Taste1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.1, 0.2>
    translate  <-2.1, 4.52, 3.7>
  }
  object { TraSwp26 }
  object { TraSwp27 }
  object { TraSwp28 }
  object { TraSwp29 }
  object { TraSwp30 }
  object { TraSwp31 }
  object { TraSwp32 }
  object { TraSwp33 }
  object { TraSwp34 }
  object { TraSwp35 }
  object { // TraSwp36->TraSwp35
    TraSwp35
    translate  -0.63*y
  }
  object { TraSwp37 }
  object { TraSwp38 }
  object { TraSwp39 }
  object { TraSwp40 }
  object { TraSwp41 }
  object { TraSwp42 }
  object { TraSwp43 }
  object { TraSwp44 }
  object { TraSwp45 }
  object { TraSwp46 }
  object { // TraSwp47->TraSwp46
    TraSwp46
    translate  -0.84*y
  }
  object { TraSwp48 }
  object { TraSwp49 }
  object { TraSwp50 }
  object { TraSwp51 }
  object { TraSwp52 }
  object { TraSwp53 }
  object { TraSwp54 }
  object { TraSwp55 }
  object { TraSwp56 }
  object { TraSwp57 }
  object { TraSwp58 }
  object { TraSwp59 }
  object { TraSwp60 }
  object { TraSwp61 }
  object { TraSwp62 }
  object { TraSwp63 }
  object { // TraSwp64->TraSwp63
    TraSwp63
    translate  -0.21*y
  }
  texture {
    White_Wood1
  }
  translate  -0.1*z
}
#declare Tasten_schwarz = union {
  object { SuprQ11 }
  object { // SuprQ12->SuprQ11
    SuprQ11
    translate  <-0.0, 0.21, 0.0>
  }
  object { SuprQ13 }
  object { SuprQ14 }
  object { SuprQ15 }
  object { SuprQ16 }
  object { // SuprQ17->SuprQ16
    SuprQ16
    translate  0.21*y
  }
  object { SuprQ18 }
  object { SuprQ19 }
  object { SuprQ20 }
  object { SuprQ21 }
  object { // SuprQ22->SuprQ21
    SuprQ21
    translate  0.21*y
  }
  object { SuprQ23 }
  object { SuprQ24 }
  object { SuprQ25 }
  object { SuprQ26 }
  object { // SuprQ27->SuprQ26
    SuprQ26
    translate  0.21*y
  }
  object { SuprQ28 }
  object { SuprQ29 }
  object { SuprQ30 }
  object { SuprQ34 }
  object { SuprQ35 }
  object { SuprQ36 }
  object { SuprQ37 }
  object { SuprQ38 }
  object { SuprQ39 }
  object { // SuprQ40->SuprQ39
    SuprQ39
    translate  0.21*y
  }
  object { SuprQ41 }
  object { SuprQ42 }
  object { // SuprQ43->SuprQ42
    SuprQ42
    translate  0.21*y
  }
  texture {
    Dark_Wood1
  }
  translate  -0.1*z
}
#declare Pedalen = union {
  object { BzPtch3 }
  object { // BzPtch4->BzPtch3
    BzPtch3
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.7, 0.0>
  }
  object { // BzPtch7->BzPtch3
    BzPtch3
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 1.4, 0.0>
  }
  texture {
    Bronze_Metal1
  }
}
union { // Klavier
  object { KGehaeuse }
  object { Tasten_weiss }
  object { Tasten_schwarz }
  object { Pedalen }
  rotate 90.0*z
  translate  <0.0, -1.0, 0.0>
}


box { // Wand
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Texture01
  }
  scale <0.25, 30.0, 10.0>
  rotate 90.0*z
  translate  <-0.0, 0.26, 10.0>
}


#declare Beine = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 0.8>
    translate  <-6.0, 1.5, 0.8>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 0.8>
    translate  <-6.0, -1.5, 0.8>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 0.8>
    translate  <-8.0, 1.5, 0.8>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 0.8>
    translate  <-8.0, -1.5, 0.8>
  }
  texture {
    White_Wood1
  }
}
#declare Rahmen_unten = union {
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <-7.0, -1.5, 1.7>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <-7.0, 1.5, 1.7>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.6, 0.1>
    translate  <-8.0, 0.0, 1.7>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.6, 0.1>
    translate  <-6.0, 0.0, 1.7>
  }
  texture {
    White_Wood1
  }
}
#declare Gestaenge = union {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.02, 0.08>
    rotate -20.0*y
    translate  <-7.0, 1.38, 2.0>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.02, 0.08>
    rotate -20.0*y
    translate  <-7.0, -1.38, 2.0>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.02, 0.08>
    rotate 20.0*y
    translate  <-7.0, 1.38, 2.0>
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.02, 0.08>
    rotate 20.0*y
    translate  <-7.0, -1.38, 2.0>
  }
  texture {
    Bronze_Metal1
  }
}
#declare Rahmen_oben = union {
  superellipsoid { // SuprQ003
    <0.1, 0.1>
    scale <0.1, 1.6, 0.1>
    translate  <-6.0, 0.0, 2.3>
  }
  superellipsoid { // SuprQ31
    <0.1, 0.1>
    scale <0.1, 1.6, 0.1>
    translate  <-8.0, 0.0, 2.3>
  }
  superellipsoid { // SuprQ32
    <0.1, 0.1>
    scale <1.1, 0.1, 0.1>
    translate  <-7.0, 1.5, 2.3>
  }
  superellipsoid { // SuprQ33
    <0.1, 0.1>
    scale <1.1, 0.1, 0.1>
    translate  <-7.0, -1.5, 2.3>
  }
  texture {
    White_Wood1
  }
}
union { // Hocker
  object { Beine }
  object { Rahmen_unten }
  object { Gestaenge }
  object { Rahmen_oben }
  superellipsoid { // Sitzflaeche
    <0.1, 1.0>
    texture {
      Texture02
    }
    scale <1.0, 1.5, 0.3>
    translate  <-7.0, 0.0, 2.4>
  }
  rotate 90.0*z
}


object { KStaender_m_K }


#declare TraSwp5 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <1.001144, 1.000842>,
  <0.497242, 0.996151>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <-0.497261, 0.99835>,
  <-0.999438, 0.998132>,
  <0.601727, -0.649438>,
  <-0.63297, -0.648704>,
  <1.001144, 1.000842>,
  <0.497242, 0.996151>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    Silver_Textur1
  }
  scale <0.5, 0.5, 0.025>
  rotate -1.0*y
  translate  0.24*z
}
#declare Verzierungen = union {
  object { TraSwp5 }
  object { TraSwp002 }
  object { // TraSwp6->TraSwp002
    TraSwp002
    rotate <-0.0, 0.0, 180.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // TraSwp7->TraSwp002
    TraSwp002
    rotate <-0.0, 0.0, -90.0>
    translate  <0.45, 0.45, -0.0>
  }
  object { // TraSwp8->TraSwp002
    TraSwp002
    rotate <-0.0, 0.0, 90.0>
    translate  <-0.45, -0.45, -0.0>
  }
}
union { // Buch
  superellipsoid { // SuprQ001
    <0.1, 0.1>
    texture {
      Tom_Wood1
    }
    scale <1.05, 1.5, 0.03>
    rotate -1.0*y
    translate  <0.02, 0.0, 0.21>
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture01
    }
    scale <1.0, 1.41, 0.2>
  }
  superellipsoid { // SuprQ2
    <0.1, 0.1>
    texture {
      Tom_Wood1
    }
    scale <1.05, 1.5, 0.03>
    translate  <0.02, 0.0, -0.21>
  }
  superellipsoid { // SuprQ3
    <0.1, 0.1>
    texture {
      Tom_Wood1
    }
    scale <0.23, 1.5, 0.03>
    rotate -90.0*y
    translate  -1.0*x
  }
  object { Verzierungen }
  scale 0.5
  rotate 84.43512*x
  translate  <0.0, -2.696794, 5.580591>
}


#declare Staender = union {
  object { Cube23 }
  object { // Cube24->Cube23
    Cube23
    rotate 30.0*y
    translate  <-1.817967, 0.0, 0.788022>
  }
  object { // Cube25->Cube23
    Cube23
    rotate <-47.151783, 14.361093, -4.37746>
    translate  <-0.827423, -2.734604, 1.308598>
  }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    scale <3.679275, 0.211978, 0.211978>
    rotate -16.600025*x
    translate  <0.236407, 0.401527, -0.859765>
  }
  texture {
    DMFLightOak1
  }
  rotate 16.600025*x
}
union { // Bild_m_Staender
  object { Staender }
  box { // Bild1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Bildtextur
      scale <2.0, 2.0, 1.0>
      rotate <0.0, -90.0, 90.0>
      translate <1.000000, -1.000000, -1.000000>
    }
    scale <-3.403468, -0.054102, -1.788022>
    rotate <161.430115, 0.0, -180.0>
    translate  <0.315209, 0.023076, 1.214684>
  }
  rotate -144.323364*z
  translate  <-8.7426, -5.044111, 3.732241>
}


