
// Persistence of Vision Ray Tracer Scene Description File
// File: searlite.inc
// Vers: 3
// Desc: A search light
// Date: 10/05/97
// Auth: Bob Franke
//

#version 3

#include "colors.inc"
#include "finish.inc"
#include "textures.inc"

#declare mainLight=
union{
  union{ //============ start the light ================

    light_source{<.0001,3.5,0>  color rgb <0.961, 0.961, 1.1>*.1 shadowless atmosphere off}

    light_source {
      <.01,3.5,0> color rgb <0.961, 0.961, 1.1>.125
      cylinder
      radius  16
      falloff 16
      point_at <500, 3.5, 0>
    }


    object{
      difference{
        sphere{<0,3.5,0>,2.5}
        sphere{<0,3.5,0>,29/12}
      }
      clipped_by{plane{x,0}}
      scale<.3,1,1>
      texture{pigment{SteelBlue } finish{Shiny}}
    }

// ------inside surface
    difference{  
      cylinder{<0,3.5,0>,<2.44,3.5,0>,29/12}
      cylinder{<-1,3.5,0>,<3.5,3.5,0>,28.99/12}
      pigment{color rgb <0.961, 0.961, 1.1>*1.9}
   }

 //-------- the lens glass
    cylinder{<2.44,3.5,0>,<2.5,3.5,0>,29/12 
      texture {
        pigment { color rgbf<1.0, 1.0, 1.0, 0.95> }
        finish  { Glass_Finish }
      }
    }

    difference{
      cylinder{<0,3.5,0>,<2.5,3.5,0>,2.5}
      cylinder{<-1,3.5,0>,<3.5,3.5,0>,29/12}
      texture{pigment{SteelBlue } finish{Shiny}}
    }
    difference{
      cylinder{<28/12,3.5,0>,<2.5,3.5,0>,2.6}
      cylinder{<20/12,3.5,0>,<3.5,3.5,0>,2.5}
      texture{pigment{SteelBlue } finish{Shiny}}
    }

    object{
      torus {2.5, 0.075 texture{pigment{SteelBlue } finish{Shiny}}}
      clipped_by{cylinder{<0,-10,0>,<0,10,0>,2.5 inverse}}
      rotate<0,0,90>
      translate<.85,3.5,0>
    }

    cylinder{<1.125,3.5,-29/12>,<1.125,3.5,-3>,.125 texture{pigment{SteelBlue } finish{Shiny}}}
    cylinder{<1.125,3.5,29/12>,<1.125,3.5,3>,.125 texture{pigment{SteelBlue } finish{Shiny}}}

    cylinder{<1.125,3.5,-3>,<1.125,3.5,-3.0625>,.25 texture{pigment{SteelBlue } finish{Shiny}}}
    cylinder{<1.125,3.5,3>,<1.125,3.5,3.0625>,.25 texture{pigment{SteelBlue } finish{Shiny}}}


    translate<-1.125,-3.5,0>
    rotate<0,0,zAngle>
    translate<1.125,3.5,0>
  } //============ end the light  ================


//========================<  start of tire  >==================='

  merge{ // ============ the saddle ring ==========
    difference{
     cylinder{<0.85,3.5,0>,<1.39,3.5,0>,3}
     cylinder{<0.15,3.5,0>,<2.39,3.5,0>,2.9375}
     clipped_by{plane{y,3.5}}
     translate<0,-.25,0>
    }
    box{<.85,3.25,3>,<1.39,3.75,2.9375>}
    box{<.85,3.25,-3>,<1.39,3.75,-2.9375>}

    object{
      sphere{<1.125,0,0>,1 scale<1,.5,1>}
      clipped_by{plane{y,0 inverse}}
    }
    texture{pigment{Bronze} finish{Dull}}

  } // ============ end of saddle ring ==========
}

#declare tire=
union{
  difference{
    torus{16,3}
    cylinder{<0,-10,0>,<0,10,0>,15}
    rotate<90,0,0>
    translate<0,19,0>
    pigment{White*.25}
  }

  merge{
    object{
      torus{14,1}
      clipped_by{plane{y,0}}
      clipped_by{cylinder{<0,-10,0>,<0,10,0>,14 inverse}}
    }
    cylinder{<0,-1,0>,<0,-1.002,0>,14}
    rotate<-90,0,0>
    translate<0,19,-2.65>
    pigment{White*.5}
  }

  merge{
    sphere{<0,1.0,0>,10  clipped_by{plane{y,1.0 inverse} }  scale<1,.25,1>}
    cylinder{<0,1.0>,<0,0,0>,10}
    texture{
      pigment { Gray20 }
      finish {
        ambient 0.1
        diffuse 0.7
        brilliance 6.0
        reflection 0.3
        phong 0.8
        phong_size 120
      }
    }
    rotate<-90,0,0>
    translate<0,19,-2.65>
  }

  object{
    torus{15,6}
    clipped_by{plane{z,0}}
    clipped_by{plane{z,0} rotate<0,-30,0>}
    clipped_by{cylinder{<0,-10,0>,<0,10,0>,17 inverse}}
    rotate<90,0,0>
    translate<0,19,0>
    texture{pigment{SteelBlue*1.25 } finish{Shiny}}
  }
  scale 1/16
}
//========================<  end of tire  >===================

#declare trailer=
union{
  box{<-1.5,29/12,-1.5>,<1.5,33/12,1.5> translate<-1.5,-.5,.1> texture{pigment{Bronze} finish{Dull}}}

  box{<-5,20/12,-3>,<3,24/12,3>  }
  box{<-6.5,20/12,-.25>,<-5,24/12,.25> }
  cylinder{<-6.2,20/12,0>,<-6.2,0,0>,.1}
  pigment{LightSteelBlue }
}


#declare searchLight=
union{
  object{trailer}
  object{mainLight rotate<0,yAngle,0> translate<-2,2.25,1>}
  object{tire translate<0,-.1,-3.5>}
  object{tire translate<0,0,3.5>}
}

