
// Persistence of Vision Ray Tracer Scene Description File
// File: showtime.pov
// Vers: 3.02
// Desc: A movie theater
// Date: 10/31/97
// Auth: Bob Franke

#version 3

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "woods.inc"
#include "finish.inc"
#include "stoneold.inc"
#include "glass.inc"
#include "ticket.inc"


global_settings
{
  assumed_gamma 2.3
  max_trace_level 5     //default is five
}
// ----------------------------------------


#declare True = 1
#declare xTrue = 0
#declare False = 0
#declare testing = False
#declare bootLights = True
#declare vaseLights = True
#declare insideLights = True
#declare buildingLights = True
#declare overHeadLights = True
#declare lightMult=1.2
#declare vaseMult=.35
#declare insideLightMult=1.0
#declare overHeadLightMult=0.95
// ----------------------------------------

camera
{
  location  <-80, 6, -100>
  direction 2*z
  right     4/3*x
  look_at   <-10, 17, 2.5>
}
// ----------------------------------------


// a giant sphere to add sky glow light pollution
sphere{<0,0,0>,4000
  texture{
    pigment{Wheat*2.0}
    finish {Luminous }
  }
  hollow
}

// ----------------------------------------

// -------add some ambient lighting
light_source{<-100, 1000, -1000>  color White*.1 atmosphere off shadowless }
light_source{<-100, 1000, 1000>  color White*.1 atmosphere off shadowless }

// --------lights in the alley to the left
light_source{<-47, 25, 10>  color White*.3 atmosphere off }
light_source{<-47, 25, 30>  color White*.3 atmosphere off }

// add atmosphere to the search light will work
atmosphere {
    type 1
    samples 30
    distance 2000
    scattering .75
    aa_level 8
    aa_threshold 0.2
//    jitter 0.05
}
// ----------------------------------------

#declare BoothOakMult=1.25
#declare BoothOak =
pigment {
    wood
    turbulence 0.05
    scale <0.2, 0.2, 1>
    color_map {
        [0.0, 0.1 color rgb <0.42, 0.26, 0.15>*BoothOakMult
                  color rgb <0.42, 0.26, 0.15>*BoothOakMult]
        [0.1, 0.9 color rgb <0.42, 0.26, 0.15>*BoothOakMult
                  color rgb <0.52, 0.37, 0.26>*BoothOakMult]
        [0.9, 1.0 color rgb <0.52, 0.37, 0.26>*BoothOakMult
                  color rgb <0.52, 0.37, 0.26>*BoothOakMult]
    }
}


// add a couple of lights inside the building
#if (insideLights = True)
  light_source{<-20,13,50>  color rgb <1.000, 1.000, 0.784>*insideLightMult atmosphere off}
  light_source{<35,13,50>  color rgb <1.000, 1.000, 0.784>*insideLightMult atmosphere off}
#end


// ------------- start of building spotlights
#if (buildingLights = True)
  light_source{
    <-18,13,-2>  color rgb <1.000, 1.000, 1.000>*lightMult
    spotlight               // this kind of light source
    point_at <-16, 21, 1>      // direction of spotlight
    radius 5                // hotspot (inner, in degrees)
    tightness 3            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 15              // intensity falloff radius (outer, in degrees)
    atmosphere off
  }


  light_source{
    <18,13,-2>  color rgb <1.000, 1.000, 1.000>*lightMult
    spotlight               // this kind of light source
    point_at <16, 21, 1>      // direction of spotlight
    radius 5                // hotspot (inner, in degrees)
    tightness 3            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 15              // intensity falloff radius (outer, in degrees)
    atmosphere off
  }


  light_source{
    <0,13,-2>  color rgb <1.000, 1.000, 1.000>*lightMult
    spotlight               // this kind of light source
    point_at <0, 21, 1>      // direction of spotlight
    radius 5                // hotspot (inner, in degrees)
    tightness 3            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 15              // intensity falloff radius (outer, in degrees)
    atmosphere off
  }

  light_source{
    <0,13,-12>  color rgb <1.000, 1.000, 1.000>*lightMult
    spotlight               // this kind of light source
    point_at <6, 20, 0>      // direction of spotlight
    radius 20                // hotspot (inner, in degrees)
    tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 55              // intensity falloff radius (outer, in degrees)
    atmosphere off
  }
  light_source{
    <0,13,-12>  color rgb <1.000, 1.000, 1.0>*lightMult
    spotlight               // this kind of light source
    point_at <-6, 20, 0>      // direction of spotlight
    radius 20                // hotspot (inner, in degrees)
    tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 55              // intensity falloff radius (outer, in degrees)
    atmosphere off
  }

  light_source{
    <-25,13,-12>  color rgb <1.000, 1.000, 1.00>*lightMult
    spotlight               // this kind of light source
    point_at <-25, 22, 0>      // direction of spotlight
    radius 15               // hotspot (inner, in degrees)
    tightness 5           // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 30            // intensity falloff radius (outer, in degrees)
    atmosphere off
  }
  light_source{
    <25,13,-12>  color rgb <1.000, 1.000, 1.00>*lightMult
    spotlight               // this kind of light source
    point_at <25, 22, 0>      // direction of spotlight
    radius 15               // hotspot (inner, in degrees)
    tightness 5           // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 30            // intensity falloff radius (outer, in degrees)
    atmosphere off
  }

  light_source{
    <-29,13,-12>  color rgb <1.000, 1.000, 1.00>*lightMult
    spotlight               // this kind of light source
    point_at <-35, 21, 0>      // direction of spotlight
    radius 15               // hotspot (inner, in degrees)
    tightness 5           // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 35            // intensity falloff radius (outer, in degrees)
    atmosphere off
  }
  light_source{
    <30,13,-12>  color rgb <1.000, 1.000, 1.00>*lightMult
    spotlight               // this kind of light source
    point_at <35, 21, 0>      // direction of spotlight
    radius 15               // hotspot (inner, in degrees)
    tightness 5           // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 35            // intensity falloff radius (outer, in degrees)
    atmosphere off
  }
#end
//---------------- end of building spotlights


#declare WindowGlass=
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.95>
              turbulence 20
            }
    normal {bumps 0.005 scale 8}
    finish {
      specular 1
      roughness 0.001
      ambient 0
      diffuse 0
      refraction 1
      reflection 0.19
      ior 1.5
   }
}
// ----------------------------------------

//slightly modified POV T_Grnt8a
#declare GrntScale=.8
#declare T_Grnt8ab =
texture {
  pigment{
    granite
    turbulence 0.6
    color_map{
      [0.00, 0.18 color rgbf <0.84*GrntScale, 0.65*GrntScale, 0.65*GrntScale, 0.0>
                  color rgbf <0.88*GrntScale, 0.76*GrntScale, 0.62*GrntScale, 0.0>]
      [0.18, 0.37 color rgbf <0.88*GrntScale, 0.76*GrntScale, 0.62*GrntScale, 0.0>
                  color rgbf <0.90*GrntScale, 0.82*GrntScale, 0.71*GrntScale, 0.0>]
      [0.37, 0.54 color rgbf <0.90*GrntScale, 0.82*GrntScale, 0.71*GrntScale, 0.0>
                  color rgbf <0.85*GrntScale, 0.67*GrntScale, 0.67*GrntScale, 0.0>]
      [0.54, 0.85 color rgbf <0.85*GrntScale, 0.67*GrntScale, 0.67*GrntScale, 0.0>
                  color rgbf <0.89*GrntScale, 0.79*GrntScale, 0.67*GrntScale, 0.0>]
      [0.85, 0.98 color rgbf <0.89*GrntScale, 0.79*GrntScale, 0.67*GrntScale, 0.0>
                  color rgbf <0.82*GrntScale, 0.61*GrntScale, 0.61*GrntScale, 0.0>]
      [0.98, 1.01 color rgbf <0.82*GrntScale, 0.61*GrntScale, 0.61*GrntScale, 0.0>
                  color rgbf <0.84*GrntScale, 0.65*GrntScale, 0.65*GrntScale, 0.0>]
    }
  }
}
// ----------------------------------------

#declare GrntScale2=1.0
#declare lightGrnt =
texture {
  pigment{
    granite
    turbulence 0.6
    color_map{
      [0.00, 0.18 color rgbf <0.84*GrntScale2, 0.65*GrntScale2, 0.65*GrntScale2, 0.0>
                  color rgbf <0.88*GrntScale2, 0.76*GrntScale2, 0.62*GrntScale2, 0.0>]
      [0.18, 0.37 color rgbf <0.88*GrntScale2, 0.76*GrntScale2, 0.62*GrntScale2, 0.0>
                  color rgbf <0.90*GrntScale2, 0.82*GrntScale2, 0.71*GrntScale2, 0.0>]
      [0.37, 0.54 color rgbf <0.90*GrntScale2, 0.82*GrntScale2, 0.71*GrntScale2, 0.0>
                  color rgbf <0.85*GrntScale2, 0.67*GrntScale2, 0.67*GrntScale2, 0.0>]
      [0.54, 0.85 color rgbf <0.85*GrntScale2, 0.67*GrntScale2, 0.67*GrntScale2, 0.0>
                  color rgbf <0.89*GrntScale2, 0.79*GrntScale2, 0.67*GrntScale2, 0.0>]
      [0.85, 0.98 color rgbf <0.89*GrntScale2, 0.79*GrntScale2, 0.67*GrntScale2, 0.0>
                  color rgbf <0.82*GrntScale2, 0.61*GrntScale2, 0.61*GrntScale2, 0.0>]
      [0.98, 1.01 color rgbf <0.82*GrntScale2, 0.61*GrntScale2, 0.61*GrntScale2, 0.0>
                  color rgbf <0.84*GrntScale2, 0.65*GrntScale2, 0.65*GrntScale2, 0.0>]
    }
  }
  scale .2
}
// ----------------------------------------

//slightly modified Dan Farmer's Dark Oak
#declare dmf=1.25
#declare xDoorOak =
texture{
  pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.2, 0.2, 1>
    color_map {
        [0.0, 0.1 color rgb <0.60, 0.30, 0.18>*dmf
                  color rgb <0.60, 0.30, 0.18>*dmf]
        [0.1, 0.9 color rgb <0.60, 0.30, 0.18>*dmf
                  color rgb <0.30, 0.15, 0.09>*dmf]
        [0.9, 1.0 color rgb <0.30, 0.15, 0.09>*dmf
                  color rgb <0.30, 0.15, 0.09>*dmf]
    }
  }
  scale .25
}
// ----------------------------------------

#declare Concrete2=
texture{
  pigment{
    bozo
    turbulence 1.0
    omega 0.8
    lambda 3.0
    color_map{
      [0.00 color rgb<0.4, 0.4, 0.4>*.8]
      [1.00 color rgb<.6,.6,.6>*.8]
    }
    scale .0007
  }
  normal {bumps 0.1 scale<.01,.001,.01>}
}
// ----------------------------------------

#declare Block= 
superellipsoid { <.0625, .0625>
  translate<1,1,1>
  scale<.75,.5,.5>
  #if (testing = True)
    pigment{White*.5}
  #else
    texture{T_Grnt8ab }
  #end
}
// ----------------------------------------


#declare halfBlock=
superellipsoid { <.0625, .0625>
  translate<1,1,1>
  scale<.375,.5,.5>
  #if (testing = True)
    pigment{White*.5}
  #else
    texture{T_Grnt8ab }
  #end
}

// ----------------------------------------

#declare PaneOfGlass =
  box{<0,0,-.0625>,<24,-36,.0625>
      #if (testing = True)
      pigment{color red 1.00 green 0.11 blue 0.68}
    #else
      texture{WindowGlass}
    #end
  }

// ----------------------------------------

#declare roadMult=.55
#declare roadTexture =
texture {
  pigment{
    granite
    turbulence 2
    color_map
      {[0.000, 0.154   color rgb <0.794, 0.786, 0.946>*roadMult
                      color rgb <0.745, 0.745, 0.813>*roadMult]
       [0.154, 0.308   color rgb <0.745, 0.745, 0.813>*roadMult
                       color rgb <0.902, 0.902, 0.949>*roadMult]
       [0.308, 0.444   color rgb <0.902, 0.902, 0.949>*roadMult
                       color rgb <0.729, 0.706, 0.754>*roadMult]
       [0.444, 0.615   color rgb <0.729, 0.706, 0.754>*roadMult
                       color rgb <0.588, 0.592, 0.705>*roadMult]
       [0.615, 0.803   color rgb <0.588, 0.592, 0.705>*roadMult
                       color rgb <0.608, 0.616, 0.719>*roadMult]
       [0.803, 1.001   color rgb <0.608, 0.616, 0.719>*roadMult
                       color rgb <0.794, 0.786, 0.946>*roadMult]
      }
  }
  normal {bumps 0.1 scale<.001,.0001,100>}
}
// ----------------------------------------

#declare roadSection=
merge{
  cylinder{<0,-6/12,1/12>,<36,-6/12,1/12>, 1/12 }
  cylinder{<0,-6/12,-215/12>,<36,-6/12,-215/12> 1/12 }
  cylinder{<1/12,-6/12,0>,<1/12,-6/12,-18>, 1/12 }
  cylinder{<431/12,-6/12,0>,<431/12,-6/12,-18>, 1/12 }
  box{<0,-12/12,0>,<36,-6/12,-18> }
  box{<1/12,-5/12,1/12>,<431/12,-7/12,-215/12>}
  texture {roadTexture  scale .2 }
}
//----------------------------------------

#declare ramp=
merge{
  box{<-2,-.6,-2>,<0,0,-9>  rotate<0,0,11.8> translate<-478/12,.001,0>}
  box{<-480.5,.001,-24>/12,<-474,-6,-108>/12 }
  #if (testing = True)
    pigment {Gray90}
  #else
    texture{Concrete2 scale .0001}
  #end
}
// ----------------------------------------

#declare curb=
union{
  cylinder {<-467,-1,-145>/12,<2400,-1,-145>/12, 1/12}
  cylinder {<-467,-1,-149>/12,<2400,-1,-149>/12, 1/12} 
  box{<-467,0,-145>/12,<2400,-2,-149>/12}
  box{<-467,-1,-144>/12,<2400,-6,-150>/12}
  torus{1,1/12 clipped_by{plane{x,0}} clipped_by{plane{z,0}} translate<-467,-1,-137>/12 }
  torus{8/12,1/12 clipped_by{plane{x,0}} clipped_by{plane{z,0}} translate<-467,-1,-137>/12 }
  difference{
    cylinder {<0,-1,0>/12,<0,-6,0>/12, 13/12}
    cylinder {<0,1,0>/12,<0,-9,0>/12, 9/12}
    clipped_by{plane{x,0}} clipped_by{plane{z,0}}
    translate<-467,0,-137>/12
   }

  difference{
    cylinder {<0,0,0>/12,<0,-6,0>/12, 12/12}
    cylinder {<0,1,0>/12,<0,-9,0>/12, 8/12}
    clipped_by{plane{x,0}} clipped_by{plane{z,0}}
    translate<-467,0,-137>/12
  }
  cylinder {<-479,-1,-137>/12,<-479,-1,2>/12, 1/12 }
  cylinder {<-475,-1,-137>/12,<-475,-1,2>/12, 1/12 }
  box{<-480,-1,-137>/12,<-474,-6,2>/12 }
  box{<-479,0,-137>/12,<-475,-6,2>/12 }
  #if (testing = True)
    pigment{Red}
  #else
    texture{T_Grnt8ab }
  #end
}
//----------------------------------------------------


// -------start of front door handle
#declare handle=
merge{
  object{
    torus{.75,.5}
      clipped_by{ plane {x,0 }}
      clipped_by{ plane {x,0 inverse} rotate<0,90,0>}
   rotate<90,0,0>
   }
  object{
    torus{.75,.5}
      clipped_by{ plane {x,0 inverse}}
      clipped_by{ plane {x,0 } rotate<0,-90,0>}
      rotate<90,0,0>
      translate<12,0,0>
  }
  cylinder{<0,0.75,0>,<12,0.75,0> .5}
  cylinder{<-.75,0,0>,<-.75,-2.25,0> .5}
  cylinder{<12.75,0,0>,<12.75,-2.25,0> .5}
  box{<-2,-2.25,-2>,<14,-2.125,2>}
  translate<0,2.25,0>
  rotate<-90,0,-90>
  texture{T_Brass_3B finish{Dull}}
}
//---------------- end of front door handle

#declare frontDoor=
union{
  box{<-48,102,-1>,<48,108,1>
    #if (testing = True)
      pigment{Red}
    #else
      texture{xDoorOak  rotate<0,-90,0> }
    #end
  }

  box{<-48,100,2>,<48,108,1> // to block light from behind
    pigment{Black}
  }

  box{<-48,0,-1>,<-42,108,1>
    #if (testing = True)
      pigment{Red}
    #else
      texture{xDoorOak  rotate<88,0,0>}
    #end
  }
  box{<48,0,-1>,<42,108,1>
    #if (testing = True)
      pigment{Red}
    #else
      texture{xDoorOak  rotate<87,0,0>}
    #end
  }
  box{<-41.5,0,-1>,<-.5,101.5,1>
    #if (testing = True)
      pigment{Red}
    #else
      texture{xDoorOak  rotate<89.25,0,0> translate <-25,0,0>}
    #end
  }
  box{<41.5,0,-1>,<.5,101.5,1>
    #if (testing = True)
      pigment{Red}
    #else
      texture{xDoorOak  rotate<89.25,0,0> translate <20,-10,0>}
    #end
  }
  object{handle translate<-5,50,-1>}
  object{handle translate<5,50,-1>}
scale 1/12
}
//----------------------------------------------------

#declare SideWalk=
union{
  cylinder {<-47,-1,0>/12,<-47,-1,-144>/12, 1/12}
  cylinder {<47,-1,0>/12,<47,-1,-144>/12, 1/12}
  box{<-47,0,0>/12,<47,-1,-144>/12}
  box{<-48,-1,0>/12,<48,-6,-144>/12}
  #if (testing = True)
    pigment {Gray90}
  #else
    texture{Concrete2 scale .0001}
  #end
}
//----------------------------------------------------

#declare sideWalkCover=
union{
  box{<-30,12,0>,<30,11.25,-10>
    pigment{Cyan}
  }

  #if (overHeadLights = True)
    light_source{<-30.05,11.625,-5>  color White*.1 atmosphere off}

    #declare zz= -1
    #while (zz > -10)
      light_source{
        <-31,11.625,zz>  color rgb <1.000, 1.000, 0.884>1
        spotlight               // this kind of light source
        point_at <-30,11.625,zz>      // direction of spotlight
        radius 30                // hotspot (inner, in degrees)
        tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
        falloff 60               // intensity falloff radius (outer, in degrees)
        atmosphere off
      }
      #declare zz=zz-2
    #end


    light_source{<0,11,-6>  color rgb <1.000, 1.000, 0.784>*.2*overHeadLightMult atmosphere off}
    light_source{<-8,11,-6>  color rgb <1.000, 1.000, 0.784>*.2*overHeadLightMult atmosphere off}
    light_source{<-16,11,-6>  color rgb <1.000, 1.000, 0.784>*.2*overHeadLightMult atmosphere off}
    light_source{<-24,11,-6>  color rgb <1.000, 1.000, 0.784>*.2*overHeadLightMult atmosphere off}
    light_source{<8,11,-6>  color rgb <1.000, 1.000, 0.784>*.2*overHeadLightMult atmosphere off}
    light_source{<16,11,-6>  color rgb <1.000, 1.000, 0.784>*.2*overHeadLightMult atmosphere off}
    light_source{<24,11,-6>  color rgb <1.000, 1.000, 0.784>*.2*overHeadLightMult atmosphere off}

    #declare xx=-29
    #while (xx < 30)
      light_source{
        <xx,11.625,-11>  color rgb <1.000, 1.000, 0.884>
        spotlight                  // this kind of light source
        point_at <xx,11.625,-10>   // direction of spotlight
        radius 10                  // hotspot (inner, in degrees)
        tightness 5                // tightness of falloff (1...100) lower is softer, higher is tighter
        falloff 40                 // intensity falloff radius (outer, in degrees)
        atmosphere off
      }
      #declare xx=xx+2
    #end
  #end


  union{
    box{<-30,12,-9.5>,<30,12.333,-10.5>}
    box{<-30,11.25,-9.5>,<30,10.9,-10.5>}
    box{<-30,11.25,0>,<-30.5,10.9,-10.5>}
    box{<-30,12,0>,<-30.5,12.333,-10.5>}
    box{<30,11.25,0>,<30.5,10.9,-10.5>}
    box{<30,12,0>,<30.5,12.333,-10.5>}

    #declare xx = -30
    #while (xx < 30)
      box{<xx,12.333,-10.25>,<xx+.5,12.67,-10.5>}
      box{<xx,10.56,-10.25>,<xx+.5,10.9,-10.5>}
      #declare xx=xx+1
    #end

    #declare zz = -10.5
    #while (zz < 0)
      box{<-30.5,12.67,zz>,<-30.25,12.333,zz+.5>}
      box{<-30.5,10.56,zz>,<-30.25,10.9,zz+.5>}
      box{<30.5,12.67,zz>,<30.25,12.333,zz+.5>}
      box{<30.5,10.56,zz>,<30.25,10.9,zz+.5>}
      #declare zz=zz+1
    #end
    texture{
       pigment{Red*.75}
       finish{
       roughness 0.05
       }
    }
  }
} // end of sidewalk cover
//----------------------------------------------------

#declare xfirstFloorFrontBricks=
  union{
    #declare yy = 0
    #while (yy < 10)
      #declare xx= -30
      #while (xx < -20)
        object{Block translate<xx,yy,0>}
        #declare xx=xx+1.5
      #end
      #declare yy = yy+2
    #end

    #declare yy = 1
    #while (yy < 8)
      #declare xx= -29.25
      #while (xx < -21)
        object{Block translate<xx,yy,0>}
        #declare xx=xx+1.5
      #end
      #declare yy = yy+2
    #end

    #declare yy = 1
    #while (yy < 8)
      object{halfBlock translate<-30,yy,0>}
      object{halfBlock translate<-20.25,yy,0>}
      #declare yy = yy+2
    #end
  }
// ----------------------------------------

#declare x2firstFloorFrontBricks=
difference{
  union{
    #declare yy = 0
    #while (yy < 10)
      #declare xx= -30
      #while (xx < -20)
        object{Block translate<xx,yy,0>}
        #declare xx=xx+1.5
      #end
      #declare yy = yy+2
    #end

    #declare yy = 1
    #while (yy < 8)
      #declare xx= -29.25
      #while (xx < -21)
        object{Block translate<xx,yy,0>}
        #declare xx=xx+1.5
      #end
      #declare yy = yy+2
    #end

    #declare yy = 1
    #while (yy < 8)
      object{halfBlock translate<-30,yy,0>}
      object{halfBlock translate<-20.25,yy,0>}
      #declare yy = yy+2
    #end
  }
  box{<.25,.25,5>,<3.75,4.75,-5> translate<-27.5,2,0>}
}
//----------------------------------------------------

#declare yfirstFloorFrontBricks=
difference{
union{
  #declare yy = 0
  #while (yy < 10)
    #declare xx= -11.5
    #while (xx < -4.0)
      object{Block translate<xx,yy,0>}
      #declare xx=xx+1.5
    #end
    #declare yy = yy+2
  #end

  #declare yy = 1
  #while (yy < 8)
    #declare xx= -10.75
    #while (xx < -5)
      object{Block translate<xx,yy,0>}
      #declare xx=xx+1.5
    #end
    #declare yy = yy+2
  #end

  #declare yy = 1
  #while (yy < 8)
    object{halfBlock translate<-11.5,yy,0>}
    object{halfBlock translate<-4.75,yy,0>}
    #declare yy = yy+2
  #end
}
//----------------------------------------------------

#declare leftBottomBricks=
union{
  object{xfirstFloorFrontBricks translate<-10.5,0,2.5>}
  #declare yy = 10
  #while (yy < 14)
    #declare xx= -40.5
    #while (xx < -30)
      object{Block translate<xx,yy,2.5>}
      #declare xx=xx+1.5
    #end
    #declare yy = yy+2
  #end

  #declare xx= -39.75
  #while (xx < -31)
    object{Block translate<xx,9,2.5>}
    object{Block translate<xx,11,2.5>}
    #declare xx=xx+1.5
  #end
  object{halfBlock translate<-40.5,9,2.5>}
  object{halfBlock translate<-40.5,11,2.5>}

  object{halfBlock translate<-30.75,9,2.5>}
  object{halfBlock translate<-30.75,11,2.5>}
}
//----------------------------------------------------

#declare outerTowers=
union{
  box{<-40.5,0,99>,<40.5,37,100>  }
  box{<-40.5,13,2.5>,<-39.5,37,100>  }
  box{<-40.5,13,2.5>,<-30,37,4>  }
  box{<-40.5,0,3.5,>,<-39.5,13,100>  }

  box{<39.5,13,2.5>,<40.5,37,100>  }
  box{<30,13,2.5>,<40.5,37,4>  }
  box{<39.5,0,3.5>,<40.5,13,100> }

  box{<30,37,1.0>,<42,37.5,100>  }
  box{<30,37.5,-0.5>,<43.5,38,100>  }
  box{<-42,37,1.0>,<-30,37.5,100>  }
  box{<-43.5,37.5,-.5>,<-30,38,100>  }

  #if (testing = True)
    pigment{White*.5}
  #else
    texture{T_Grnt8ab }
  #end
}
//----------------------------------------------------

#declare windowCutout=
merge{
  cylinder { <0,144,-24>, <0,144,24>,72 }
  box{<-72,144,-24>,<72,-12,24>}
  scale 1/12
}

// ----------------------------------------
#declare towerTrim=
union{
  box{<-30,35.5,-2.5/12>,<30,37,0> }
  box{<-30,13,-2/12>,<-28.5,37,0> }
  box{<-21.5,13,-2/12>,<-20,37,0> }
  box{<-30,13,-2.5/12>,<-20,15,0> }

  box{<30,13,-2/12>,<28.5,37,0> }
  box{<21.5,13,-2/12>,<20,37,0> }
  box{<30,13,-2.5/12>,<20,15,0> }


  box{<-40.5,13,2.5-(2/12)>,<-39,37,2.5>  }
  box{<40.5,13,2.5-(2/12)>,<39,37,2.5>  }

  #declare yy=14.25
  #while (yy < 37)
    box{<-39,yy,2.5-(2/12)>,<-38.625,yy+2,2.5>  }
    box{<39,yy,2.5-(2/12)>,<38.625,yy+2,2.5>  }
   box{<-31.875,yy,2.5-(2/12)>,<-31.5,yy+2,2.5>  }
    box{<31.875,yy,2.5-(2/12)>,<31.5,yy+2,2.5>  }

    box{<-28.5,yy,-2/12>,<-28.125,yy+2,0> }
    box{<28.5,yy,-2/12>,<28.125,yy+2,0> }
    box{<-21.5,yy,-2/12>,<-21.875,yy+2,0> }
    box{<21.5,yy,-2/12>,<21.875,yy+2,0> }
    #declare yy=yy+4
  #end

  box{<-31.5,13,2.5-(2/12)>,<-30,37,2.5>  }
  box{<31.5,13,2.5-(2/12)>,<30,37,2.5>  }

  box{<-40.5,13,2.5-(2.5/12)>,<-30,15,2.5>  }
  box{<40.5,13,2.5-(2.5/12)>,<30,15,2.5>  }
  box{<-40.5,35.5,2.5-(2.5/12)>,<-30,37,2.5>  }
  box{<40.5,35.5,2.5-(2.5/12)>,<30,37,2.5>  }

  #if (testing = True)
    pigment{White*.5}
  #else
    texture{lightGrnt }
  #end
}
// ----------------------------------------

#declare vaseCutout=
merge{
  cylinder { <0,48,-20>, <0,48,36>,20 }
  box{<-20,48,-20>,<20,0,36>}
  scale 1/12
}
// ----------------------------------------

#declare vaseTrim =
difference{
  union{
    box{<-26/12,0,0>,<26/12,6,-2/12>}
    box{<-26/12,6,0>,<26/12,7.5,-2.5/12>}
  }
  vaseCutout
  cylinder { <-4,12.25,-20>, <-4,12.25,36>,6 }
  cylinder { <4,12.25,-20>, <4,12.25,36>,6 }
  texture{lightGrnt }
}
//-----------------------------------------

#declare innerTowers=
union{
  difference{
    union{
      box{<-30,12,0>,<-20,37,5> }
      box{< 30,12,0>,< 20,37,5> }
      box{<-20,12,8>,<20,37,9>}
      box{<-20,35.5,0>,<20,37,100>}
      box{<-31.5,37,-1.5>,<31.5,37.5,100>}
      box{<-33,37.5,-3>,<33,38,100>}
    }
    cylinder{<0,35,32>,<0,40,32>,22.9}
    object{windowCutout translate< 7.5,15,7.8>}
    object{windowCutout translate<-7.5,15,7.8>}
    object{vaseCutout translate<-25,15,0>}
    object{vaseCutout translate<25,15,0>}
    #if (testing = True)
      pigment{White*.5}
    #else
      texture{T_Grnt8ab }
    #end
  }

  #declare xx=0
  #while (xx < 360)
    difference{
      cylinder{<0,28,-0.05>,<0,28,0.05>,26.1}
      cylinder{<0,28,-0.1>,<0,28,0.1>,25.8}
      clipped_by{plane{y,38 inverse}}
      pigment{Black}
      rotate<0,xx,0>
      translate<0,0,32>
    }
    #declare xx=xx+20
  #end

  difference{
    cylinder{<0,50.576,32>,<0,50.456,32>,13.15}
    cylinder{<0,51,32>,<0,49,32>,13.0}
    pigment{Black}
  }

  difference{
    cylinder{<0,44.772,32>,<0,44.652,32>,20.06}
    cylinder{<0,45,32>,<0,42,32>,19.90}
    pigment{Black}
  }

  sphere{<0,28,32>,26
    clipped_by{plane{y,38 inverse}}
    texture {
      pigment {color rgb <0.882, 1.000, 0.788>*1.9 }
      finish {Shiny
        roughness .001
      }
    }
  }
  sphere{<0,28,32>,25.9
    clipped_by{plane{y,38 inverse}}
    texture {
      pigment {color rgb <0.882, 1.000, 0.788>*.625 }
      finish {Luminous
      roughness .001
      }
    }
  }
  difference{
    cylinder{<0,37,32>,<0,38,32>,22.9}
    cylinder{<0,35,32>,<0,40,32>,22.8}
    pigment{Black}
  }
}
}

//----------------------------------------------------

#declare zfirstFloorFrontBricks=
union{
  #declare yy = 10
  #while (yy < 14)
    #declare xx= -30
    #while (xx < 30)
      object{Block translate<xx,yy,0>}
      #declare xx=xx+1.5
    #end
    #declare yy = yy+2
  #end

  #declare xx= -29.25
  #while (xx < 29)
    object{Block translate<xx,9,0>}
    object{Block translate<xx,11,0>}
    #declare xx=xx+1.5
  #end
  object{halfBlock translate<-30,9,0>}
  object{halfBlock translate<29.25,9,0>}
  object{halfBlock translate<-30,11,0>}
  object{halfBlock translate<29.25,11,0>}
}
//--------------------------------------------------

#declare column=
merge{
  difference{
    cylinder{<0,0,0>,<0,20,0>,2}
    #declare xx = 0
    #while (xx < 180)
      object{cylinder{<2,0.75,0>,<2,19.25,0>,.13} rotate<0,xx,0>}
      object{sphere{<2,0.75,0>,.13} rotate<0,xx,0>}
      object{sphere{<2,19.25,0>,.13} rotate<0,xx,0>}
      #declare xx =  xx+13
    #end
  }
  cylinder{<0,0,0>,<0,-2/12,0>,2.25}
  object{torus {2.125,0.25} translate<0,-4/12,0>}
  cylinder{<0,-4/12,0>,<0,-8/12,0>,2.5}
  object{torus {2.375,0.4} translate<0,-12/12,0>}
  box{<-2.875,-1,-2.875>,<2.875,-1.75,2.875>}

  cylinder{<0,20+0,0>,<0,20+2/12,0>,2.25}
  object{torus {2.125,0.25} translate<0,20+4/12,0>}
  cylinder{<0,20+4/12,0>,<0,20+8/12,0>,2.5}
  object{torus {2.375,0.4} translate<0,20+12/12,0>}
  box{<-2.875,20+1,-2.875>,<2.875,20+1.75,2.875>}


  #if (testing = True)
    pigment{White*.5}
  #else
    texture{T_Grnt8ab }
  #end
}
//--------------------------------------------------

#declare vase=
union{
  lathe {
    linear_spline
    47, // number of points
    <0,600>, <30,600>, <61,600>, <80,596>, <88,591>, // the list of <u,v> points
    <79,580>, <65,575>, <51,570>, <40,567>, <35,555>, // the list of <u,v> points
    <30,542>, <30,525>, <34,510>, <39,507>, <40,501>, // the list of <u,v> points
    <34,492>, <42,480>, <56,469>, <76,449>, <101,414>, // the list of <u,v> points
    <148,295>, <130,357>, <135,352>, <133,345>, <140,325>, // the list of <u,v> points
    <155,248>, <155,216>, <155,178>, <153,158>, <147,149>, // the list of <u,v> points
    <133,144>, <116,144>, <96,144>, <82,139>, <66,131>, // the list of <u,v> points
    <47,115>, <38,93>, <38,75>, <39,62>, <49,56>, // the list of <u,v> points
    <61,56>, <72,54>, <61,46>, <41,38>, <24,34>, // the list of <u,v> points
    <0,34>, <0,600>  // the list of <u,v> points
    sturm
    translate<0,-600,-155>
    scale .0075
    texture{lightGrnt }
    rotate<180,0,0>
  } 

  #if (vaseLights = True)
    light_source{<0,5.5,2.8>  color rgb <1.000, 1.000, 1.0>*.8*vaseMult atmosphere off}

    light_source{
     <0,-3,-9>  color rgb <1,1,1>*vaseMult
     spotlight               // this kind of light source
     point_at <0, 2.5, 0>      // direction of spotlight
     radius 5               // hotspot (inner, in degrees)
     tightness 3            // tightness of falloff (1...100) lower is softer, higher is tighter
     falloff 30               // intensity falloff radius (outer, in degrees)
     atmosphere off
   }

  light_source{
    <0,5.5,-2>  color rgb <1,1,1>*.8*vaseMult
    spotlight
    point_at <0, 4.5, 0>
    radius 60
    tightness 10
    falloff 90
    atmosphere off
  }
  #end
}
//-----------------------------------------

#declare BigWindow=
union{
  union{
    object{
      difference{
        cylinder { <0,12*12,-3>, <0,12*12,3>,66 }
        cylinder { <0,12*12,-20>, <0,12*12,50>,60 }
      }
      clipped_by{ plane {y,12*12 inverse}}
    }

    object{
      difference{
        cylinder { <0,12*12,-6>, <0,12*12,6>,72 }
        cylinder { <0,12*12,-20>, <0,12*12,50>,66 }
      }
      clipped_by{ plane {y,12*12 inverse}}
    }
    box{<60,144,-3>,<66,0,3>}
    box{<-60,144,-3>,<-66,0,3>}
    box{<-66,0,-3>,<66,-6,3>}

    box{<-66,144,-6>,<-72,-6,6>}
    box{<66,144,-6>,<72,-6,6>}
    box{<-72,-6,-6>,<72,-12,6>}

    #if (testing = True)
      pigment{White*.5}
    #else
      texture{lightGrnt }
    #end
  }

  object{
    cylinder { <0,12*12,-.125>, <0,12*12,.125,>,59.9 }
    clipped_by{ plane {y,12*12 inverse}}
    #if (testing = True)
      pigment{color red 1.00 green 0.11 blue 0.68}
    #else
      texture{WindowGlass}
    #end
  }

  object{
    difference{
      cylinder { <0,12*12,-2>, <0,12*12,2>,60 }
      cylinder { <0,12*12,-20>, <0,12*12,50>,58 }
    }
    clipped_by{ plane {y,12*12 inverse}}
    pigment {color Gray20}
  }

  union{
    box{<-60,144,-.5>,<60,146,.5>}
    box{<-60,-1,-.5>,<0,1,.5> rotate<0,0,-30> translate<0,145,0>}
    box{<-60,-1,-.5>,<0,1,.5> rotate<0,0,-90> translate<0,145,0>}
    box{<-60,-1,-.5>,<0,1,.5> rotate<0,0,-150> translate<0,145,0>}

    box{<-60,108,-.5>,<60,106,.5>}
    box{<-60,70,-.5>,<60,72,.5>}
    box{<-60,36,-.5>,<60,34,.5>}

    box{<60,144,-.5>,<58,0,.5>}
    box{<35,144,-.5>,<37,0,.5>}
    box{<11,144,-.5>,<13,0,.5>}
    box{<-11,144,-.5>,<-13,0,.5>}
    box{<-35,144,-.5>,<-37,0,.5>}
    box{<-60,144,-.5>,<-58,0,.5>}
    box{<-60,0,-.5>,<60,2,.5>}
    pigment {color Gray20}
  }

  #declare xxx = seed(123654)
  #declare yyy = seed(988511)
  #declare zzz = seed(753159)
  #declare xx= -59
  #while (xx < 50)
    #declare yy=143
    #while (yy > 0)
      object{PaneOfGlass rotate<rand(xxx)*.3,rand(yyy)*.3,rand(zzz)*.3> translate<xx,yy,0>}
      #declare yy = yy - 36
    #end
    #declare xx = xx + 24
  #end
  scale 1/12
}
//----------------------------------------------------

//----start of booth parts-----------------

#declare boothTop=
object{
  box{<-2,8,0>,<2,95/12,-3>}
  #if (testing = True)
    pigment{Red}
  #else
    texture{BoothOak scale .1 rotate<0,-90,0> }
  #end
}

#declare boothBack=
  box{<-2,8,0>,<2,0,-1/12>
  #if (testing = True)
    pigment{Red}
  #else
    texture{BoothOak scale .1 rotate<89,0,0> }
  #end
}

#declare fakeDoor=
union{
  box{<-1,7,0>,<1,0,-1/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{xDoorOak scale .1 rotate<89,0,0> }
    #end
  }

  union{
    box{<-1.25,7.25,-1/12>,<-1,0,-2/12>}
    box{<1,7.25,-1/12>,<1.25,0,-2/12>}
    box{<-1.25,7.25,-1/12>,<1.25,7,-2/12>}
    pigment{SemiSweetChoc }
  }
}

#declare boothFront=
union{
  object{
    difference{
      box{<-1.9,3.4,-70.75/12>,<1.9,89/12,-71.25/12>}
      cylinder{<0,4.5,-65>,<0,4.5,-75/12>,.5}
      #if (testing = True)
        pigment{Red}
      #else
        texture{WindowGlass }
      #end
    }
  }

  box{<-2,3.5,-6>,<2,38/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<0,-90,0> }
    #end
  }

  box{<-2,0,-6>,<2,4/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<0,-90,0> }
    #end
  }


  box{<-2,0,-6>,<-20/12,38/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<87,0,0>}
    #end
  }

  box{<2,0,-6>,<20/12,38/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<87,0,0>}
    #end
  }

  box{<-2/12,4/12,-6>,<2/12,38/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<87,0,0> }
    #end
  }


  box{<-2,8,-6>,<2,88/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<0,-90,0> }
    #end
  }


  box{<-2,3.5,-6>,<-20/12,8,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<87,0,0>}
    #end
  }

  box{<2,3.5,-6>,<20/12,8,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<87,0,0>}
    #end
  }

  box{<-1.9,0.08,-71.375/12>,<-0.08,3.4,-70.625/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<1,0,0> scale .25}
    #end
  }
  box{<1.9,0.08,-71.375/12>,<0.08,3.4,-70.625/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{BoothOak scale .1 rotate<89,0,0> scale .25}
    #end
  }
}

#declare boothSide=
union{
  box{<-1.4,3.4,-6>,<1.4,89/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      texture{WindowGlass }
    #end
  }
  box{<-1.5,3.5,-6>,<1.5,38/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<0,-90,0> }
    #end
  }
  box{<-1.5,0,-6>,<1.5,4/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<0,-90,0> }
    #end
  }
  box{<-1.5,0,-6>,<-14/12,3.5,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<87,0,0>}
    #end
  }
  box{<1.5,0,-6>,<14/12,3.5,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<87,0,0>}
    #end
  }
  box{<-2/12,0,-6>,<2/12,3.5,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<87,0,0> }
    #end
  }
  box{<-1.5,8,-6>,<1.5,88/12,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<0,-90,0> }
    #end
  }
  box{<-1.5,3.5,-6>,<-14/12,8,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<87,0,0>}
    #end
  }
  box{<1.5,3.5,-6>,<14/12,8,-70/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<87,0,0>}
    #end
  }
  box{<-1.4,0.08,-71.375/12>,<-0.08,3.4,-70.625/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<1,0,0> scale .25}
    #end
  }
  box{<1.4,0.08,-71.375/12>,<0.08,3.4,-70.625/12>
    #if (testing = True)
      pigment{Red}
    #else
      pigment{BoothOak scale .1 rotate<89,0,0> scale .20}
    #end
  }
}
//----end of booth parts-----------------

//----now assemble the booth----------------
#declare ticketBooth=
union{
  #if (bootLights = True)
   light_source{<0,7.8, -1.5>  White*.55 atmosphere off}
  #end
  object{fakeDoor}
  object{boothBack}
  object{boothTop}
  object{boothFront translate<0,0,34/12>}
  object{
    boothSide
    translate<0,0,71/12>
    rotate<0,90,0>
    translate<23/12,0,-1.5>
  }
  object{
    boothSide
    translate<0,0,71/12>
    rotate<0,90,0>
    translate<-23/12,0,-1.5>
  }
}
//-----------------------------------------

#declare pictureAndFrame=
union{
  difference{
    box{<-.25,-.25,0>,<4.25,5.25,-1/12>}
    box{<.25,.25,2>,<3.75,4.75,-2>}
    pigment{MediumWood*.75 }
  }
  difference{
    box{<.25,.25,0>,<3.75,4.75,1/12>}
    box{<.5,.5,4>,<3.5,4.5,-2>}
    pigment{DarkWood*.75 }
  }

  box{<.5,.5,1/12>,<3.5,4.5,1.1/12>
    pigment{
      image_map{
        tga "c:\ae62.tga" 
        map_type 0        
        interpolate 2    
        once
      }
      translate <.18,.125,0>
      scale <3,4,1>
    }
  }
}


//========<<< assemble the scene >>>==================
object{towerTrim}
object{innerTowers}
object{column translate<-15,13.75,2.875>}
object{column translate< 15,13.75,2.875>}
object{column translate<  0,13.75,2.875>}
object{outerTowers}
object{x2firstFloorFrontBricks}
object{leftBottomBricks}
object{leftBottomBricks translate<70.5,0,0>}
object{x2firstFloorFrontBricks translate<49.5,0,0>}
object{yfirstFloorFrontBricks}
object{yfirstFloorFrontBricks translate<15.5,0,0>}
object{zfirstFloorFrontBricks}
object{frontDoor translate<0,0,1>}
object{frontDoor translate<-15.5,0,1>}
object{frontDoor translate< 15.5,0,1>}
object{sideWalkCover scale<.975,1,1>}


//----- add the sidewalk and curb
#declare xx = -426/12
#while (xx < (2400/12))
  object{SideWalk  translate<xx,0,0>}
  #declare xx=xx+(96/12)
#end
object{ramp}
object{curb}
//----- end sidewalk and curb

// some more blocks for the first floor
#declare yy= 0
#while (yy< 13)
  object{Block  rotate<0,90,0> translate<-30,yy,2.5>}
  object{Block  rotate<0,90,0> translate<-30,yy,3.5>}
  object{Block  rotate<0,90,0> translate<29,yy,2.5>}
  #declare yy=yy+1
#end

object{BigWindow no_shadow translate<-7.5,15,7.8>}
object{BigWindow no_shadow translate<7.5,15,7.8>}

object{vaseTrim translate <-25,15,0>}
object{vaseTrim translate <25,15,0>}
object{vase translate <-25,15,0>}
object{vase translate <25,15,0>}


//------ start of cars on the street
  #declare BodyColor=OldGold
  #include "cab.inc"
  object{yellowCab    rotate<0,-90,0>scale .086 translate<97,1.872,47>}
  object{yellowCab    rotate<0,180,0>scale .086 translate<13,1.872,-15.5>}
  #declare BodyColor=Red*.55
  #include "cab.inc"
  object{yellowCab scale .086 translate<-70,1.872,-81.5>}
//------ end of cars on the street


object{ticketBooth translate<-7.75,0,0> }
object{ticketBooth translate<7.75,0,0> }
object{ticketTaker scale 12 translate<-7.75,3.75,-1.4>}


//-------- add the search light
  #declare yAngle= 45
  #declare zAngle= 41
  #include "d:\pov-ra~1\a&e\searlite.inc"
  object{searchLight translate<-38,-.33,-17.5>}


//---------- add a bunch of street lights
  #declare lampMult=.75
  #include "strlight.inc"
  object{streetLight translate<-38,0,-10>}

  #declare lampMult=1.0
  #include "strlight.inc"
  object{streetLight translate<-80,0,-10>}
  object{streetLight translate<50,0,50>}
  object{streetLight translate<50,0,90>}
  object{streetLight translate<50,0,170>}
  object{streetLight translate<-0,0,-88>}
  object{streetLight translate<-40,0,-88>}
  object{streetLight translate<40,0,-88>}
  object{streetLight translate<35,0,-10>}
  object{streetLight translate<50,0,8>}
  object{streetLight translate<104,0,47>}
//---------- end of street lights

//------------ add two boxes for the street yellow lines
  box{<-2000,-4.8,-580>/12,<2000,-7,-576>/12 no_shadow pigment{Yellow}}
  box{<-2000,-4.8,-584>/12,<2000,-7,-588>/12  no_shadow pigment{Yellow}}

//------ start paving the street
  object{roadSection translate<108,0,42>}
  object{roadSection translate<108,0,24>}
  object{roadSection translate<108,0,6>}

  object{roadSection translate<72,0,42>}
  object{roadSection translate<72,0,24>}
  object{roadSection translate<72,0,6>}

  object{roadSection translate<36,0,42>}
  object{roadSection translate<36,0,24>}
  object{roadSection translate<36,0,6>}

  object{roadSection translate<0,0,-12>}
  object{roadSection translate<0,0,-30>}
  object{roadSection translate<0,0,-48>}
  object{roadSection translate<0,0,-66>}

  object{roadSection translate<-36,0,-12>}
  object{roadSection translate<-36,0,-30>}
  object{roadSection translate<-36,0,-48>}
  object{roadSection translate<-36,0,-66>}

  object{roadSection translate<-72,0,60>}
  object{roadSection translate<-72,0,42>}
  object{roadSection translate<-72,0,24>}
  object{roadSection translate<-72,0,6>}
  object{roadSection translate<-72,0,-12>}
  object{roadSection translate<-72,0,-30>}
  object{roadSection translate<-72,0,-48>}
  object{roadSection translate<-72,0,-66>}
//------ end paving the street


//----- start add a couple of trees
  #declare TREE_RAND = seed(0)
  #declare Wiggle_Flag = on
  #declare Branches_On_End_Flag = on
  #declare Number_Of_Large_Branches = 5
  #declare Number_Of_Medium_Branches = 8
  #declare Number_Of_Small_Branches = 8
  #declare Large_Branch_Minimum_Angle = 20
  #declare Large_Branch_Maximum_Angle = 60
  #declare Medium_Branch_Minimum_Angle = 20
  #declare Medium_Branch_Maximum_Angle = 80
  #declare Small_Branch_Minimum_Angle = 20
  #declare Small_Branch_Maximum_Angle = 60
  #declare Tree_Trunk_Size = 12
  #declare Large_Branch_Size_Min = 2
  #declare Large_Branch_Size_Max = 4
  #declare Medium_Branch_Size_Min = 2
  #declare Medium_Branch_Size_Max = 3
  #declare Small_Branch_Size_Min = 2
  #declare Small_Branch_Size_Max = 4
  #declare Leaf_Type = 4
  #declare TREE_MESH_SIZE = 200
  #declare Leaf_Texture = texture { pigment{Green*.55} }
  #declare Bark_Texture = texture { T_Stone14 normal { bumps 2.0 scale 0.1 } }

  #include "ptd_tree.inc"
  object { Complete_Tree  scale 1.5 translate<117,-9,44>}
  object { Complete_Tree  scale 1.5 translate<117,-9,51>}
//----- end add a couple of trees

object{pictureAndFrame translate<-27.5,2,0>}
object{pictureAndFrame translate<22,2,0>}

//------ add spotlights for the picture frames
#if (buildingLights = True)
  light_source{
    <-25,10,-7>  color rgb <1.000, 1.000, 1.000>*.62
    spotlight               
    point_at <-25.5,5.5,0>      
    radius 15                
    tightness 3            
    falloff 25            
    atmosphere off
  }
  light_source{
    <25,10,-7>  color rgb <1.000, 1.000, 1.000>*.62
    spotlight             
    point_at <24,5.5,0>     
    radius 15            
    tightness 3           
    falloff 25           
    atmosphere off
  }
#end



