// Persistence of Vision Ray Tracer Scene Description File
// File: searlite.inc
// Vers: 3
// Desc: A street lightt
// Date: 10/05/97
// Auth: Bob Franke
//

#version 3


#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "finish.inc"
#include "stoneold.inc"
#include "glass.inc"


//----------------------------------------
#declare Lamp_tex =
texture {
  pigment { color Gray20 }
  finish { ambient .1 phong .7 }
}

#declare lightGlass =
box{<-.74,16.01,-.73>,<.74,17.99,-.72>
    texture{Glass_tex}
}

#declare gusset=
object{
  box{<-.25,.5,0.01>,<.25,-2.5,-0.01>}
  clipped_by{plane{x,0 inverse} rotate<0,0,20> translate<0,-.5,0>}
  translate<-.4,15.5,0>
  texture{Lamp_tex }
}


#declare streetLight=
union{
 light_source{
    <0,16.8,0>  color rgb <1.000, 1.000, 0.95>*1.5
    spotlight            
    point_at <0,0,0>   
    radius 10            
    tightness 2            
    falloff 90              
    atmosphere off
  }

  union{
    light_source { <0,17,0> color rgb<1, 1, 0.85>* .15*lampMult
      atmosphere off
      shadowless
/*
      area_light <4, 0, 0>, <0, 0, 4>, 4, 4
      adaptive 1
      jitter
*/
   }


    sphere { <0,17,0>, .16
      texture { pigment { color Yellow*1.5 } finish { ambient 1 diffuse 1 } }
      no_shadow
    }

    object{lightGlass }
    object{lightGlass rotate<0,90,0> }
    object{lightGlass rotate<0,180,0> }
    object{lightGlass rotate<0,270,0> }

    union{
      box{<-.75,16,-.75>,<-.70,18,-.70> }
      box{<-.75,16,.75>,<-.70,18,.70> }
      box{<.75,16,-.75>,<.70,18,-.70> }
      box{<.75,16,.75>,<.70,18,.70>}
 
      box{<-.75,16,-.75>,<.75,16.05,.75> }

      box{<-.75,18,-.75>,<.75,17.9,-.70> }
      box{<-.75,18,-.75>,<.75,17.9,-.70>  rotate<0,90,0> }
      box{<-.75,18,-.75>,<.75,17.9,-.70>  rotate<0,180,0> }
      box{<-.75,18,-.75>,<.75,17.9,-.70>  rotate<0,270,0> }

      box{<-.75,16,-.75>,<.75,16.05,-.70> }
      box{<-.75,16,-.75>,<.75,16.05,-.70> rotate<0,90,0> }
      box{<-.75,16,-.75>,<.75,16.05,-.70> rotate<0,270,0> }
      texture{Lamp_tex }
    }

    union{
      triangle {<-.75,18,-.75>, <0,19,0>, <.75,18,-.75>}
      triangle {<-.75,18,.75>, <0,19,0>, <.75,18,.75>}
      triangle {<-.75,18,.75>, <0,19,0>, <-.75,18,-.75>}
      triangle {<.75,18,.75>, <0,19,0>, <.75,18,-.75>}
      pigment{Cyan}
    }

    sphere{<0,19,0>,.18 texture{Gold_Texture}}
    sphere{<-.73,18.1,-.73>,.15 texture{Gold_Texture}}
    sphere{<-.73,18.1,-.73>,.15 rotate<0,90,0> texture{Gold_Texture}}
    sphere{<-.73,18.1,-.73>,.15 rotate<0,180,0> texture{Gold_Texture}}
    sphere{<-.73,18.1,-.73>,.15 rotate<0,270,0> texture{Gold_Texture}}
    no_shadow
  }

  union{
    cone {<0,0,0>, 5/12, <0,16,0>, 3/12  }
    superellipsoid{  <0.35, .35>  scale<1,2,1> translate<0,1,0>      }
    torus{5/12,3/12 translate<0,2.9,0>  }
    #declare xx=0
    #while (xx < 350)
      object{gusset rotate<0,xx,0> no_shadow}
      #declare xx=xx+30
    #end
    torus{3.5/12,1.5/12 translate<0,14.5,0>  }
    torus{.7,.75/12 translate<0,15.6,0> no_shadow }
    texture{Lamp_tex }
  }
}


