
#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "glass.inc"
#include "metals.inc"
#include "consts.inc"
#include "film2.inc"

#include "stones1.inc"
#include "woods.inc"
#declare Area_Lights = off
#if(Area_Lights)
    #debug "\nArea lights are ON"
#else
    #debug "\nArea lights are OFF"
#end


camera {  //  Camera Camera01
  location  <5.8, 9.900, -10.700>
  look_at   <5.8,  0.000, -3>
}


#declare Water = texture {
  pigment {
    color rgbf <0.0, 0.0, 0.0, 0.6>
  }
  //normal { bumps 0.4 }
  finish {
    reflection 0.4
    refraction 0.5
    ior 1.33
    phong 1.0
    phong_size 100
  }
}

// Declare Spill shape
#declare Spill=
    merge{
	 sphere{ <0,0,0> 1 scale <3,.22,1>}
	 //sphere{ <-.5,0,-1> 1 scale <3,.22,1> }
     sphere{ <0,0,0> 1 scale <3,.22,1> rotate <0,-36,0> }
     sphere{ <0,0,0> 1 scale <3,.22,1> rotate <0,-66,0> }
     sphere{ <0,0,0> 1 scale <3,.22,1> rotate <0,90,0> translate <.75,0,1>}
	 }


//Declare olive shape

#declare OLIVE = union{
// create a sphere shape
sphere
{
  <0, 1, 0>
   0.5
   scale <1.6,1,1>
   pigment {DarkOliveGreen} // Duh! what other color would it be?
}

// create a sphere shape
sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  0.2       // radius of sphere
   pigment {Brown}     // Brown always looked pimento color to me
   translate <-.7,0,0>
}
}
// Declare Sky
sky_sphere{
   pigment{ SkyBlue }
   }


#declare MGlass =
lathe {
  cubic_spline
  13,
  <0.000000, 0.000000>,
  <0.000000, 0.000000>,
  <0.193050, 0.003861>,
  <0.193050, 0.019305>,
  <0.073359, 0.038610>,
  <0.027027, 0.135135>,
  <0.023166, 0.559846>,
  <0.100386, 0.679537>,
  <0.359073, 0.996139>,
  <0.335907, 1.000000>,
  <0.096525, 0.725869>,
  <0.000000, 0.691120>,
  <0.000000, 0.691120>

  scale <1.5, 1.5, 1.5>
}

#declare Dist=15
#declare L = 0.7

//light_source {   // Light001
//  <0.000, 0.000, 7.500>
//  color rgb L
//  #if(Area_Lights)
//     #debug "\nDing! Area light #1 turned on."
//     area_light <-6, -6, 0>, <6, 6, 0>, 5, 5
//     adaptive 1
//     jitter
//  #end
//  fade_distance Dist fade_power 2
//}

light_source {   // Light002
  <4.000, 15.000, -11.500>
  color rgb L
  #if(Area_Lights)
     #debug "\nBing! Area light #2 turned on.\n"
     area_light <-10.5, -1.5, 0>, <10.5, 1.5, 0>, 5, 5
     adaptive 1
     jitter
  #end
  fade_distance Dist fade_power 2
}
//light_source {
 //    <10,200,-50>
 //    shadowless
  //   }
light_source {<7,100,-1> LightGray
             shadowless}
light_source {<0,100,-1> LightGray
             shadowless}
// ********  O B J E C T S *******






    box {   // Floor
      <-1, -1, -1>, <1, 1, 1>
      scale <30.010000, 0.03,50.00001>
      translate <10.000000, 0.000000, -10.000>
      texture {
        T_Stone10
        scale <.1,.1,.1>
        finish {  reflection 0.01 }
      }
   }







#declare Star =
union{
triangle {
   <-1,0,0>,<0,0,-2.5>,<1,0,0>
  }
triangle {
     <-1,0,0>,<0,0,-2.5>,<1,0,0>

   rotate <0,72,0>
   }
triangle {
     <-1,0,0>,<0,0,-2.5>,<1,0,0>

   rotate <0,144,0>
}
triangle {
     <-1,0,0>,<0,0,-2.5>,<1,0,0>

   rotate <0,216,0>
}
triangle {
     <-1,0,0>,<0,0,-2.5>,<1,0,0>

   rotate <0,284,0>
}

   scale <1,10,1>

}




text { ttf "timrom.ttf" "GEORGE BURNS" .25, 0.1*x
  rotate<90,0,0>
  scale <1.25,1.25,1.25>
  translate<.5 ,.15,-.2>
  texture { T_Brass_4A }
  finish { reflection 0.35 specular 1 }

}

object{ Star
        texture{T_Brass_4A}
        scale <4,1,4>
        rotate<0,36,0>
        translate <6,.1,-1>

        }
object{ Star
       texture{T_Grnt12
         scale <.1,.1,.1>}
        scale <3.8,.95,3.8>
        rotate<0,36,0>
        translate <6,.12,-1>
        }
object {
  MGlass
  pigment{color rgbf<1.0, 1.0, 1.0, 0.85>}
  finish {
      F_Glass3
  }
  scale <2, 2, 2>
  rotate <0,45,90>
  translate <8.7, 0.22, 2.5>
}


#declare Cigar=
union{
cylinder
{
  0*x,  3*x,  .2
  //rotate <0,-45,0>
  //translate <6,.22,-3>

  // open
}

// create a sphere shape
sphere
{
  <3, 0, 0> // center of sphere <X Y Z>
  0.2       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
}
}

// Glowing ashes
#declare GlowTip =
    cylinder { -.1*x, 0*x, .201  hollow
    no_shadow
    pigment { colour Clear }
    halo {
        linear
        max_value 0.15
        cylindrical_mapping
        turbulence 0.3
        colour_map {
             [0.0 color rgbt <1, 0.5, 0, 1>]
             [0.95 color rgbt <1, 0.5, 0, 0>]
        }
        samples 10
        aa_level 0
        aa_threshold 0.3
        scale <0.75, 1.1, 1.1>
    }
   // rotate z*90
   // scale <2.0, 7.5, 7.5>
  //  translate <6,.22,-3>                  // position at ash tip of cigarette
}

 // ashes... a cylinder with rounded cap ends
        superellipsoid { <1.0, 0.65> scale <.2, .12, .25> rotate y*90
            pigment {
                gradient x
                turbulence 0.35
                color_map {
                    [ 0.00 Gray60 ]       // ashes
                    [ 0.05 Gray20 ]       // dark burned area
                    [ 0.10 Gray60 ]       // ashes
                    [ 0.15 Gray20 ]       // dark burned area
                    [ 0.20 Gray60 ]       // ashes
                    [ 0.25 Gray20 ]       // dark burned area
                    [ 0.30 Gray60 ]       // ashes
                    [ 0.50 Gray20 ]       // dark burned area
                    [ 0.60 Orange ]      // a little extra glow
                    [ 0.85 red 0.4 ]
                    [ 0.90 Gray20 ]
                    [ 1.00 White ]
                }
                scale .2
                //translate -x*5
            }
            rotate <0,-45,0>
            translate<6,.22,-3>
            //rotate <0,-45,0>
            finish { ambient 0.4 }
        }



object{
  Cigar
  rotate <0,-45,0>
  translate <6,.22,-3>


 texture{T_Wood17
 			normal{ bumps .9 scale .2}
            scale <100,4,1>
           rotate<45,-45,45>
           }
           finish{diffuse .8}
}

object{
GlowTip
rotate<90,-45,0>
translate<6,.22,-3>}




// scale and place martini spill
object { Spill
   	    	texture { T_Glass3
                    finish {
						    ior 1.33
						    phong 1.0
						    phong_size 100
						   }
         			}

            scale <.55,.15,.25>
            rotate<0,-95,0>
			translate <5,.22,2.53>
		  }



//Scale and place olive

object{   OLIVE
          scale<.43,.43,.43>
          rotate<45,-45,0>
          translate <4,.02,2.53>
      }



// Scale and place film sign
object {
          Film
          scale <.25,.03,.25>
          rotate <0,180,0>
          translate <5.8,.15,-3.3>
       }

