
// ********  TEXTURES  *******
//

#include "objs.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare SzGardin1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006387, 0.033047, 39.858155>, <0.681133, -2.247271, 39.858155>, <1.666832, 3.280772, 39.858155>, <2.591142, 0.516750, 39.858155>,
      <0.006387, 0.022031, 33.208644>, <0.681133, -2.258287, 33.208644>, <1.666832, 3.269757, 33.208644>, <2.591142, 0.505735, 33.208644>,
      <0.005361, 0.011016, 26.559134>, <0.571788, -2.269302, 26.559134>, <1.399248, 3.258741, 26.559134>, <2.400731, 0.494719, 25.525250>,
      <0.003281, -0.001778, 20.658876>, <0.349896, -2.650131, 20.658876>, <0.856248, 3.770118, 20.658876>, <1.427246, 0.995322, 19.958567>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.003281, -0.001778, 20.658876>, <0.349896, -2.650131, 20.658876>, <0.856248, 3.770118, 20.658876>, <1.427246, 0.995322, 19.958567>,
      <0.001200, -0.014571, 14.758618>, <0.128005, -3.030959, 14.758618>, <0.313247, 4.281496, 14.758618>, <0.451790, 1.495925, 14.391883>,
      <0.003573, -0.016402, 8.903084>, <0.381062, -1.714133, 8.903084>, <0.932514, 2.401578, 8.903084>, <1.442336, 0.343722, 8.828441>,
      <0.003573, -0.024604, -0.052403>, <0.381062, -1.722335, -0.052403>, <0.853404, 2.393377, 0.233350>, <1.363225, 0.335521, 0.403245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.591142, 0.516750, 39.858155>, <3.515451, -2.247271, 39.858155>, <6.249186, 3.280772, 39.858155>, <6.836860, 0.516750, 39.858155>,
      <2.591142, 0.505735, 33.208644>, <3.515451, -2.258287, 33.208644>, <6.249186, 3.269757, 33.208644>, <6.836860, 0.505735, 33.208644>,
      <2.400731, 0.494719, 25.525250>, <3.402214, -2.269302, 24.491367>, <4.886613, 4.250953, 22.571297>, <5.855022, 0.990825, 22.571297>,
      <1.427246, 0.995322, 19.958567>, <1.996274, -1.779474, 19.258257>, <2.834460, 3.315571, 18.298222>, <3.393451, 0.768049, 18.298222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.427246, 0.995322, 19.958567>, <1.996274, -1.779474, 19.258257>, <2.834460, 3.315571, 18.298222>, <3.393451, 0.768049, 18.298222>,
      <0.451790, 1.495925, 14.391883>, <0.590333, -1.289645, 14.025148>, <0.782306, 2.380189, 14.025148>, <0.931879, 0.545272, 14.025148>,
      <1.442336, 0.343722, 8.828441>, <1.952157, -1.714133, 8.753797>, <2.717525, 2.401578, 8.753797>, <3.336049, 0.343722, 8.794143>,
      <1.363225, 0.335521, 0.403245>, <1.873046, -1.722335, 0.573139>, <2.638414, 2.393377, 1.126335>, <3.153888, 0.335521, 1.611343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.836860, 0.516750, 39.858155>, <7.424533, -2.247271, 39.858155>, <8.410232, 3.280772, 39.858155>, <9.454401, 1.310520, 39.858155>,
      <6.836860, 0.505735, 33.208644>, <7.424533, -2.258287, 33.208644>, <8.410232, 3.269757, 33.208644>, <9.454401, 1.299504, 33.208644>,
      <5.855022, 0.990825, 22.571297>, <6.823431, -2.269302, 22.571297>, <7.650892, 3.258741, 22.571297>, <8.652375, 0.494719, 22.571297>,
      <3.393451, 0.768049, 18.298222>, <3.952442, -1.779474, 18.298222>, <4.437960, 2.540239, 18.298222>, <5.025587, 0.380383, 18.298222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.393451, 0.768049, 18.298222>, <3.952442, -1.779474, 18.298222>, <4.437960, 2.540239, 18.298222>, <5.025587, 0.380383, 18.298222>,
      <0.931879, 0.545272, 14.025148>, <1.081452, -1.289645, 14.025148>, <1.225028, 1.821736, 14.025148>, <1.398800, 0.266046, 14.025148>,
      <3.336049, 0.343722, 8.794143>, <3.954573, -1.714133, 8.834490>, <4.071338, 2.401578, 8.985153>, <4.674028, 0.758128, 8.985153>,
      <3.153888, 0.335521, 1.611343>, <3.669362, -1.722335, 2.096352>, <4.021838, 2.393377, 2.498776>, <4.525894, 0.751910, 3.028843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <9.454401, 1.310520, 39.858155>, <10.498570, -0.659732, 39.858155>, <11.781932, 3.280772, 39.858155>, <12.974933, 0.516750, 39.858155>,
      <9.454401, 1.299504, 33.208644>, <10.498570, -0.670748, 33.208644>, <11.781932, 3.269757, 33.208644>, <12.974933, 0.505735, 33.208644>,
      <8.652375, 0.494719, 22.571297>, <9.653858, -2.269302, 22.571297>, <10.394510, 3.258741, 21.561588>, <11.204862, 0.494719, 20.426835>,
      <5.025587, 0.380383, 18.298222>, <5.613215, -1.779474, 18.298222>, <6.055329, 2.540239, 17.793368>, <6.547391, 0.380383, 17.225991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.025587, 0.380383, 18.298222>, <5.613215, -1.779474, 18.298222>, <6.055329, 2.540239, 17.793368>, <6.547391, 0.380383, 17.225991>,
      <1.398800, 0.266046, 14.025148>, <1.572572, -1.289645, 14.025148>, <1.716148, 1.821736, 14.025148>, <1.889920, 0.266046, 14.025148>,
      <4.674028, 0.758128, 8.985153>, <5.276718, -0.885322, 8.985153>, <6.338827, 1.240376, 13.528603>, <6.826471, -0.027734, 14.467747>,
      <4.525894, 0.751910, 3.028843>, <5.029949, -0.889558, 3.558909>, <5.600262, 1.236140, 4.207818>, <6.140377, -0.243097, 5.131196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <12.974933, 0.516750, 39.858155>, <14.167934, -2.247271, 39.858155>, <16.051940, -0.312456, 39.858155>, <16.139331, 0.724052, 39.858155>,
      <12.974933, 0.505735, 33.208644>, <14.167934, -2.258287, 33.208644>, <16.051940, -0.323472, 33.208644>, <16.139331, 0.713037, 33.208644>,
      <11.204862, 0.494719, 20.426835>, <12.015213, -2.269302, 19.292082>, <13.266242, -0.334487, 18.593157>, <13.331318, 0.702021, 18.593157>,
      <6.547391, 0.380383, 17.225991>, <7.039452, -1.779474, 16.658615>, <7.802178, -0.267574, 16.309152>, <7.841081, 0.542372, 16.309152>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.547391, 0.380383, 17.225991>, <7.039452, -1.779474, 16.658615>, <7.802178, -0.267574, 16.309152>, <7.841081, 0.542372, 16.309152>,
      <1.889920, 0.266046, 14.025148>, <2.063691, -1.289645, 14.025148>, <2.338114, -0.200661, 14.025148>, <2.350844, 0.382723, 14.025148>,
      <6.826471, -0.027734, 14.467747>, <7.314114, -1.295845, 15.406891>, <8.592904, -0.206861, 15.463228>, <8.633500, 0.376523, 15.463228>,
      <6.140377, -0.243097, 5.131196>, <6.680492, -1.722335, 6.054574>, <7.406523, -0.281836, 7.625694>, <7.448829, 0.489860, 7.625694>
    }
  }
  texture {
    GardinTex
  }
  scale 0.85
}
#declare GardinBand = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.077489, 0.508211, 0.000000>, <-3.077489, -2.271011, 0.000000>, <2.675930, -1.119579, 0.000000>, <2.675930, -0.119579, 0.000000>,
      <-3.077489, 0.508211, 0.271193>, <-3.077489, -2.271011, 0.271193>, <2.086030, -0.863101, 0.271193>, <2.380980, 0.008660, 0.271193>,
      <-3.077489, 0.508211, 0.542386>, <-3.077489, -2.271011, 0.542386>, <2.727225, -1.119579, 0.388500>, <2.816993, -0.119579, 0.337204>,
      <-3.077489, 0.508211, 0.813580>, <-3.077489, -2.271011, 0.813580>, <2.675930, -1.119579, 0.813580>, <2.675930, -0.119579, 0.813580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.675930, -0.119579, 0.000000>, <2.675930, 0.880421, 0.000000>, <-3.077489, 3.287433, 0.000000>, <-3.077489, 0.508211, 0.000000>,
      <2.380980, 0.008660, 0.271193>, <2.675930, 0.880421, 0.271193>, <-3.077489, 3.287433, 0.271193>, <-3.077489, 0.508211, 0.271193>,
      <2.816993, -0.119579, 0.337204>, <2.906760, 0.880421, 0.285908>, <-3.077489, 3.287433, 0.542386>, <-3.077489, 0.508211, 0.542386>,
      <2.675930, -0.119579, 0.813580>, <2.675930, 0.880421, 0.813580>, <-3.077489, 3.287433, 0.813580>, <-3.077489, 0.508211, 0.813580>
    }
  }
  texture {
    GardinBandsTex
  }
  rotate 4.423121*y
  translate  <2.774953, -0.02485, 12.567605>
}
#declare SzGardin=
union { // SzGardin
  object { SzGardin1 }
  object { GardinBand }
  //translate  21.0*x
}

#declare SvavaSkynke=
union { // SvavaSkynke
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.479653, -0.030486, -13.671516>, <-0.864899, -0.275427, -13.671516>, <-0.505922, 0.115074, -13.671516>, <0.073744, -0.072945, -13.671516>,
      <-3.479653, -0.030486, -5.772523>, <-1.453766, -0.275443, -5.772523>, <-0.850379, 0.115057, -5.772523>, <0.123952, -0.072962, -5.772523>,
      <-3.479653, -0.029303, 0.172688>, <-2.033489, -0.538775, -0.098634>, <-1.261770, 0.208143, -0.007629>, <0.473054, -0.157182, -0.007629>,
      <-3.479653, -0.029902, 3.652357>, <-2.001907, -0.538705, 3.335681>, <-1.261770, 0.214129, 3.453314>, <0.473054, -0.144064, 3.453314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.479653, -0.029902, 3.652357>, <-2.001907, -0.538705, 3.335681>, <-1.261770, 0.214129, 3.453314>, <0.473054, -0.144064, 3.453314>,
      <-3.479653, -0.030502, 7.132026>, <-1.970325, -0.538636, 6.769996>, <-1.261770, 0.220115, 6.914256>, <0.473054, -0.145210, 6.914256>,
      <-3.479653, -0.030500, 10.766378>, <-2.135651, -0.538384, 10.595971>, <-1.261770, 0.214008, 10.541740>, <0.473054, -0.151317, 10.541740>,
      <-3.479653, -0.030487, 13.671516>, <-1.982408, -0.535353, 13.671516>, <-1.159608, 0.223398, 13.671516>, <0.575216, -0.141926, 13.671516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.073744, -0.072945, -13.671516>, <0.653409, -0.260964, -13.671516>, <1.036907, 0.071685, -13.671516>, <3.480482, -0.030486, -13.671516>,
      <0.123952, -0.072962, -5.772523>, <1.098284, -0.260980, -5.772523>, <1.742886, 0.071668, -5.772523>, <3.480482, -0.030486, -5.772523>,
      <0.473054, -0.157182, -0.007629>, <2.207879, -0.522506, -0.007629>, <2.325582, 0.135671, -0.098634>, <3.480482, -0.029303, 0.172688>,
      <0.473054, -0.144064, 3.453314>, <2.207879, -0.516520, 3.453314>, <2.357164, 0.135740, 3.335681>, <3.480482, -0.029902, 3.652357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.473054, -0.144064, 3.453314>, <2.207879, -0.516520, 3.453314>, <2.357164, 0.135740, 3.335681>, <3.480482, -0.029902, 3.652357>,
      <0.473054, -0.145210, 6.914256>, <2.207879, -0.510534, 6.914256>, <2.388745, 0.135809, 6.769996>, <3.480482, -0.030502, 7.132026>,
      <0.473054, -0.151317, 10.541740>, <2.207879, -0.516641, 10.541740>, <2.223420, 0.136061, 10.595971>, <3.480482, -0.030500, 10.766378>,
      <0.575216, -0.141926, 13.671516>, <2.310041, -0.507251, 13.671516>, <2.376663, 0.139093, 13.671516>, <3.480482, -0.030487, 13.671516>
    }
  }
  texture {
    SvavaTex
    scale <6.843279, 27.393209, 1.0>
    rotate 90.0*x
  translate <-3.407258, 0.000000, -13.680641>
  }
  translate  <18.0, 0.0, 13.675763>
  translate -x*18
}


#declare Gardin1=
union { // Gardin1
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.648282, 0.227779, -7.341377>, <3.682817, 0.219031, -4.907697>, <3.717352, 0.210284, -2.474016>, <3.751887, 0.201536, -0.040336>,
      <3.462024, -0.425170, -7.343479>, <3.496559, -0.433918, -4.909798>, <3.531094, -0.442666, -2.476117>, <3.565629, -0.451413, -0.042437>,
      <2.851081, 0.424611, -7.345580>, <2.885616, 0.415863, -4.911899>, <2.920151, 0.407116, -2.478219>, <2.954687, 0.398368, -0.044538>,
      <2.669850, 0.220847, -7.347714>, <2.511517, 0.212099, -4.914000>, <2.546052, 0.203352, -2.480320>, <2.580587, 0.194604, -0.046639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.669850, 0.220847, -7.347714>, <2.511517, 0.212099, -4.914000>, <2.546052, 0.203352, -2.480320>, <2.580587, 0.194604, -0.046639>,
      <2.488620, 0.017083, -7.349847>, <2.137417, 0.008336, -4.916102>, <2.171953, -0.000412, -2.482421>, <2.206488, -0.009159, -0.048740>,
      <1.118916, 0.295173, -7.351818>, <1.461139, 0.286426, -4.918203>, <1.495674, 0.277678, -2.484522>, <1.530209, 0.268931, -0.050842>,
      <0.784322, -0.080097, -7.353952>, <0.972701, -0.088845, -4.920304>, <1.007236, -0.097592, -2.486623>, <1.041772, -0.106340, -0.052943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.784322, -0.080097, -7.353952>, <0.972701, -0.088845, -4.920304>, <1.007236, -0.097592, -2.486623>, <1.041772, -0.106340, -0.052943>,
      <0.449728, -0.455368, -7.356086>, <0.484263, -0.464116, -4.922405>, <0.518799, -0.472863, -2.488725>, <0.553334, -0.481611, -0.055044>,
      <0.377808, 0.753761, -7.358187>, <0.412344, 0.745014, -4.924506>, <0.446879, 0.736266, -2.490826>, <0.481414, 0.727519, -0.057145>,
      <-0.053460, 0.019142, -7.360288>, <-0.018925, 0.010394, -4.926607>, <0.015610, 0.001647, -2.492927>, <0.050146, -0.007101, -0.059246>
    }
  }
  texture {
    GardinTex
  }
  translate  0.0*x
}

#declare PennStall=
union { // PennStallet
  superellipsoid { // PennStall
    <0.1, 1.0>
    texture {
      DMFWood5
    }
    scale <1.030859, 0.423717, 0.537696>
    rotate -90.0*x
  }
  sphere { // PennaBas
    <0,0,0>,1
    texture {
      PennTex
    }
    scale <0.13, 0.13, 1.3>
    rotate <-18.813343, -35.06786, -1.874367>
    translate  <0.059067, 0.074164, 1.001724>
  }
  translate  0.0*x
}

/*
#declare SzLampScreen = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  49  // control points
  <-1.079864, -1.079864>,
  <-0.807286, -1.063891>,
  <-0.754548, -1.287511>,
  <-0.521571, -1.191674>,
  <-0.391378, -1.375362>,
  <-0.157362, -1.279525>,
  <-0.007252, -1.487172>,
  <0.169738, -1.326664>,
  <0.400294, -1.425422>,
  <0.546597, -1.243098>,
  <0.771937, -1.273486>,
  <0.860775, -1.091162>,
  <1.091162, -1.067982>,
  <1.091162, -0.829775>,
  <1.281083, -0.762975>,
  <1.212711, -0.510823>,
  <1.417825, -0.363036>,
  <1.33426, -0.175307>,
  <1.495158, 0.000735>,
  <1.303873, 0.177335>,
  <1.402632, 0.400294>,
  <1.151937, 0.546597>,
  <1.281083, 0.740387>,
  <1.037984, 0.839225>,
  <1.060775, 1.060385>,
  <0.816401, 1.083565>,
  <0.734927, 1.265889>,
  <0.523415, 1.212711>,
  <0.418259, 1.395035>,
  <0.172166, 1.341857>,
  <-0.000735, 1.503145>,
  <-0.161362, 1.33543>,
  <-0.372041, 1.391335>,
  <-0.539, 1.191674>,
  <-0.781878, 1.247579>,
  <-0.868054, 1.047919>,
  <-1.071878, 1.079864>,
  <-1.063891, 0.805396>,
  <-1.303484, 0.730588>,
  <-1.215633, 0.489294>,
  <-1.44724, 0.399365>,
  <-1.319457, 0.165348>,
  <-1.495158, -0.008721>,
  <-1.303484, -0.161362>,
  <-1.440851, -0.394147>,
  <-1.231606, -0.517391>,
  <-1.303484, -0.741946>,
  <-1.087851, -0.828122>,
  <-1.079864, -1.079864>
  rotate <90,0,90>
  texture {
    Chrome_Metal1
  }
  scale <1.0, 1.06221, 3.301756>
  rotate <-180.0, 0.0, 180.0>
  translate  5.0*z
}
#declare SzLampScreenX = intersection {
  object { SzLampScreen }
  box { // Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.644782, 1.767252, 1.477616>
    translate  <0.0, 0.041473, 2.198073>
  }
  texture {
    SzLampScreenTex
  }
  translate  1.1*z
}
#declare SzLampBase = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.228306, 0.000000, 0.000000>, <-0.228306, 0.280401, 0.000000>, <0.228306, 0.280401, 0.000000>, <0.228306, 0.000000, 0.000000>,
      <-0.343703, 0.000000, 0.501332>, <-0.343703, 0.451480, 0.501332>, <0.343703, 0.451480, 0.501332>, <0.343703, 0.000000, 0.501332>,
      <-0.391734, 0.000000, 1.002664>, <-0.391734, 0.537905, 1.002664>, <0.391734, 0.537905, 1.002664>, <0.391734, 0.000000, 1.002664>,
      <-0.459089, 0.000000, 1.498342>, <-0.459089, 0.625752, 1.503995>, <0.459089, 0.625752, 1.503995>, <0.459089, 0.000000, 1.498342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.228306, 0.000000, 0.000000>, <0.228306, -0.280401, 0.000000>, <-0.228306, -0.280401, 0.000000>, <-0.228306, 0.000000, 0.000000>,
      <0.343703, 0.000000, 0.501332>, <0.343703, -0.451480, 0.501332>, <-0.343703, -0.451480, 0.501332>, <-0.343703, 0.000000, 0.501332>,
      <0.391734, 0.000000, 1.002664>, <0.391734, -0.537905, 1.002664>, <-0.391734, -0.537905, 1.002664>, <-0.391734, 0.000000, 1.002664>,
      <0.459089, 0.000000, 1.498342>, <0.459089, -0.625752, 1.503995>, <-0.459089, -0.625752, 1.503995>, <-0.459089, 0.000000, 1.498342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.459089, 0.000000, 1.498342>, <-0.459089, 0.625752, 1.503995>, <0.459089, 0.625752, 1.503995>, <0.459089, 0.000000, 1.498342>,
      <-0.526444, 0.000000, 2.005327>, <-0.526444, 0.713599, 2.005327>, <0.526444, 0.713599, 2.005327>, <0.526444, 0.000000, 2.005327>,
      <-0.293599, 0.000000, 2.153219>, <-0.293599, 0.322511, 2.153219>, <0.279756, 0.322511, 2.153219>, <0.279756, 0.000000, 2.153219>,
      <-0.152378, 0.000000, 2.391525>, <-0.152378, 0.212330, 2.391525>, <0.152378, 0.212330, 2.391525>, <0.152378, 0.000000, 2.391525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.459089, 0.000000, 1.498342>, <0.459089, -0.625752, 1.503995>, <-0.459089, -0.625752, 1.503995>, <-0.459089, 0.000000, 1.498342>,
      <0.526444, 0.000000, 2.005327>, <0.526444, -0.713599, 2.005327>, <-0.526444, -0.713599, 2.005327>, <-0.526444, 0.000000, 2.005327>,
      <0.279756, 0.000000, 2.153219>, <0.279756, -0.322511, 2.153219>, <-0.293599, -0.322511, 2.153219>, <-0.293599, 0.000000, 2.153219>,
      <0.152378, 0.000000, 2.391525>, <0.152378, -0.212330, 2.391525>, <-0.152378, -0.212330, 2.391525>, <-0.152378, 0.000000, 2.391525>
    }
  }
  texture {
    SzLampBaseTex
  }
  translate  0.25*z
}
#declare SzLamp=
union { // SzLamp
  object { SzLampScreenX no_shadow}
  object { SzLampBase }
  torus { // SzLampBottom
    1.0, 1.0  rotate -x*90
    texture {
      SzLampBaseTex
    }
    scale <0.3, 0.3, 0.25>
  }
  torus { // SzLampGoldB
    1.5, 0.5  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.16, 0.16, 0.25>
    translate  <0.0, 0.0, 0.265484>
  }
  torus { // SzLampGoldT
    1.5, 0.5  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.1, 0.1, 0.174143>
    translate  <0.0, 0.0, 2.575586>
  }
  torus { // SzScreenRing
    1.5, 0.01  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale <0.396872, 0.438058, 0.125378>
    translate  <-0.003315, 0.0, 4.645477>
  }
light_source
 {<0,0,4> color rgb<1,1,.7>/2.8 fade_distance 5 fade_power 1}
  translate  0.0*x
}
*/
#declare SzLampBase = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.228306, 0.000000, 0.000000>, <-0.228306, 0.280401, 0.000000>, <0.228306, 0.280401, 0.000000>, <0.228306, 0.000000, 0.000000>,
      <-0.343703, 0.000000, 0.501332>, <-0.343703, 0.451480, 0.501332>, <0.343703, 0.451480, 0.501332>, <0.343703, 0.000000, 0.501332>,
      <-0.391734, 0.000000, 1.002664>, <-0.391734, 0.537905, 1.002664>, <0.391734, 0.537905, 1.002664>, <0.391734, 0.000000, 1.002664>,
      <-0.459089, 0.000000, 1.498342>, <-0.459089, 0.625752, 1.503995>, <0.459089, 0.625752, 1.503995>, <0.459089, 0.000000, 1.498342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.228306, 0.000000, 0.000000>, <0.228306, -0.280401, 0.000000>, <-0.228306, -0.280401, 0.000000>, <-0.228306, 0.000000, 0.000000>,
      <0.343703, 0.000000, 0.501332>, <0.343703, -0.451480, 0.501332>, <-0.343703, -0.451480, 0.501332>, <-0.343703, 0.000000, 0.501332>,
      <0.391734, 0.000000, 1.002664>, <0.391734, -0.537905, 1.002664>, <-0.391734, -0.537905, 1.002664>, <-0.391734, 0.000000, 1.002664>,
      <0.459089, 0.000000, 1.498342>, <0.459089, -0.625752, 1.503995>, <-0.459089, -0.625752, 1.503995>, <-0.459089, 0.000000, 1.498342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.459089, 0.000000, 1.498342>, <-0.459089, 0.625752, 1.503995>, <0.459089, 0.625752, 1.503995>, <0.459089, 0.000000, 1.498342>,
      <-0.526444, 0.000000, 2.005327>, <-0.526444, 0.713599, 2.005327>, <0.526444, 0.713599, 2.005327>, <0.526444, 0.000000, 2.005327>,
      <-0.293599, 0.000000, 2.153219>, <-0.293599, 0.322511, 2.153219>, <0.279756, 0.322511, 2.153219>, <0.279756, 0.000000, 2.153219>,
      <-0.152378, 0.000000, 2.391525>, <-0.152378, 0.212330, 2.391525>, <0.152378, 0.212330, 2.391525>, <0.152378, 0.000000, 2.391525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.459089, 0.000000, 1.498342>, <0.459089, -0.625752, 1.503995>, <-0.459089, -0.625752, 1.503995>, <-0.459089, 0.000000, 1.498342>,
      <0.526444, 0.000000, 2.005327>, <0.526444, -0.713599, 2.005327>, <-0.526444, -0.713599, 2.005327>, <-0.526444, 0.000000, 2.005327>,
      <0.279756, 0.000000, 2.153219>, <0.279756, -0.322511, 2.153219>, <-0.293599, -0.322511, 2.153219>, <-0.293599, 0.000000, 2.153219>,
      <0.152378, 0.000000, 2.391525>, <0.152378, -0.212330, 2.391525>, <-0.152378, -0.212330, 2.391525>, <-0.152378, 0.000000, 2.391525>
    }
  }
  texture {
    SzLampBaseTex
  }
  translate  0.25*z
}
#declare SzLampScreen = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  49  // control points
  <-1.079864, -1.079864>,
  <-0.807286, -1.063891>,
  <-0.754548, -1.287511>,
  <-0.521571, -1.191674>,
  <-0.391378, -1.375362>,
  <-0.157362, -1.279525>,
  <-0.007252, -1.487172>,
  <0.169738, -1.326664>,
  <0.400294, -1.425422>,
  <0.546597, -1.243098>,
  <0.771937, -1.273486>,
  <0.860775, -1.091162>,
  <1.091162, -1.067982>,
  <1.091162, -0.829775>,
  <1.281083, -0.762975>,
  <1.212711, -0.510823>,
  <1.417825, -0.363036>,
  <1.33426, -0.175307>,
  <1.495158, 0.000735>,
  <1.303873, 0.177335>,
  <1.402632, 0.400294>,
  <1.151937, 0.546597>,
  <1.281083, 0.740387>,
  <1.037984, 0.839225>,
  <1.060775, 1.060385>,
  <0.816401, 1.083565>,
  <0.734927, 1.265889>,
  <0.523415, 1.212711>,
  <0.418259, 1.395035>,
  <0.172166, 1.341857>,
  <-0.000735, 1.503145>,
  <-0.161362, 1.33543>,
  <-0.372041, 1.391335>,
  <-0.539, 1.191674>,
  <-0.781878, 1.247579>,
  <-0.868054, 1.047919>,
  <-1.071878, 1.079864>,
  <-1.063891, 0.805396>,
  <-1.303484, 0.730588>,
  <-1.215633, 0.489294>,
  <-1.44724, 0.399365>,
  <-1.319457, 0.165348>,
  <-1.495158, -0.008721>,
  <-1.303484, -0.161362>,
  <-1.440851, -0.394147>,
  <-1.231606, -0.517391>,
  <-1.303484, -0.741946>,
  <-1.087851, -0.828122>,
  <-1.079864, -1.079864>
  rotate <90,0,90>
  texture {
    Chrome_Metal1
  }
  scale <1.0, 1.06221, 3.301756>
  rotate <-180.0, 0.0, 180.0>
  translate  5.0*z
}
#declare SzLampScreenX = intersection {
  object { SzLampScreen }
  box { // Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.644782, 1.767252, 1.477616>
    translate  <0.0, 0.041473, 2.198073>
  }
  texture {
    SzLampScreenTex
  }
  no_shadow
  translate  1.1*z
}
#declare LampSkarm = difference {
  object { SzLampScreenX }
  cone { // SzLampScreenInn
    <0,0,0>, 0.4, <0,0,1>, 1.0
    texture {
      SzLampScreenT1
    }
    no_shadow
    scale <1.279034, 1.31981, 2.02559>
    rotate <180.0, 0.0, 180.0>
    translate  <0.0, 0.0, 4.802454>
  }
}
#declare SzLamp=
union { // SzLamp
  object { SzLampBase }
  torus { // SzLampBottom
    1.0, 1.0  rotate -x*90
    texture {
      SzLampBaseTex
    }
    scale <0.3, 0.3, 0.25>
  }
  torus { // SzLampGoldB
    1.5, 0.5  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.16, 0.16, 0.25>
    translate  <0.0, 0.0, 0.265484>
  }
  torus { // SzLampGoldT
    1.5, 0.5  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.1, 0.1, 0.174143>
    translate  <0.0, 0.0, 2.575586>
  }
  cone { // SzLampSkInner
    <0,0,0>, 1.0, <0,0,1>, 0.4
    open
    texture {
      SzLampScreenT1
    }
    scale <1.45, 1.45, 1.75> no_shadow
    translate  2.70168*z
  }
  cone { // SzLampSkYtter
    <0,0,0>, 1.0, <0,0,1>, 0.4
    open
    /*texture {
      FakeTex
    }*/
    texture
     {average
      texture_map
       {[gradient z texture_map
                   {[0  pigment{color rgb<1,.95,.6>} finish{diffuse 0 ambient -.5}]
                    [.1 pigment{color rgb<1,.95,.6>} finish{diffuse 0 ambient  .9}]
                    [.9 pigment{color rgb<1,.95,.6>} finish{diffuse 0 ambient  .9}]
                    [1  pigment{color rgb<1,.95,.6>} finish{diffuse 0 ambient -.5}]
                   }
        ]
        [radial texture_map
                  {[0  pigment{color rgb<1,.95,.6>} finish{diffuse 0 ambient -.25}]
                   [.05  pigment{color rgb<1,.95,.6>} finish{diffuse 0 ambient .9}]
                   [1  pigment{color rgb<1,.95,.6>} finish{diffuse 0 ambient .9}]
                  }
         rotate x*90
        ]
     }
     rotate z*225
    }
    scale <1.46, 1.46, 1.762069>    no_shadow
    translate  2.70168*z
  }
 light_source
 {<0,0,4> color rgb<1,1,.7>/2.5 fade_distance 5 fade_power 1}
   //translate  9.0*x
}



#declare BlueLampBase = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.145224, 0.000000, 0.000000>, <-0.145224, -0.185810, 0.000000>, <0.145224, -0.185810, 0.000000>, <0.145224, 0.000000, 0.000000>,
      <-0.121698, 0.000000, 0.242399>, <-0.121698, -0.275428, 0.242399>, <0.121698, -0.275428, 0.242399>, <0.121698, 0.000000, 0.242399>,
      <-0.231420, 0.000000, 0.625206>, <-0.231420, -0.275428, 0.625206>, <0.231420, -0.275428, 0.625206>, <0.231420, 0.000000, 0.625206>,
      <-0.293341, 0.000000, 1.122542>, <-0.293341, -0.182670, 1.122542>, <0.293341, -0.182670, 1.122542>, <0.293341, 0.000000, 1.122542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.145224, 0.000000, 0.000000>, <0.145224, 0.185810, 0.000000>, <-0.145224, 0.185810, 0.000000>, <-0.145224, 0.000000, 0.000000>,
      <0.121698, 0.000000, 0.242399>, <0.121698, 0.275428, 0.242399>, <-0.121698, 0.275428, 0.242399>, <-0.121698, 0.000000, 0.242399>,
      <0.231420, 0.000000, 0.625206>, <0.231420, 0.275428, 0.625206>, <-0.231420, 0.275428, 0.625206>, <-0.231420, 0.000000, 0.625206>,
      <0.293341, 0.000000, 1.122542>, <0.293341, 0.182670, 1.122542>, <-0.293341, 0.182670, 1.122542>, <-0.293341, 0.000000, 1.122542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.293341, 0.000000, 1.122542>, <-0.293341, -0.182670, 1.122542>, <0.293341, -0.182670, 1.122542>, <0.293341, 0.000000, 1.122542>,
      <-0.355262, 0.000000, 1.619878>, <-0.355262, -0.089913, 1.619878>, <0.355262, -0.089913, 1.619878>, <0.355262, 0.000000, 1.619878>,
      <-0.038821, 0.000000, 1.008165>, <-0.038821, -0.089913, 1.008165>, <0.038821, -0.089913, 1.008165>, <0.038821, 0.000000, 1.008165>,
      <-0.015998, 0.000000, 3.283187>, <-0.015998, -0.017793, 3.283187>, <0.018280, -0.017793, 3.283187>, <0.018280, 0.000000, 3.283187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.293341, 0.000000, 1.122542>, <0.293341, 0.182670, 1.122542>, <-0.293341, 0.182670, 1.122542>, <-0.293341, 0.000000, 1.122542>,
      <0.355262, 0.000000, 1.619878>, <0.355262, 0.089913, 1.619878>, <-0.355262, 0.089913, 1.619878>, <-0.355262, 0.000000, 1.619878>,
      <0.038821, 0.000000, 1.008165>, <0.038821, 0.089913, 1.008165>, <-0.038821, 0.089913, 1.008165>, <-0.038821, 0.000000, 1.008165>,
      <0.018280, 0.000000, 3.283187>, <0.018280, 0.017793, 3.283187>, <-0.015998, 0.017793, 3.283187>, <-0.015998, 0.000000, 3.283187>
    }
  }
  texture {
    Chrome_Metal1
  }
  scale <1.0, 1.0, 1.05>
}
#declare BlueLamp=
union { // BlueLamp
  cone { // BlueLampScreen
    <0,0,0>, 1.0, <0,0,1>, 0.2
    texture {
      BlueScreenTex
    }
    scale <0.976119, 0.5, 1.573139>
    translate  1.761192*z
  }
  object { BlueLampBase }
  translate  0.0*x
}


#declare Foretrade = intersection {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.01, 2.0>
  }
  plane { // Plane002
    z,0
    rotate 240.0*y
    translate  <-1.579035, 0.0, 0.778166>
  }
  plane { // Plane003
    z,0
    rotate -240.0*y
    translate  <1.552205, 0.0, 0.723277>
  }
  translate  2.0*z
}
#declare HornCut1 = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.605914, 0.5, 0.591319>
    translate  <2.105413, 0.0, 4.081536>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <1.502813, -0.5, 3.502808>
  }
}
#declare HornCut2 = difference {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.605914, 0.5, 0.591319>
    translate  <2.105413, 0.0, 4.081536>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <1.502813, -0.5, 3.502808>
  }
  scale <-1.0, 1.0, 1.0>
}
#declare HornCut3 = difference {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.605914, 0.5, 0.591319>
    translate  <2.105413, 0.0, 4.081536>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 1.0>
    rotate -90.0*x
    translate  <1.502813, -0.5, 3.502808>
  }
  scale <-1.0, 1.0, 1.0>
  rotate <-180.0, -45.0, -180.0>
  translate  <1.409683, 0.0, 4.593539>
}
#declare VajPlikt = difference {
  object { Foretrade }
  object { HornCut1 }
  object { HornCut2 }
  object { HornCut3 }
}
#declare VajningsSkylt=
union { // VajningsSkylt
  object { VajPlikt }
  box { // Kant1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025002, 0.15, 1.580818>
    rotate -30.0*y
    translate  <-1.15962, -0.154996, 2.115108>
  }
  box { // Kant2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025002, 0.15, 1.580818>
    rotate 30.0*y
    translate  <1.161042, -0.154996, 2.115108>
  }
  box { // Kant3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024061, 0.15, 1.508804>
    rotate <0.0, -90.0, 0.0>
    translate  <0.00792, -0.154996, 3.967175>
  }
}

#declare GardinHange = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.569608, 0.228744, 0.126510>, <-6.424024, -0.744131, 0.126510>, <-6.201655, -0.016290, 0.126510>, <-5.563623, 0.335946, 0.126510>,
      <-7.569608, 0.236888, 4.651555>, <-6.424024, -0.724301, 4.651555>, <-6.201655, -0.008145, 4.651555>, <-5.563623, 0.344091, 4.651555>,
      <-7.569608, 0.245033, 9.176600>, <-6.424024, -0.704471, 9.176600>, <-6.201655, 0.000000, 9.176600>, <-5.563623, 0.352235, 9.176600>,
      <-7.569608, 0.253178, 13.701645>, <-6.424024, -0.684640, 13.701645>, <-6.201655, 0.008145, 13.701645>, <-5.563623, 0.360380, 13.701645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.563623, 0.335946, 0.126510>, <-4.925590, 0.688181, 0.126510>, <-4.333502, -0.016290, 0.126510>, <-3.527009, -0.368525, 0.126510>,
      <-5.563623, 0.344091, 4.651555>, <-4.925590, 0.696326, 4.651555>, <-4.333502, -0.008145, 4.651555>, <-3.527009, -0.360380, 4.651555>,
      <-5.563623, 0.352235, 9.176600>, <-4.925590, 0.704471, 9.176600>, <-4.333502, 0.000000, 9.176600>, <-3.527009, -0.352235, 9.176600>,
      <-5.563623, 0.360380, 13.701645>, <-4.925590, 0.712615, 13.701645>, <-4.333502, 0.008145, 13.701645>, <-3.527009, -0.344091, 13.701645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.527009, -0.368525, 0.126510>, <-2.720516, -0.720760, 0.126510>, <-2.465348, -0.016290, 0.126510>, <-2.256124, 0.136856, 0.126510>,
      <-3.527009, -0.360380, 4.651555>, <-2.720516, -0.712615, 4.651555>, <-2.465348, -0.008145, 4.651555>, <-2.256124, 0.145001, 4.651555>,
      <-3.527009, -0.352235, 9.176600>, <-2.720516, -0.704471, 9.176600>, <-2.465348, 0.000000, 9.176600>, <-2.256124, 0.153146, 9.176600>,
      <-3.527009, -0.344091, 13.701645>, <-2.720516, -0.696326, 13.701645>, <-2.465348, 0.008145, 13.701645>, <-2.256124, 0.161291, 13.701645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.256124, 0.136856, 0.126510>, <-2.046900, 0.290002, 0.126510>, <-0.597195, -0.016290, 0.126510>, <0.117411, -0.307267, 0.126510>,
      <-2.256124, 0.145001, 4.651555>, <-2.046900, 0.298147, 4.651555>, <-0.597195, -0.008145, 4.651555>, <0.117411, -0.299122, 4.651555>,
      <-2.256124, 0.153146, 9.176600>, <-2.046900, 0.306292, 9.176600>, <-0.597195, 0.000000, 9.176600>, <0.117411, -0.290977, 9.176600>,
      <-2.256124, 0.161291, 13.701645>, <-2.046900, 0.314436, 13.701645>, <-0.597195, 0.008145, 13.701645>, <0.117411, -0.282832, 13.701645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.117411, -0.307267, 0.126510>, <0.832016, -0.598244, 0.126510>, <1.270959, -0.016290, 0.126510>, <1.832418, 0.305317, 0.126510>,
      <0.117411, -0.299122, 4.651555>, <0.832016, -0.590099, 4.651555>, <1.270959, -0.008145, 4.651555>, <1.832418, 0.313461, 4.651555>,
      <0.117411, -0.290977, 9.176600>, <0.832016, -0.581954, 9.176600>, <1.270959, 0.000000, 9.176600>, <1.832418, 0.321606, 9.176600>,
      <0.117411, -0.282832, 13.701645>, <0.832016, -0.573809, 13.701645>, <1.270959, 0.008145, 13.701645>, <1.832418, 0.329751, 13.701645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.832418, 0.305317, 0.126510>, <2.393878, 0.626923, 0.126510>, <3.139112, -0.016290, 0.126510>, <3.669943, -0.353210, 0.126510>,
      <1.832418, 0.313461, 4.651555>, <2.393878, 0.635068, 4.651555>, <3.139112, -0.008145, 4.651555>, <3.669943, -0.345066, 4.651555>,
      <1.832418, 0.321606, 9.176600>, <2.393878, 0.643212, 9.176600>, <3.139112, 0.000000, 9.176600>, <3.669943, -0.336921, 9.176600>,
      <1.832418, 0.329751, 13.701645>, <2.393878, 0.651357, 13.701645>, <3.139112, 0.008145, 13.701645>, <3.669943, -0.328776, 13.701645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.669943, -0.353210, 0.126510>, <4.200773, -0.690131, 0.126510>, <5.007266, -0.016290, 0.126510>, <5.522782, 0.198115, 0.126510>,
      <3.669943, -0.345066, 4.651555>, <4.200773, -0.681986, 4.651555>, <5.007266, -0.008145, 4.651555>, <5.522782, 0.206259, 4.651555>,
      <3.669943, -0.336921, 9.176600>, <4.200773, -0.673842, 9.176600>, <5.007266, 0.000000, 9.176600>, <5.522782, 0.214404, 9.176600>,
      <3.669943, -0.328776, 13.701645>, <4.200773, -0.665697, 13.701645>, <5.007266, 0.008145, 13.701645>, <5.522782, 0.222549, 13.701645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.522782, 0.198115, 0.126510>, <6.038297, 0.412519, 0.126510>, <6.783532, -0.200065, 0.126510>, <7.498137, -0.016290, 0.126510>,
      <5.522782, 0.206259, 4.651555>, <6.038297, 0.420663, 4.651555>, <6.783532, -0.191920, 4.651555>, <7.498137, -0.008145, 4.651555>,
      <5.522782, 0.214404, 9.176600>, <6.038297, 0.428808, 9.176600>, <6.783532, -0.183775, 9.176600>, <7.498137, 0.000000, 9.176600>,
      <5.522782, 0.222549, 13.701645>, <6.038297, 0.436953, 13.701645>, <6.783532, -0.175630, 13.701645>, <7.498137, 0.008145, 13.701645>
    }
  }
  texture {
    GardinTex
  }
  translate  -1.313745*z
}
#declare HangGardin=
union { // HangGardin
  cylinder { // GardinStang
    <0,0,1>, <0,0,0>, 1
    texture {
      Gold_Texture1
    }
    scale <0.15, 0.15, 15.0>
    rotate -90.0*y
    translate  <7.5, 0.0, 13.0>
  }
  torus { // GardinRing1
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <-7.053395, 0.0, 12.555654>
  }
  torus { // GardinRing2
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <-5.982495, 0.0, 12.555654>
  }
  torus { // GardinRing3
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <7.186448, 0.0, 12.555654>
  }
  torus { // GardinRing4
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <5.035323, 0.0, 12.555654>
  }
  torus { // GardinRing5
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <3.33866, 0.0, 12.555654>
  }
  torus { // GardinRing6
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <1.424671, 0.0, 12.555654>
  }
  torus { // GardinRing7
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.764327, 0.0, 12.555654>
  }
  torus { // GardinRing8
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.342712, 0.0, 12.555654>
  }
  torus { // GardinRing9
    1.5, 0.3  rotate -x*90
    texture {
      Gold_Texture1
    }
    scale <0.35, 0.5, 0.387904>
    rotate <-90.0, 0.0, -90.0>
    translate  <-4.166974, 0.0, 12.555654>
  }
  object { GardinHange }
  box { // Gardinddd
    <-1, -1, -1>, <1, 1, 1>
    texture {
      GardinTex
    }
    scale <7.432492, 0.197114, 8.13831>
    translate  <-0.092641, 0.864647, 19.9706>
  }
}

#declare SaltKarToppen = intersection {
  sphere { // SaltKarToppS
    <0,0,0>,1
    scale <0.197487, 0.231512, 0.10223>
    translate  0.706697*z
  }
  box { // SKTScut
    <-1, -1, -1>, <1, 1, 1>
    scale 0.299037
    translate  <-0.009132, 0.0, 0.992238>
  }
  texture {
    Chrome_Metal1
  }
}
#declare SaltKar=
union { // SaltKaret
  cone { // SaltKar
    <0,0,0>, 1.0, <0,0,1>, 0.8
    texture {
      Glass3
    }
    scale <0.229851, 0.268021, 0.707428>
  }
  cone { // Salt
    <0,0,0>, 1.0, <0,0,1>, 0.8
    texture {
      Glass3
    }
    scale <0.202017, 0.238541, 0.433169>
    translate  0.035253*z
  }
  object { SaltKarToppen }
  //translate  4.5*x
}

#declare NewsCafe=
union { // NewsCafe
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.204892, -1.080017, -0.159832>, <-6.751600, -1.044154, -0.159832>, <-6.000000, -1.118126, 0.179811>, <-5.153874, -0.823398, 0.179811>,
      <-7.204892, -0.441189, -0.159832>, <-7.000000, -0.479298, -0.159832>, <-6.000000, -0.479298, -0.159832>, <-5.000000, -0.479298, -0.159832>,
      <-7.204892, 0.038109, 0.000000>, <-7.000000, 0.000000, 0.000000>, <-6.000000, 0.000000, 0.000000>, <-5.000000, 0.000000, 0.000000>,
      <-7.204892, 0.517407, 0.000000>, <-7.000000, 0.479298, 0.000000>, <-6.000000, 0.479298, 0.000000>, <-5.000000, 0.479298, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.153874, -0.823398, 0.179811>, <-4.307748, -0.528671, 0.179811>, <-3.000000, -1.194345, -0.159832>, <-1.969259, -0.855456, 0.009990>,
      <-5.000000, -0.479298, -0.159832>, <-4.000000, -0.479298, -0.159832>, <-3.000000, -0.479298, -0.159832>, <-2.000000, -0.479298, 0.009990>,
      <-5.000000, 0.000000, 0.000000>, <-4.000000, 0.000000, 0.000000>, <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.089906>,
      <-5.000000, 0.479298, 0.000000>, <-4.000000, 0.479298, 0.000000>, <-3.000000, 0.479298, 0.000000>, <-2.000000, 0.479298, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.969259, -0.855456, 0.009990>, <-0.938517, -0.516567, 0.179811>, <0.000000, -1.194345, -0.159832>, <1.030741, -0.855456, -0.159832>,
      <-2.000000, -0.479298, 0.009990>, <-1.000000, -0.479298, 0.179811>, <0.000000, -0.479298, -0.159832>, <1.000000, -0.479298, -0.159832>,
      <-2.000000, 0.000000, 0.089906>, <-1.000000, 0.000000, 0.179811>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <-2.000000, 0.479298, 0.000000>, <-1.000000, 0.479298, 0.000000>, <0.000000, 0.479298, 0.000000>, <1.000000, 0.479298, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.030741, -0.855456, -0.159832>, <2.061483, -0.516567, -0.159832>, <3.000000, -1.194345, 0.179811>, <4.030741, -0.855456, 0.179811>,
      <1.000000, -0.479298, -0.159832>, <2.000000, -0.479298, -0.159832>, <3.000000, -0.479298, -0.159832>, <4.000000, -0.479298, 0.009990>,
      <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, <4.000000, 0.000000, 0.089906>,
      <1.000000, 0.479298, 0.000000>, <2.000000, 0.479298, 0.000000>, <3.000000, 0.479298, 0.000000>, <4.000000, 0.479298, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.030741, -0.855456, 0.179811>, <5.061483, -0.516567, 0.179811>, <5.326092, -1.041907, 0.179811>, <7.000000, -1.041907, -0.159832>,
      <4.000000, -0.479298, 0.009990>, <5.000000, -0.479298, 0.179811>, <6.000000, -0.479298, -0.159832>, <7.000000, -0.479298, -0.159832>,
      <4.000000, 0.000000, 0.089906>, <5.000000, 0.000000, 0.179811>, <6.000000, 0.000000, 0.000000>, <7.000000, 0.000000, 0.000000>,
      <4.000000, 0.479298, 0.000000>, <5.000000, 0.479298, 0.000000>, <6.000000, 0.479298, 0.000000>, <7.000000, 0.479298, 0.000000>
    }
  }
  texture {
    NewsTex
    scale <14.164138, 1.591647, 1.0>
  translate <-7.247672, -1.109337, 0.000000>
  }
  scale 2.15411
  rotate 90.0*x
  translate  <15.519185, 0.0, -1.057983>
}


#declare Tallrik = difference {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.25, 1.25, 0.1>
    translate  0.2*z
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.128765>
    translate  0.2*z
  }
  texture {
    TallrikTex
    scale <1.25, 1.25, 1.0>
  translate <0.000000, 0.000000, 0.250000>
  }
}
#declare Tallrik=
union { // Tallriken
  object { Tallrik }
  cone { // Servett1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      SaltT
    }
    scale <0.770439, 0.01, 1.442898>
    rotate <22.213291, 90.0, 0.0>
    translate  <-0.631084, 0.5509, 0.228056>
  }
  cone { // Servett2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      SaltT
    }
    scale <0.770439, 0.01, 1.442898>
    rotate <-24.744286, 90.0, 0.0>
    translate  <-0.61791, -0.594178, 0.228056>
  }
}
