
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare Special_effects = on
#declare Light_locate = off
#declare Rad_effects = on
#declare Lens_effects = on
#declare Lamp_lights = on

#if (Light_locate = off)
camera {
	location <300,100,-300>
	look_at  <0,130,0>
}
#else
camera {
	location <0,900,-250>
	look_at  <0,0,-250>
}
#end

light_source {<300,300,-500> color <1.00,1.00,0.84> atmosphere off}

#if (Special_effects = on)

light_source
{
  <200,200,-1000>                     // light's position (translated below)
  color rgb <1.00,1.00,0.84>       // light's color
  spotlight               // this kind of light source
  point_at <0,280,100>      // direction of spotlight
  radius 0.75                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 1               // intensity falloff radius (outer, in degrees)
}

atmosphere
{
  type 1
  samples 20
  distance 80  // old = 20
  scattering .75
  aa_level 8
  aa_threshold 0.1
  jitter 0.5
  color rgbft <1.00,1.00,0.84,.5,.75>
}

#end

#if (Rad_effects = on)
#include "consts.inc"
//#declare Rad_Quality = Radiosity_Debug
#declare Rad_Quality = Radiosity_Final

#include "rad_def.inc"
#end


#if (Lens_effects = on)
#declare camera_location = <300,100,-300>
#declare camera_look_at = <0,130,0>

#declare flare_position = <0,280,100>
#declare flare_type = 7
#declare flare_size = 1.5
#declare flare_spots = false
#declare flare_brightness = 1
#include "Lensflar.inc"

#end

#include "surfaces.inc"

#include "tower.inc"

object {Lego_tower translate <0,0,100>}
object {Lego_tower translate <200,0,100>}
object {Lego_tower translate <0,0,-200>}

#include "wall.inc"

object {Wall2 translate <0,0,220>}
object {Wall2 translate <-64,0,220>}
object {Wall2 translate <-128,0,220>}
object {Wall2 translate <64,0,220>}
object {Wall2 translate <128,0,220>}

#include "entry.inc"

object {Entry2 rotate <0,-90,0> translate <-50,0,-50>}
object {Entry rotate <0,-90,0> translate <-50,0,14>}
object {Entry rotate <0,-90,0> translate <-50,0,78>}
object {Entry rotate <0,-90,0> translate <-50,0,142>}
object {Entry rotate <0,-90,0> translate <-50,0,-114>}

plane {y,0
	pigment{color <0.33,0.46,0.75>}
	finish{phong 1 reflection 0.5}
	normal{bumps 0.1 scale 10}
}

#declare Cloud1 =
pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 rgb <0.88,0.66,0.56>]
        [0.1 rgb <0.26,0.28,0.40>]
		[0.2 rgb <1.00,0.90,0.50>]
		[0.3 rgb <0.79,0.43,0.26>]
		[0.4 rgb <0.26,0.28,0.40>]
        [1.0 rgbf <1,1,1,1>]
    }
    scale <3,0.75,3> rotate <0,-90,0>
}

#declare Cloud2 =
pigment {
    wrinkles
    turbulence 0.5
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 rgb <0.88,0.66,0.56>]
        [0.1 rgb <0.26,0.28,0.40>]
		[0.25 rgb <0.54,0.36,0.45>]
		[0.3 rgb <0.61,0.46,0.57>]
		[0.35 rgb <0.71,0.56,0.67>]
		[0.4 rgb <0.26,0.28,0.40>]
		[0.5 rgbf <1,1,1,.2>]
        [1.0 rgbf <1.00,0.93,0.67,.2>]
    }
    scale <3,1,3>
}

#declare Cloud3 =
pigment {
	granite
	turbulence 1
	color_map {
		[0.0 rgb <1.00,0.93,0.67>]
		[0.025 rgb <2,2,4>]
		[0.075 rgb <1,1,1>]
		[0.15 rgbf <1.00,0.93,0.67,.2>]
		[1.0 rgbf <1.00,0.93,0.67,.5>]
	}
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.0 rgb <0.88,0.66,0.56> ] // horizon
            [0.1 Cloud1 scale 0.25 rotate z*5]
            [0.60 Cloud2 scale <0.25, 0.15, 0.25> rotate z*10]
			[0.8 Cloud3 scale .2]
        }
    }
}

#declare Logo =
union {
#declare Blength = 3 #declare Bwidth  = 3 #declare Bheight = 3
#include "blocks.inc"
object {Lego_block texture{T_red}}
text {ttf "artistik.ttf", "13",5 0
	rotate <90,0,0>
	scale <27,1,27>
	translate <4,12,4>
	texture{T_yellow}
}
}

object {Logo rotate <-20,-30,0> translate <190,-5,-60>}
