#declare CandyCoat =
finish {
    specular 1
    roughness 0.001
    ambient 0.85
    diffuse 0
    reflection 0.1
    refraction 0.1
    ior 1
    //refraction 1
    //ior 1.5
}

#declare Cane = cylinder
{
   <0, 0, 0>, <0, 10, 0>, 1

	texture
		{
		pigment
			{
			gradient y
			color_map {
				[ 0 color White*0.8 ]
				[ 0.49 color White*0.8 ]
				[ 0.51 color Red ]
				[ 1 color Red ]
				}
			}
		rotate z*-15
		}
	finish { CandyCoat }
}

#declare CandyLoop = torus
{
	2.5, 1 - 0.025

	texture {
		pigment
			{
			radial
			color_map {
				[ 0 color White*0.8 ]
				[ 0.09 color White*0.8 ]
				[ 0.1 color Red ]
				[ 0.19 color Red ]
				[ 0.2 color White*0.8 ]
				[ 0.29 color White*0.8 ]
				[ 0.3 color Red ]
				[ 0.39 color Red ]
				[ 0.4 color White*0.8 ]
				[ 0.49 color White*0.8 ]
				[ 0.5 color Red ]
				[ 0.59 color Red ]
				[ 0.6 color White*0.8 ]
				[ 0.69 color White*0.8 ]
				[ 0.7 color Red ]
				[ 0.79 color Red ]
				[ 0.8 color White*0.8 ]
				[ 0.89 color White*0.8 ]
				[ 0.9 color Red ]
				[ 0.99 color Red ]
				[ 1 color White*0.8 ]
			}
			frequency 4 
		}
	}
	finish { CandyCoat }
}

#declare Hook = difference
{
	object { CandyLoop
		rotate x*90
		}
	plane { y*1, 0 pigment { color White } finish { CandyCoat } }
}

#declare CandyCane = union {
	object { Cane }
	object { Hook translate <2.5, 10 - 0.05, 0> }
}

#declare Mint = superellipsoid
{
	<1, 0.1>
	texture { pigment { spiral1 5 color_map {
					[0 color White*0.75]
					[0.49 color White*0.75]
					[0.51 color Yellow*0.5]
					[1 color Yellow*0.5]
					}
		} }
		finish { CandyCoat }
	rotate x*90
	scale <2, 0.5, 2>
}

#declare Gazebo = union
{
	union {
		object { CandyCane rotate y*-45 translate <-5.3033, 0, -5.3033> }
		object { CandyCane rotate y*45 translate <-5.3033, 0, 5.3033> }
		object { CandyCane rotate y*-135 translate <5.3033, 0, -5.3033> }
		object { CandyCane rotate y*135 translate <5.3033, 0, 5.3033> }
		//object { CandyLoop translate y*10 }
		torus { 2.5, 1 pigment { color SkyBlue }
			finish {
                            ambient 0.1
                            diffuse 0.1
                            reflection .25
                            refraction 1
                            ior 1.5
                            specular 1
                            roughness 0.001
			}
			translate y*10
		}
		sphere { <0, 12.61, 0>, 1.732 pigment { color rgbf <1, 0.5, 0, 0.8> }
			finish {
			    ambient 0.1
			    diffuse 0.1
			    reflection .25
			    refraction 1
			    ior 1.5
			    specular 1
			    roughness 0.001
				}
			}
		translate <0, 1 - 0.05, 0>
		}
	//cylinder { <0, 0, 0>, <0, 1.01, 0>, 8.75
	superellipsoid { <1, 0.1>
		rotate x*90
		scale <8.8, 0.5, 8.8>
		translate y*0.5
		texture {
			pigment {
				radial
				color_map {
					[ 0 color White*0.75 ]
					[ 0.49 color White*0.75 ]
					[ 0.51 color Green*0.6 ]
					[ 1 color Green*0.6 ]
					}
				frequency 15
				}
			}
		finish { CandyCoat }
		}
	object { Mint scale 0.75 translate <-3.5, 1.2, 0> }
	object { Mint scale 0.75 translate <3.5, 1.2, 0> }
	object { Mint scale 0.75 translate <0, 1.2, 3.5> }
	object { Mint scale 0.75 translate <0, 1.2, -3.5> }
}
