#include "colors.inc"
#include "stones.inc"
#include "skies.inc"
#include "sky.inc"
#include "window.inc"
#include "gazebo.inc"
#include "butterfly.inc"
#include "people.inc"
#include "birds.inc"

background { color White * 0.5 }

camera { location <0, 5, -85> look_at z*13 }

//sky_sphere { S_Cloud5 }
sky_sphere { BrownCloud }

light_source { <-1000, 1000, -1000> color White }

#declare SD1 = seed(5)
#declare SD2 = seed(16)
#declare SD3 = seed(23)
#declare SD4 = seed(124)

#declare IslandA = 
union {
	height_field { gif "adulthf9.ghf"
		smooth
		hollow
		water_level 1/256
		translate <-0.5, -0.5, -0.5>
	scale <100, 20, 100>
	}

	plane { y*1, -10 pigment { color Blue*0.5 }
		normal { ripples }
		finish { ambient 0.35 } hollow }

	difference { plane { y*1, (-0.5 + 127/255.0) hollow }
		 box { <-0.5*100 + 0.001, 0.15, -0.5*100 + 0.001>,
		       <0.5*100 - 0.001, -0.15, 0.5*100 - 0.001> }	
		 plane { x*1, 0.5*100 - 0.001  hollow }
		 plane { z*1, 0.5*100 - 0.001  hollow }
		 }

	difference { plane { y*1, (-0.5 + 127/255.0) hollow }
		plane { z*1, 0.5*100 - 0.001 hollow }
		//plane { x*1, -0.5*100 - 0.001 hollow }
		}

	difference { plane { y*1, (-0.5 + 127/255.0) hollow }
		 plane { x*1, -0.38*100 + 0.001  hollow }
		 plane { z*-1, 0.5*100 + 0.001  hollow }
		 }

	//no_shadow
	hollow
	scale <1, 1, 1.65>
	translate x*45
}

#declare IslandB = union
{
	height_field { gif "childhf9.ghf"
		smooth
		water_level 1/256
		translate <-0.5, -0.5, -0.5>
		//rotate y*90
	hollow
	scale <100, 20, 100>
	//translate <-90, 0, -15>
	}
	difference { plane { y*1, (-0.5 + 127/255.0) hollow }
		 plane { x*-1, -0.42*100 + 0.001  hollow }
		 plane { z*-1, 0.5*100 + 0.001  hollow }
		 }
	scale <1, 1, 1.65>
	translate x*-45
}

#declare Mountains = height_field
	{
	gif "backmnt.ghf"
	smooth
	translate <-0.5, -0.125, -0.5>
	scale <1500, 100, 1000>
	}

#declare City = union
{
	#declare Loop = 0
	#while(Loop < 30)
		#declare Loop2 = 0
		#while(Loop2 < 2)
		box { <-1, 0, -1>, <1 + rand(SD4)*0.5 - 0.25, 8 + rand(SD1)*2 - 1, 1>
			pigment { White*0.05 }
		scale 10
		translate <50 + Loop*50 + rand(SD3)*10 - 5 + Loop2*15, 0, 1000 + rand(SD2)*10 - 5 - Loop2*15>
		texture { WindowTex }
		}
		#declare Loop2 = Loop2 + 1
		#end
	#declare Loop = Loop + 1
	#end
}

#declare OfficeBuilding = union
{
box { <0, 0, 0>, <2, 6, 2.8>
	pigment { White*0.15 }
	finish { ambient 0.35 } 
    }
#declare Y_Offset = 5.9
#while (Y_Offset > 0.5)
	#declare Loop = 0
	#while (Loop < 2)
		box { <Loop, Y_Offset, -0.001>,
			<Loop + 0.38, Y_Offset - 0.38, -0.02>
			texture { WindowTex } }
	#declare Loop = Loop + 0.4
	#end
	#declare Loop = 0
	#while (Loop < 2.8)
		box { <-0.001, Y_Offset, Loop>,
		      <-0.02, Y_Offset - 0.38, Loop + 0.38>
			texture { WindowTex } }
	#declare Loop = Loop + 0.4
	#end
#declare Y_Offset = Y_Offset - 0.4
#end
translate <-1, 0, -1.5>
}

#declare WindowTex2 =
texture {
    pigment { color rgbf<0.7, 0.95, 0.7, 0.7> }
    finish  { WindowFinish }
}

#declare OfficeBuilding2 = union
{
box { <0, 0, 0>, <2.5, 6, 2.5>
	pigment { White*0.15 }
	finish { ambient 0.35 } 
    }
box { <0, 0, 0>, <3.5, 5, 3.5>
	pigment { White*0.15 }
	finish { ambient 0.35 }
    }
box { <0, 0, 0>, <4.5, 4, 4.5>
	pigment { White*0.15 }
	finish { ambient 0.35 }
    }

#declare Y_Offset = 3.95
#while (Y_Offset > 0.5)
	#declare Loop = 0
	#while (Loop < 4.5)
		box { <Loop, Y_Offset, -0.001>,
			<Loop + 0.48, Y_Offset - 0.48, -0.02>
			texture { WindowTex2 } }
	#declare Loop = Loop + 0.5
	#end
	#declare Loop = 0
	#while (Loop < 4.5)
		box { <4.5 + 0.001, Y_Offset, Loop>,
		      <4.5 + 0.02, Y_Offset - 0.48, Loop + 0.48>
			texture { WindowTex2 } }
	#declare Loop = Loop + 0.5
	#end
#declare Y_Offset = Y_Offset - 0.4
#end
#declare Y_Offset = 5.95
#while (Y_Offset > 5)
	#declare Loop = 0
	#while (Loop < 2.5)
		box { <Loop, Y_Offset, -0.001>,
			<Loop + 0.48, Y_Offset - 0.48, -0.02>
			texture { WindowTex2 } }
		box { <2.5 + 0.001, Y_Offset, Loop>,
			<2.5 + 0.02, Y_Offset - 0.48, Loop + 0.48>
			texture { WindowTex2 } }
	#declare Loop = Loop + 0.5
	#end
#declare Y_Offset = Y_Offset - 0.5
#end
#declare Y_Offset = 4.95
#while (Y_Offset > 4)
	#declare Loop = 0
	#while (Loop < 3.5)
		box { <Loop, Y_Offset, -0.001>,
			<Loop + 0.48, Y_Offset - 0.48, -0.02>
			texture { WindowTex2 } }
		box { <3.5 + 0.001, Y_Offset, Loop>,
			<3.5 + 0.02, Y_Offset - 0.48, Loop + 0.48>
			texture { WindowTex2 } }
	#declare Loop = Loop + 0.5
	#end
#declare Y_Offset = Y_Offset - 0.5
#end

translate <-1, 0, -1.5>
}

#declare Flock = union
{
	object { Crow rotate z*5 }
	object { Crow rotate <10, 10, -15> translate <-4.5, -4, -5> }
	object { Crow translate <2, -5.5, 3> }
}

object { OfficeBuilding scale 5 translate <60, 0, 40>}

object { OfficeBuilding2 scale 5 rotate y*90 translate <20, 0, 30>}

object { IslandA 
	texture { T_Grnt29 scale 1/1000.0 }
	finish { ambient 0.35 }
	hollow
	}


object { IslandB
	pigment { color Green*0.5 }
	finish { ambient 0.35 }
	normal { granite }
	hollow
	}

object { Mountains
	translate <-1000, 15, 1000>
	pigment { color Green*0.65 }
	finish { ambient 0.35 }
	normal { granite }
	}

object { City }

object { Gazebo scale 0.3
	translate <(0.164 - 0.5)*100 + 26, -0.2, (0.438 - 0.5)*100 -65> }

object { Butterfly scale 0.5 rotate y*50 translate <-5, 4.5, -70> no_shadow}

object { Child scale 0.65 translate <-4, 2.2, -55> }
object { Adult rotate y*180 scale 0.8 translate <15, 2, -55> }

object { Flock scale 1.5 translate <48, 20, 30> }
