
// Persistence of Vision Ray Tracer Scene Description File
// File: parquet.inc
// Vers: 3
// Desc: A parquet floor tile
// Date: 12/15/97
// Auth: Bob Franke [bobfranke@halcyon.com]
//

#version 3

#include "colors.inc"
#include "woods.inc"
#include "finish.inc"

#declare xbrightness=.475

#declare wood1mult=2.25*xbrightness
#declare woodMap1 =
color_map {
    [0.00 color rgb <0.5, 0.25, 0.125>*wood1mult]
    [0.40 color rgb <1.0, 0.50, 0.250>*wood1mult ]
    [0.60 color rgb <1.0, 0.50, 0.250>*wood1mult ]
    [1.00 color rgb <0.5, 0.25, 0.125>*wood1mult]
}
#declare woodMap2 =
color_map {
    [0.00 0.30 color rgb <0.35, 0.175, 0.0875>*wood1mult
               color rgb <1.00, 0.500, 0.2500>*wood1mult ]
    [0.30 1.00 color Clear color Clear]
}

#declare wood2mult=2.0*xbrightness
#declare woodMap3 =
color_map {
    [0.00 color rgb <0.5, 0.25, 0.125>*wood2mult]
    [0.40 color rgb <1.0, 0.50, 0.250>*wood2mult]
    [0.60 color rgb <1.0, 0.50, 0.250>*wood2mult]
    [1.00 color rgb <0.5, 0.25, 0.125>*wood2mult]
}
#declare woodMap4 =
color_map {
    [0.00 0.30 color rgb <0.35, 0.175, 0.0875>*wood2mult
               color rgb <1.00, 0.500, 0.2500>*wood2mult]
    [0.30 1.00 color Clear color Clear]
}

#declare wood3mult=2.75*xbrightness
#declare woodMap5 =
color_map {
    [0.00 color rgb <0.5, 0.25, 0.125>*wood3mult]
    [0.40 color rgb <1.0, 0.50, 0.250>*wood3mult]
    [0.60 color rgb <1.0, 0.50, 0.250>*wood3mult]
    [1.00 color rgb <0.5, 0.25, 0.125>*wood3mult]
}
#declare woodMap6 =
color_map {
    [0.00 0.30 color rgb <0.35, 0.175, 0.0875>*wood3mult
               color rgb <1.00, 0.500, 0.2500>*wood3mult]
    [0.30 1.00 color Clear color Clear]
}


#declare WoodGrain1 =
pigment {
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.065
    omega 0.45
    lambda 2.3
    color_map { M_Wood19A }
    rotate x*4
}
#declare WoodGrain2 =
pigment {
    bozo
    color_map { M_Wood19B }
    scale <0.013, 0.013, 0.75>
}

#declare wood1 =
    texture {  pigment{ WoodGrain1 color_map { woodMap1 }}}
    texture {  pigment{ WoodGrain2 color_map { woodMap2}}}

#declare wood2 =
    texture {  pigment{ WoodGrain1 color_map { woodMap3 }}}
    texture {  pigment{ WoodGrain2 color_map { woodMap4}}}

#declare wood3 =
    texture {  pigment{ WoodGrain1 color_map { woodMap5 }}}
    texture {  pigment{ WoodGrain2 color_map { woodMap6}}}


#declare smallPiece =
box{<0,-.25,0>,<4,0,-1>}

#declare smallPiece2 =
box{<0,-.25,0>,<1,0,-2>}

#declare qrtPiece=
union{
object{smallPiece texture{wood1 rotate<0,90,0>  finish{Shiny}} }
object{smallPiece translate<0,0,-1> texture{wood2 rotate<1,89,0> scale<1,.25,1> finish{Shiny}}}
object{smallPiece texture{wood1 rotate<0,90,0> finish{Shiny}} rotate<0,90,0>translate<1,0,-2> }
object{smallPiece texture{wood3 rotate<0,90,0> finish{Shiny}} rotate<0,90,0>translate<2,0,-2> }

object{smallPiece texture{wood3 rotate<0,90,0> finish{Shiny}} rotate<0,90,0>translate<5,0,0>}
object{smallPiece texture{wood1 rotate<0,90,0> finish{Shiny}} rotate<0,90,0>translate<6,0,0>}

object{smallPiece texture{wood3 rotate<0,90,0> finish{Shiny}} translate<2,0,-4>}
object{smallPiece texture{wood1 rotate<0,90,0> finish{Shiny}} translate<2,0,-5> }

object{smallPiece2 texture{wood1 rotate<-4,0,0> finish{Shiny}} translate<2,0,-2>}
object{smallPiece2 texture{wood3 rotate<4,0,0> finish{Shiny}} translate<3,0,-2>}

}

/*
#declare parquetSquare=
union{
  object{qrtPiece}
  object{qrtPiece rotate<0,90,0> translate<6,0,-6>}
  object{qrtPiece rotate<0,90,0> translate<12,0,0>}
  object{qrtPiece translate<6,0,-6>}
}
*/


#declare parquetSquare=
difference{
  union{
    object{qrtPiece translate<-6,0,6>}
    object{qrtPiece rotate<0,90,0> translate<0,0,0>}
    object{qrtPiece rotate<0,90,0> translate<6,0,6>}
    object{qrtPiece translate<0,0,0>}
  }
  box{<-.0625,1,8>,<.0625,-1,-8> rotate<0,0,45> translate<6,-.0625,0>}
  box{<-.0625,1,8>,<.0625,-1,-8> rotate<0,0,-45> translate<-6,-.0625,0>}
  box{<-8,-1,-.0625>,<8,1,.0625> rotate<-45,0,0> translate<0,-.0625,6> }
  box{<-8,-1,-.0625>,<8,1,.0625> rotate<45,0,0> translate<0,-.0625,-6> }
}
