//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 4 lights, 4 textures and 26 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/12/1997    (12.12.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//


#include "colors.inc"
#include "textures.inc"

// homegrown skin file with hints taken from
// newsgroup message in comp.graphics.rendering.raytrracing by:
//richard725@denver.email.com (Richard Adams)
//Date:         1996/05/18
// -- thanks to Deja News search for finding this reference!



#include "skin_c.inc"
#include "metals.inc"


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
//  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
//  radiosity {
//    brightness       3.3
//    count            100
//    distance_maximum 0.0
//    error_bound      0.4
//    gray_threshold   0.5
//    low_error_factor 0.8
//    minimum_reuse    0.015
//    nearest_count    6
//    recursion_limit  1
//  }
}

background { color <0.000,0.000,0.500> }

camera {  //  Camera StdCam
  location  <-500, -150, -35.0>
//  location <0.0, -600, 0.0 >
  direction <0.0,     0.0,  1.1736>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  look_at   <67.139, 73.002, 24.131>
  angle 36.0   // was 37
  look_at < 0,0,0 >
}

 fog{
  fog_type 2    // Ground Fog
  distance     25.0
  color <255/255,255/255,222/255,0.1,0.0>
  up           <0,0,1>
  rotate 180.0*x
  fog_offset   -100.0
  fog_alt     10.0
  turbulence 0.6
}


// *******  L I G H T S *******
light_source { // area_light_4
  <9.497, -153.596, 152.467>
  color  rgb<0.75, 0.75, 0.75>
  area_light <72.000, 0.000, 0.000>, <0.000, 16.000, 0.000>, 3, 3
  adaptive 1
  jitter
//  atmospheric_attenuation on
}


light_source { // area_light_3
  <-199.304, -151.168, 152.467>
  color  rgb<0.75, 0.75, 0.75>
  area_light <72.000, 0.000, 0.000>, <0.000, 16.000, 0.000>, 3, 3
  adaptive 1
  jitter
//  atmospheric_attenuation on
}


light_source { // area_light_2
  <-196.876, -17.633, 152.467>
  color  rgb<0.75, 0.75, 0.75>
  area_light <72.000, 0.000, 0.000>, <0.000, 16.000, 0.000>, 3, 3
  adaptive 1
  jitter
//  atmospheric_attenuation on
}


light_source { // area_light_1
  <9.182, -12.777, 152.204>
  color  rgb<0.75, 0.75, 0.75>
  area_light <72.000, 0.000, 0.000>, <0.000, 16.000, 0.000>, 3, 3
  adaptive 1
  jitter
//  atmospheric_attenuation on
}



// ********  TEXTURES  *******
//

#include "cubicle4.inc"

#declare PalePink = rgb < 1, .73, .77 >



// ********  OBJECTS  *******

// Legs
// chopped version from
// renee's body -
//     ftp.cyberware.com
//       /pub/WholeBody/renee

##include "legs2.inc"

#declare legs_Ref = object {
  raw_object
  texture {
    SKIN_CAUCASIAN
  }
  scale 12.0
  rotate -125.0*z
  translate  <51.926923, 2.770494, -18.912398>
}

// Sandal
// modified version from
// http://www.ocnus.com/models/People/sandal.wrl.gz
// converted to .raw and imported using Moray

#include "sandal.inc"

#declare rightshoe_Ref = object {
  Layer0_Black
  texture {
    Leather
  }
  scale -2.9
  rotate <-90.0, -10.0, 165.0>
  translate  <18.811569, 1.450844, -68.108478>
}
#declare leftshoe_Ref = object {
  Layer0_Black
  texture {
    Leather
  }
  scale 2.9
  rotate <85.957603, 3.569041, -164.970169>
  translate  <86.994312, 3.524958, -70.086378>
}
union { // legsandshoes
  object { legs_Ref }
  object { rightshoe_Ref }
  object { leftshoe_Ref }
  translate  <0.0, 0.207411, 3.007465>
}



plane { // ceiling
  z,0
  texture {
    grout
  }
  hollow
  scale <300.0, 360.0, 1.0>
  translate  <-90., -180., 160.>
}


// homegrown extrusion in Protocad

#include "bracket.inc"

object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  rotate 90.0*z
  translate  <102.38659, -108.060017, -36.876297>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  rotate 90.0*z
  translate  <102.617273, -108.060017, 57.799497>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  translate  <-97.918775, -100.476779, 55.867338>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  translate  <-97.918775, -100.476779, -36.562143>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  translate  <0.046185, -101.424684, -41.417987>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  translate  <0.046185, -101.424684, 55.698893>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  rotate -180.0*z
  translate  <0.080751, 106.794634, -36.562143>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  rotate -180.0*z
  translate  <0.080751, 106.794634, 55.698893>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  rotate -180.0*z
  translate  <-98.199534, 106.794634, 55.698893>
}


object {
  bracket
  texture {
    chrome
  }
  scale 0.5
  rotate -180.0*z
  translate  <-98.199534, 107.577321, -35.092798>
}


plane { // sidewall
  z,0
  texture {
    pigment { White }
  }
  hollow
  scale <182.421188, 126.208702, 1.0>
  rotate <-90.0, 0.0, -90.0>
  translate  <109.2, -63., 53.414284>
}


plane { // backwall
  z,0
  texture {
    pigment { White }
  }
  hollow
  scale <136.963638, 274.402039, 1.0>
  rotate <0.0, -90.0, -90.0>
  translate  <-164., 115.2, 74.>
}

// Toilet
// chopped from toilet.3ds  on
//  toilet.zip
//  www.3dcafe.com/hou3_pic.htm


#include "toilet.inc"

#declare bowl_Ref = object {
  TOILETBO
  texture {
    porcelin
  }
  scale 0.1
  rotate -180.0*z
  translate  <40.745171, -25.53554, -54.048543>
}
#declare bowl1_Ref = object {
  TOILETBO
  texture {
    porcelin
  }
  scale 0.1
  rotate -180.0*z
  translate  <136.065524, -25.53554, -55.203941>
}
union { // toilet_obj
  object { bowl_Ref }
  object { bowl1_Ref }
  texture {
    porcelin
  }
}






box { // pillar3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    greymetalwall
  }
  scale <6.0, 1.0, 80.0>
  translate  <96.0, -108.0, 6.0>
}


box { // pillar2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    greymetalwall
  }
  scale <10.58154, -1.211778, 80.0>
  translate  <-99.633635, -108.0, 6.0>
}


box { // pillar1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    greymetalwall
  }
  scale <8.211778, 1.0, 80.0>
  translate  <0.0, -108.0, 6.0>
}


box { // Door2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    greymetalwall
  }
  scale <38.0, 1.0, 60.0>
  translate  <48.0, -108.0, 12.0>
}


box { // Door1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    greymetalwall
  }
  scale <38.0, 1.0, 60.0>
  translate  <-48.0, -108.0, 12.0>
}


plane { // floor
  z,0
  texture {
    pigment {White}
  }
  hollow
  scale <270.0, 180.0, 1.0>
  translate  <-164., -61., -74.>
}


box { // Wall1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    greymetalwall
  }
  scale <1.0, 108.0, 60.0>
  translate  <-98.0, 0.0, 12.0>
}


box { // Wall2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    greymetalwall
  }
  scale <1.0, 108.0, 60.0>
  translate  12.0*z
}

#include "alltile.inc"
