// modified from povray demo of superellipsoids -- mostly parameterization


// need following predeclared:
// tiletype 1=XY, 2=XZ, 3=YZ
// tilehalfx - half x dim of tile
// tilehalfy - half y dim of tile
// tilehalfz - half z dim of tile
// groutwidth - width of grout
// numberhigh - number of tile high
// numberwide - number of tile wide
// tilepigment - pigment to use on tile
// tilefinish - finish to use on tile
// major offset - overall translate 

#if (tiletype = 1)  // XY
  #declare wide = x
  #declare high = y
  #declare deep = z
//  #declare tilehalfwide = tilehalfx
//  #declare tilehalfhigh = tilehalfy
//  #declare tilehalfdeep = tilehalfz
#end

#if (tiletype = 2 ) // XZ
  #declare wide = x
  #declare high = z
  #declare deep = y
//  #declare tilehalfwide = tilehalfx
//  #declare tilehalfhigh = tilehalfz
//  #declare tilehalfdeep = tilehalfy
#end

#if (tiletype = 3 ) //YZ
  #declare wide = y
  #declare high = z 
  #declare deep = x
//  #declare tilehalfwide = tilehalfy
//  #declare tilehalfhigh = tilehalfz
//  #declare tilehalfdeep = tilehalfx
#end


#declare Tile = superellipsoid {
  <0.05, 0.05>
#if (tiletype = 1 ) //XY
  scale <tilehalfwide, tilehalfhigh, tilehalfdeep>
#end
#if (tiletype = 2 ) //XZ
  scale <tilehalfwide, tilehalfdeep, tilehalfhigh>
#end
#if (tiletype = 3 ) //YZ
  scale <tilehalfdeep, tilehalfwide, tilehalfhigh>
#end
}
#ifdef(View_POV_Include_Stack)
  #   debug concat("scale x = ",str(tilehalfwide,6,3)," \n")
  #   debug concat("scale y = ",str(tilehalfhigh,6,3)," \n")    
  #   debug concat("scale z = ",str(tilehalfdeep,6,3)," \n") 
#end
#declare Offsetwide = 2.0*tilehalfwide+groutwidth
#declare Offsethigh = 2.0*tilehalfhigh+groutwidth
#declare Offsetdeep = 2.0*tilehalfdeep+groutwidth

#declare i = 1
#declare j = 1
#while ( j <= numberhigh )
  #while ( i <= numberwide )
    object {Tile
    #declare widevector = wide*(i*(2.0*(tilehalfwide+groutwidth)))  
    #declare highvector = high*(j*(2.0*(tilehalfhigh+groutwidth)))
    #declare deepvector =  0.2 * deep
    #declare sumvector = highvector+widevector+deepvector+majoroffset
//    #ifdef(View_POV_Include_Stack)
//      #   debug concat("sumvector.x = ",str(sumvector.x,5,2)," \n")
//      #   debug concat("sumvector.y = ",str(sumvector.y,5,2)," \n")    
//      #   debug concat("sumvector.z = ",str(sumvector.z,5,2)," \n") 
//    #end
    texture { tiletexture }
    finish { tilefinish }
    translate sumvector
    }

    #declare i = i + 1
 //   #ifdef(View_POV_Include_Stack)
 //   #   debug concat("i = ",str(i,3,0)," \n")
 //   #end
  #end
  #declare i = 1 
  #declare j = j + 1
//  #ifdef(View_POV_Include_Stack)
//    #   debug concat("j = ",str(j,3,0)," \n")
//    #end
#end


