// parameters for wall
#declare x_start = -20
#declare x_finish = 20
#declare y_start = -20
#declare y_finish = 20
#declare brique_size = 1 // brick have a 2/1 ratio
#declare gap_size = 0.1

// parameter for random tile rotations
#declare perfect = 0
#declare good = 1
#declare fair = 2
#declare rough = 3
#declare chaotic = 5
#declare smoothness = good // rougth, fair or good
#declare randomizer = seed(0)

// create the basic tile
#declare the_brick = box
  {
   <-(brique_size/2)+(gap_size/2), -(brique_size)+(gap_size/2), -(brique_size)>,
   < (brique_size/2)-(gap_size/2),  (brique_size)-(gap_size/2), 0 >
  }

// we nee counters
#declare x_current = x_start
#declare offset_flag = 0 // to implement row offset

union {
#while (x_current < x_finish)
  #declare y_current = y_start
  #while (y_current < y_finish)
    object { the_brick
      texture {
        #if (rand(randomizer) < 0.2) red_brick
        #else #if (rand(randomizer) > 0.8) beige_brick
              #else brown_brick
              #end
        #end
          translate <50*rand(randomizer),40*rand(randomizer),20*rand(randomizer)>
          rotate <0,0,5*rand(randomizer)>
      }
      rotate <smoothness*(0.5-rand(randomizer)), smoothness*(0.5-rand(randomizer)), smoothness*(0.5-rand(randomizer))>
      translate < x_current, y_current+(offset_flag*(brique_size)), 0>
    }
    #declare y_current = y_current + brique_size*2
  #end
  #declare x_current = x_current + brique_size
  // update the offset_flag between rows
  #if (offset_flag = 0)
    #declare offset_flag = 1
  #else
    #declare offset_flag = 0
  #end
#end

// global transformation for this particular scene
translate z*40
}

