
// Persistence of Vision Ray Tracer Scene Description File
// File: desir.pov
// Vers: 3
// Desc:scene principale
// Date: 07/12/97
// Auth: Denis
// necessite desir_t.inc, desir_o.inc, robinet.inc
//           + image_map : graduat.Gif, EtiquetteC.gif, EtiquetteD.gif, desir_formula.gif
global_settings { assumed_gamma 2.2 }

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "desir_o.inc"
#include "desir_t.inc"

//**************background
background { color red 0.15 green 0.15 blue 0.35 }


//*******************************************************interrupteurs
#declare Cuv = 1
#declare Tuyauterie = 1
#declare Room = 1
#declare Plan1 = 1 //table+objets
//************************************************camera

#declare C1 = camera
{
  location  <4 , 7 ,-20.0>
  look_at   <4 , 7 , 0.0>
  angle 40
}

#declare C1b = camera
{
  location  <15.0 , 6.0 , -28.0>
  look_at   <0.0 , 5.0 , 0.0>
  angle 40

}
#declare C1h = camera
{
  location  <0.0 , 10.0 ,0.0>
  look_at   <0.0 , 0.0 , 0.0>
}

camera { C1b }

//***************************************lumire
 light_source {
    <5, 10, -15> color rgb <1, 1, 1>
    spotlight
    point_at <-2, 6, -3>
    radius 8
    falloff 20
  }
 light_source {
    <12, 13, -9> color rgb <1, 1, 1>
    spotlight
    point_at <9, 5, -1>
    radius 15
    falloff 40
  }
 light_source {                 //eclaire la table
    <10, 8, -20> color rgb <1, 1, 1>
    spotlight
    point_at <8, 4.5, -20>
    radius 9
    falloff 17
  }
   light_source {       //eclaire la table
    <10, 9, -20> color rgb <1, 1, 1>
    spotlight
    point_at <10, 4, -20>
    radius 16
    falloff 30
  }


light_source        //lumire arrire
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
   translate <6.3, 15, 4>
fade_distance 2.5
fade_power 2
}
 light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
translate <15, 16.5, -10>
}
//******************************************************
#ifdef ( Tuyauterie )

//+++++++++++++++++++++++++++++++Robinet_droit1 (haut
object { Robinet1
       scale     <0.20, 0.20, 0.20>
       rotate    <-90.00, 0.00, 0.00>
       translate <2.96, 9.07, 0.09>
}

//+++++++++++++++++++++++++++++Robinet_droit2 (milieu vertical)
object { Robinet1
       scale     <0.20, 0.20, 0.20>//position 2me robinet droit
       rotate    <-90.00, 0.00, 90.00>
       translate <4.11, 8.34, 0.07>
}

//+++++++++++++++++++++++++++++Robinet_droit3 (bas)
object { Robinet1
       scale     <0.20, 0.20, 0.20>//position 3me robinet droit
       rotate    <0, 1.3, 0>
       translate <3.53, 4.39, -0.15>
}
//++++++++++++++++++++++++++++++++++++++manometre1
union {
object { Manometre}
object { Aiguille1 }
              scale     <0.25, 0.25, 0.25>
       rotate    <0.00, -18.00, 0.00>
       translate <2.85, 5.99, -0.32>
}
//+++++++++++++++++++++++++++++++++++++++++manometre2
union {
object { Manometre}
object { Aiguille2 no_shadow}
       scale     <0.25, 0.25, 0.25>
       rotate    <0.00, 0.00, 0.00>
       translate <3.95, 7.90, -0.68>
}
object { Robinet}//++++++++++++++++++++++++++++++++++++++robinet bas

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++Tuyauterie
object { Tdroit  scale     <0.20, 0.20, 0.55>
       rotate    <0.00, 88.00, 0.00>
       translate <2.18, 3.91, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 0.55>
       rotate    <0.00, 90.00, 0.00>
       translate <2.19, 7.04, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 2.35>
       rotate    <0.00, 90.00, 90.00>
       translate <2.85, 5.47, 0.00>
}
object { Tcoude         scale     <0.25, 0.25, 0.25>
       rotate    <90.00, 0.00, -90.00>
       translate <2.45, 4.325, 0.00>
}
object { Tcoude         scale     <0.25, 0.25, 0.25>
       rotate    <90.00, 0.00, 0.00>
       translate <2.45, 6.64, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 0.55>
       rotate    <0.00, 90.00, 0.00>
       translate <5.46, 5.75, 0.00>
}

object { Tcoude        scale     <0.15, 0.15, 0.15>
       rotate    <0.00, 0.00, -90.00>
       translate <2.85, 5.52, -0.08>
}
object { Tdroit        scale     <0.20, 0.20, 0.50>
       rotate    <0.00, 90.00, 0.00>
       translate <4.15, 4.47, 0.00>
}
object { Tdroit         scale     <0.20, 0.20, 1.50>
       rotate    <0.00, 90.00, -90.00>
       translate <4.20, 3.72, 0.00>
}
object { Tcoude        scale     <0.25, 0.25, 0.25>
       rotate    <90.00, 0.00, -90.00>
       translate <4.40, 4.89, -0.01>
}
object { Tcoude        scale     <0.25, 0.25, 0.25>
       rotate    <90.00, 0.00, -270.00>
       translate <5.19, 5.35, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 0.50>
       rotate    <0.00, 90.00, -90.00>
       translate <4.79, 5.11, 0.00>
}
object { Tcoude        scale     <0.25, 0.25, 0.25>
       rotate    <90.00, -90.00, -180.00>
       translate <4.20, 2.97, -0.40>
}
object { Tcoude        scale     <0.15, 0.15, 0.15>
       rotate    <0.00, 0.00, -90.00>
       translate <3.95, 7.42, -0.44>
}
object { Tdroit        scale     <0.12, 0.12, 0.40>
       translate <3.95, 7.18, -0.24>
}

object { Tdroit        scale     <0.20, 0.20, 0.55>
       rotate    <0.00, 90.00, 0.00>
       translate <3.13, 4.47, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 2.50>//
       rotate    <0.00, 90.00, 0.00>
       translate <4.59, 9.23, 0.01>
}
object { Tdroit        scale     <0.20, 0.20, 1.00>
       rotate    <0.00, 88.00, 0.00>
       translate <2.33, 9.22, 0.01>
}
object { Tdroit        scale     <0.20, 0.20, 0.70>
       rotate    <0.00, 90.00, 0.00>
       translate <3.22, 6.34, 0.00>
}
object { Tcoude        scale     <0.25, 0.25, 0.25>
       rotate    <90.00, 0.00, -90.00>
       translate <3.55, 6.74, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 1.50>
       rotate    <0.00, 90.00, -90.00>
       translate <3.95, 7.47, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 0.50>
       rotate    <0.00, 90.00, -90.00>
       translate <3.95, 8.98, 0.00>
}
object { Tdroit        scale     <0.20, 0.20, 0.55>
       rotate    <0.00, 90.00, 0>
       translate <3.13, 4.47, 0.00>
}


#end//++++++++++++fin de Tuyauterie

#ifdef ( Cuv )//++++++++++++++++++++++++++++++++++++++++++++cuves
union {
object { Tcuve}
object { EtiquetteD }
}
union{
object { Tcuve1
}
object { EtiquetteG }
       translate <7.66, 0.00, 0.00>//position 2me cuve

}
#end
//*********************************************************************PIECE
#ifdef ( Room )
plane { y, 0 texture { Beton }
 hollow }

difference {
      box { <-6, -1, -30>, <20, 21, 6> }
      box { <-5, -0.5, -29>, <19, 20, 5> }
      box { < -0.8, -1.5, -3 >, < 0.8, 1.5, 3 >
          rotate z*-25
          translate < -5.5, 9, -2 >
          }
texture { terre }
}
#declare Barreau =
cylinder { < 0, -1.5, 0 >, < 0, 1.5, 0 >, 0.15 }
union {
object { Barreau translate z*-1.5 }
object { Barreau }
object { Barreau translate z*1.5 }
texture { Noir }
          translate < -5.5, 9, -2 >
}

#end
//*****************************************************************Table
#ifdef ( Plan1 )
object { Table
       rotate y*20
       translate < 7, 3.5, -22>
       texture { Dessus_T }
}
//++++++++++++++++++++++++++++++++++++++++++++objets sur la table
object { Eprouvette
       scale 0.3
       translate < 8, 3.5, -20.5 >
       }
object { Feuille
      scale 2.5
       rotate x*80
       rotate y*-20
       translate < 11, 3.5, -21.2 >
      no_shadow
       }
object { Crayon
rotate z*-10
rotate y*20
translate < 11.4, 3.5, -21 > }

#end
//********************************************************Recipient (au sol )
object { Recipient  scale 0.7 translate < 6, 0, -3 > }
//*******************************************************Flaque
object { Flaque translate <6, 0, -2 > scale 0.7 }
