
// Persistence of Vision Ray Tracer Scene Description File
// File: desir_t.inc
// Vers: 3
// Desc: description objets de desir : Boulon, Tdroit, Tcoude, Ecrou, Robinet1, Aiguille
//                                     Aiguille1, Manometre, Robinet, Tcuve, Table, Crayon,
//                                     Feuille, Recipient, Flaque
// Date: 3/12/97
// Auth: denis

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions



#include "robinet.inc"
#include "desir_t.inc"
//*************************boulon de cercle de cuve
#declare Boulon=
    sphere {<0, 0, 0>, 0.5
       scale     <0.09, 0.09, 0.09>
       translate <0.14, 5.15, -1.04>
}

// ********************** Tdroit tuyau droit
#declare Tdroit =
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
texture { Cuivre_tuyau }
    }

// ********************** Tcoude tuyau coud
#declare Tcoude =
   difference
    {
    torus {2.000000, 0.500000
       scale     <0.80, 0.80, 0.80>
}
   difference
    {
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
       scale     <5.00, 1.00, 5.00>
}

    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
       scale     <2.50, 1.00, 2.50>
       translate <1.29, 0.00, -1.24>
}//box
}//difference
texture { Cuivre_tuyau }
}//difference

// ********************************** boulon tete (ecrou)
#declare Ecrou =

   intersection
    {
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
}
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
       rotate    <0.00, 0.00, -43.00>
}
texture { Acier }
}

//***********************************Robinet1 ( inserer les textures ici pour les differencier)
#declare Robinet1 =
union {
object { Ecrou
              scale     <1.10, 1.10, 0.50>
       rotate    <0.00, -92.00, 0.00>
       translate <1.77, 0.40, 0.81>
}
object { Ecrou
       scale     <1.10, 1.10, 0.50>
       rotate    <0.00, -92.00, 0.00>
       translate <-0.60, 0.40, 0.76>

}
object { Robi1
              rotate    <89.00, -32.00, 1.00>
       translate <1.47, 1.88, -0.72>
texture { Acier2}
}
}
//********************************Aiguille (manometre)
#declare Aiguille =
   union
    {
    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <0.00, 0.00, 0.15>
       texture { Acier2 }
       }
    cone {<0, 0, 0>, 0.5, <0, 0, 1>, 0.0
       scale     <0.20, 1.00, 1.00>
       rotate    <0.00, -92.00, 0.00>
       }
    cone {<0, 0, 0>, 0.5, <0, 0, 1>, 0.0
       scale     <0.20, 1.00, 3.00>
       rotate    <0.00, 90.00, 0.00>
       }
 texture
 { Noir }
       scale     <0.25, 0.25, 0.25>
       translate <0.00, 0.00, -0.27>

}
#declare Aiguille1 = object { Aiguille
       rotate    <0.00, 0.00, 430.00>
       translate <0.00, 0.00, -0.21>
}
#declare Aiguille2 = object { Aiguille
       rotate    <0.00, 0.00, 502.00>
       translate <0.00, 0.00, -0.21>
}

//********************************Manometre (inserer les textures )
#declare Manometre =
union {
      object { Ecrou
       scale     <0.55, 0.55, 0.25>
       rotate    <90.00, 0.00, 0.00>
       translate <0.00, -1.88, 0.00>
       }
        cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <0.30, 0.30, 0.90>
       rotate    <90.00, -1.00, 0.00>
       translate <0.00, -1.41, 0.00>
       texture { Acier2 }
       }

 //  Object: vitre et cerclage
   difference
    {
//  Object: cerclage
    torus {0.990000, 0.100000
      texture
      { Gold_T}
       rotate    <90.00, 0.00, -1.00>
       translate <0.01, 0.00, -0.20>
}
//  Object: vitre
   intersection
    {

    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <1.9, 1.90, 0.30>
       translate <0.02, -0.0, -0.25>
}
    sphere {<0, 0, 0>, 0.5
       scale     <8.00, 8.00, 8.00>
       translate <0.03, 0.00, 3.64>
}
      texture
      { T_Glass3 }
       translate <-0.01, 0.00, -0.10>
}



       translate <0.04, -0.08, 0.00>
}

// object cadran
difference {
               cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
                      scale     <1.95, 1.95, 0.30>
       translate <0.029, -0.042, -0.25>
}
               disc
{
  <0, 0, -0.25>  // center position
  z,         // normal vector
  2,       // outer radius
        texture
      {
      pigment
     {
     image_map
    {   gif "C:\Program Files\POV-Ray for Windows\imagemap\graduat.gif"
     once
     map_type 0
     interpolate 2
      }
      translate < -0.46, -0.55, 0 >
      scale 2
      }
}
rotate z*-20
}//disc
}//difference

//  Object: corps
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
      texture
      { Cuivre      }
       scale     <2.00, 2.00, 0.40>

}
}
//**************************************** Robinet + Goutte

#declare Robinet =
union {
object { Robi
texture { Acier2 }
}
object { Ecrou
              scale     <1.00, 1.00, 0.50>
       rotate    <0.00, 90.00, 0.00>
       translate <-1.54, -0.59, -0.00>
       }
object { Gout texture { Ruby_Glass } scale 1.2 }
       scale     <0.20, 0.20, 0.20>
       rotate    <0.00, 90.00, 0.00>
       translate <4.19, 2.70, -0.72>
}
//*************************************** Tcuve
#declare Pdc = //++++++++++++deco pied de cuve
   torus {2.000000, 0.100000}

#declare Pied =
   difference
    {
   difference
    {
    sphere {<0, 0, 0>, 0.5
       scale     <1.80, 1.80, 1.80>
}
    sphere {<0, 0, 0>, 0.5
       scale     <1.5, 1.50, 1.50>
}
}

   union
    {
    sphere {<0, 0, 0>, 0.5
       scale     <1.13, 0.84, 0.94>
       translate <0.00, 0.12, 0.85>
}
    sphere {<0, 0, 0>, 0.5
       scale     <1.13, 0.84, 0.94>
       rotate    <0.00, -88.00, 0.00>
       translate <0.86, 0.12, 0.00>
}
    sphere {<0, 0, 0>, 0.5
       scale     <1.13, 0.84, 0.94>
       translate <0.01, 0.12, -0.85>
}
    sphere {<0, 0, 0>, 0.5
       scale     <1.13, 0.84, 0.94>
       rotate    <0.00, -88.00, 0.00>
       translate <-0.86, 0.12, 0.01>
}
object { Pdc        scale     <1.10, 1.00, 1.10>
       rotate    <90.00, -45.00, 0.00>
}
object { Pdc        scale     <1.10, 1.00, 1.10>
       rotate    <90.00, 45.00, 0.00>
}

}
texture { Fonte }
       scale     <2.50, 2.50, 2.50>

}
#declare Cuve =
   union
    {
    sphere {<0, 0, 0>, 0.5
       scale     <2.00, 1.40, 2.00>
       translate <0.00, 5.33, 0.00>
}
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <2.00, 2.00, 4.00>
       rotate    <-90.00, 0.00, 0.00>
       translate <-0.01, 3.35, -0.01>
}
    sphere {<0, 0, 0>, 0.5
       scale     <2.00, 1.40, 2.00>
       translate <0.00, 1.33, 0.00>
}
       scale     <2.00, 2.00, 2.00>
       translate <0.02, 0.17, 0.00>
}

#declare CercleCuve =
   union
    {
object { Boulon
       translate <-0.03, 0.00, 2.10>}
object { Boulon
       translate <0.38, 0.00, 1.93>}
object { Boulon
       translate <0.69, 0.00, 1.62>}
object { Boulon
       translate <0.82, 0.00, 1.27>}
object { Boulon
       translate <0.83, 0.00, 0.82>}
object { Boulon
       translate <0.68, 0.00, 0.44>}
object { Boulon
       translate <0.37, 0.00, 0.14>}
object { Boulon
       translate <-0.44, 0.00, -0.01>}
object { Boulon
       translate <-0.86, 0.00, 0.18>}
object { Boulon
       translate <-1.11, 0.00, 0.45>}
object { Boulon
       translate <-1.27, 0.00, 0.79>}
object { Boulon
       translate <-1.29, 0.00, 1.21>}
object { Boulon
       translate <-1.13, 0.00, 1.65>}
object { Boulon
       translate <-0.84, 0.00, 1.93>}
object { Boulon
       translate <-0.44, 0.00, 2.11>}

cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <2.20, 2.20, 0.30>
       rotate    <90.00, 0.00, 0.00>
       translate <-0.09, 5.16, 0.00>
}
}

#declare EtiquetteD =
   union
    {
   intersection
    {
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
       translate <0.00, 0, -0.94>
}
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <2.15, 2.15, 0.50>
       rotate    <90.00, 0.00, 0.00>
       translate <0.00, 0, 0.00>
}
texture { Acier_Poli}
texture { Childhood }
       scale     <3.00, 3.00, 3.00>
       translate <0.00, 4.3, 2.22>
}

union{

    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <1.38, 4.85, -0.63>
}

    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <1.38, 3.67, -0.64>
}
    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <-1.36, 3.64, -0.65>
}
    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <-1.34, 4.86, -0.65>
}
texture { Acier }
}
       scale     <0.60, 0.75, 0.60>
       translate <0.00, 4.33, -1.44>
}
#declare EtiquetteG =
   union
    {
   intersection
    {
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
       translate <0.00, 0, -0.94>
}
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <2.15, 2.15, 0.50>
       rotate    <90.00, 0.00, 0.00>
       translate <0.00, 0, 0.00>
}
texture { Acier_Poli}
texture { Desir }
       scale     <3.00, 3.00, 3.00>
       translate <0.00, 4.3, 2.22>
}

union{              //boulons de plaque

    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <1.38, 4.85, -0.63>
}

    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <1.38, 3.67, -0.64>
}
    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <-1.36, 3.64, -0.65>
}
    sphere {<0, 0, 0>, 0.5
       scale     <0.20, 0.20, 0.20>
       translate <-1.34, 4.86, -0.65>
}
texture { Acier }
}
       scale     <0.60, 0.75, 0.60>
       translate <0.00, 4.33, -1.44>
}



#declare Tcuve =
union {
object { Pied }
object { Cuve }
object { CercleCuve        scale     <1.98, 1.98, 1.98>
       translate <0.21, -7.08, -0.01> }
object { CercleCuve       scale     <1.98, 1.98, 1.98>
       translate <0.20, 0.33, -0.03> }
texture { Cuivre_tuyau }
}
#declare Tcuve1 =
union {
union{
object { Cuve }
object { CercleCuve        scale     <1.98, 1.98, 1.98>
       translate <0.21, -7.08, -0.01> }
object { CercleCuve      scale     <1.98, 1.98, 1.98>       translate <0.20, 0.33, -0.03> }

       rotate y*-40
texture { Cuivre_tuyau }
}
object { Pied }
}

//***********************************************Table
#declare Table =
box { <-3,-0.5,-5>, < 8, 0, 5 > }

//************************************eprouvette + support
#declare Eprou =
  union
    {
   difference
    {
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <1.00, 1.00, 9.00>
       rotate    <90.00, 0.00, 0.00>
       translate <0.00, 5.00, 0.00>
}
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <0.99, 0.99, 9.60>
       rotate    <90.00, 0.00, 0.00>
       translate <0.00, 5.30, 0.00>
}
}//difference
    sphere {<0, 0, 0>, 0.5
       translate <0.00, 0.50, 0.00>
}
    torus {0.450000, 0.050000
       translate <0.00, 9.50, 0.00>
}
       rotate    <9.00, 0.00, -1.00>
       translate <0.00, 0.00, -0.87>
}
//+++++++++++++++++++++++++++++++++liquide
#declare Liquide =
   difference
    {
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <0.99, 0.99, 4.50>
       rotate    <99.00, 0.00, -1.00>
       translate <0.03, 2.83, -0.42>
}
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
       scale     <2.00, 2.00, 2.00>
       translate <0.00, 5.96, -0.12>
}
}
//++++++++++++++++++++++++++++++++support
#declare Sup =
   union
    {
    torus {1.400000, 0.100000
       translate <0.00, 0.10, 0.00>
}
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <0.20, 0.20, 8.00>
       rotate    <90.00, 0.00, 0.00>
       translate <1.51, 4.00, 0.00>
}
    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5
       scale     <0.20, 0.20, 0.80>
       rotate    <0.00, 90.00, 0.00>
       translate <1.09, 6.00, 0.00>
}
    torus {0.700000, 0.100000
       translate <0.00, 6.00, 0.00>
}
}
//+++++++++++++++++++++++++++++++++objet eprouvette
#declare Eprouvette =
union {
object { Eprou       texture { T_Glass3 }}
object { Liquide      texture { pigment { color rgb < 0.8, 0.2, 0.2 > }}}
object { Sup         texture { Acier_Poli      }}
}
//************************************************* Feuille
#declare Feuille =
box {
< -1.42, 2, 0.001>, < 1.42, -2, 0.001 >
texture {
      pigment
     {
     image_map
    {   gif "C:\Program Files\POV-Ray for Windows\imagemap\desir_formula.gif"
     once
     map_type 0
     interpolate 2
      }
      translate < -0.50, -0.50, 0 >
      }
      }
}


//**********************************************************Crayon
#declare Crayon =
union {
intersection {
             box { <-1.5, -0.3, -0.3 >, < 1.5, 0.3, 0.3 > }
             box { <-1.5, -0.3, -0.3 >, < 1.5, 0.3, 0.3 > rotate x*-45 }
            texture { pigment { Green }}
             }
sphere { < 1.5, 0, 0 > 0.3 pigment { Green }}
cone { < -2.2, 0, 0 > 0.02, < -1.5, 0, 0 > 0.3 texture { Mine }}
scale < 0.4, 0.2, 0.2 >
}

//********************************************************Recipient ( au sol )

#declare Socle_R =
difference {
sphere { <0, 0, 0 > 0.9
       scale <1, 0.4, 1 >
       }
torus { 0.9, 0.09
      translate < 0, 0.17, 0>
      }
torus { 0.6, 0.09
      translate < 0, 0.30, 0>
      }
box {< -1, 0.3, -0.5 >, < 1, 1, 0.5 >      }
}
#declare Corps_R =
union {
      cylinder {< 0, 0.3, 0 > < 0, 3.2, 0 > 0.3 }
      difference {
      cone { < -0.38, 3.5, 0> 0.03, < -0.1, 3.2, 0 > 0.25 }
      box { < -0.5, 3.2, -1 >, < 0.5, 4.5, 1> }
      }
 }

#declare Recipient =
union {
           object { Socle_R    texture { Acier2 }
 }
           difference {
                      object { Corps_R }
                      object { Corps_R scale 0.97 translate y*0.01 }
                      texture { Glass2 }
                      }
}
//**********************************************************Flaque
#declare Flaque =
union {
sphere { < 0, 0, 0 > 1 scale < 1, 0.1, 1> }
sphere { < 0.9, 0, -0.5 > 1 scale < 1, 0.1, 2.1 > }
sphere { < -0.5, 0, -0.4 > 1 scale < 1.5, 0.1, 1.3 >}
sphere { < 0, 0, 0.7 > 1 scale <1, 0.1, 1 > }
texture  { Ruby_Glass }

}


