
// Persistence of Vision Ray Tracer Scene Description File
// File: Dino.pov
// Vers: 3
// Desc: A wood T-Rex to use with homid.inc
// Date: 26/8/97
// Auth: Francisco Muoz
// Dino.pov version: Alpha 0.5  (now with animation!)
// Copyright: This is my work if u plagiate it, my curse will fall upon u
// (c) 26/8/1997

#version 3

#debug "This file needs homid.inc, jungle.inc and mano.inc \n"

#declare Turbo = 0
    // Turbo =0 No turbo, Turbo = 1 Flat Colors, Turbo =2 Dinos only, Turbo =3 Background
#switch (Turbo)
    #case (0) #debug "/n Final Render!! -> Time to go for pizza./n" #break
    #case (1) #debug "/n No textures -> Cartoon colors /n" #break
    #case (2) #debug "/n Mamma Dino & babies /n" #break
    #case (3) #debug "/n The Jungle in the PoV-Raisic Park /n" #break
    #else #error "\n If you RayTrace, don't drink \n"
#end
#include "colors.inc"
#include "textures.inc"
#if (Turbo!=2)
    #include "jungle.inc"
#end

// And somewhere below homid.inc & mano.inc"


global_settings
{
  assumed_gamma 1.0
}

#if (Turbo!=3)

#if (Turbo!= 1)
    #declare TexWood=texture {pigment{DMFWood2}}
    #declare Textjoint=texture {Bronze_Metal}
    #declare Texture1=texture {Textjoint}
    #declare Texture2=texture {TexWood}
    #declare Texture3=texture {Textjoint}
#else
    #declare TexWood=texture {pigment{Brown}}
    #declare Textjoint=texture {pigment {Yellow}}
    #declare Texture1=texture {Textjoint}
    #declare Texture2=texture {TexWood}
    #declare Texture3=texture {Textjoint}
#end
#declare altura=10



// ----------------------------------------


     #declare girXjaw=-25
     #declare girYtail=5
     #declare girYhead=0
     #declare girXtail=5
     #declare girXhead=95
     #declare girXtorso=-85
     #declare girXmusloI=60
     #declare girXmusloD=60
     #declare girXpantorrI=-120
     #declare girXpantorrD=-120
     #declare girXantebrazoD=125
     #declare girXantebrazoI=125
     #declare girZantebrazoD=210
     #declare girZantebrazoI=-210
     #declare girXbrazoD=-65
     #declare girXbrazoI=-60

// ----------------------------------------


#declare altorso=2
#declare anchtorso=.5
#declare altvientre=1
#declare anchvientre=2.5 //false but needed to locate the legs
#declare longmusloI=1.5
#declare anchmusloI=1
#declare longmusloD=1.5
#declare anchmusloD=1
#declare longpantorrD=2
#declare longpantorrI=2
#declare altfootL=1
#declare altfootR=1
#declare anchfootL=1
#declare anchfootR=1
#declare longbrazos=1.5
#declare flatfootR=yes
#declare flatfootL=yes


#declare incmano=yes
#declare longhand=.75
#declare girTh=20
#declare girFA=40
#declare girFB=35
#declare girFC=45
#declare Numberf=3
#declare nailclass=3


// ----------------------------------------
#ifndef (postailsection) #declare postailsection=<0,0,0> #end

#declare tailsection =object{ sphere {<0,0,0>,.25
           texture{Textjoint}}}

#declare vientre = union {
#declare Count=0
  #while (Count < 6)
    #object {tailsection
           translate postailsection
            texture{Textjoint}
           }
    #declare Count=Count+1
    #declare postailsection = postailsection +vrotate (y*.5,<girXtail*Count+90,girYtail*Count,0>)
  #end
#declare Count=0
  #while (Count < 6)
    #object {tailsection
           translate postailsection
            texture{Textjoint}
           }
    #declare Count=Count+1
    #declare postailsection =
       postailsection +vrotate (y*.5,<girXtail*6-girXtail*Count+90,girYtail*(6+Count),0>)
  #end
cone {<0,0,0>,1,<0,-1.5,0>,.5 texture{TexWood}}

}

#declare jaw=intersection {
           sphere {<0,0,0>,.5 scale <1,1,2> }
           box {<1,-.2,1>,<-1,-4,-1>}
           texture{TexWood}
}
#declare head=union{
 sphere {<0,0,0>,.25 texture{Textjoint}}
 sphere {<0,.5,0>,.25 texture{Textjoint}}
 cylinder {<0,0,0>,<0,1.25,0>,.1}
 sphere {<0,1.25,0>,.5 scale <1,1,1> texture{TexWood}}
 torus {.1,.05 rotate x*90 translate <.25,1.75,-1.2> texture{TexWood}}
 torus {.1,.05 rotate x*90 translate <-.25,1.75,-1.2> texture{TexWood}}
 sphere {<.35,1.8,-.5>,.15 texture{Textjoint}}
 sphere {<-.35,1.8,-.5>,.15 texture{Textjoint}}
 difference {
           sphere {<0,1.5,0>,.5 scale <1,1,2> translate <0,0,-.5>}
           box {<-.8,1.15,2>,<2,0,-2>}
           texture{TexWood}}
 object {jaw translate <0,0,-.5>
        rotate <girXjaw,0,0>
        translate <0,1.5,0>
        }
}

#declare torso=union {
sphere {<0,0,0>,.25 }
sphere {<0,.5,0>,.25}
sphere {<0,1,0>,.25}
sphere {<0,1.5,0>,.25}
sphere {<0,2,0>,.25}
cylinder {<0,0,0>,<0,2,0>,.1}
cylinder {<0,.25,-.5>,<0,1.5,-.25>,.25 texture{TexWood}}
texture{Textjoint}
}

#declare musloD=union {
sphere {<0,0,0>,.5 texture{Textjoint}}
cone { <0,-.25,0>,.4,<0,-1.5,0>,.2 texture{TexWood}}
}
#declare musloI=object {musloD scale <-1,1,1>}

#declare pantorrD=union {
sphere {<0,0,0>,.22 texture{Textjoint}}
cone { <0,-.20,0>,.2,<0,-2,0>,.15 texture{TexWood}}
}
#declare pantorrI=object {pantorrD scale <-1,1,1>}

#declare footR=union {
sphere {<0,0,0>,.16 texture{Textjoint}}
cone { <0,-.2,0>,.2,<0,-.75,-.75>,.15 texture{TexWood}}
sphere {<0,-.75,-.67>,.14 texture{Textjoint}}
cylinder { <0,-.75,-.75>,<0,-1,-.75>,.3 texture{TexWood}}
    difference {
        union{
            cone {<0,0,-.1>,.15,<0,0,-.6>,0 texture{Textjoint} scale <1,1.75,1> translate <0,-1,-.75>}
            cone {<0,0,-.1>,.15,<0,0,-.6>,0 texture{Textjoint} scale <1,1.5,1> rotate y*35 translate <0,-1,-.75>}
            cone {<0,0,-.1>,.15,<0,0,-.6>,0 texture{Textjoint} scale <1,1.5,1> rotate y*-35 translate <0,-1,-.75>}
            }
        plane {y,-1 texture{Textjoint} }
    }
}

#declare footL=object {footR scale <-1,1,1>}


// ----------------------------------------
//      The POV-Dino!!!

#include "homid.inc"

object {homid rotate y*50
translate <vdot (z,-postobilloI),min (vdot (y,-postobilloD)+1,vdot (y,-postobilloI)+1),vdot (z,-postobilloI)>
translate <-2,0,3>
}

// ----------------------------------------
//      The Baby POV-Dino 1 !!!

//#declare head=object {object {head} scale 1.25} // Kids allways have big heads :-)
    #declare girXtail=-3
    #declare girXjaw=-25
    #declare girXtorso=-85
    #declare girYtorso=0
    #declare girZtorso=0
    #declare girXhead=95
    #declare girYhead=20
    #declare girZhead=0
    #declare girXmusloD=30
    #declare girXmusloI=90
    #declare girXpantorrD=-130
    #declare girXpantorrI=-120
    #declare girZmusloD=0
    #declare girZmusloI=0
    #declare girZpantorrD=0
    #declare girZpantorrI=0
    #declare girXantebrazoD=125
    #declare girXantebrazoI=125
    #declare girZantebrazoD=210
    #declare girZantebrazoI=-210
    #declare girXbrazoD=-65
    #declare girXbrazoI=-60
    #declare girZbrazoD=0
    #declare girZbrazoI=0
    #declare girXhandL=0
    #declare girYhandL=-15
    #declare girYhandL=0
    #declare girXhandR=0
    #declare girYhandR=-15
    #declare girYhandR=0
    #declare flatfootR=yes
    #declare flatfootL=no
#declare incmano=yes
#declare longhand=.75
#declare girTh=20
#declare girFA=40
#declare girFB=35
#declare girFC=45
#declare Numberf=3
#declare nailclass=3

#declare postailsection=<0,0,0>

#declare tailsection =object{ sphere {<0,0,0>,.25
           texture{Textjoint}}}

#declare vientre = union {
#declare Count=0
  #while (Count < 6)
    #object {tailsection
           translate postailsection
            texture{Textjoint}
           }
    #declare Count=Count+1
    #declare postailsection = postailsection +vrotate (y*.5,<girXtail*Count+90,girYtail*Count,0>)
  #end
#declare Count=0
  #while (Count < 6)
    #object {tailsection
           translate postailsection
            texture{Textjoint}
           }
    #declare Count=Count+1
    #declare postailsection =
       postailsection +vrotate (y*.5,<girXtail*6-girXtail*Count+90,girYtail*(6+Count),0>)
  #end
cone {<0,0,0>,1,<0,-1.5,0>,.5 texture{TexWood}}

}



#include "homid.inc"
#declare Baby= object {homid
    rotate y*55
    translate <0,-(min (vdot (y,postobilloD),vdot (y,postobilloI)))+heightfootR,0>
                    // To stick the feets to the ground ;-) (coment if flying)
}
object {Baby
    scale .45
    translate <2,0,-1>
}
// ----------------------------------------

// ----------------------------------------
//      The Baby POV-Dino   2  !!!

//#declare head=object {object {head} scale 1.25} // Kids have big heads :-)
    #declare girXtail=3
    #declare girXjaw=-25
    #declare girXtorso=-85
    #declare girYtorso=0
    #declare girZtorso=0
    #declare girXhead=95
    #declare girYhead=20
    #declare girZhead=0
    #declare girXmusloD=90
    #declare girXmusloI=30
    #declare girXpantorrD=-120
    #declare girXpantorrI=-130
    #declare girZmusloD=0
    #declare girZmusloI=0
    #declare girZpantorrD=0
    #declare girZpantorrI=0
    #declare girXantebrazoD=125
    #declare girXantebrazoI=125
    #declare girZantebrazoD=210
    #declare girZantebrazoI=-210
    #declare girXbrazoD=-65
    #declare girXbrazoI=-60
    #declare girZbrazoD=0
    #declare girZbrazoI=0
    #declare girXhandL=0
    #declare girYhandL=-15
    #declare girYhandL=0
    #declare girXhandR=0
    #declare girYhandR=-15
    #declare girYhandR=0
    #declare flatfootR=no
    #declare flatfootL=yes
#declare incmano=yes
#declare longhand=.75
#declare girTh=20
#declare girFA=40
#declare girFB=35
#declare girFC=45
#declare Numberf=3
#declare nailclass=3

#declare postailsection=<0,0,0>

#declare tailsection =object{ sphere {<0,0,0>,.25
           texture{Textjoint}}}

#declare vientre = union {
#declare Count=0
  #while (Count < 6)
    #object {tailsection
           translate postailsection
            texture{Textjoint}
           }
    #declare Count=Count+1
    #declare postailsection = postailsection +vrotate (y*.5,<girXtail*Count+90,girYtail*Count,0>)
  #end
#declare Count=0
  #while (Count < 6)
    #object {tailsection
           translate postailsection
            texture{Textjoint}
           }
    #declare Count=Count+1
    #declare postailsection =
       postailsection +vrotate (y*.5,<girXtail*6-girXtail*Count+90,girYtail*(6+Count),0>)
  #end
cone {<0,0,0>,1,<0,-1.5,0>,.5 texture{TexWood}}

}



#include "homid.inc"
#declare Baby= object {homid
    rotate y*55
    translate <0,-(min (vdot (y,postobilloD),vdot (y,postobilloI)))+heightfootR,0>
                    // To stick the feets to the ground ;-) (coment if flying)
}
object {Baby
    scale .45
    translate <4,0,3>
}

// ----------------------------------------

#end

// ----------------------------------------


camera
{
  location  <0.0, 5.5, -12.0>
  look_at   <0,5, 0>
}

light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 60, -30>
}

