// Persistence of Vision Raytracer
// Sol en parquet simple

#ifndef (MAIN_POV)
#include "common.inc"
#end

/******************************************************************************
   A faire:
******************************************************************************/



/******************************************************************************

        textures

******************************************************************************/

#declare Sol_T=
    texture { pigment { P_WoodGrain4A color_map { M_Wood8A }} rotate 1*z}
    texture {
       pigment { P_WoodGrain4B color_map { M_Wood8B }}
       normal {wood turbulence <0.04, 0.04, 1> octaves 4
          scale <0.05, 0.05, 1> * 0.66 bump_size .1}
       finish {specular 1 roughness 0.0001 reflection 0.05}
       finish {specular 1 roughness 0.001 reflection 0.05}
       rotate 1*z
       }

/******************************************************************************

        objets

******************************************************************************/

//////////////////////////////////////////////////////////////////////// SOL
#declare Sol0=object{
   box {<-300, -5, -192>, <300, -1, 190>}
   pigment {Tan}
   }

#declare Sol_seed=seed(1)
#declare Sol1=union {
#declare Sol_x=-250
   #while (Sol_x < 250)
      #declare Sol_z= -150+300*rand(Sol_seed)
      object {
         box {<Sol_x, -2, -150>, <Sol_x+6.7, 0, Sol_z-.25>}
         texture {Sol_T translate x*1000*rand(Sol_seed) scale 10}
         }
      object {
         box {<Sol_x, -2, 180>, <Sol_x+6.7, 0, Sol_z+.25>}
         texture {Sol_T translate x*1000*rand(Sol_seed) scale 10}
         }
      #declare Sol_x = Sol_x+7
      #end
   }

#declare Sol_Tapis=object{
   box {0, 1}
      pigment {
         image_map {
            png "shirvan.png"
            map_type 0 //plan
            interpolate 2
            once
            transmit 255, 1
            }
         }
         finish {ambient 0.2}
   translate -.5
   rotate 90*x rotate 90*y
   scale <250, 1, 150>
   translate -.4*y
   no_shadow
   }

#declare Sol=union{
   object {Sol0}
   object {Sol1}
   object {Sol_Tapis rotate 20*y}
   }

//////////////////////////////////////////////////////////////////////// MURS

#declare Murs0=object {
   difference{
      box {<-260, -5, -300>, <260, 300, 195>}
      prism {
         linear_sweep linear_spline
         -0.5, 250,
         13,
         < -250, -150>, < -250,  150>, <-160, 150>, <-160, 190>, <-90, 190>, <-90, 150>,
         <90, 150>, <90, 190>, <160, 190>, <160, 150>, < 250, 150>, < 250, -150>, < -250, -150>
         hollow
         }
      box {<-155, .01, 200> <-95, 200, 185>}
      box {<155, .01, 200> <95, 200, 185>}
      }
   texture{
      pigment {
         image_map {
            png "papier.png"
            map_type 0 //plan
            interpolate 2
            }
         scale <73, 26, 1>/2
         rotate -45*y
         }
      }
   }

#declare Murs1=object{
   box {<-250, 250, -150>, <250, 255, 200>}
   pigment {White}
   }

#declare Murs=union{
   object {Murs0}
   object {Murs1}
   }

#declare Panneaux=union{
   object{#declare Panneau_x=90 #include "panneau1.inc" rotate 180*y translate <250, 0, 150>}
   object{#declare Panneau_x=90 #include "panneau1.inc" rotate 180*y translate <-160, 0, 150>}
   object{#declare Panneau_x=30 #include "panneau1.inc" rotate 180*y translate <90, 0, 150>}
   object{#declare Panneau_x=30 #include "panneau1.inc" rotate 180*y translate <-60, 0, 150>}
   object{#declare Panneau_x=40 #include "panneau1.inc" rotate 90*y translate <-160, 0, 190>}
   object{#declare Panneau_x=40 #include "panneau1.inc" rotate 90*y translate <90, 0, 190>}
   object{#declare Panneau_x=40 #include "panneau1.inc" rotate -90*y translate <-90, 0, 150>}
   object{#declare Panneau_x=40 #include "panneau1.inc" rotate -90*y translate <160, 0, 150>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate 90*y translate <-250, 0, 150>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate 90*y translate <-250, 0, 75>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate 90*y translate <-250, 0, 0>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate 90*y translate <-250, 0, -75>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate -90*y translate <250, 0, -150>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate -90*y translate <250, 0, -75>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate -90*y translate <250, 0, 0>}
   object{#declare Panneau_x=75 #include "panneau1.inc" rotate -90*y translate <250, 0, 75>}
   object{#declare Panneau_x=70 #include "panneau1.inc" rotate 0*y translate <180, 0, -150>}
   object{#declare Panneau_x=70 #include "panneau1.inc" rotate 0*y translate <110, 0, -150>}
   object{#declare Panneau_x=70 #include "panneau1.inc" rotate 0*y translate <40, 0, -150>}
   object{#declare Panneau_x=70 #include "panneau1.inc" rotate 0*y translate <-110, 0, -150>}
   object{#declare Panneau_x=70 #include "panneau1.inc" rotate 0*y translate <-180, 0, -150>}
   object{#declare Panneau_x=70 #include "panneau1.inc" rotate 0*y translate <-250, 0, -150>}
   object{#declare Panneau_x=80 #include "panneau1.inc" rotate 0*y translate <-40, 0, -150>}
   }

//////////////////////////////////////////////////////////////////////// TABLEAU

#declare Tableau1=object {
   box {0, 1}
      pigment {
         image_map {
            png "leaphors.png"
            map_type 0 //plan
            interpolate 2
            once
            }
         }
         //finish {ambient 0.2}
   translate -.5
   rotate 0*x rotate 180*y
   scale <50, 40, 1>
   }

#declare Tableau2=object {
   union{
      sphere {<-25, -20, 1>, .1}
      sphere {< 25, -20, 1>, .1}
      sphere {<-25,  20, 1>, .1}
      sphere {< 25,  20, 1>, .1}
      cylinder {<-25, -20, 1>, <25, -20, 1>, .5}
      cylinder {<-25,  20, 1>, <25,  20, 1>, .5}
      cylinder {< 25,  20, 1>, <25,  -20, 1>, .5}
      cylinder {<-25,  20, 1>, <-25,  -20, 1>, .5}
      }
   texture {T_Gold_1E}
   translate -z
   }

#declare Tableau=union {
   object {Tableau1}
   object {Tableau2}
   rotate 5*x
   }

//////////////////////////////////////////////////////////////////////// CHEMINEE

#declare Cheminee0=object {
   union{
      box {<-55, 0, 120> <9, 200, 185> rotate -5*z}
      box {<-9, 0, 120.001> <55, 200, 185.001> rotate 5*z}
      }
   texture{
      pigment {White}
      normal {crackle bump_size 2 scale 1}
      finish {phong 0.2 phong_size 5}
      }
   rotate 5*x translate 100*y
   }

#declare Cheminee1=object {
   box {<-65, 95, 185> <65, 100, 105>}
   texture {T_Stone2 scale 5}
   }

#declare Cheminee2=object {
   difference{
      union{
         box {<-60, -.5, 180>, <60, 101, 100>}
         cylinder {<-60, 0, 100>, <60, 0, 100>, 5}
         }
      box {<-61, 5, 110>, <61, 102, 99>}
      box {<-54.001, 5, 144.99>, <54.001, 99, 115>}
      cylinder {120.01*z, 100*z, 1 scale <54, 30, 1> translate <0, 50, 0>}
      box {<53.999, 5, 100>, <-53.999, 50, 120>}
      }
   texture{
      brick texture {
         pigment {Clear}
         finish {phong 0.2 phong_size 1}
         }
      texture {
         pigment {color Tan*.7}
         normal {dents 0.2 bump_size 2}
         finish {phong 0.2 phong_size 1 crand 0.3}
         }
      brick_size <6,4,12>   // size of brick
      mortar 1       // width of mortar
      translate 1.5*x
      }
   }

#declare Cheminee3=object {
   difference{
      union{
         box {<-59, -.6, 179>, <60, 101.1, 101>}
         cylinder {<-59, 0, 100>, <59, 0, 100>, 4}
         }
      box {<-61, 4, 111>, <61, 102, 99>}
      box {<-55.001, 4, 144.99>, <55.001, 100.01, 114>}
      cylinder {120.01*z, 100*z, 1 scale <55, 31, 1> translate <0, 50, 0>}
      box {<54.999, 4, 100>, <-54.999, 51, 120>}
      }
   texture{
      pigment{Gray}
      finish {phong 0.2 phong_size 1 crand 0.4}
      }
   }

#declare Cheminee_Plaque=object{
   union{
      box {0, 1}
      cylinder {0, z, .5 scale <.7, .2, .99> translate <.5, 1, 0>}
      }
   pigment{Black}
   normal {
      bump_map{
         png "floral_4.png"
         map_type 0 //plan
         interpolate 2
         once
         }
      turbulence 0.2
      }
   finish {phong .3 phong_size 3}
   translate -.5*x scale <60, 50, 1>
   }

#declare Cheminee_Chenets1=object{
   union{
      box {<-30, 10, 10> <30, 11, 11>}
      box {<-30, 10, -10> <30, 11, -11>}

      box {<-25, 9, -15>, <-24, 10, 15>}
      box {<-20, 9, -20>, <-19, 10, 15>}
      box {<-15, 9, -15>, <-14, 10, 15>}
      box {<-10, 9, -15>, <-9, 10, 15>}
      box {<-5, 9, -15>, <-4, 10, 15>}
      box {<0, 9, -15>, <1, 10, 15>}
      box {<5, 9, -15>, <6, 10, 15>}
      box {<10, 9, -15>, <11, 10, 15>}
      box {<15, 9, -15>, <16, 10, 15>}
      box {<20, 9, -20>, <21, 10, 15>}
      box {<25, 9, -15>, <26, 10, 15>}

      box {<20, 10, -20>, <21, 30, -19>}
      box {<-20, 10, -20>, <-19, 30, -19>}

      box {<-25, 0, -11>, <-24, 9, -10>}
      box {<-25, 0, 11>, <-24, 9, 10>}
      box {<25, 0, -11>, <26, 9, -10>}
      box {<25, 0, 11>, <26, 9, 10>}
      }
   pigment {Gray10}
   normal {bumps bump_size 2 scale 3}
   finish {phong 0.2 phong_size 10}
   }

#declare Cheminee_Chenets2=object{
   union{
      sphere {<20.5, 30.5, -19.5>, 2}
      sphere {<-19.5, 30.5, -19.5>, 2}
      }
   texture {T_Gold_1A}
   }

#declare Cheminee_Chenets=union{
   object {Cheminee_Chenets1}
   object {Cheminee_Chenets2}
   }

#declare Cheminee_Feu=object {
   sphere {0, 2 hollow}
   texture {
      pigment {colour Clear}
      halo {
         linear
         max_value 1.0
         spherical_mapping
         emitting
         turbulence 0.7
         colour_map {
            [0.0 color rgbt <1.0, 0.2, 0.0, 1.0>]
            [0.5 color rgbt <1.0, 0.5, 0.0, 0.5>]
            [1.0 color rgbt <1.0, 1.0, 0.5, 0.1>]
            }
         samples 10
         }
      }
   }

#declare Buche1=object{ //bois
   union{
      cone {-30*x, 10, -29*x, 2}
      cone {30*x, 10, 29*x, 2}
      }
   pigment {
      wood color_map{
         [0 Tan]
         [1 rgb <1, .9, .8>]
         }
      rotate 90*y
      }
   }

#declare Buche2=object{ //braise
   cylinder{-29.5*x, 29.5*x, 9}
   pigment {
      crackle color_map{
         [0.00 White]
         [0.02 color rgb <1, 1, .7>]
         [0.05 color rgb <1, .3, 0>]
         [1.00 color rgb <.5, 0, 0>]
         }
      scale 3
      }
   finish {ambient 1}
   }

#declare Buche3=object{ //ecorce
   union{
      cone {-29.9*x, 10.5, 29*x, 9.5}//3.5
      cone {29.9*x, 10.5, -29*x, 9.5}//6.5
      }
   pigment {
      gradient x pigment_map {
      [0  Clear]
      [0.4 Clear]
      [1
      radial color_map{
         [0.0 Black]
         [0.2 Black]
         [0.3 Gray50]
         [1.0 Gray50]
         }
         frequency 10 turbulence 5 rotate 90*z scale <5, 1, 1>
         ]
      }
      scale 30
      }
   }

#declare Buche=union{
   object {Buche1}
   object {Buche2}
   object {Buche3}
   scale <.8, .6, .6>
   }

#declare Cheminee=union{
   object {Cheminee0}
   object {Cheminee1}
   object {Cheminee2}
   object {Cheminee3}
   object {Tableau translate <0, 150, 125>}
   object {Cheminee_Plaque translate <0, 5, 144>}
   object {Cheminee_Feu scale <-35, 30, 20>*1 translate <0, 30, 120>}
   object {Cheminee_Chenets translate <0, 0, 120>}
   object {Buche scale <-1, 1, 1>  translate <-2, 17, 110>}
   object {Buche rotate 120*x scale <1, 1, 1> translate <3, 17, 130>}
   object {Buche scale <1, .8, .8>  translate <0, 22, 120>}
   }

//////////////////////////////////////////////////////////////////////// FENETRE

#declare Fenetre1=object{
   union{
      difference {
         box {<-35, 0, -1.5>, <35, 200, 1.5>}
         box {<-30, 50, -2>, <30, 190, 2>}
         }
      box {<-1.4, 50, -1.4>, <1.4, 190, 1.4> rotate 45*y translate -10*x}
      box {<-1.4, 50, -1.4>, <1.4, 190, 1.4> rotate 45*y translate 10*x}
      box {<-30, -1.4, -1.4>, <30, 1.4, 1.4> rotate 45*x translate 70*y}
      box {<-30, -1.4, -1.4>, <30, 1.4, 1.4> rotate 45*x translate 90*y}
      box {<-30, -1.4, -1.4>, <30, 1.4, 1.4> rotate 45*x translate 110*y}
      box {<-30, -1.4, -1.4>, <30, 1.4, 1.4> rotate 45*x translate 130*y}
      box {<-30, -1.4, -1.4>, <30, 1.4, 1.4> rotate 45*x translate 150*y}
      box {<-30, -1.4, -1.4>, <30, 1.4, 1.4> rotate 45*x translate 170*y}
      }
   pigment {White}
   }

#declare Fenetre2=object {
   box {<-33, 45, -.2>, <33, 193, .2>}
   pigment {Clear}
   normal {bumps bump_size 0.06 scale 5}
   finish {Glossy phong 3 phong_size 1000 refraction 1 ior 1.5}
   }

#declare Fenetre_Poignee1=object {
   cone {-10*x, 2, -3*x, 1}
   pigment {White}
   finish {Glossy}
   }

#declare Fenetre_Poignee2=object {
   union{
      sphere {0, 1 scale <.5, 1.5, 1.5> translate -10*x}
      cylinder {-5*x, 0, .5}
      sphere {0, .5}
      cylinder {0, -4*z, .5}
      }
   texture {T_Gold_1A}
   }

#declare Fenetre=union{
   object {Fenetre1}
   object {Fenetre2}
   object {Fenetre_Poignee1 translate <32.5, 100, -5.5>}
   object {Fenetre_Poignee1 translate <32.5, 100,  5.5>}
   object {Fenetre_Poignee2 translate <32.5, 100, -5.5>}
   object {Fenetre_Poignee2 translate <32.5, 100,  5.5>}
   }

#declare Rideaux = union{
   object{ #include "rideau1.inc" translate <-125, 210, 155>}
   object{ #include "rideau1.inc" translate <-125, 210, 155>}
   object{ #include "rideau2.inc" rotate 180*y translate < 125, 155, 160>}
   object{ #include "rideau2.inc" rotate   0*y translate <-115, 155, 160>}
   object{
      cylinder {-y/2, y/2, 1/2}
      texture{
         pigment {LightBlue*0.8}
         finish {phong 0.1 phong_size 1 reflection 0.0}
         }
      scale <15, 5, 8> rotate 25*z translate <160, 85, 160>
      }
   object{
      cylinder {-y/2, y/2, 1/2}
      texture{
         pigment {LightBlue*0.8}
         finish {phong 0.1 phong_size 1 reflection 0.0}
         }
      scale <15, 5, 8> rotate -25*z translate <-150, 85, 160>
      }
   }

#declare Dehors=object {
   box{0, 1}
   pigment {
      image_map {
         png "LAND_01.png"
         map_type 0 //plan
         interpolate 2
         once
         }
      }
   finish {ambient .8 diffuse 0}
   scale <640, 480, 1>*.5 translate <-160, 0, 200>
   no_shadow
   }

#declare Decor=union{
   object {Murs}
   object {Dehors}
   object {Rideaux}
   object {Fenetre translate <-125, 0, 190>}
   object {Fenetre rotate 180*y translate <125, 0, 190>}
   object {Panneaux}
   object {Cheminee}
   object {Sol}
   }
